/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.toolbox.ControlHandle;
import com.apple.mrj.macos.toolbox.ControlRef;

public class ControlRef16Bit
extends ControlRef {
    private int fMax32 = 0;
    private int fMin32 = 0;
    private float fScale32 = 1.0f;
    private static final int kMax = Short.MAX_VALUE;

    public ControlRef16Bit(int n) {
        super(n);
    }

    public ControlRef16Bit(ControlHandle controlHandle, boolean bl) {
        super(controlHandle.getHandleValue());
        if (bl) {
            controlHandle.data = null;
        }
    }

    private short TruncateSInt32toSInt16(int n) {
        return (short)((float)n / this.fScale32);
    }

    private void computeScale() {
        if (this.fMin32 >= -32767 && this.fMax32 <= Short.MAX_VALUE) {
            this.fScale32 = 1.0f;
        } else {
            int n = this.fMax32 - this.fMin32;
            this.fScale32 = n / 65534;
        }
    }

    public int get32BitValue() {
        return (int)((float)this.getValue() * this.fScale32);
    }

    public int get32BitMinimum() {
        return this.fMin32;
    }

    public int get32BitMaximum() {
        return this.fMax32;
    }

    public void set32BitValue(int n) {
        this.setValue(this.TruncateSInt32toSInt16(n));
    }

    public void set32BitMinimum(int n) {
        this.fMin32 = n;
        this.computeScale();
        this.setMinimum(this.TruncateSInt32toSInt16(n));
    }

    public void set32BitMaximum(int n) {
        this.fMax32 = n;
        this.computeScale();
        this.setMaximum(this.TruncateSInt32toSInt16(n));
    }

    public int getViewSize() {
        return 0;
    }

    public void setViewSize(int n) {
    }

    public short activate() {
        this.hilite((short)0);
        return 0;
    }

    public short deactivate() {
        this.hilite((short)254);
        return 0;
    }
}

