/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.carbon;

import java.security.AccessController;
import sun.security.action.LoadLibraryAction;

public class CarbonLock {
    private static boolean log_recursive = false;
    private static final String log_recursive_name = "com.apple.mrj.macos.carbon.log_recursive_locks";

    private CarbonLock() {
    }

    public static void acquire() {
        int n = CarbonLock.acquire0();
        if (n == 1 && log_recursive) {
            Thread.dumpStack();
        }
    }

    public static void acquireAndSlamRunLoop() {
        int n = CarbonLock.acquire1();
        if (n == 1 && log_recursive) {
            Thread.dumpStack();
        }
    }

    public static void release() {
        int n = CarbonLock.release0();
        if (n == 1 && log_recursive) {
            Thread.dumpStack();
        }
    }

    private static native int acquire0();

    private static native int acquire1();

    private static native int release0();

    public static native Object getInstance();

    private static native void init();

    public static Object releaseWhileCalling(Callback callback) {
        ReleaseWhileCallingThread releaseWhileCallingThread = new ReleaseWhileCallingThread(callback);
        try {
            CarbonLock.acquire();
            releaseWhileCallingThread.start();
            do {
                try {
                    CarbonLock.getInstance().wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!releaseWhileCallingThread.fFinished);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            CarbonLock.release();
            throw throwable;
        }
        CarbonLock.release();
        return releaseWhileCallingThread.fResult;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("JDirect"));
        String string = System.getProperty(log_recursive_name);
        if (string != null && string.equals("true")) {
            log_recursive = true;
        }
        CarbonLock.init();
    }

    private static class ReleaseWhileCallingThread
    extends Thread {
        private Callback fProc;
        Object fResult;
        boolean fFinished;

        ReleaseWhileCallingThread(Callback callback) {
            super("ReleaseWhileCallingThread for " + Thread.currentThread().getName());
            this.setPriority(Math.min(Thread.currentThread().getPriority(), 10));
            this.fProc = callback;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    this.fResult = this.fProc.run();
                }
                catch (Throwable throwable) {
                    this.fResult = throwable;
                    Object var3_2 = null;
                    this.fFinished = true;
                    try {}
                    catch (Throwable throwable2) {
                        Object var5_7 = null;
                        CarbonLock.release();
                        throw throwable2;
                    }
                    CarbonLock.acquire();
                    CarbonLock.getInstance().notifyAll();
                    Object var5_6 = null;
                    CarbonLock.release();
                    return;
                }
                Object var3_1 = null;
                this.fFinished = true;
                try {
                    CarbonLock.acquire();
                    CarbonLock.getInstance().notifyAll();
                    Object var5_4 = null;
                    CarbonLock.release();
                    return;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    CarbonLock.release();
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.fFinished = true;
                try {}
                catch (Throwable throwable3) {
                    Object var5_9 = null;
                    CarbonLock.release();
                    throw throwable3;
                }
                CarbonLock.acquire();
                CarbonLock.getInstance().notifyAll();
                Object var5_8 = null;
                CarbonLock.release();
                throw throwable;
            }
        }
    }

    public static interface Callback {
        public Object run() throws Throwable;
    }
}

