/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.internal.bindery;

import com.apple.mrj.internal.bindery.ZipDirEnumerator;
import com.apple.mrj.internal.bindery.ZipFD;
import com.apple.mrj.internal.vfs.VFS;
import com.apple.mrj.internal.vfs.VFSDirEnumerator;
import com.apple.mrj.internal.vfs.VFSFileDescriptor;
import com.apple.mrj.internal.vfs.VFSStat;
import com.apple.mrj.internal.vfs.VFSWrangler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ZipFS
implements VFS {
    static boolean debug = false;
    String itsFSName;
    ZipFile itsFile;

    ZipFS(String string, String string2) {
        try {
            if (debug) {
                System.out.println("ZipFS: Init");
            }
            this.itsFSName = new StringTokenizer(string, "/", false).nextToken();
            this.itsFile = new ZipFile(string2);
            VFSWrangler.registerVirtualFileSystem(this.itsFSName, this);
            if (debug) {
                System.out.println("ADDED: " + this.itsFSName + " , " + this.itsFile);
            }
        }
        catch (IOException iOException) {
            System.out.println("Got IOException: " + iOException);
            iOException.printStackTrace();
        }
    }

    static String resolvePath(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", false);
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (debug) {
                System.out.println("[" + string3 + "]");
            }
            if (string3.length() == 0 || string3.equals(".")) continue;
            if (string3.equals("..")) {
                int n = string2.lastIndexOf(47);
                if (n == -1) {
                    throw new FileNotFoundException(string);
                }
                string2 = string2.substring(n);
                continue;
            }
            string2 = string2 == null ? "/" : String.valueOf(string2) + "/";
            string2 = String.valueOf(string2) + string3;
        }
        if (debug) {
            System.out.println("String in: " + string + " String out: " + string2);
        }
        return string2;
    }

    public VFSFileDescriptor openFile(String string, int n) throws IOException {
        ZipEntry zipEntry;
        string = ZipFS.resolvePath(string);
        if (debug) {
            System.out.println("openFile for [" + string + "]");
        }
        if ((zipEntry = this.itsFile.getEntry(string)) != null) {
            return new ZipFD(this.itsFile, zipEntry, n);
        }
        if (debug) {
            System.out.println("not found!");
        }
        return null;
    }

    public boolean accessFile(String string, int n) {
        try {
            string = ZipFS.resolvePath(string);
        }
        catch (IOException iOException) {
            return false;
        }
        if (debug) {
            System.out.println("accessFile for " + string);
        }
        if ((n & 2) != 0) {
            return false;
        }
        return this.itsFile.getEntry(string) != null;
    }

    public VFSDirEnumerator openDir(String string) throws IOException {
        String string2;
        Object object;
        string = ZipFS.resolvePath(string);
        if (debug) {
            System.out.println("FolderPath[" + string + "]");
        }
        Enumeration<? extends ZipEntry> enumeration = this.itsFile.entries();
        Vector<String> vector = new Vector<String>();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = string.length();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (object == null || (string2 = ((ZipEntry)object).getName()).equals(string)) continue;
            int n2 = string2.lastIndexOf("/");
            if (n2 != n) {
                int n3 = string2.indexOf("/", n + 1);
                if (n3 == -1) continue;
                String string3 = string2.substring(0, n3);
                hashtable.put(string3, string3);
                continue;
            }
            if (debug) {
                System.out.println("Adding dir entry: " + string2);
            }
            vector.addElement(string2);
        }
        object = hashtable.elements();
        while (object.hasMoreElements()) {
            string2 = object.nextElement();
            if (vector.contains(string2)) continue;
            vector.addElement(string2);
        }
        if (debug) {
            System.out.println("OK, returning with these names: " + vector);
        }
        return new ZipDirEnumerator(vector);
    }

    public VFSStat statFile(String string) throws IOException {
        ZipEntry zipEntry;
        string = ZipFS.resolvePath(string);
        if (debug) {
            System.out.println("statFile for " + string);
        }
        if ((zipEntry = this.itsFile.getEntry(string)) != null) {
            int n;
            return new VFSStat(n, (n = (int)zipEntry.getSize()) == 0, ((Object)zipEntry).hashCode(), (int)zipEntry.getTime(), (int)zipEntry.getTime());
        }
        if (string.equalsIgnoreCase("/" + this.itsFSName)) {
            return new VFSStat(0, true, 0, 0, 0);
        }
        return null;
    }

    public void makeDirectory(String string, int n) throws IOException {
        throw new IOException("Read Only File System");
    }

    public void removeDirectory(String string) throws IOException {
        throw new IOException("Read Only File System");
    }
}

