/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.console;

import com.apple.mrj.console.Console;
import com.apple.mrj.console.NullInputStream;
import com.apple.mrj.console.NullOutputStream;
import com.apple.mrj.macos.generated.FSSpecStruct;
import com.apple.mrj.macos.toolbox.FSSpec;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class Redirector {
    public static final int WINDOW_IO = 1;
    public static final int NULL_IO = 2;
    public static final int FILE_IO = 3;
    public static final int FILE_APPEND_IO = 4;
    private static PrintStream initialOutputStream = null;

    public static void redirectStandardIO(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) {
        initialOutputStream = Redirector.makePrintStream(outputStream);
        System.setIn(new BufferedInputStream(inputStream));
        System.setOut(initialOutputStream);
        System.setErr(Redirector.makePrintStream(outputStream2));
    }

    private static PrintStream makePrintStream(OutputStream outputStream) {
        PrintStream printStream = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(new BufferedOutputStream(outputStream, 128), true);
        return printStream;
    }

    public static void redirectStandardIO(InputStream inputStream, OutputStream outputStream) {
        outputStream = Redirector.makePrintStream(outputStream);
        Redirector.redirectStandardIO(inputStream, outputStream, outputStream);
    }

    public static boolean redirectStandardIO() {
        return Redirector.redirectStandardIO(1, null, 1, null);
    }

    public static boolean redirectStandardIO(int n, Object object, int n2, Object object2) {
        boolean bl = true;
        try {
            Console console;
            InputStream inputStream = null;
            OutputStream outputStream = null;
            if (n == 1) {
                if (n2 == 1) {
                    console = new Console(object2);
                    inputStream = console.getInputStream();
                    outputStream = console.getOutputStream();
                } else {
                    console = new Console(object2, true, false);
                    inputStream = console.getInputStream();
                }
            } else {
                inputStream = n == 3 ? new FileInputStream(Redirector.toFullPath(object)) : new NullInputStream();
            }
            if (outputStream == null) {
                if (n2 == 1) {
                    console = new Console(object2, false, true);
                    outputStream = console.getOutputStream();
                } else {
                    outputStream = n2 == 3 ? new FileOutputStream(Redirector.toFullPath(object2)) : (n2 == 4 ? new FileOutputStream(Redirector.toFullPath(object2), true) : new NullOutputStream());
                }
            }
            Redirector.redirectStandardIO(inputStream, outputStream);
        }
        catch (IOException iOException) {
            return false;
        }
        return bl;
    }

    private static String toFullPath(Object object) throws IOException {
        String string = null;
        if (object instanceof FSSpecStruct) {
            FSSpecStruct fSSpecStruct = (FSSpecStruct)object;
            FSSpec fSSpec = new FSSpec(fSSpecStruct);
            string = fSSpec.toFile().getPath();
        } else if (object instanceof File) {
            string = ((File)object).getPath();
        } else if (object instanceof String) {
            string = (String)object;
        } else {
            throw new IOException("cannot convert specified object to a file path: " + object);
        }
        return string;
    }

    static void redirectToSystemDefaults() {
        FileInputStream fileInputStream = new FileInputStream(FileDescriptor.in);
        FileOutputStream fileOutputStream = new FileOutputStream(FileDescriptor.out);
        FileOutputStream fileOutputStream2 = new FileOutputStream(FileDescriptor.err);
        Redirector.redirectStandardIO(fileInputStream, fileOutputStream, fileOutputStream2);
    }

    static boolean sendBytesToRedirectedOutput(byte[] byArray) {
        PrintStream printStream = initialOutputStream;
        if (initialOutputStream == null) {
            printStream = System.out;
        }
        try {
            ((OutputStream)printStream).write(byArray);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }
}

