/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.JManager;

import com.apple.mrj.JManager.AudioWatcher;
import com.apple.mrj.JManager.ULAWAudioBuffer;
import com.apple.mrj.macos.toolbox.MacOSError;
import com.apple.mrj.macos.toolbox.SndChannel;
import com.apple.mrj.macos.toolbox.SoundHeader;
import java.applet.AudioClip;
import java.util.Vector;

public class ULAWAudioClip
implements AudioClip {
    ULAWAudioBuffer itsBuffer;
    SndChannel itsChannel;
    boolean itsLooping;
    static Vector theirSoundChannels = new Vector();

    public ULAWAudioClip(ULAWAudioBuffer uLAWAudioBuffer) {
        this.itsBuffer = uLAWAudioBuffer;
        this.itsChannel = null;
        this.itsLooping = false;
    }

    public void play() {
        this.stop();
        SoundHeader soundHeader = this.itsBuffer.getSound();
        if (soundHeader != null) {
            this.itsChannel = ULAWAudioClip.acquireChannel(true);
            if (this.itsChannel != null) {
                this.itsChannel.PlaySound(soundHeader);
                new AudioWatcher(this, this.itsChannel);
            }
            this.itsLooping = false;
        }
    }

    public void loop() {
        this.stop();
        SoundHeader soundHeader = this.itsBuffer.getSound();
        if (soundHeader != null) {
            this.itsChannel = ULAWAudioClip.acquireChannel(true);
            if (this.itsChannel != null) {
                this.itsChannel.LoopSound(soundHeader);
                this.itsLooping = true;
            }
        }
    }

    public void stop() {
        if (this.itsChannel != null) {
            this.itsChannel.Quiet();
            if (this.itsLooping) {
                this.releaseChannel(this.itsChannel);
            } else {
                this.itsChannel = null;
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().toString()) + "[" + this.itsBuffer.getURL() + "]";
    }

    static SndChannel acquireChannel(boolean bl) {
        Vector vector = theirSoundChannels;
        synchronized (vector) {
            int n = theirSoundChannels.size();
            int n2 = 0;
            while (n2 < n) {
                SndChannel sndChannel = (SndChannel)theirSoundChannels.elementAt(n2);
                if (!sndChannel.Busy()) {
                    theirSoundChannels.removeElementAt(n2);
                    SndChannel sndChannel2 = sndChannel;
                    Object var3_8 = null;
                    return sndChannel2;
                }
                ++n2;
            }
        }
        SndChannel sndChannel = null;
        if (bl) {
            try {
                sndChannel = new SndChannel(5, 2);
            }
            catch (MacOSError macOSError) {
                if (macOSError.getErrorNumber() == -201) {
                    sndChannel = null;
                }
                throw macOSError;
            }
        }
        return sndChannel;
    }

    void releaseChannel(SndChannel sndChannel) {
        if (this.itsChannel == sndChannel) {
            this.itsChannel = null;
        }
        Vector vector = theirSoundChannels;
        synchronized (vector) {
            theirSoundChannels.addElement(sndChannel);
        }
    }

    protected void finalize() {
        this.stop();
    }
}

