/*
 * Decompiled with CFR 0.152.
 */
package com.apple.memory;

import com.apple.memory.MemoryObject;
import com.apple.memory.StdCLib;

public class PointerObject
extends MemoryObject {
    protected int pointer;
    protected int size;

    public PointerObject(int n, int n2) {
        this.pointer = n;
        this.size = n2;
    }

    public PointerObject(int n) {
        this(0, n);
    }

    public PointerObject() {
        this(0, 0);
    }

    public final byte getByteAt(int n) {
        return PointerObject.getByteAt(this.pointer, n);
    }

    public final short getShortAt(int n) {
        return PointerObject.getShortAt(this.pointer, n);
    }

    public final int getIntAt(int n) {
        return PointerObject.getIntAt(this.pointer, n);
    }

    public final long getLongAt(int n) {
        return PointerObject.getLongAt(this.pointer, n);
    }

    public final float getFloatAt(int n) {
        return PointerObject.getFloatAt(this.pointer, n);
    }

    public final double getDoubleAt(int n) {
        return PointerObject.getDoubleAt(this.pointer, n);
    }

    public final void setByteAt(int n, byte by) {
        PointerObject.setByteAt(this.pointer, n, by);
    }

    public final void setShortAt(int n, short s) {
        PointerObject.setShortAt(this.pointer, n, s);
    }

    public final void setIntAt(int n, int n2) {
        PointerObject.setIntAt(this.pointer, n, n2);
    }

    public final void setLongAt(int n, long l) {
        PointerObject.setLongAt(this.pointer, n, l);
    }

    public final void setFloatAt(int n, float f) {
        PointerObject.setFloatAt(this.pointer, n, f);
    }

    public final void setDoubleAt(int n, double d) {
        PointerObject.setDoubleAt(this.pointer, n, d);
    }

    public final byte[] getBytes() {
        byte[] byArray = new byte[this.size];
        StdCLib.memcpy(byArray, this.pointer, this.size);
        return byArray;
    }

    public void getBytes(int n, byte[] byArray, int n2, int n3) {
        if (n + n3 > this.size || n2 + n3 > byArray.length || n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        PointerObject.copyBytes(this.pointer, n, byArray, n2, n3);
    }

    public void setBytes(int n, byte[] byArray, int n2, int n3) {
        if (n + n3 > this.size || n2 + n3 > byArray.length || n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        PointerObject.copyBytes(byArray, n2, this.pointer, n, n3);
    }

    public final int getSize() {
        return this.size;
    }

    public final int getPointer() {
        return this.pointer;
    }

    protected PointerObject PointerAt(int n, int n2) {
        return new PointerObject(this.getIntAt(n), n2);
    }

    protected PointerObject PointerTo(int n, int n2) {
        return new PointerObject(PointerObject.getPointerTo(this.pointer, n), n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof PointerObject) {
            PointerObject pointerObject = (PointerObject)object;
            return this.pointer == pointerObject.pointer;
        }
        return false;
    }

    public final int strlen(int n) {
        return StdCLib.strlen(PointerObject.getPointerTo(this.pointer, n));
    }

    private static native byte getByteAt(int var0, int var1);

    private static native short getShortAt(int var0, int var1);

    private static native int getIntAt(int var0, int var1);

    private static native long getLongAt(int var0, int var1);

    private static native float getFloatAt(int var0, int var1);

    private static native double getDoubleAt(int var0, int var1);

    private static native int getPointerTo(int var0, int var1);

    private static native void setByteAt(int var0, int var1, byte var2);

    private static native void setShortAt(int var0, int var1, short var2);

    private static native void setIntAt(int var0, int var1, int var2);

    private static native void setLongAt(int var0, int var1, long var2);

    private static native void setFloatAt(int var0, int var1, float var2);

    private static native void setDoubleAt(int var0, int var1, double var2);

    private static native void copyBytes(byte[] var0, int var1, byte[] var2, int var3, int var4);

    private static native void copyBytes(byte[] var0, int var1, int var2, int var3, int var4);

    private static native void copyBytes(int var0, int var1, byte[] var2, int var3, int var4);

    private static native void copyBytes(int var0, int var1, int var2, int var3, int var4);
}

