/*
 * Decompiled with CFR 0.152.
 */
package com.apple.memory;

import com.apple.memory.MemoryObject;
import com.apple.memory.PointerObject;

public class MemoryReference
extends MemoryObject {
    protected MemoryObject reference;
    protected int offset;

    public MemoryReference(MemoryObject memoryObject, int n) {
        this.reference = memoryObject;
        this.offset = n;
    }

    public MemoryReference(MemoryObject memoryObject) {
        this(memoryObject, 0);
    }

    public final byte getByteAt(int n) {
        return this.reference.getByteAt(this.offset + n);
    }

    public final short getShortAt(int n) {
        return this.reference.getShortAt(this.offset + n);
    }

    public final int getIntAt(int n) {
        return this.reference.getIntAt(this.offset + n);
    }

    public final long getLongAt(int n) {
        return this.reference.getLongAt(this.offset + n);
    }

    public final float getFloatAt(int n) {
        return this.reference.getFloatAt(this.offset + n);
    }

    public final double getDoubleAt(int n) {
        return this.reference.getDoubleAt(this.offset + n);
    }

    public final void setByteAt(int n, byte by) {
        this.reference.setByteAt(this.offset + n, by);
    }

    public final void setShortAt(int n, short s) {
        this.reference.setShortAt(this.offset + n, s);
    }

    public final void setIntAt(int n, int n2) {
        this.reference.setIntAt(this.offset + n, n2);
    }

    public final void setLongAt(int n, long l) {
        this.reference.setLongAt(this.offset + n, l);
    }

    public final void setFloatAt(int n, float f) {
        this.reference.setFloatAt(this.offset + n, f);
    }

    public final void setDoubleAt(int n, double d) {
        this.reference.setDoubleAt(this.offset + n, d);
    }

    public final byte[] getBytes() {
        byte[] byArray = this.reference.getBytes();
        if (this.offset > 0) {
            int n = byArray.length - this.offset;
            byte[] byArray2 = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray2[n2] = byArray[this.offset++];
                ++n2;
            }
            byArray = byArray2;
        }
        return byArray;
    }

    public final int getPointer() {
        return ((PointerObject)this.reference).pointer + this.offset;
    }

    public final int getSize() {
        return this.reference.getSize() - this.offset;
    }
}

