/*
 * Decompiled with CFR 0.152.
 */
package com.apple.memory;

import com.apple.NativeObject;

public abstract class MemoryObject
implements NativeObject {
    protected MemoryObject() {
    }

    protected MemoryObject(int n, MemoryObject memoryObject) {
        this.setBytesAt(0, this.getSize(), memoryObject, n);
    }

    public abstract byte getByteAt(int var1);

    public abstract short getShortAt(int var1);

    public abstract int getIntAt(int var1);

    public abstract long getLongAt(int var1);

    public abstract float getFloatAt(int var1);

    public abstract double getDoubleAt(int var1);

    public abstract void setByteAt(int var1, byte var2);

    public abstract void setShortAt(int var1, short var2);

    public abstract void setIntAt(int var1, int var2);

    public abstract void setLongAt(int var1, long var2);

    public abstract void setFloatAt(int var1, float var2);

    public abstract void setDoubleAt(int var1, double var2);

    public abstract byte[] getBytes();

    public abstract int getSize();

    public void setBytesAt(int n, int n2, byte[] byArray) {
        this.setBytesAt(n, n2, byArray, 0);
    }

    public byte[] getBytesAt(int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = this.getByteAt(n++);
            ++n3;
        }
        return byArray;
    }

    public void setBytesAt(int n, int n2, byte[] byArray, int n3) {
        int n4 = 0;
        while (n4 < n2) {
            this.setByteAt(n4 + n, byArray[n3 + n4]);
            ++n4;
        }
    }

    public void setBytesAt(int n, int n2, MemoryObject memoryObject) {
        this.setBytesAt(n, n2, memoryObject, 0);
    }

    public void setBytesAt(int n, int n2, MemoryObject memoryObject, int n3) {
        int n4 = 0;
        while (n4 < n2) {
            this.setByteAt(n++, memoryObject.getByteAt(n3++));
            ++n4;
        }
    }

    public int strlen(int n) {
        int n2 = 0;
        while (this.getByteAt(n++) != 0) {
            ++n2;
        }
        return n2;
    }

    public String CStringAt(int n) {
        return new String(this.getBytesAt(n, this.strlen(n)));
    }

    public void setCStringAt(int n, int n2, String string) {
        n2 = Math.min(n2, string.length());
        this.setBytesAt(n, n2, string.getBytes(), 0);
        this.setByteAt(n + n2, (byte)0);
    }

    public String PStringAt(int n) {
        byte by = this.getByteAt(n);
        return new String(this.getBytesAt(n + 1, by));
    }

    public void setPStringAt(int n, int n2, String string) {
        n2 = Math.min(Math.min(n2, string.length()), 255);
        this.setByteAt(n, (byte)n2);
        this.setBytesAt(n + 1, n2, string.getBytes(), 0);
    }
}

