/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.MacOSError;
import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.Ptr;
import com.apple.MacOS.SerShk;
import com.apple.MacOS.SerStaRec;
import com.apple.MacOS.StringPtr;
import com.apple.NativeObject;
import java.io.IOException;

public class SerialPort
implements NativeObject {
    public static final int baud150 = 763;
    public static final int baud300 = 380;
    public static final int baud600 = 189;
    public static final int baud1200 = 94;
    public static final int baud1800 = 62;
    public static final int baud2400 = 46;
    public static final int baud3600 = 30;
    public static final int baud4800 = 22;
    public static final int baud7200 = 14;
    public static final int baud9600 = 10;
    public static final int baud14400 = 6;
    public static final int baud19200 = 4;
    public static final int baud28800 = 2;
    public static final int baud38400 = 1;
    public static final int baud57600 = 0;
    public static final int stop10 = 16384;
    public static final int stop15 = Short.MIN_VALUE;
    public static final int stop20 = -16384;
    public static final int noParity = 0;
    public static final int oddParity = 4096;
    public static final int evenParity = 12288;
    public static final int data5 = 0;
    public static final int data6 = 2048;
    public static final int data7 = 1024;
    public static final int data8 = 3072;
    public static final StringPtr[] kModemPortNames = new StringPtr[]{new StringPtr(".AOut"), new StringPtr(".AIn")};
    public static final StringPtr[] kPrinterPortNames = new StringPtr[]{new StringPtr(".BOut"), new StringPtr(".BIn")};
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;
    private short outRefNum;
    private short inRefNum = (short)-1;
    private Ptr buffer;

    public SerialPort(int n) throws MacOSError {
        this.outRefNum = (short)-1;
        short[] sArray = new short[]{-1};
        MacOSError.CheckResult(SerialPort.OpenDriver(kModemPortNames[0].getBytes(), sArray));
        this.outRefNum = sArray[0];
        MacOSError.CheckResult(SerialPort.OpenDriver(kModemPortNames[1].getBytes(), sArray));
        this.inRefNum = sArray[0];
        this.buffer = new Ptr(1024, true);
        MacOSError.CheckResult(SerialPort.SerSetBuf(this.inRefNum, this.buffer.getPointer(), (short)this.buffer.getSize()));
        short s = (short)(n | 0x4000 | 0xC00);
        MacOSError.CheckResult(SerialPort.SerReset(this.outRefNum, s));
        MacOSError.CheckResult(SerialPort.SerReset(this.inRefNum, s));
        SerShk serShk = new SerShk();
        this.setHandshake(serShk, serShk);
    }

    public void Dispose() {
        if (this.inRefNum != -1) {
            SerialPort.CloseDriver(this.inRefNum);
            this.inRefNum = (short)-1;
        }
        if (this.outRefNum != -1) {
            SerialPort.CloseDriver(this.outRefNum);
            this.outRefNum = (short)-1;
        }
        if (this.buffer != null) {
            this.buffer.Dispose();
            this.buffer = null;
        }
    }

    protected void finalize() {
        this.Dispose();
    }

    public int write(int n) throws IOException {
        int[] nArray = new int[]{1};
        byte[] byArray = new byte[]{(byte)n};
        MacOSError.CheckResult(SerialPort.FSWrite(this.outRefNum, nArray, byArray));
        return nArray[0];
    }

    public int write(byte[] byArray) throws IOException {
        int[] nArray = new int[]{byArray.length};
        MacOSError.CheckResult(SerialPort.FSWrite(this.outRefNum, nArray, byArray));
        return nArray[0];
    }

    public int read(byte[] byArray) throws IOException {
        int[] nArray = new int[]{byArray.length};
        MacOSError.CheckResult(SerialPort.FSRead(this.inRefNum, nArray, byArray));
        return nArray[0];
    }

    public int bytesAvailable() {
        int[] nArray = new int[1];
        MacOSError.CheckResult(SerialPort.SerGetBuf(this.inRefNum, nArray));
        return nArray[0];
    }

    public void getStatus(SerStaRec serStaRec, SerStaRec serStaRec2) {
        MacOSError.CheckResult(SerialPort.SerStatus(this.inRefNum, serStaRec));
        MacOSError.CheckResult(SerialPort.SerStatus(this.outRefNum, serStaRec2));
    }

    public void setHandshake(SerShk serShk, SerShk serShk2) {
        MacOSError.CheckResult(SerialPort.SerHShake(this.inRefNum, serShk));
        MacOSError.CheckResult(SerialPort.SerHShake(this.outRefNum, serShk2));
    }

    private static native short OpenDriver(byte[] var0, short[] var1);

    private static native short CloseDriver(short var0);

    private static native short FSWrite(short var0, int[] var1, byte[] var2);

    private static native short FSRead(short var0, int[] var1, byte[] var2);

    private static native short SerReset(short var0, short var1);

    private static native short SerSetBuf(short var0, int var1, short var2);

    private static native short SerGetBuf(short var0, int[] var1);

    private static native short SerHShake(short var0, SerShk var1);

    private static native short SerStatus(short var0, SerStaRec var1);
}

