/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.ControlActionUPP;
import com.apple.MacOS.ControlHandle;
import com.apple.MacOS.Point;
import com.apple.MacOS.Rect;
import com.apple.MacOS.ScrollPaneComponent;
import com.apple.MacOS.Str255;

class ScrollPane {
    protected ControlHandle hScroll;
    protected ControlHandle vScroll;
    protected boolean hasBorder;
    protected Rect boundsRect;
    protected ControlActionUPP hActionUPP;
    protected ControlActionUPP vActionUPP;
    protected ScrollPaneComponent myComponent;

    ScrollPane(ScrollPaneComponent scrollPaneComponent, Rect rect, boolean bl, boolean bl2, ControlActionUPP controlActionUPP, ControlActionUPP controlActionUPP2, boolean bl3) {
        this.myComponent = scrollPaneComponent;
        this.hasBorder = bl3;
        this.hActionUPP = controlActionUPP;
        this.vActionUPP = controlActionUPP2;
        this.boundsRect = new Rect(rect);
        if (bl) {
            this.createHScrollBar();
        }
        if (bl2) {
            this.createVScrollBar();
        }
    }

    ScrollPane(ScrollPaneComponent scrollPaneComponent, Rect rect, boolean bl, boolean bl2, boolean bl3) {
        this(scrollPaneComponent, rect, bl, bl2, null, null, bl3);
    }

    public boolean hasHScroll() {
        return this.hScroll != null;
    }

    public boolean hasVScroll() {
        return this.vScroll != null;
    }

    public void IsHilited(boolean bl) {
        if (this.hasHScroll()) {
            this.hScroll.IsHilited(bl);
        }
        if (this.hasVScroll()) {
            this.vScroll.IsHilited(bl);
        }
    }

    public void IsVisible(boolean bl) {
        if (this.hasHScroll()) {
            this.hScroll.IsVisible(bl);
        }
        if (this.hasVScroll()) {
            this.vScroll.IsVisible(bl);
        }
    }

    protected short vScrollValue() {
        return this.hasVScroll() ? this.vScroll.GetValue() : (short)0;
    }

    protected void vScrollValue(short s) {
        if (this.hasVScroll()) {
            this.vScroll.SetValue(s);
        }
    }

    protected short hScrollValue() {
        return this.hasHScroll() ? this.hScroll.GetValue() : (short)0;
    }

    protected void hScrollValue(short s) {
        if (this.hasHScroll()) {
            this.hScroll.SetValue(s);
        }
    }

    public void drawBorder() {
        if (this.hasBorder) {
            this.myComponent.getWindowRef().Frame(this.boundsRect);
        }
    }

    public void Draw() {
        this.drawBorder();
        if (this.hasHScroll()) {
            this.hScroll.Draw();
        }
        if (this.hasVScroll()) {
            this.vScroll.Draw();
        }
    }

    public boolean HitTest(Point point) {
        return this.boundsRect.Contains(point);
    }

    private Rect calcHScrollBoundsFor(Rect rect) {
        Rect rect2 = new Rect(rect);
        if (this.hasVScroll() || this.myComponent.getWindowRef().InGrowZone(rect.bottomRight())) {
            rect2.setRight((short)(rect2.getRight() - 15));
            rect2.setBottom(rect2.getBottom());
        }
        rect2.setTop((short)(rect2.getBottom() - 16));
        return rect2;
    }

    private Rect calcVScrollBoundsFor(Rect rect) {
        Rect rect2 = new Rect(rect);
        if (this.hasHScroll() || this.myComponent.getWindowRef().InGrowZone(rect.bottomRight())) {
            rect2.setBottom((short)(rect2.getBottom() - 15));
            rect2.setRight(rect2.getRight());
        }
        rect2.setLeft((short)(rect2.getRight() - 16));
        return rect2;
    }

    public Rect GetBounds() {
        return this.boundsRect;
    }

    public Rect SetBounds(Rect rect) {
        this.boundsRect.Erase();
        this.boundsRect.Set(rect);
        if (this.hasVScroll()) {
            this.vScroll.SetBounds(this.calcVScrollBoundsFor(rect));
        }
        if (this.hasHScroll()) {
            this.hScroll.SetBounds(this.calcHScrollBoundsFor(rect));
        }
        return this.calcViewRect();
    }

    protected void adjustScrollBar(ControlHandle controlHandle, boolean bl, boolean bl2) {
        int n;
        Rect rect = this.myComponent.getViewRect();
        Rect rect2 = this.myComponent.getDestRect();
        short s = controlHandle.GetValue();
        short s2 = controlHandle.GetMaximum();
        int n2 = this.myComponent.getScrollMax(rect, rect2, bl);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 != s2) {
            controlHandle.SetMaximum((short)n2);
        }
        if ((n = bl ? rect.top - rect2.top : rect.left - rect2.left) < 0) {
            n = 0;
        } else if (n > n2) {
            n = n2;
        }
        if (n != s) {
            controlHandle.SetValue((short)n);
        }
        if (bl2) {
            controlHandle.Draw();
        }
    }

    public Rect calcViewRect() {
        Rect rect = new Rect(this.boundsRect);
        rect.Inset((short)1, (short)1);
        if (this.hasHScroll()) {
            rect.setBottom(rect.getBottom() - 15);
        }
        if (this.hasVScroll()) {
            rect.setRight(rect.getRight() - 15);
        }
        return rect;
    }

    public void Click(Point point) {
        if (this.hasHScroll() && this.hScroll.HitTest(point)) {
            this.hScroll.Track(point, this.hActionUPP);
            System.out.println(this.hScroll);
        } else if (this.hasVScroll() && this.vScroll.HitTest(point)) {
            this.vScroll.Track(point, this.vActionUPP);
            System.out.println(this.vScroll);
        }
        this.myComponent.adjustContentsForScrollBars(this.hScroll, this.vScroll);
    }

    protected void createHScrollBar() {
        Rect rect = this.calcHScrollBoundsFor(this.boundsRect);
        this.hScroll = new ControlHandle(this.myComponent.getWindowRef(), rect, false, 0, 0, 0, this.myComponent.getIdentifier());
        this.hScroll.SetAction(this.hActionUPP);
        if (this.hasVScroll()) {
            this.vScroll.SetBounds(this.calcVScrollBoundsFor(rect));
        }
        this.myComponent.Size((short)0, (short)-15);
        this.adjustScrollBar(this.hScroll, false, false);
        this.hScroll.Show();
    }

    protected void createVScrollBar() {
        Rect rect = this.calcVScrollBoundsFor(this.boundsRect);
        this.vScroll = new ControlHandle(this.myComponent.getWindowRef(), rect, new Str255(), false, 0, 0, 0, 16, this.myComponent.getIdentifier());
        this.vScroll.SetAction(this.vActionUPP);
        if (this.hasHScroll()) {
            this.hScroll.SetBounds(this.calcHScrollBoundsFor(rect));
        }
        this.myComponent.Size((short)-15, (short)0);
        this.adjustScrollBar(this.vScroll, true, false);
        this.vScroll.Show();
    }

    public void Dispose() {
        if (this.hasVScroll()) {
            this.vScroll.Dispose();
        }
        if (this.hasHScroll()) {
            this.hScroll.Dispose();
        }
    }
}

