/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.FSSpec;
import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.Picture;
import com.apple.MacOS.ResourceHandle;
import com.apple.MacOS.ResourceManager;
import com.apple.MacOS.TranslateString;
import com.apple.NativeObject;
import java.io.File;
import java.util.Hashtable;

public class ResourceFile
implements NativeObject,
ResourceManager {
    private boolean itsOpenedExplicitly;
    private boolean itsReadOnly;
    private short itsRefNum = (short)-1;
    private Hashtable itsLoadedResources = new Hashtable();
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public ResourceFile(boolean bl) {
        this.itsOpenedExplicitly = false;
        this.itsReadOnly = bl;
        this.itsRefNum = ResourceFile.CurResFile();
    }

    public ResourceFile(short s, boolean bl) {
        this.itsOpenedExplicitly = false;
        this.itsReadOnly = bl;
        this.itsRefNum = s;
    }

    public ResourceFile() {
        this(false);
    }

    public ResourceFile(String string, boolean bl) {
        this.itsReadOnly = bl;
        Object object = ResourceManager.lock;
        synchronized (object) {
            short s = ResourceFile.CurResFile();
            FSSpec fSSpec = new FSSpec(string);
            this.itsRefNum = ResourceFile.FSpOpenResFile(fSSpec.getBytes(), (byte)(bl ? 1 : 3));
            this.itsOpenedExplicitly = true;
            ResourceFile.UseResFile(s);
        }
    }

    public ResourceFile(File file, boolean bl) {
        this(file.getPath(), bl);
    }

    public boolean isReadOnly() {
        return this.itsReadOnly;
    }

    private short SwapResFile(short s) {
        short s2 = ResourceFile.CurResFile();
        ResourceFile.UseResFile(s);
        return s2;
    }

    private ResourceHandle getUniqueResource(int n) {
        if (n == 0) {
            throw new OutOfMemoryError("ResourceFile");
        }
        Integer n2 = new Integer(n);
        ResourceHandle resourceHandle = (ResourceHandle)this.itsLoadedResources.get(n2);
        if (resourceHandle == null) {
            resourceHandle = new ResourceHandle(this, n);
            this.itsLoadedResources.put(n2, resourceHandle);
        }
        return resourceHandle;
    }

    public ResourceHandle getResource(int n, short s) {
        Object object = ResourceManager.lock;
        synchronized (object) {
            short s2 = this.SwapResFile(this.itsRefNum);
            ResourceFile.SetResLoad(false);
            int n2 = ResourceFile.GetResource(n, s);
            ResourceFile.SetResLoad(true);
            ResourceFile.UseResFile(s2);
            ResourceHandle resourceHandle = this.getUniqueResource(n2);
            Object var5_7 = null;
            return resourceHandle;
        }
    }

    public ResourceHandle getResource(int n, String string) {
        Object object = ResourceManager.lock;
        synchronized (object) {
            short s = this.SwapResFile(this.itsRefNum);
            ResourceFile.SetResLoad(false);
            int n2 = ResourceFile.GetNamedResource(n, TranslateString.asPascalBytes(string));
            ResourceFile.SetResLoad(true);
            ResourceFile.UseResFile(s);
            ResourceHandle resourceHandle = this.getUniqueResource(n2);
            Object var5_7 = null;
            return resourceHandle;
        }
    }

    public ResourceHandle getIndexedResource(int n, short s) {
        Object object = ResourceManager.lock;
        synchronized (object) {
            short s2 = this.SwapResFile(this.itsRefNum);
            ResourceFile.SetResLoad(false);
            int n2 = ResourceFile.GetIndResource(n, s);
            ResourceFile.SetResLoad(true);
            ResourceFile.UseResFile(s2);
            ResourceHandle resourceHandle = this.getUniqueResource(n2);
            Object var5_7 = null;
            return resourceHandle;
        }
    }

    public ResourceHandle addResource(int n, String string) {
        int n2 = ResourceFile.NewHandle(0);
        if (n2 == 0) {
            throw new OutOfMemoryError();
        }
        Object object = ResourceManager.lock;
        synchronized (object) {
            short s = this.SwapResFile(this.itsRefNum);
            ResourceFile.AddResource(n2, n, ResourceFile.Unique1ID(n), TranslateString.asPascalBytes(string));
            ResourceFile.UseResFile(s);
            ResourceHandle resourceHandle = this.getUniqueResource(n2);
            Object var6_7 = null;
            return resourceHandle;
        }
    }

    public short countResources(int n) {
        short s = 0;
        Object object = ResourceManager.lock;
        synchronized (object) {
            short s2 = this.SwapResFile(this.itsRefNum);
            s = ResourceFile.Count1Resources(n);
            ResourceFile.UseResFile(s2);
        }
        return s;
    }

    public short countTypes() {
        short s = 0;
        Object object = ResourceManager.lock;
        synchronized (object) {
            short s2 = this.SwapResFile(this.itsRefNum);
            s = ResourceFile.Count1Types();
            ResourceFile.UseResFile(s2);
        }
        return s;
    }

    public int getIndexedType(short s) {
        int[] nArray = new int[1];
        Object object = ResourceManager.lock;
        synchronized (object) {
            short s2 = this.SwapResFile(this.itsRefNum);
            ResourceFile.Get1IndType(nArray, s);
            ResourceFile.UseResFile(s2);
        }
        return nArray[0];
    }

    public void close() {
        Object object = ResourceManager.lock;
        synchronized (object) {
            if (this.itsRefNum != -1) {
                this.itsLoadedResources.clear();
                if (this.itsOpenedExplicitly) {
                    ResourceFile.CloseResFile(this.itsRefNum);
                }
                this.itsRefNum = (short)-1;
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    public static short getCurApRefNum() {
        return ResourceFile.LMGetCurApRefNum();
    }

    public String getIndString(short s, short s2) {
        byte[] byArray = new byte[255];
        Object object = ResourceManager.lock;
        synchronized (object) {
            short s3 = this.SwapResFile(this.itsRefNum);
            ResourceFile.GetIndString(byArray, s, s2);
            ResourceFile.UseResFile(s3);
        }
        return new String(byArray, 0, 1, (int)byArray[0]);
    }

    public Picture getPicture(short s) {
        Picture picture = null;
        Object object = ResourceManager.lock;
        synchronized (object) {
            short s2 = this.SwapResFile(this.itsRefNum);
            picture = new Picture(s);
            ResourceFile.UseResFile(s2);
        }
        return picture;
    }

    public Picture getPicture(String string) {
        Picture picture = null;
        Object object = ResourceManager.lock;
        synchronized (object) {
            short s = this.SwapResFile(this.itsRefNum);
            picture = new Picture(string);
            ResourceFile.UseResFile(s);
        }
        return picture;
    }

    private static native short FSpOpenResFile(byte[] var0, byte var1);

    private static native void CloseResFile(short var0);

    private static native short CurResFile();

    private static native short LMGetCurApRefNum();

    private static native void UseResFile(short var0);

    private static native void SetResLoad(boolean var0);

    private static native int GetResource(int var0, short var1);

    private static native int GetNamedResource(int var0, byte[] var1);

    private static native int GetIndResource(int var0, short var1);

    private static native void GetIndString(byte[] var0, int var1, int var2);

    private static native int NewHandle(int var0);

    private static native void DisposeHandle(int var0);

    private static native void AddResource(int var0, int var1, short var2, byte[] var3);

    private static native short Unique1ID(int var0);

    private static native short Count1Resources(int var0);

    private static native short Count1Types();

    private static native void Get1IndType(int[] var0, short var1);
}

