/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.MacOSLibraries;
import com.apple.memory.MemoryObject;
import com.apple.memory.StructObject;

public class Point
extends StructObject {
    public short v;
    public short h;
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public Point() {
    }

    public Point(int n, int n2) {
        this((short)n, (short)n2);
    }

    public Point(short s, short s2) {
        this.v = s2;
        this.h = s;
    }

    public Point(Point point) {
        this.v = point.v;
        this.h = point.h;
    }

    public Point(int n) {
        this.v = (short)(n >> 16);
        this.h = (short)(n & 0xFFFF);
    }

    public Point(MemoryObject memoryObject) {
        this(memoryObject.getIntAt(0));
    }

    public final short getV() {
        return this.v;
    }

    public final short getH() {
        return this.h;
    }

    public final void setH(short s) {
        this.h = s;
    }

    public final void setV(short s) {
        this.v = s;
    }

    public final void setH(int n) {
        this.setH((short)n);
    }

    public final void setV(int n) {
        this.setV((short)n);
    }

    public final int toInt() {
        return this.v << 16 | this.h;
    }

    public final String toString() {
        return String.valueOf(this.getClass().getName()) + "[h " + this.h + ", v " + this.v + "]";
    }

    public final void LocalToGlobal() {
        Point.LocalToGlobal(this);
    }

    public final void GlobalToLocal() {
        Point.GlobalToLocal(this);
    }

    public final void Add(Point point) {
        Point.AddPt(point.toInt(), this);
    }

    public final void Sub(Point point) {
        Point.SubPt(point.toInt(), this);
    }

    public final Point Delta(Point point) {
        return new Point(Point.DeltaPoint(this.toInt(), point.toInt()));
    }

    public final void Offset(short s, short s2) {
        this.Set(this.h + s, this.v + s2);
    }

    public final void Set(short s, short s2) {
        Point.SetPt(this, s2, s);
    }

    public final void Set(int n, int n2) {
        this.Set((short)n, (short)n2);
    }

    public final boolean Equal(Point point) {
        return Point.EqualPt(point.toInt(), this.toInt());
    }

    private static native void GlobalToLocal(Point var0);

    private static native void LocalToGlobal(Point var0);

    private static native void AddPt(int var0, Point var1);

    private static native void SubPt(int var0, Point var1);

    private static native int DeltaPoint(int var0, int var1);

    private static native void SetPt(Point var0, short var1, short var2);

    private static native boolean EqualPt(int var0, int var1);
}

