/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.Handle;
import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.MemoryUtils;
import com.apple.MacOS.OSUtils;
import com.apple.MacOS.PPHandle;
import com.apple.MacOS.Pattern;
import com.apple.MacOS.Point;
import com.apple.MacOS.Rect;
import com.apple.MacOS.Shape;
import com.apple.MacOS.Str255;
import com.apple.NativeObject;

public class Picture
implements NativeObject,
Shape {
    private Handle picHandle;
    private Rect bounds;
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public Picture(short s) {
        int n = Picture.GetPicture(s);
        if (n == 0) {
            throw new NullPointerException("PICT " + s + " not found.");
        }
        this.picHandle = new Handle(n);
        Picture.DetachResource(this.picHandle.getHandle());
        this.bounds = MemoryUtils.RectAt(this.picHandle, 2);
        this.bounds.MoveTo((short)0, (short)0);
    }

    public Picture(String string) {
        int n = Picture.Get1Resource(OSUtils.makeOSType("PICT"), new Str255(string).getBytes());
        if (n == 0) {
            throw new NullPointerException("PICT " + string + " not found.");
        }
        this.picHandle = new Handle(n);
        Picture.DetachResource(this.picHandle.getHandle());
        this.bounds = MemoryUtils.RectAt(this.picHandle, 2);
        this.bounds.MoveTo((short)0, (short)0);
    }

    public Picture(Handle handle) {
        this.picHandle = handle;
        this.bounds = MemoryUtils.RectAt(this.picHandle, 2);
        this.bounds.MoveTo((short)0, (short)0);
    }

    Picture(int n) {
        this.picHandle = new PPHandle(n);
        this.bounds = MemoryUtils.RectAt(this.picHandle, 2);
        this.bounds.MoveTo((short)0, (short)0);
    }

    public Rect Bounds() {
        return new Rect(this.bounds);
    }

    public boolean Contains(Point point) {
        return this.bounds.Contains(point);
    }

    public void MoveTo(short s, short s2) {
        this.bounds.MoveTo(s, s2);
    }

    public void Offset(short s, short s2) {
        this.bounds.Offset(s, s2);
    }

    public void Frame() {
        this.bounds.Frame();
    }

    public void Paint() {
        Picture.DrawPicture(this.picHandle.getHandle(), this.bounds);
    }

    public void Fill(Pattern pattern) {
        this.bounds.Fill(pattern);
    }

    public void Invert() {
        this.bounds.Invert();
    }

    public void Erase() {
        this.bounds.Erase();
    }

    public void PaintScaled(Rect rect) {
        Picture.DrawPicture(this.picHandle.getHandle(), rect);
    }

    public Handle getPictHandle() {
        return this.picHandle;
    }

    protected void finalize() throws Throwable {
        Picture.KillPicture(this.picHandle.getHandle());
        this.picHandle = null;
        super.finalize();
    }

    private static native int GetPicture(short var0);

    private static native int Get1Resource(int var0, byte[] var1);

    private static native void DrawPicture(int var0, Rect var1);

    private static native void DetachResource(int var0);

    private static native void KillPicture(int var0);
}

