/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.Handle;
import com.apple.MacOS.MenuManager;
import com.apple.MacOS.ScriptConstants;
import com.apple.MacOS.Str255;
import com.apple.MacOS.StringPtr;
import com.apple.MacOS.TranslateString;

public class MenuHandle
extends MenuManager {
    public static MenuHandle GetOwnedMenu(int n, Handle handle) {
        if (n != 0) {
            return new MenuHandle(n, handle);
        }
        return null;
    }

    protected MenuHandle(int n, Handle handle) {
        super(n, handle);
    }

    public MenuHandle() {
        this(0, "");
    }

    public MenuHandle(int n, String string) {
        super(MenuHandle.NewMenu((short)n, TranslateString.asPascalBytes(string)));
    }

    public MenuHandle(short s, Str255 str255) {
        super(MenuHandle.NewMenu(s, TranslateString.asPascalBytes(str255)));
    }

    public MenuHandle(int n) {
        super(MenuHandle.GetMenu((short)n));
        MenuHandle.DetachResource(this.getHandle());
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[label '" + this.getTitle() + ", id " + this.getMenuID() + "]";
    }

    public short getMenuID() {
        return this.getShortAt(0);
    }

    public void setMenuID(int n) {
        this.setShortAt(0, (short)n);
    }

    public int getEnableFlags() {
        return this.getIntAt(10);
    }

    public void setEnableFlags(int n) {
        this.setIntAt(10, n);
    }

    public String getTitle() {
        return TranslateString.asString(this.getBytes(), (short)15, this.getByteAt(14), ScriptConstants.SystemFontScript);
    }

    public void setTitle(String string) {
        byte[] byArray = TranslateString.asPascalBytes(string);
        MenuHandle.Munger(this.getHandle(), 14, null, this.getByteAt(14), byArray, byArray.length);
    }

    public void getItemString(int n, Str255 str255) {
        MenuHandle.GetMenuItemText(this.getHandle(), (short)n, str255.getBytes());
    }

    public String getItemString(int n) {
        Str255 str255 = new Str255();
        MenuHandle.GetMenuItemText(this.getHandle(), (short)n, str255.getBytes());
        return str255.toString();
    }

    public byte getItemCmd(int n) {
        short[] sArray = new short[1];
        MenuHandle.GetItemCmd(this.getHandle(), (short)n, sArray);
        return (byte)sArray[0];
    }

    public void setItemCmd(int n, char c) {
        MenuHandle.SetItemCmd(this.getHandle(), (short)n, (byte)c);
    }

    public byte getItemMark(int n) {
        short[] sArray = new short[1];
        MenuHandle.GetItemMark(this.getHandle(), (short)n, sArray);
        return (byte)sArray[0];
    }

    public void setItemMark(int n, char c) {
        MenuHandle.SetItemMark(this.getHandle(), (short)n, (byte)c);
    }

    public short getItemIcon(int n) {
        short[] sArray = new short[1];
        MenuHandle.GetItemIcon(this.getHandle(), (short)n, sArray);
        return sArray[0];
    }

    public void setItemIcon(int n, short s) {
        MenuHandle.SetItemIcon(this.getHandle(), (short)n, s);
    }

    public void setItemScript(int n, short s) {
        MenuHandle.SetItemIcon(this.getHandle(), (short)n, s);
        MenuHandle.SetItemCmd(this.getHandle(), (short)n, (short)28);
    }

    public short getItemStyle(int n) {
        short[] sArray = new short[1];
        MenuHandle.GetItemStyle(this.getHandle(), (short)n, sArray);
        return sArray[0];
    }

    public void setItemStyle(int n, short s) {
        MenuHandle.SetItemStyle(this.getHandle(), (short)n, s);
    }

    public int appendMenu(String string) {
        MenuHandle.AppendMenu(this.getHandle(), TranslateString.asPascalBytes(string));
        return MenuHandle.CountMItems(this.getHandle());
    }

    public int appendResMenu(int n) {
        MenuHandle.AppendResMenu(this.getHandle(), n);
        return MenuHandle.CountMItems(this.getHandle());
    }

    public int insertResMenu(int n, int n2) {
        MenuHandle.InsertResMenu(this.getHandle(), n, (short)n2);
        return MenuHandle.CountMItems(this.getHandle());
    }

    public void insertMenu() {
        MenuHandle.InsertMenu(this.getHandle(), (short)0);
    }

    public void insertMenu(MenuHandle menuHandle) {
        MenuHandle.InsertMenu(this.getHandle(), menuHandle.getMenuID());
    }

    public void insertMenu(int n) {
        MenuHandle.InsertMenu(this.getHandle(), (short)n);
    }

    public void deleteMenu() {
        MenuHandle.DeleteMenu(this.getMenuID());
    }

    public void insertMenuItem(String string, int n) {
        this.insertMenuItem(new StringPtr(string), n);
    }

    public void insertMenuItem(StringPtr stringPtr, int n) {
        MenuHandle.InsertMenuItem(this.getHandle(), stringPtr.getBytes(), (short)n);
    }

    public void deleteMenuItem(int n) {
        MenuHandle.DeleteMenuItem(this.getHandle(), (short)n);
    }

    public void hiliteMenu() {
        MenuManager.hiliteMenu(this.getMenuID());
    }

    public void setMenuItemText(int n, String string) {
        this.setMenuItemText(n, new StringPtr(string, 240));
    }

    public void setMenuItemText(int n, StringPtr stringPtr) {
        if (stringPtr.length() > 240) {
            stringPtr = new StringPtr(stringPtr, 240);
        }
        MenuHandle.SetMenuItemText(this.getHandle(), (short)n, stringPtr.getBytes());
        short s = stringPtr.getScript();
        if (s != ScriptConstants.SystemFontScript) {
            this.setItemScript(n, s);
        }
    }

    public String getItem(int n) {
        Str255 str255 = new Str255();
        MenuHandle.GetMenuItemText(this.getHandle(), (short)n, str255.getBytes());
        return str255.toString();
    }

    public void disableItem(int n) {
        MenuHandle.DisableItem(this.getHandle(), (short)n);
    }

    public void enableItem(int n) {
        MenuHandle.EnableItem(this.getHandle(), (short)n);
    }

    public void checkItem(int n, boolean bl) {
        MenuHandle.CheckItem(this.getHandle(), (short)n, bl);
    }

    public void calcMenuSize() {
        MenuHandle.CalcMenuSize(this.getHandle());
    }

    public int countMenuItems() {
        return MenuHandle.CountMItems(this.getHandle());
    }

    public void flashMenuBar() {
        MenuManager.flashMenuBar(this.getMenuID());
    }

    public void initProcMenu(int n) {
        MenuHandle.InitProcMenu((short)n);
    }

    public int popupMenuSelect(int n, int n2, int n3) {
        return MenuHandle.PopUpMenuSelect(this.getHandle(), (short)n, (short)n2, (short)n3);
    }

    public int menuChoice() {
        return MenuHandle.MenuChoice();
    }

    public void insertFontResMenu(int n, int n2) {
        MenuHandle.InsertFontResMenu(this.getHandle(), (short)n, (short)n2);
    }

    public void insertIntlResMenu(int n, int n2, int n3) {
        MenuHandle.InsertIntlResMenu(this.getHandle(), n, (short)n2, (short)n3);
    }

    protected void FreeHandle(int n) {
        MenuHandle.DisposeMenu(n);
    }

    private static native void DetachResource(int var0);

    private static native int Munger(int var0, int var1, byte[] var2, int var3, byte[] var4, int var5);

    private static native int NewMenu(short var0, byte[] var1);

    private static native int GetMenu(short var0);

    private static native void DisposeMenu(int var0);

    private static native void AppendMenu(int var0, byte[] var1);

    private static native void AppendResMenu(int var0, int var1);

    private static native void InsertResMenu(int var0, int var1, short var2);

    private static native void InsertMenu(int var0, short var1);

    private static native void DeleteMenu(short var0);

    private static native void InsertMenuItem(int var0, byte[] var1, short var2);

    private static native void DeleteMenuItem(int var0, short var1);

    private static native void SetMenuItemText(int var0, short var1, byte[] var2);

    private static native void GetMenuItemText(int var0, short var1, byte[] var2);

    private static native void DisableItem(int var0, short var1);

    private static native void EnableItem(int var0, short var1);

    private static native void CheckItem(int var0, short var1, boolean var2);

    private static native void SetItemMark(int var0, short var1, short var2);

    private static native void GetItemMark(int var0, short var1, short[] var2);

    private static native void SetItemIcon(int var0, short var1, short var2);

    private static native void GetItemIcon(int var0, short var1, short[] var2);

    private static native void SetItemStyle(int var0, short var1, short var2);

    private static native void GetItemStyle(int var0, short var1, short[] var2);

    private static native void CalcMenuSize(int var0);

    private static native short CountMItems(int var0);

    private static native int GetMenuHandle(short var0);

    private static native void InitProcMenu(short var0);

    private static native void GetItemCmd(int var0, short var1, short[] var2);

    private static native void SetItemCmd(int var0, short var1, short var2);

    private static native int PopUpMenuSelect(int var0, short var1, short var2, short var3);

    private static native int MenuChoice();

    private static native void InsertFontResMenu(int var0, short var1, short var2);

    private static native void InsertIntlResMenu(int var0, int var1, short var2, short var3);
}

