/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.Cell;
import com.apple.MacOS.ControlHandle;
import com.apple.MacOS.DialogRef;
import com.apple.MacOS.EventRecord;
import com.apple.MacOS.Handle;
import com.apple.MacOS.ListSearchUPP;
import com.apple.MacOS.MemoryUtils;
import com.apple.MacOS.PenState;
import com.apple.MacOS.Point;
import com.apple.MacOS.Ptr;
import com.apple.MacOS.Rect;
import com.apple.MacOS.Region;
import com.apple.MacOS.Str255;
import com.apple.MacOS.TextUtilities;
import com.apple.MacOS.ToolboxObject;
import com.apple.MacOS.TranslateString;
import com.apple.MacOS.UniversalProcPtr;
import com.apple.MacOS.WindowRef;
import com.apple.memory.PShort;

public class ListHandle
extends Handle
implements ToolboxObject {
    boolean visible = true;
    boolean isOneDimensional = false;
    public static final short kTextLDEF = 0;
    private static short kMaxKeyThresh = (short)120;
    private Str255 gListNavigateString = new Str255();
    private int gLength = 0;
    private int gLastKeyTime;
    private int gTSThresh;

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[bounds '" + this.GetBounds() + ", DataBounds " + this.getDataBounds() + "]";
    }

    public ListHandle(Rect rect, Rect rect2, Point point, short s, WindowRef windowRef, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(ListHandle.LNew(rect, rect2, point.toInt(), s, windowRef.getPointer(), bl, bl2, bl3, bl4));
    }

    protected void FreeHandle(int n) {
        ListHandle.LDispose(n);
    }

    public short AddColumn(short s, short s2) {
        return ListHandle.LAddColumn(s, s2, this.handle);
    }

    public short AddRow(short s, short s2) {
        return ListHandle.LAddRow(s, s2, this.handle);
    }

    public void DelColumn(short s, short s2) {
        ListHandle.LDelColumn(s, s2, this.handle);
    }

    public void DelRow(short s, short s2) {
        ListHandle.LDelRow(s, s2, this.handle);
    }

    public boolean GetSelect(boolean bl, Cell cell) {
        return ListHandle.LGetSelect(bl, cell, this.handle);
    }

    public void SetSelect(boolean bl, Cell cell) {
        ListHandle.LSetSelect(bl, cell.toInt(), this.handle);
    }

    public void SetCell(Ptr ptr, short s, Cell cell) {
        ListHandle.LSetCell(ptr.getPointer(), s, cell.toInt(), this.handle);
    }

    public void SetCell(String string, Cell cell) {
        this.SetCell(TranslateString.asPtr(string), (short)string.length(), cell);
    }

    public void AddToCell(byte[] byArray, short s, Cell cell) {
        ListHandle.LAddToCell(byArray, s, cell.toInt(), this.handle);
    }

    public void ClrCell(Cell cell) {
        ListHandle.LClrCell(cell.toInt(), this.handle);
    }

    public byte[] GetCellData(short s, short s2, Cell cell) {
        PShort pShort = new PShort(s);
        PShort pShort2 = new PShort(s2);
        ListHandle.LGetCellDataLocation(pShort, pShort2, cell.toInt(), this.handle);
        byte[] byArray = new byte[pShort2.getValue()];
        this.getBytes(pShort.getValue(), byArray, 0, pShort2.getValue());
        return byArray;
    }

    public short GetCell(byte[] byArray, short s, Cell cell) {
        PShort pShort = new PShort(s);
        ListHandle.LGetCell(byArray, pShort, cell.toInt(), this.handle);
        return pShort.getValue();
    }

    public boolean Click(Point point, short s) {
        return ListHandle.LClick(point, s, this.handle);
    }

    public void Activate(boolean bl) {
        ListHandle.LActivate(bl, this.handle);
    }

    public void Update(Region region) {
        ListHandle.LUpdate(region.getHandle(), this.handle);
    }

    public void IsHilited(boolean bl) {
        this.Activate(bl);
    }

    public boolean HitTest(Point point) {
        return this.GetBounds().Contains(point);
    }

    public void SetDrawingMode(boolean bl) {
        ListHandle.LSetDrawingMode(bl, this.handle);
    }

    public void Draw() {
        this.Update(this.getWindowRef().GetUpdateRgn());
    }

    public void Draw(Cell cell) {
        ListHandle.LDraw(cell, this.handle);
    }

    public void AutoScroll(ListHandle listHandle) {
        ListHandle.LAutoScroll(this.handle);
    }

    public void Scroll(short s, short s2) {
        ListHandle.LScroll(s, s2, this.handle);
    }

    public void IsVisible(boolean bl) {
        if (!this.visible) {
            this.SetDrawingMode(bl);
        }
        this.visible = bl;
    }

    public boolean Search(byte[] byArray, short s, ListSearchUPP listSearchUPP, Cell cell) {
        return ListHandle.LSearch(byArray, s, UniversalProcPtr.getUPP(listSearchUPP), cell, this.handle);
    }

    public boolean Search(String string, ListSearchUPP listSearchUPP, Cell cell) {
        return this.Search(TranslateString.asBytes(string), (short)string.length(), listSearchUPP, cell);
    }

    public void Size(short s, short s2) {
        ListHandle.LSize(s, s2, this.handle);
    }

    public void CellSize(Point point) {
        ListHandle.LCellSize(point, this.handle);
    }

    public boolean NextCell(boolean bl, boolean bl2, Cell cell) {
        return ListHandle.LNextCell(bl, bl2, cell, this.handle);
    }

    public void Rect(Rect rect, Cell cell) {
        ListHandle.LRect(rect, cell.toInt(), this.handle);
    }

    public Cell LastClick() {
        return ListHandle.LLastClick(this.handle);
    }

    public Rect getRView() {
        return MemoryUtils.RectAt(this, 0);
    }

    public WindowRef getWindowRef() {
        return new WindowRef(this.getIntAt(8));
    }

    public Point getCellSize() {
        return new Point(this.getIntAt(16));
    }

    public void setRView(Rect rect) {
        MemoryUtils.setRectAt(this, 0, rect);
    }

    public Rect getVisible() {
        return MemoryUtils.RectAt(this, 20);
    }

    public Rect getDataBounds() {
        return MemoryUtils.RectAt(this, 72);
    }

    public short getRowCount() {
        return this.getDataBounds().Height();
    }

    public short getColumnCount() {
        return this.getDataBounds().Width();
    }

    public ControlHandle getVScroll() {
        return ControlHandle.GetOwnedControl(this.getIntAt(28), this);
    }

    public ControlHandle getHScroll() {
        return ControlHandle.GetOwnedControl(this.getIntAt(32), this);
    }

    public Point GetOrigin() {
        return this.getRView().topLeft();
    }

    public Rect GetBounds() {
        return this.getRView();
    }

    public void SetBounds(Rect rect) {
        ControlHandle controlHandle = this.getVScroll();
        ControlHandle controlHandle2 = this.getHScroll();
        int n = controlHandle == null ? 0 : 15;
        int n2 = controlHandle2 == null ? 0 : 15;
        Rect rect2 = this.getRView();
        rect2.Erase();
        if (controlHandle != null) {
            controlHandle.Hide();
        }
        if (controlHandle2 != null) {
            controlHandle2.Hide();
        }
        Rect rect3 = new Rect(rect);
        rect2.Set(rect3.getLeft(), rect3.getTop(), (short)(rect3.getRight() - n), (short)(rect3.getBottom() - n2));
        this.setRView(rect2);
        if (controlHandle != null) {
            controlHandle.Move((short)(rect3.getRight() - n), rect3.getTop());
        }
        if (controlHandle2 != null) {
            controlHandle2.Move(rect3.getLeft(), (short)(rect3.getBottom() - n2));
        }
        this.Size((short)(rect3.Width() - n), (short)(rect3.Height() - n2));
        if (this.visible) {
            if (controlHandle != null) {
                controlHandle.Show();
            }
            if (controlHandle2 != null) {
                controlHandle2.Show();
            }
        }
        if (this.isOneDimensional) {
            Point point = this.getCellSize();
            point.setH(rect3.Width() - n);
            this.CellSize(point);
        }
    }

    public void Invalidate() {
        Rect rect = this.getRView();
        this.getWindowRef().Inval(rect);
    }

    public void Show() {
        if (!this.visible) {
            this.visible = true;
            this.SetDrawingMode(this.visible);
            this.Invalidate();
        }
    }

    public void Hide() {
        if (this.visible) {
            this.visible = false;
            this.SetDrawingMode(this.visible);
            this.Invalidate();
        }
    }

    public static ListHandle CreateVerticallyScrollingList(WindowRef windowRef, Rect rect, short s, short s2) {
        Rect rect2 = new Rect();
        Point point = new Point();
        rect2.Set((short)0, (short)0, s, (short)0);
        point.Set(0, 0);
        if (rect.Empty()) {
            rect.Set((short)0, (short)0, (short)75, (short)75);
        }
        rect.setRight((short)(rect.getRight() - 15));
        return new ListHandle(rect, rect2, point, s2, windowRef, true, false, false, true);
    }

    public ListHandle CreateTextListInDialog(DialogRef dialogRef, short s) {
        Rect rect = dialogRef.GetItemRect(s);
        return ListHandle.CreateVerticallyScrollingList(dialogRef, rect, (short)1, (short)0);
    }

    public void DrawListBorder() {
        Rect rect = this.getRView();
        PenState penState = new PenState();
        penState.PenSize((short)1, (short)1);
        rect.Inset((short)-1, (short)-1);
        rect.Frame();
        penState.SetPenState();
    }

    public void AddItemsFromStringList(short s) {
        Str255 str255 = new Str255();
        Cell cell = new Cell();
        short s2 = this.getDataBounds().getBottom();
        short s3 = 1;
        do {
            str255.GetIndString(s, s3);
            if (str255.length() > 0) {
                s2 = this.AddRow((short)1, s2);
                cell.Set(0, (int)s2);
                this.SetCell(str255.toString(), cell);
            }
            s2 = (short)(s2 + 1);
            s3 = (short)(s3 + 1);
        } while (str255.length() > 0);
    }

    public boolean GetFirstSelectedCell(Cell cell) {
        cell.Set(0, 0);
        return this.GetSelect(true, cell);
    }

    public void GetLastSelectedCell(Cell cell) {
        Cell cell2 = null;
        if (this.GetFirstSelectedCell(cell2)) {
            do {
                cell = cell2;
                boolean bl = this.NextCell(true, true, cell2);
            } while (this.GetSelect(true, cell2));
        }
    }

    public void SelectOneCell(Cell cell) {
        Cell cell2 = null;
        if (this.GetFirstSelectedCell(cell2)) {
            while (this.GetSelect(true, cell2)) {
                if (cell2.h != cell.h || cell2.v != cell.v) {
                    this.SetSelect(false, cell2);
                    continue;
                }
                boolean bl = this.NextCell(true, true, cell2);
            }
        }
        this.SetSelect(true, cell);
    }

    public void MakeCellVisible(Cell cell) {
        int n = 0;
        int n2 = 0;
        Rect rect = this.getVisible();
        if (!rect.Contains(cell)) {
            short s = cell.getH();
            short s2 = cell.getV();
            short s3 = rect.getRight();
            short s4 = rect.getLeft();
            short s5 = rect.getTop();
            short s6 = rect.getBottom();
            if (s > s3 - 1) {
                n = s - s3 + 1;
            } else if (s < s4) {
                n = s - s4;
            }
            if (s2 > s6 - 1) {
                n2 = s2 - s6 + 1;
            } else if (s2 < s5) {
                n2 = s2 - s5;
            }
            this.Scroll((short)n, (short)n2);
        }
    }

    public short SearchPartialMatch(Ptr ptr, Ptr ptr2, short s, short s2) {
        if (s > 0 && s >= s2) {
            return TextUtilities.IdenticalText(ptr, ptr2, s2, s2);
        }
        return 1;
    }

    public short MatchNextAlphabetically(Ptr ptr, Ptr ptr2, short s, short s2) {
        short s3 = 1;
        if (s > 0) {
            if (TextUtilities.IdenticalText(ptr, ptr2, s2, s2) == 0) {
                s3 = 0;
            } else if (TextUtilities.CompareText(ptr, ptr2, s, s2) == 1) {
                s3 = 0;
            }
        }
        return s3;
    }

    private static native short LMGetKeyThresh();

    public void ResetTypeSelection() {
        this.gLength = 0;
        this.gLastKeyTime = 0;
        this.gTSThresh = 2 * ListHandle.LMGetKeyThresh();
        if (this.gTSThresh > kMaxKeyThresh) {
            this.gTSThresh = kMaxKeyThresh;
        }
    }

    public void KeySearchInList(EventRecord eventRecord) {
        Cell cell = new Cell();
        ListSearchUPP listSearchUPP = new ListSearchUPP("MatchNextAlphabetically");
        byte by = (byte)eventRecord.getCharCode();
        if (eventRecord.getWhen() - this.gLastKeyTime >= this.gTSThresh || this.gLength == 255) {
            this.ResetTypeSelection();
        }
        this.gLastKeyTime = eventRecord.getWhen();
        this.gListNavigateString.setByteAt(this.gLength, by);
        ++this.gLength;
        cell.Set(0, 0);
        if (this.Search(this.gListNavigateString.getBytes(), (short)this.gLength, listSearchUPP, cell)) {
            this.SelectOneCell(cell);
            this.MakeCellVisible(cell);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void FindNewCellLoc(Cell cell, Cell cell2, char c, boolean bl) {
        Rect rect = this.getDataBounds();
        int n = rect.getBottom() - rect.getTop();
        int n2 = rect.getRight() - rect.getLeft();
        cell2 = cell;
        if (bl) {
            switch (c) {
                case '\u001e': {
                    cell2.setV(0);
                    return;
                }
                case '\u001f': {
                    cell2.setV(n - 1);
                    return;
                }
                case '\u001c': {
                    cell2.setH(0);
                    return;
                }
                case '\u001d': {
                    cell2.setH(n2 - 1);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        switch (c) {
            case '\u001e': {
                if (cell.getV() == 0) return;
                cell2.setV(cell.v - 1);
                break;
            }
            case '\u001f': {
                if (cell.getV() == n - 1) return;
                cell2.setV(cell.v + 1);
                break;
            }
            case '\u001c': {
                if (cell.getH() == 0) return;
                cell2.setH(cell.h - 1);
                break;
            }
            case '\u001d': {
                if (cell.getH() == n2 - 1) return;
                cell2.setH(cell.h + 1);
            }
        }
    }

    public void ArrowKeyMoveSelection(char c, boolean bl) {
        Cell cell = new Cell();
        Cell cell2 = new Cell();
        if (this.GetFirstSelectedCell(cell)) {
            if (c == '\u001d' || c == '\u001f') {
                this.GetLastSelectedCell(cell);
            }
            this.FindNewCellLoc(cell, cell2, c, bl);
            this.SelectOneCell(cell2);
            this.MakeCellVisible(cell2);
        }
    }

    public void ArrowKeyExtendSelection(char c, boolean bl) {
        Cell cell = new Cell();
        Cell cell2 = new Cell();
        if (this.GetFirstSelectedCell(cell)) {
            if (c == '\u001d' || c == '\u001f') {
                this.GetLastSelectedCell(cell);
            }
            this.FindNewCellLoc(cell, cell2, c, bl);
            if (!this.GetSelect(false, cell2)) {
                this.SetSelect(true, cell2);
            }
            this.MakeCellVisible(cell2);
        }
    }

    public void ArrowKeyInList(EventRecord eventRecord, boolean bl) {
        if (!bl || eventRecord.shiftKeyDown()) {
            this.ArrowKeyMoveSelection(eventRecord.getCharCode(), eventRecord.cmdKeyDown());
        } else {
            this.ArrowKeyExtendSelection(eventRecord.getCharCode(), eventRecord.cmdKeyDown());
        }
    }

    private static native int LNew(Rect var0, Rect var1, int var2, short var3, int var4, boolean var5, boolean var6, boolean var7, boolean var8);

    private static native void LDispose(int var0);

    private static native short LAddColumn(short var0, short var1, int var2);

    private static native short LAddRow(short var0, short var1, int var2);

    private static native void LDelColumn(short var0, short var1, int var2);

    private static native void LDelRow(short var0, short var1, int var2);

    private static native boolean LGetSelect(boolean var0, Cell var1, int var2);

    private static native Cell LLastClick(int var0);

    private static native boolean LNextCell(boolean var0, boolean var1, Cell var2, int var3);

    private static native boolean LSearch(byte[] var0, short var1, int var2, Cell var3, int var4);

    private static native void LSize(short var0, short var1, int var2);

    private static native void LSetDrawingMode(boolean var0, int var1);

    private static native void LScroll(short var0, short var1, int var2);

    private static native void LAutoScroll(int var0);

    private static native void LUpdate(int var0, int var1);

    private static native void LActivate(boolean var0, int var1);

    private static native void LCellSize(Point var0, int var1);

    private static native boolean LClick(Point var0, short var1, int var2);

    private static native void LAddToCell(byte[] var0, short var1, int var2, int var3);

    private static native void LClrCell(int var0, int var1);

    private static native void LGetCell(byte[] var0, PShort var1, int var2, int var3);

    private static native void LRect(Rect var0, int var1, int var2);

    private static native void LSetCell(int var0, short var1, int var2, int var3);

    private static native void LSetSelect(boolean var0, int var1, int var2);

    private static native void LDraw(Cell var0, int var1);

    private static native void LGetCellDataLocation(PShort var0, PShort var1, int var2, int var3);
}

