/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.tracing;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopSpan;
import io.opentracing.noop.NoopTracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tag;
import io.opentracing.util.GlobalTracer;
import io.opentracing.util.ThreadLocalScopeManager;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePropagator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String TRACE_HOST_NAME = System.getProperty("solr.traceHostName", System.getProperty("host"));
    static final String TRACE_ID = System.getProperty("solr.traceIdHeader", "X-Trace-Id");
    private static final AtomicLong traceCounter = new AtomicLong(0L);

    public static void load() {
        GlobalTracer.registerIfAbsent(() -> {
            log.info("Always-on trace id generation enabled.");
            return new SimplePropagatorTracer();
        });
    }

    private static String newTraceId() {
        return TRACE_HOST_NAME + "-" + traceCounter.incrementAndGet();
    }

    static class SimplePropagatorTracer
    implements NoopTracer {
        private final ScopeManager scopeManager = new ThreadLocalScopeManager();

        SimplePropagatorTracer() {
        }

        public ScopeManager scopeManager() {
            return this.scopeManager;
        }

        public Span activeSpan() {
            return this.scopeManager.activeSpan();
        }

        public Scope activateSpan(Span span) {
            return this.scopeManager.activate(span);
        }

        public Tracer.SpanBuilder buildSpan(String operationName) {
            return new SimplePropagatorSpanBuilder(this.scopeManager);
        }

        public void close() {
        }

        public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
            if (!format.equals((Object)Format.Builtin.HTTP_HEADERS)) {
                return;
            }
            String traceId = spanContext.toTraceId();
            if (traceId != null && !traceId.isEmpty()) {
                TextMap tm = (TextMap)carrier;
                tm.put(TRACE_ID, traceId);
            }
        }

        public <C> SpanContext extract(Format<C> format, C carrier) {
            if (!format.equals((Object)Format.Builtin.HTTP_HEADERS)) {
                return NoopSpan.INSTANCE.context();
            }
            String traceId = null;
            TextMap tm = (TextMap)carrier;
            for (Map.Entry e : tm) {
                if (!((String)e.getKey()).equalsIgnoreCase(TRACE_ID)) continue;
                traceId = (String)e.getValue();
                break;
            }
            if (traceId == null) {
                traceId = SimplePropagator.newTraceId();
            }
            return new SimplePropagatorSpan(traceId);
        }

        public String toString() {
            return "SimplePropagator";
        }
    }

    private static final class SimplePropagatorSpan
    implements Span,
    SpanContext,
    NoopSpan {
        private final String traceId;

        private SimplePropagatorSpan(String traceId) {
            this.traceId = traceId;
        }

        public String toTraceId() {
            return this.traceId;
        }

        public String toSpanId() {
            return "";
        }

        public Iterable<Map.Entry<String, String>> baggageItems() {
            return Collections.emptyList();
        }

        public SpanContext context() {
            return this;
        }

        public void finish() {
        }

        public void finish(long arg0) {
        }

        public String getBaggageItem(String arg0) {
            return null;
        }

        public Span log(Map<String, ?> arg0) {
            return this;
        }

        public Span log(String arg0) {
            return this;
        }

        public Span log(long arg0, Map<String, ?> arg1) {
            return this;
        }

        public Span log(long arg0, String arg1) {
            return this;
        }

        public Span setBaggageItem(String arg0, String arg1) {
            return this;
        }

        public Span setOperationName(String arg0) {
            return this;
        }

        public Span setTag(String arg0, String arg1) {
            return this;
        }

        public Span setTag(String arg0, boolean arg1) {
            return this;
        }

        public Span setTag(String arg0, Number arg1) {
            return this;
        }

        public <T> Span setTag(Tag<T> arg0, T arg1) {
            return this;
        }
    }

    private static final class SimplePropagatorSpanBuilder
    implements Tracer.SpanBuilder {
        private final ScopeManager scopeManager;
        private SpanContext parent;

        public SimplePropagatorSpanBuilder(ScopeManager scopeManager) {
            this.scopeManager = scopeManager;
        }

        public Span start() {
            if (this.parent != null) {
                if (this.parent instanceof SimplePropagatorSpan) {
                    return (SimplePropagatorSpan)this.parent;
                }
                return NoopSpan.INSTANCE;
            }
            Span activeSpan = this.scopeManager.activeSpan();
            if (activeSpan != null) {
                return activeSpan;
            }
            return new SimplePropagatorSpan(SimplePropagator.newTraceId());
        }

        public Tracer.SpanBuilder addReference(String referenceType, SpanContext reference) {
            return this;
        }

        public Tracer.SpanBuilder asChildOf(SpanContext parent) {
            this.parent = parent;
            return this;
        }

        public Tracer.SpanBuilder asChildOf(Span parent) {
            return this;
        }

        public Tracer.SpanBuilder ignoreActiveSpan() {
            return this;
        }

        public Tracer.SpanBuilder withStartTimestamp(long arg0) {
            return this;
        }

        public Tracer.SpanBuilder withTag(String arg0, String arg1) {
            return this;
        }

        public Tracer.SpanBuilder withTag(String arg0, boolean arg1) {
            return this;
        }

        public Tracer.SpanBuilder withTag(String arg0, Number arg1) {
            return this;
        }

        public <T> Tracer.SpanBuilder withTag(Tag<T> arg0, T arg1) {
            return this;
        }
    }
}

