/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.URLUtil;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.update.IndexFingerprint;
import org.apache.solr.update.PeerSync;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.UpdateLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerSyncWithLeader
implements SolrMetricProducer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean debug = log.isDebugEnabled();
    private String leaderUrl;
    private int nUpdates;
    private UpdateHandler uhandler;
    private UpdateLog ulog;
    private final SolrClient clientToLeader;
    private final String coreName;
    private final String leaderBaseUrl;
    private boolean doFingerprint;
    private SolrCore core;
    private PeerSync.Updater updater;
    private MissedUpdatesFinder missedUpdatesFinder;
    private Set<Long> bufferedUpdates;
    private Timer syncTime;
    private Counter syncErrors;
    private Counter syncSkipped;
    private SolrMetricsContext solrMetricsContext;
    public static final String METRIC_SCOPE = "peerSync";

    public PeerSyncWithLeader(SolrCore core, String leaderUrl, int nUpdates) {
        this.core = core;
        this.leaderUrl = leaderUrl;
        this.nUpdates = nUpdates;
        this.doFingerprint = !"true".equals(System.getProperty("solr.disableFingerprint"));
        this.uhandler = core.getUpdateHandler();
        this.ulog = this.uhandler.getUpdateLog();
        this.leaderBaseUrl = URLUtil.extractBaseUrl((String)leaderUrl);
        this.coreName = URLUtil.extractCoreFromCoreUrl((String)leaderUrl);
        this.clientToLeader = core.getCoreContainer().getUpdateShardHandler().getRecoveryOnlyHttpClient();
        this.updater = new PeerSync.Updater(this.msg(), core);
        core.getCoreMetricManager().registerMetricProducer(SolrInfoBean.Category.REPLICATION.toString(), this);
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = parentContext.getChildContext(this);
        this.syncTime = this.solrMetricsContext.timer("time", scope, METRIC_SCOPE);
        this.syncErrors = this.solrMetricsContext.counter("errors", scope, METRIC_SCOPE);
        this.syncSkipped = this.solrMetricsContext.counter("skipped", scope, METRIC_SCOPE);
    }

    private String msg() {
        ZkController zkController = this.uhandler.core.getCoreContainer().getZkController();
        String myURL = "";
        if (zkController != null) {
            myURL = zkController.getBaseUrl();
        }
        return "PeerSync: core=" + this.uhandler.core.getName() + " url=" + myURL + " ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerSync.PeerSyncResult sync(List<Long> startingVersions) {
        if (this.ulog == null) {
            this.syncErrors.inc();
            return PeerSync.PeerSyncResult.failure();
        }
        if (startingVersions.isEmpty()) {
            log.warn("no frame of reference to tell if we've missed updates");
            this.syncErrors.inc();
            return PeerSync.PeerSyncResult.failure();
        }
        try (Timer.Context timerContext = null;){
            List<Long> ourUpdates;
            if (log.isInfoEnabled()) {
                log.info("{} START leader={} nUpdates={}", new Object[]{this.msg(), this.leaderUrl, this.nUpdates});
            }
            if (this.debug) {
                log.debug("{} startingVersions={} {}", new Object[]{this.msg(), startingVersions.size(), startingVersions});
            }
            if (this.doFingerprint && this.alreadyInSync()) {
                this.syncSkipped.inc();
                PeerSync.PeerSyncResult peerSyncResult = PeerSync.PeerSyncResult.success();
                return peerSyncResult;
            }
            timerContext = this.syncTime.time();
            try (UpdateLog.RecentUpdates recentUpdates = this.ulog.getRecentUpdates();){
                ourUpdates = recentUpdates.getVersions(this.nUpdates);
                this.bufferedUpdates = recentUpdates.getBufferUpdates();
            }
            ourUpdates.sort(PeerSync.absComparator);
            startingVersions.sort(PeerSync.absComparator);
            long ourLowThreshold = PeerSync.percentile(startingVersions, 0.8f);
            long ourHighThreshold = PeerSync.percentile(startingVersions, 0.2f);
            long smallestNewUpdate = Math.abs(ourUpdates.get(ourUpdates.size() - 1));
            if (Math.abs(startingVersions.get(0)) < smallestNewUpdate) {
                log.warn("{} too many updates received since start - startingUpdates no longer overlaps with our currentUpdates", (Object)this.msg());
                this.syncErrors.inc();
                PeerSync.PeerSyncResult peerSyncResult = PeerSync.PeerSyncResult.failure();
                return peerSyncResult;
            }
            for (Long ver : startingVersions) {
                if (Math.abs(ver) >= smallestNewUpdate) continue;
                ourUpdates.add(ver);
            }
            boolean success = this.doSync(ourUpdates, ourLowThreshold, ourHighThreshold);
            if (log.isInfoEnabled()) {
                log.info("{} DONE. sync {}", (Object)this.msg(), (Object)(success ? "succeeded" : "failed"));
            }
            if (!success) {
                this.syncErrors.inc();
            }
            PeerSync.PeerSyncResult peerSyncResult = success ? PeerSync.PeerSyncResult.success() : PeerSync.PeerSyncResult.failure();
            return peerSyncResult;
        }
    }

    private boolean doSync(List<Long> ourUpdates, long ourLowThreshold, long ourHighThreshold) {
        NamedList<Object> missedUpdatesRsp;
        NamedList<Object> leaderVersionsAndFingerprint = this.getVersions();
        IndexFingerprint leaderFingerprint = this.getFingerprint(leaderVersionsAndFingerprint);
        if (this.doFingerprint) {
            if (leaderFingerprint == null) {
                log.warn("Could not get fingerprint from the leader");
                return false;
            }
            log.info("Leader fingerprint {}", (Object)leaderFingerprint);
        }
        this.missedUpdatesFinder = new MissedUpdatesFinder(ourUpdates, this.msg(), this.nUpdates, ourLowThreshold);
        PeerSync.MissedUpdatesRequest missedUpdates = this.buildMissedUpdatesRequest(leaderVersionsAndFingerprint);
        if (missedUpdates == PeerSync.MissedUpdatesRequest.ALREADY_IN_SYNC) {
            return true;
        }
        if (missedUpdates != PeerSync.MissedUpdatesRequest.UNABLE_TO_SYNC && this.handleUpdates(missedUpdatesRsp = this.requestUpdates(missedUpdates), missedUpdates.totalRequestedUpdates, leaderFingerprint)) {
            if (this.doFingerprint) {
                return this.compareFingerprint(leaderFingerprint);
            }
            return true;
        }
        return false;
    }

    private PeerSync.MissedUpdatesRequest buildMissedUpdatesRequest(NamedList<Object> rsp) {
        List otherVersions = (List)rsp.get("versions");
        if (log.isInfoEnabled()) {
            log.info("{} Received {} versions from {}", new Object[]{this.msg(), otherVersions.size(), this.leaderUrl});
        }
        if (otherVersions.isEmpty()) {
            return PeerSync.MissedUpdatesRequest.UNABLE_TO_SYNC;
        }
        PeerSync.MissedUpdatesRequest updatesRequest = this.missedUpdatesFinder.find(otherVersions, this.leaderUrl);
        if (updatesRequest == PeerSync.MissedUpdatesRequest.EMPTY) {
            if (this.doFingerprint) {
                return PeerSync.MissedUpdatesRequest.UNABLE_TO_SYNC;
            }
            return PeerSync.MissedUpdatesRequest.ALREADY_IN_SYNC;
        }
        return updatesRequest;
    }

    private NamedList<Object> requestUpdates(PeerSync.MissedUpdatesRequest missedUpdatesRequest) {
        if (log.isInfoEnabled()) {
            log.info("{} Requesting updates from {} n={} versions={}", new Object[]{this.msg(), this.leaderUrl, missedUpdatesRequest.totalRequestedUpdates, missedUpdatesRequest.versionsAndRanges});
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("qt", new String[]{"/get"});
        params.set("distrib", false);
        params.set("getUpdates", new String[]{missedUpdatesRequest.versionsAndRanges});
        params.set("onlyIfActive", false);
        params.set("skipDbq", true);
        return this.request(params, "Failed on getting missed updates from the leader");
    }

    private boolean handleUpdates(NamedList<Object> rsp, long numRequestedUpdates, IndexFingerprint leaderFingerprint) {
        boolean existDBIOrDBQInTheGap;
        List updates = (List)rsp.get("updates");
        if ((long)updates.size() < numRequestedUpdates) {
            log.error("{} Requested {} updated from {} but retrieved {}", new Object[]{this.msg(), numRequestedUpdates, this.leaderUrl, updates.size()});
            return false;
        }
        try (UpdateLog.RecentUpdates recentUpdates = this.ulog.getRecentUpdates();){
            for (Long bufferUpdate : this.bufferedUpdates) {
                updates.add(recentUpdates.lookup(bufferUpdate));
            }
        }
        if (leaderFingerprint != null && !(existDBIOrDBQInTheGap = updates.stream().anyMatch(e -> {
            List u = (List)e;
            long version = (Long)u.get(1);
            int oper = (Integer)u.get(0) & 0xF;
            return version > leaderFingerprint.getMaxVersionEncountered() && (oper == 2 || oper == 3);
        }))) {
            updates.removeIf(e -> {
                List u = (List)e;
                long version = (Long)u.get(1);
                return version > leaderFingerprint.getMaxVersionEncountered();
            });
        }
        try {
            this.updater.applyUpdates(updates, this.leaderUrl);
        }
        catch (Exception e2) {
            return false;
        }
        return true;
    }

    private NamedList<Object> request(ModifiableSolrParams params, String onFail) {
        try {
            QueryRequest request = new QueryRequest((SolrParams)params, SolrRequest.METHOD.POST);
            request.setBasePath(this.leaderBaseUrl);
            QueryResponse rsp = (QueryResponse)request.process(this.clientToLeader, this.coreName);
            Exception exception = rsp.getException();
            if (exception != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, onFail);
            }
            return rsp.getResponse();
        }
        catch (IOException | SolrServerException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, onFail);
        }
    }

    private NamedList<Object> getVersions() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("qt", new String[]{"/get"});
        params.set("distrib", false);
        params.set("getVersions", this.nUpdates);
        params.set("fingerprint", this.doFingerprint);
        return this.request(params, "Failed to get recent versions from leader");
    }

    private boolean alreadyInSync() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("qt", new String[]{"/get"});
        params.set("distrib", false);
        params.set("getFingerprint", new String[]{String.valueOf(Long.MAX_VALUE)});
        NamedList<Object> rsp = this.request(params, "Failed to get fingerprint from leader");
        IndexFingerprint leaderFingerprint = this.getFingerprint(rsp);
        return this.compareFingerprint(leaderFingerprint);
    }

    private IndexFingerprint getFingerprint(NamedList<Object> rsp) {
        Object fingerprint = null;
        if (rsp != null) {
            fingerprint = rsp.get("fingerprint");
        }
        if (fingerprint == null) {
            return null;
        }
        return IndexFingerprint.fromObject(fingerprint);
    }

    private boolean compareFingerprint(IndexFingerprint leaderFingerprint) {
        if (leaderFingerprint == null) {
            log.warn("Replica did not return a fingerprint - possibly an older Solr version or exception");
            return false;
        }
        try {
            IndexFingerprint ourFingerprint = IndexFingerprint.getFingerprint(this.core, Long.MAX_VALUE);
            int cmp = IndexFingerprint.compare(leaderFingerprint, ourFingerprint);
            log.info("Fingerprint comparison result: {}", (Object)cmp);
            if (cmp != 0) {
                log.info("Leader fingerprint: {}, Our fingerprint: {}", (Object)leaderFingerprint, (Object)ourFingerprint);
            }
            return cmp == 0;
        }
        catch (IOException e) {
            log.warn("Could not confirm if we are already in sync. Continue with PeerSync");
            return false;
        }
    }

    public static class MissedUpdatesFinder
    extends PeerSync.MissedUpdatesFinderBase {
        private long ourHighest;
        private String logPrefix;
        private long nUpdates;

        MissedUpdatesFinder(List<Long> ourUpdates, String logPrefix, long nUpdates, long ourLowThreshold) {
            super(ourUpdates, ourLowThreshold);
            this.logPrefix = logPrefix;
            this.ourHighest = ourUpdates.get(0);
            this.nUpdates = nUpdates;
        }

        public PeerSync.MissedUpdatesRequest find(List<Long> leaderVersions, Object updateFrom) {
            leaderVersions.sort(PeerSync.absComparator);
            log.debug("{} sorted versions from {} = {}", new Object[]{this.logPrefix, updateFrom, leaderVersions});
            long leaderLowest = leaderVersions.get(leaderVersions.size() - 1);
            if (Math.abs(this.ourHighest) < Math.abs(leaderLowest)) {
                log.info("{} Our versions are too old comparing to leader, ourHighest={} otherLowest={}", new Object[]{this.logPrefix, this.ourHighest, leaderLowest});
                return PeerSync.MissedUpdatesRequest.UNABLE_TO_SYNC;
            }
            boolean completeList = (long)leaderVersions.size() < this.nUpdates;
            PeerSync.MissedUpdatesRequest updatesRequest = this.handleVersionsWithRanges(leaderVersions, completeList);
            if (updatesRequest.totalRequestedUpdates > this.nUpdates) {
                log.info("{} PeerSync will fail because number of missed updates is more than:{}", (Object)this.logPrefix, (Object)this.nUpdates);
                return PeerSync.MissedUpdatesRequest.UNABLE_TO_SYNC;
            }
            if (updatesRequest == PeerSync.MissedUpdatesRequest.EMPTY) {
                log.info("{} No additional versions requested", (Object)this.logPrefix);
            }
            return updatesRequest;
        }
    }
}

