/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Date;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.DocValuesAcc;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.SimpleAggValueSource;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.SumAgg;
import org.apache.solr.search.facet.UnInvertedFieldAcc;
import org.apache.solr.search.function.FieldNameValueSource;

public class SumsqAgg
extends SimpleAggValueSource {
    public SumsqAgg(ValueSource vs) {
        super("sumsq", vs);
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, long numDocs, int numSlots) throws IOException {
        ValueSource vs = this.getArg();
        if (vs instanceof FieldNameValueSource) {
            String field = ((FieldNameValueSource)vs).getFieldName();
            SchemaField sf = fcontext.qcontext.searcher().getSchema().getField(field);
            if (sf.getType().getNumberType() == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.name() + " aggregation not supported for " + sf.getType().getTypeName());
            }
            if (sf.multiValued() || sf.getType().multiValuedFieldCache()) {
                if (sf.hasDocValues()) {
                    if (sf.getType().isPointField()) {
                        return new SumSqSortedNumericAcc(fcontext, sf, numSlots);
                    }
                    return new SumSqSortedSetAcc(fcontext, sf, numSlots);
                }
                if (sf.getType().isPointField()) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.name() + " aggregation not supported for PointField w/o docValues");
                }
                return new SumSqUnInvertedFieldAcc(fcontext, sf, numSlots);
            }
            vs = sf.getType().getValueSource(sf, null);
        }
        return new SlotAcc.SumsqSlotAcc(vs, fcontext, numSlots);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new SumAgg.Merger();
    }

    static class SumSqSortedNumericAcc
    extends DocValuesAcc.DoubleSortedNumericDVAcc {
        public SumSqSortedNumericAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots, 0.0);
        }

        @Override
        protected void collectValues(int doc, int slot) throws IOException {
            int count = this.values.docValueCount();
            for (int i = 0; i < count; ++i) {
                double val = this.getDouble(this.values.nextValue());
                int n = slot;
                this.result[n] = this.result[n] + val * val;
            }
        }
    }

    static class SumSqSortedSetAcc
    extends DocValuesAcc.DoubleSortedSetDVAcc {
        public SumSqSortedSetAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots, 0.0);
        }

        @Override
        protected void collectValues(int doc, int slot) throws IOException {
            long ord;
            while ((ord = this.values.nextOrd()) != -1L) {
                BytesRef term = this.values.lookupOrd(ord);
                Object obj = this.sf.getType().toObject(this.sf, term);
                double val = obj instanceof Date ? (double)((Date)obj).getTime() : ((Number)obj).doubleValue();
                int n = slot;
                this.result[n] = this.result[n] + val * val;
            }
        }
    }

    static class SumSqUnInvertedFieldAcc
    extends UnInvertedFieldAcc.DoubleUnInvertedFieldAcc {
        public SumSqUnInvertedFieldAcc(FacetContext fcontext, SchemaField sf, int numSlots) throws IOException {
            super(fcontext, sf, numSlots, 0.0);
        }

        @Override
        public void call(int termNum) {
            try {
                BytesRef term = this.docToTerm.lookupOrd(termNum);
                Object obj = this.sf.getType().toObject(this.sf, term);
                double val = obj instanceof Date ? (double)((Date)obj).getTime() : ((Number)obj).doubleValue();
                int n = this.currentSlot;
                this.result[n] = this.result[n] + val * val;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

