/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RateLimiter;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.FastOutputStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrDeletionPolicy;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.core.backup.repository.LocalFileSystemRepository;
import org.apache.solr.handler.IndexFetcher;
import org.apache.solr.handler.OldBackupDirectory;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RestoreCore;
import org.apache.solr.handler.SnapShooter;
import org.apache.solr.handler.admin.api.CoreReplicationAPI;
import org.apache.solr.handler.admin.api.SnapshotBackupAPI;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.APIConfigProvider;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.NumberUtils;
import org.apache.solr.util.PropertiesInputStream;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ReplicationHandler
extends RequestHandlerBase
implements SolrCoreAware,
APIConfigProvider<ReplicationHandlerConfig> {
    public static final String PATH = "/replication";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    SolrCore core;
    private volatile boolean closed = false;
    private IndexFetcher pollingIndexFetcher;
    private ReentrantLock indexFetchLock = new ReentrantLock();
    private ExecutorService restoreExecutor = ExecutorUtil.newMDCAwareSingleThreadExecutor((ThreadFactory)new SolrNamedThreadFactory("restoreExecutor"));
    private volatile Future<Boolean> restoreFuture;
    private volatile String currentRestoreName;
    private String includeConfFiles;
    private NamedList<String> confFileNameAlias = new NamedList();
    private boolean isLeader = false;
    private boolean isFollower = false;
    private boolean replicateOnOptimize = false;
    private boolean replicateOnCommit = false;
    private boolean replicateOnStart = false;
    private volatile ScheduledExecutorService executorService;
    private volatile long executorStartTime;
    private int numTimesReplicated = 0;
    private final Map<String, FileInfo> confFileInfoCache = new HashMap<String, FileInfo>();
    private Long reserveCommitDuration = ReplicationHandler.readIntervalMs("00:00:10");
    volatile IndexCommit indexCommitPoint;
    volatile NamedList<?> snapShootDetails;
    private AtomicBoolean replicationEnabled = new AtomicBoolean(true);
    private Long pollIntervalNs;
    private String pollIntervalStr;
    private PollListener pollListener;
    private final ReplicationHandlerConfig replicationHandlerConfig = new ReplicationHandlerConfig();
    private AtomicBoolean pollDisabled = new AtomicBoolean(false);
    private volatile IndexFetcher currentIndexFetcher;
    private final CloseHook startShutdownHook = new CloseHook(){

        @Override
        public void preClose(SolrCore core) {
            if (ReplicationHandler.this.executorService != null) {
                ReplicationHandler.this.executorService.shutdown();
            }
        }

        @Override
        public void postClose(SolrCore core) {
            if (ReplicationHandler.this.pollingIndexFetcher != null) {
                ReplicationHandler.this.pollingIndexFetcher.destroy();
            }
            if (ReplicationHandler.this.currentIndexFetcher != null && ReplicationHandler.this.currentIndexFetcher != ReplicationHandler.this.pollingIndexFetcher) {
                ReplicationHandler.this.currentIndexFetcher.destroy();
            }
        }
    };
    private final CloseHook finishShutdownHook = new CloseHook(){

        @Override
        public void preClose(SolrCore core) {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)ReplicationHandler.this.restoreExecutor);
            if (ReplicationHandler.this.restoreFuture != null) {
                ReplicationHandler.this.restoreFuture.cancel(false);
            }
        }
    };
    private static final String SUCCESS = "success";
    private static final String FAILED = "failed";
    public static final String EXCEPTION = "exception";
    public static final String LEADER_URL = "leaderUrl";
    @Deprecated
    public static final String LEGACY_LEADER_URL = "masterUrl";
    public static final String FETCH_FROM_LEADER = "fetchFromLeader";
    public static final String SKIP_COMMIT_ON_LEADER_VERSION_ZERO = "skipCommitOnLeaderVersionZero";
    @Deprecated
    public static final String LEGACY_SKIP_COMMIT_ON_LEADER_VERSION_ZERO = "skipCommitOnMasterVersionZero";
    public static final String STATUS = "status";
    public static final String MESSAGE = "message";
    public static final String COMMAND = "command";
    public static final String CMD_DETAILS = "details";
    public static final String CMD_BACKUP = "backup";
    public static final String CMD_RESTORE = "restore";
    public static final String CMD_RESTORE_STATUS = "restorestatus";
    public static final String CMD_FETCH_INDEX = "fetchindex";
    public static final String CMD_ABORT_FETCH = "abortfetch";
    public static final String CMD_GET_FILE_LIST = "filelist";
    public static final String CMD_GET_FILE = "filecontent";
    public static final String CMD_DISABLE_POLL = "disablepoll";
    public static final String CMD_DISABLE_REPL = "disablereplication";
    public static final String CMD_ENABLE_REPL = "enablereplication";
    public static final String CMD_ENABLE_POLL = "enablepoll";
    public static final String CMD_INDEX_VERSION = "indexversion";
    public static final String CMD_SHOW_COMMITS = "commits";
    public static final String CMD_DELETE_BACKUP = "deletebackup";
    public static final String GENERATION = "generation";
    public static final String OFFSET = "offset";
    public static final String LEN = "len";
    public static final String FILE = "file";
    public static final String SIZE = "size";
    public static final String MAX_WRITE_PER_SECOND = "maxWriteMBPerSec";
    public static final String CONF_FILE_SHORT = "cf";
    public static final String TLOG_FILE = "tlogFile";
    public static final String CHECKSUM = "checksum";
    public static final String ALIAS = "alias";
    public static final String CONF_CHECKSUM = "confchecksum";
    public static final String CONF_FILES = "confFiles";
    public static final String REPLICATE_AFTER = "replicateAfter";
    public static final String FILE_STREAM = "filestream";
    public static final String POLL_INTERVAL = "pollInterval";
    public static final String INTERVAL_ERR_MSG = "The pollInterval must be in this format 'HH:mm:ss'";
    private static final Pattern INTERVAL_PATTERN = Pattern.compile("(\\d*?):(\\d*?):(\\d*)");
    public static final int PACKET_SZ = 0x100000;
    public static final String RESERVE = "commitReserveDuration";
    public static final String COMPRESSION = "compression";
    public static final String EXTERNAL = "external";
    public static final String INTERNAL = "internal";
    public static final String ERR_STATUS = "ERROR";
    public static final String OK_STATUS = "OK";
    public static final String NEXT_EXECUTION_AT = "nextExecutionAt";
    public static final String NUMBER_BACKUPS_TO_KEEP_REQUEST_PARAM = "numberToKeep";
    public static final String NUMBER_BACKUPS_TO_KEEP_INIT_PARAM = "maxNumberOfBackups";
    public static final String WAIT = "wait";

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    String getPollInterval() {
        return this.pollIntervalStr;
    }

    public void setPollListener(PollListener pollListener) {
        this.pollListener = pollListener;
    }

    public boolean isFollower() {
        return this.isFollower;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        rsp.setHttpCaching(false);
        SolrParams solrParams = req.getParams();
        String command = solrParams.required().get(COMMAND);
        if (command.equals(CMD_INDEX_VERSION)) {
            CoreReplicationAPI.IndexVersionResponse indexVersionResponse = this.getIndexVersionResponse();
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, (Object)indexVersionResponse);
        } else if (command.equals(CMD_GET_FILE)) {
            this.getFileStream(solrParams, rsp);
        } else if (command.equals(CMD_GET_FILE_LIST)) {
            CoreReplicationAPI coreReplicationAPI = new CoreReplicationAPI(this.core, req, rsp);
            V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, (Object)coreReplicationAPI.fetchFileList(Long.parseLong(solrParams.required().get(GENERATION))));
        } else if (command.equalsIgnoreCase(CMD_BACKUP)) {
            this.doSnapShoot((SolrParams)new ModifiableSolrParams(solrParams), rsp, req);
        } else if (command.equalsIgnoreCase(CMD_RESTORE)) {
            this.restore((SolrParams)new ModifiableSolrParams(solrParams), rsp, req);
        } else if (command.equalsIgnoreCase(CMD_RESTORE_STATUS)) {
            this.populateRestoreStatus(rsp);
        } else if (command.equalsIgnoreCase(CMD_DELETE_BACKUP)) {
            this.deleteSnapshot(new ModifiableSolrParams(solrParams), rsp);
        } else if (command.equalsIgnoreCase(CMD_FETCH_INDEX)) {
            this.fetchIndex(solrParams, rsp);
        } else if (command.equalsIgnoreCase(CMD_DISABLE_POLL)) {
            this.disablePoll(rsp);
        } else if (command.equalsIgnoreCase(CMD_ENABLE_POLL)) {
            this.enablePoll(rsp);
        } else if (command.equalsIgnoreCase(CMD_ABORT_FETCH)) {
            if (this.abortFetch()) {
                rsp.add(STATUS, OK_STATUS);
            } else {
                this.reportErrorOnResponse(rsp, "No follower configured", null);
            }
        } else if (command.equals(CMD_SHOW_COMMITS)) {
            this.populateCommitInfo(rsp);
        } else if (command.equals(CMD_DETAILS)) {
            this.getReplicationDetails(rsp, ReplicationHandler.getBoolWithBackwardCompatibility(solrParams, "follower", "slave", true));
        } else if (CMD_ENABLE_REPL.equalsIgnoreCase(command)) {
            this.replicationEnabled.set(true);
            rsp.add(STATUS, OK_STATUS);
        } else if (CMD_DISABLE_REPL.equalsIgnoreCase(command)) {
            this.replicationEnabled.set(false);
            rsp.add(STATUS, OK_STATUS);
        }
    }

    static boolean getBoolWithBackwardCompatibility(SolrParams params, String preferredKey, String alternativeKey, boolean defaultValue) {
        Boolean value = params.getBool(preferredKey);
        if (value != null) {
            return value;
        }
        return params.getBool(alternativeKey, defaultValue);
    }

    static <T> T getObjectWithBackwardCompatibility(SolrParams params, String preferredKey, String alternativeKey, T defaultValue) {
        String value = params.get(preferredKey);
        if (value != null) {
            return (T)value;
        }
        value = params.get(alternativeKey);
        if (value != null) {
            return (T)value;
        }
        return defaultValue;
    }

    public static <T> T getObjectWithBackwardCompatibility(NamedList<?> params, String preferredKey, String alternativeKey) {
        Object value = params.get(preferredKey);
        if (value != null) {
            return (T)value;
        }
        return (T)params.get(alternativeKey);
    }

    private void reportErrorOnResponse(SolrQueryResponse response, String message, Exception e) {
        response.add(STATUS, ERR_STATUS);
        response.add(MESSAGE, message);
        if (e != null) {
            response.add(EXCEPTION, e);
        }
    }

    public boolean abortFetch() {
        IndexFetcher fetcher = this.currentIndexFetcher;
        if (fetcher != null) {
            fetcher.abortFetch();
            return true;
        }
        return false;
    }

    private void deleteSnapshot(ModifiableSolrParams params, SolrQueryResponse rsp) {
        params.required().get("name");
        String location = params.get("location");
        this.core.getCoreContainer().assertPathAllowed(location == null ? null : Path.of(location, new String[0]));
        SnapShooter snapShooter = new SnapShooter(this.core, location, params.get("name"));
        snapShooter.validateDeleteSnapshot();
        snapShooter.deleteSnapAsync(this);
        rsp.add(STATUS, OK_STATUS);
    }

    private void fetchIndex(SolrParams solrParams, SolrQueryResponse rsp) throws InterruptedException {
        String leaderUrl = ReplicationHandler.getObjectWithBackwardCompatibility(solrParams, LEADER_URL, LEGACY_LEADER_URL, null);
        if (!this.isFollower && leaderUrl == null) {
            this.reportErrorOnResponse(rsp, "No follower configured or no 'leaderUrl' specified", null);
            return;
        }
        ModifiableSolrParams paramsCopy = new ModifiableSolrParams(solrParams);
        IndexFetcher.IndexFetchResult[] results = new IndexFetcher.IndexFetchResult[1];
        Thread fetchThread = new Thread(() -> this.lambda$fetchIndex$0((SolrParams)paramsCopy, results), "explicit-fetchindex-cmd");
        fetchThread.setDaemon(false);
        fetchThread.start();
        if (solrParams.getBool(WAIT, false)) {
            fetchThread.join();
            if (results[0] == null) {
                this.reportErrorOnResponse(rsp, "Unable to determine result of synchronous index fetch", null);
            } else if (results[0].getSuccessful()) {
                rsp.add(STATUS, OK_STATUS);
            } else {
                this.reportErrorOnResponse(rsp, results[0].getMessage(), null);
            }
        } else {
            rsp.add(STATUS, OK_STATUS);
        }
    }

    private List<NamedList<Object>> getCommits() {
        Map<Long, IndexCommit> commits = this.core.getDeletionPolicy().getCommits();
        ArrayList<NamedList<Object>> l = new ArrayList<NamedList<Object>>();
        for (IndexCommit c : commits.values()) {
            try {
                NamedList nl = new NamedList();
                nl.add("indexVersion", (Object)IndexDeletionPolicyWrapper.getCommitTimestamp(c));
                nl.add(GENERATION, (Object)c.getGeneration());
                ArrayList commitList = new ArrayList(c.getFileNames().size());
                commitList.addAll(c.getFileNames());
                Collections.sort(commitList);
                nl.add(CMD_GET_FILE_LIST, commitList);
                l.add((NamedList<Object>)nl);
            }
            catch (IOException e) {
                log.warn("Exception while reading files for commit {}", (Object)c, (Object)e);
            }
        }
        return l;
    }

    static Long getCheckSum(Checksum checksum, Path f) {
        Long l;
        block9: {
            checksum.reset();
            byte[] buffer = new byte[0x100000];
            InputStream in = Files.newInputStream(f, new OpenOption[0]);
            try {
                int bytesRead;
                while ((bytesRead = in.read(buffer)) >= 0) {
                    checksum.update(buffer, 0, bytesRead);
                }
                l = checksum.getValue();
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("Exception in finding checksum of {}", (Object)f, (Object)e);
                    return null;
                }
            }
            in.close();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexFetcher.IndexFetchResult doFetch(SolrParams solrParams, boolean forceReplication) {
        String leaderUrl;
        String string = leaderUrl = solrParams == null ? null : (String)ReplicationHandler.getObjectWithBackwardCompatibility(solrParams, LEADER_URL, LEGACY_LEADER_URL, null);
        if (!this.indexFetchLock.tryLock()) {
            return IndexFetcher.IndexFetchResult.LOCK_OBTAIN_FAILED;
        }
        if (this.core.getCoreContainer().isShutDown()) {
            log.warn("I was asked to replicate but CoreContainer is shutting down");
            return IndexFetcher.IndexFetchResult.CONTAINER_IS_SHUTTING_DOWN;
        }
        try {
            if (leaderUrl != null) {
                if (this.currentIndexFetcher != null && this.currentIndexFetcher != this.pollingIndexFetcher) {
                    this.currentIndexFetcher.destroy();
                }
                this.currentIndexFetcher = new IndexFetcher(solrParams.toNamedList(), this, this.core);
            } else {
                this.currentIndexFetcher = this.pollingIndexFetcher;
            }
            IndexFetcher.IndexFetchResult indexFetchResult = this.currentIndexFetcher.fetchLatestIndex(forceReplication);
            return indexFetchResult;
        }
        catch (Exception e) {
            log.error("Index fetch failed", (Throwable)e);
            if (this.currentIndexFetcher != this.pollingIndexFetcher) {
                this.currentIndexFetcher.destroy();
            }
            IndexFetcher.IndexFetchResult indexFetchResult = new IndexFetcher.IndexFetchResult("Fetching index failed by exception", false, e);
            return indexFetchResult;
        }
        finally {
            if (this.pollingIndexFetcher != null) {
                if (this.currentIndexFetcher != this.pollingIndexFetcher) {
                    this.currentIndexFetcher.destroy();
                }
                this.currentIndexFetcher = this.pollingIndexFetcher;
            }
            this.indexFetchLock.unlock();
        }
    }

    boolean isReplicating() {
        return this.indexFetchLock.isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restore(SolrParams params, SolrQueryResponse rsp, SolrQueryRequest req) throws IOException {
        if (this.restoreFuture != null && !this.restoreFuture.isDone()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Restore in progress. Cannot run multiple restore operationsfor the same core");
        }
        Object name = params.get("name");
        String location = params.get("location");
        String repoName = params.get("repository");
        CoreContainer cc = this.core.getCoreContainer();
        BackupRepository repo = null;
        if (repoName != null) {
            repo = cc.newBackupRepository(repoName);
            location = repo.getBackupLocation(location);
            if (location == null) {
                throw new IllegalArgumentException("location is required");
            }
        } else {
            repo = new LocalFileSystemRepository();
            if (location == null) {
                location = this.core.getDataDir();
            }
        }
        if (FILE.equals(repo.createURI("x").getScheme())) {
            this.core.getCoreContainer().assertPathAllowed(Paths.get(location, new String[0]));
        }
        URI locationUri = repo.createDirectoryURI(location);
        if (name == null) {
            String[] filePaths = repo.listAll(locationUri);
            ArrayList<OldBackupDirectory> dirs = new ArrayList<OldBackupDirectory>();
            for (String f : filePaths) {
                OldBackupDirectory obd = new OldBackupDirectory(locationUri, f);
                if (!obd.getTimestamp().isPresent()) continue;
                dirs.add(obd);
            }
            Collections.sort(dirs);
            if (dirs.size() == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No backup name specified and none found in " + this.core.getDataDir());
            }
            name = ((OldBackupDirectory)dirs.get(0)).getDirName();
        } else {
            name = "snapshot." + (String)name;
        }
        RestoreCore restoreCore = RestoreCore.create(repo, this.core, locationUri, (String)name);
        try {
            MDC.put((String)"RestoreCore.core", (String)this.core.getName());
            MDC.put((String)"RestoreCore.backupLocation", (String)location);
            MDC.put((String)"RestoreCore.backupName", (String)name);
            this.restoreFuture = this.restoreExecutor.submit(restoreCore);
            this.currentRestoreName = name;
            rsp.add(STATUS, OK_STATUS);
        }
        finally {
            MDC.remove((String)"RestoreCore.core");
            MDC.remove((String)"RestoreCore.backupLocation");
            MDC.remove((String)"RestoreCore.backupName");
        }
    }

    private void populateRestoreStatus(SolrQueryResponse rsp) {
        SimpleOrderedMap restoreStatus = new SimpleOrderedMap();
        if (this.restoreFuture == null) {
            restoreStatus.add(STATUS, (Object)"No restore actions in progress");
            rsp.add(CMD_RESTORE_STATUS, restoreStatus);
            rsp.add(STATUS, OK_STATUS);
            return;
        }
        restoreStatus.add("snapshotName", (Object)this.currentRestoreName);
        if (this.restoreFuture.isDone()) {
            try {
                boolean success = this.restoreFuture.get();
                if (success) {
                    restoreStatus.add(STATUS, (Object)SUCCESS);
                }
                restoreStatus.add(STATUS, (Object)FAILED);
            }
            catch (Exception e) {
                restoreStatus.add(STATUS, (Object)FAILED);
                restoreStatus.add(EXCEPTION, (Object)e.getMessage());
                rsp.add(CMD_RESTORE_STATUS, restoreStatus);
                this.reportErrorOnResponse(rsp, "Unable to read restorestatus", e);
                return;
            }
        } else {
            restoreStatus.add(STATUS, (Object)"In Progress");
        }
        rsp.add(CMD_RESTORE_STATUS, restoreStatus);
        rsp.add(STATUS, OK_STATUS);
    }

    private void populateCommitInfo(SolrQueryResponse rsp) {
        rsp.add(CMD_SHOW_COMMITS, this.getCommits());
        rsp.add(STATUS, OK_STATUS);
    }

    private void doSnapShoot(SolrParams params, SolrQueryResponse rsp, SolrQueryRequest req) {
        try {
            int numberToKeep = params.getInt(NUMBER_BACKUPS_TO_KEEP_REQUEST_PARAM, 0);
            String location = params.get("location");
            String repoName = params.get("repository");
            String commitName = params.get("commitName");
            String name = params.get("name");
            ReplicationHandler.doSnapShoot(numberToKeep, this.replicationHandlerConfig.numberBackupsToKeep, location, repoName, commitName, name, this.core, nl -> {
                this.snapShootDetails = nl;
            });
            rsp.add(STATUS, OK_STATUS);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Exception while creating a snapshot", (Throwable)e);
            this.reportErrorOnResponse(rsp, "Error encountered while creating a snapshot: " + e.getMessage(), e);
        }
    }

    public static void doSnapShoot(int numberToKeep, int numberBackupsToKeep, String location, String repoName, String commitName, String name, SolrCore core, Consumer<NamedList<?>> result) throws IOException {
        if (numberToKeep > 0 && numberBackupsToKeep > 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot use numberToKeep if maxNumberOfBackups was specified in the configuration.");
        }
        if ((numberToKeep = Math.max(numberToKeep, numberBackupsToKeep)) < 1) {
            numberToKeep = Integer.MAX_VALUE;
        }
        CoreContainer cc = core.getCoreContainer();
        BackupRepository repo = null;
        if (repoName != null) {
            repo = cc.newBackupRepository(repoName);
            location = repo.getBackupLocation(location);
            if (location == null) {
                throw new IllegalArgumentException("location is required");
            }
        } else {
            repo = new LocalFileSystemRepository();
            location = location == null ? core.getDataDir() : core.getCoreDescriptor().getInstanceDir().resolve(location).normalize().toString();
        }
        if (FILE.equals(repo.createURI("x").getScheme())) {
            core.getCoreContainer().assertPathAllowed(Paths.get(location, new String[0]));
        }
        URI locationUri = repo.createDirectoryURI(location);
        SnapShooter snapShooter = new SnapShooter(repo, core, locationUri, name, commitName);
        snapShooter.validateCreateSnapshot();
        snapShooter.createSnapAsync(numberToKeep, result);
    }

    private void getFileStream(SolrParams solrParams, SolrQueryResponse rsp) {
        ModifiableSolrParams rawParams = new ModifiableSolrParams(solrParams);
        rawParams.set("wt", new String[]{FILE_STREAM});
        String cfileName = solrParams.get(CONF_FILE_SHORT);
        String tlogFileName = solrParams.get(TLOG_FILE);
        if (cfileName != null) {
            rsp.add(FILE_STREAM, new LocalFsConfFileStream(solrParams));
        } else if (tlogFileName != null) {
            rsp.add(FILE_STREAM, new LocalFsTlogFileStream(solrParams));
        } else {
            rsp.add(FILE_STREAM, new DirectoryFileStream(solrParams));
        }
        rsp.add(STATUS, OK_STATUS);
    }

    public CoreReplicationAPI.IndexVersionResponse getIndexVersionResponse() throws IOException {
        IndexCommit commitPoint = this.indexCommitPoint;
        CoreReplicationAPI.IndexVersionResponse rsp = new CoreReplicationAPI.IndexVersionResponse();
        if (commitPoint == null) {
            commitPoint = this.core.getDeletionPolicy().getLatestCommit();
        }
        if (commitPoint != null && this.replicationEnabled.get()) {
            this.core.getDeletionPolicy().setReserveDuration(commitPoint.getGeneration(), this.reserveCommitDuration);
            rsp.indexVersion = IndexDeletionPolicyWrapper.getCommitTimestamp(commitPoint);
            rsp.generation = commitPoint.getGeneration();
        } else {
            rsp.indexVersion = 0L;
            rsp.generation = 0L;
        }
        rsp.status = OK_STATUS;
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CoreReplicationAPI.FileMetaData> getConfFileInfoFromCache(NamedList<String> nameAndAlias, Map<String, FileInfo> confFileInfoCache) {
        ArrayList<CoreReplicationAPI.FileMetaData> confFiles = new ArrayList<CoreReplicationAPI.FileMetaData>();
        Map<String, FileInfo> map = confFileInfoCache;
        synchronized (map) {
            Adler32 checksum = null;
            for (int i = 0; i < nameAndAlias.size(); ++i) {
                String cf = nameAndAlias.getName(i);
                Path f = this.core.getResourceLoader().getConfigPath().resolve(cf);
                if (!Files.exists(f, new LinkOption[0]) || Files.isDirectory(f, new LinkOption[0])) continue;
                FileInfo info = confFileInfoCache.get(cf);
                long lastModified = 0L;
                long size = 0L;
                try {
                    lastModified = Files.getLastModifiedTime(f, new LinkOption[0]).toMillis();
                    size = Files.size(f);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (info == null || info.lastmodified != lastModified || info.fileMetaData.size != size) {
                    if (checksum == null) {
                        checksum = new Adler32();
                    }
                    info = new FileInfo(lastModified, cf, size, ReplicationHandler.getCheckSum(checksum, f));
                    confFileInfoCache.put(cf, info);
                }
                CoreReplicationAPI.FileMetaData m = info.fileMetaData;
                if (nameAndAlias.getVal(i) != null) {
                    m.alias = (String)nameAndAlias.getVal(i);
                }
                confFiles.add(m);
            }
        }
        return confFiles;
    }

    private void disablePoll(SolrQueryResponse rsp) {
        if (this.pollingIndexFetcher != null) {
            this.pollDisabled.set(true);
            log.info("inside disable poll, value of pollDisabled = {}", (Object)this.pollDisabled);
            rsp.add(STATUS, OK_STATUS);
        } else {
            this.reportErrorOnResponse(rsp, "No follower configured", null);
        }
    }

    private void enablePoll(SolrQueryResponse rsp) {
        if (this.pollingIndexFetcher != null) {
            this.pollDisabled.set(false);
            log.info("inside enable poll, value of pollDisabled = {}", (Object)this.pollDisabled);
            rsp.add(STATUS, OK_STATUS);
        } else {
            this.reportErrorOnResponse(rsp, "No follower configured", null);
        }
    }

    boolean isPollingDisabled() {
        return this.pollDisabled.get();
    }

    @SuppressForbidden(reason="Need currentTimeMillis, to output next execution time in replication details")
    private void markScheduledExecutionStart() {
        this.executorStartTime = System.currentTimeMillis();
    }

    private Date getNextScheduledExecTime() {
        Date nextTime = null;
        if (this.executorStartTime > 0L) {
            nextTime = new Date(this.executorStartTime + TimeUnit.MILLISECONDS.convert(this.pollIntervalNs, TimeUnit.NANOSECONDS));
        }
        return nextTime;
    }

    int getTimesReplicatedSinceStartup() {
        return this.numTimesReplicated;
    }

    void setTimesReplicatedSinceStartup() {
        ++this.numTimesReplicated;
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.REPLICATION;
    }

    @Override
    public String getDescription() {
        return "ReplicationHandler provides replication of index and configuration files from Leader to Followers";
    }

    public NamedList<String> getConfFileNameAlias() {
        return this.confFileNameAlias;
    }

    public Map<String, FileInfo> getConfFileInfoCache() {
        return this.confFileInfoCache;
    }

    public String getIncludeConfFiles() {
        return this.includeConfFiles;
    }

    public Long getReserveCommitDuration() {
        return this.reserveCommitDuration;
    }

    private CommitVersionInfo getIndexVersion() {
        try {
            return this.core.withSearcher(searcher -> CommitVersionInfo.build(searcher.getIndexReader().getIndexCommit()));
        }
        catch (IOException e) {
            log.warn("Unable to get index commit: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        super.initializeMetrics(parentContext, scope);
        this.solrMetricsContext.gauge(() -> this.core != null && !this.core.isClosed() ? NumberUtils.readableSize(this.core.getIndexSize()) : parentContext.nullString(), true, "indexSize", this.getCategory().toString(), scope);
        this.solrMetricsContext.gauge(() -> this.core != null && !this.core.isClosed() ? this.getIndexVersion().toString() : parentContext.nullString(), true, "indexVersion", this.getCategory().toString(), scope);
        this.solrMetricsContext.gauge(() -> this.core != null && !this.core.isClosed() ? Long.valueOf(this.getIndexVersion().generation) : parentContext.nullNumber(), true, GENERATION, this.getCategory().toString(), scope);
        this.solrMetricsContext.gauge(() -> this.core != null && !this.core.isClosed() ? this.core.getIndexDir() : parentContext.nullString(), true, "indexPath", this.getCategory().toString(), scope);
        this.solrMetricsContext.gauge(() -> this.isLeader, true, "isLeader", this.getCategory().toString(), scope);
        this.solrMetricsContext.gauge(() -> this.isFollower, true, "isFollower", this.getCategory().toString(), scope);
        MetricsMap fetcherMap = new MetricsMap(map -> {
            IndexFetcher fetcher = this.currentIndexFetcher;
            if (fetcher != null) {
                map.put((CharSequence)LEADER_URL, (CharSequence)fetcher.getLeaderCoreUrl());
                if (this.getPollInterval() != null) {
                    map.put((CharSequence)POLL_INTERVAL, (CharSequence)this.getPollInterval());
                }
                map.put((CharSequence)"isPollingDisabled", this.isPollingDisabled());
                map.put((CharSequence)"isReplicating", this.isReplicating());
                long elapsed = fetcher.getReplicationTimeElapsed();
                long val = fetcher.getTotalBytesDownloaded();
                if (elapsed > 0L) {
                    map.put((CharSequence)"timeElapsed", elapsed);
                    map.put((CharSequence)"bytesDownloaded", val);
                    map.put((CharSequence)"downloadSpeed", val / elapsed);
                }
                Properties props = this.loadReplicationProperties();
                this.addReplicationProperties((arg_0, arg_1) -> ((MapWriter.EntryWriter)map).putNoEx(arg_0, arg_1), props);
            }
        });
        this.solrMetricsContext.gauge(fetcherMap, true, "fetcher", this.getCategory().toString(), scope);
        this.solrMetricsContext.gauge(() -> this.isLeader && this.includeConfFiles != null ? this.includeConfFiles : "", true, "confFilesToReplicate", this.getCategory().toString(), scope);
        this.solrMetricsContext.gauge(() -> this.isLeader ? this.getReplicateAfterStrings() : Collections.emptyList(), true, REPLICATE_AFTER, this.getCategory().toString(), scope);
        this.solrMetricsContext.gauge(() -> this.isLeader && this.replicationEnabled.get(), true, "replicationEnabled", this.getCategory().toString(), scope);
    }

    private NamedList<Object> getReplicationDetails(SolrQueryResponse rsp, boolean showFollowerDetails) {
        NamedList<?> snapshotStats;
        IndexFetcher fetcher;
        SimpleOrderedMap details = new SimpleOrderedMap();
        SimpleOrderedMap leader = new SimpleOrderedMap();
        SimpleOrderedMap follower = new SimpleOrderedMap();
        details.add("indexSize", (Object)NumberUtils.readableSize(this.core.getIndexSize()));
        details.add("indexPath", (Object)this.core.getIndexDir());
        details.add(CMD_SHOW_COMMITS, this.getCommits());
        details.add("isLeader", (Object)String.valueOf(this.isLeader));
        details.add("isFollower", (Object)String.valueOf(this.isFollower));
        CommitVersionInfo vInfo = this.getIndexVersion();
        details.add("indexVersion", (Object)(null == vInfo ? 0L : vInfo.version));
        details.add(GENERATION, (Object)(null == vInfo ? 0L : vInfo.generation));
        IndexCommit commit = this.indexCommitPoint;
        if (this.isLeader) {
            if (this.includeConfFiles != null) {
                leader.add(CONF_FILES, (Object)this.includeConfFiles);
            }
            leader.add(REPLICATE_AFTER, this.getReplicateAfterStrings());
            leader.add("replicationEnabled", (Object)String.valueOf(this.replicationEnabled.get()));
        }
        if (this.isLeader && commit != null) {
            CommitVersionInfo repCommitInfo = CommitVersionInfo.build(commit);
            leader.add("replicableVersion", (Object)repCommitInfo.version);
            leader.add("replicableGeneration", (Object)repCommitInfo.generation);
        }
        if ((fetcher = this.currentIndexFetcher) != null) {
            Date nextScheduled;
            Properties props = this.loadReplicationProperties();
            if (showFollowerDetails) {
                try {
                    NamedList<Object> nl = fetcher.getDetails();
                    follower.add("leaderDetails", nl.get(CMD_DETAILS));
                }
                catch (Exception e) {
                    log.warn("Exception while invoking 'details' method for replication on leader ", (Throwable)e);
                    follower.add(ERR_STATUS, (Object)"invalid_leader");
                }
            }
            follower.add(LEADER_URL, (Object)fetcher.getLeaderCoreUrl());
            if (this.getPollInterval() != null) {
                follower.add(POLL_INTERVAL, (Object)this.getPollInterval());
            }
            if ((nextScheduled = this.getNextScheduledExecTime()) != null && !this.isPollingDisabled()) {
                follower.add(NEXT_EXECUTION_AT, (Object)nextScheduled.toString());
            } else if (this.isPollingDisabled()) {
                follower.add(NEXT_EXECUTION_AT, (Object)"Polling disabled");
            }
            this.addReplicationProperties((arg_0, arg_1) -> ((NamedList)follower).add(arg_0, arg_1), props);
            follower.add("currentDate", (Object)new Date().toString());
            follower.add("isPollingDisabled", (Object)String.valueOf(this.isPollingDisabled()));
            boolean isReplicating = this.isReplicating();
            follower.add("isReplicating", (Object)String.valueOf(isReplicating));
            if (isReplicating) {
                try {
                    long bytesToDownload = 0L;
                    ArrayList<String> filesToDownload = new ArrayList<String>();
                    for (Map<String, Object> file : fetcher.getFilesToDownload()) {
                        filesToDownload.add((String)file.get("name"));
                        bytesToDownload += ((Long)file.get(SIZE)).longValue();
                    }
                    for (Map<String, Object> file : fetcher.getConfFilesToDownload()) {
                        filesToDownload.add((String)file.get("name"));
                        bytesToDownload += ((Long)file.get(SIZE)).longValue();
                    }
                    follower.add("filesToDownload", filesToDownload);
                    follower.add("numFilesToDownload", (Object)String.valueOf(filesToDownload.size()));
                    follower.add("bytesToDownload", (Object)NumberUtils.readableSize(bytesToDownload));
                    long bytesDownloaded = 0L;
                    ArrayList<String> filesDownloaded = new ArrayList<String>();
                    for (Map<String, Object> file : fetcher.getFilesDownloaded()) {
                        filesDownloaded.add((String)file.get("name"));
                        bytesDownloaded += ((Long)file.get(SIZE)).longValue();
                    }
                    for (Map<String, Object> file : fetcher.getConfFilesDownloaded()) {
                        filesDownloaded.add((String)file.get("name"));
                        bytesDownloaded += ((Long)file.get(SIZE)).longValue();
                    }
                    Map<String, Object> currentFile = fetcher.getCurrentFile();
                    String currFile = null;
                    long currFileSize = 0L;
                    long currFileSizeDownloaded = 0L;
                    float percentDownloaded = 0.0f;
                    if (currentFile != null) {
                        currFile = (String)currentFile.get("name");
                        currFileSize = (Long)currentFile.get(SIZE);
                        if (currentFile.containsKey("bytesDownloaded")) {
                            currFileSizeDownloaded = (Long)currentFile.get("bytesDownloaded");
                            bytesDownloaded += currFileSizeDownloaded;
                            if (currFileSize > 0L) {
                                percentDownloaded = (float)(currFileSizeDownloaded * 100L) / (float)currFileSize;
                            }
                        }
                    }
                    follower.add("filesDownloaded", filesDownloaded);
                    follower.add("numFilesDownloaded", (Object)String.valueOf(filesDownloaded.size()));
                    long estimatedTimeRemaining = 0L;
                    Date replicationStartTimeStamp = fetcher.getReplicationStartTimeStamp();
                    if (replicationStartTimeStamp != null) {
                        follower.add("replicationStartTime", (Object)replicationStartTimeStamp.toString());
                    }
                    long elapsed = fetcher.getReplicationTimeElapsed();
                    follower.add("timeElapsed", (Object)(String.valueOf(elapsed) + "s"));
                    if (bytesDownloaded > 0L) {
                        estimatedTimeRemaining = (bytesToDownload - bytesDownloaded) * elapsed / bytesDownloaded;
                    }
                    float totalPercent = 0.0f;
                    long downloadSpeed = 0L;
                    if (bytesToDownload > 0L) {
                        totalPercent = (float)(bytesDownloaded * 100L) / (float)bytesToDownload;
                    }
                    if (elapsed > 0L) {
                        downloadSpeed = bytesDownloaded / elapsed;
                    }
                    if (currFile != null) {
                        follower.add("currentFile", (Object)currFile);
                    }
                    follower.add("currentFileSize", (Object)NumberUtils.readableSize(currFileSize));
                    follower.add("currentFileSizeDownloaded", (Object)NumberUtils.readableSize(currFileSizeDownloaded));
                    follower.add("currentFileSizePercent", (Object)String.valueOf(percentDownloaded));
                    follower.add("bytesDownloaded", (Object)NumberUtils.readableSize(bytesDownloaded));
                    follower.add("totalPercent", (Object)String.valueOf(totalPercent));
                    follower.add("timeRemaining", (Object)(String.valueOf(estimatedTimeRemaining) + "s"));
                    follower.add("downloadSpeed", (Object)NumberUtils.readableSize(downloadSpeed));
                }
                catch (Exception e) {
                    log.error("Exception while writing replication details: ", (Throwable)e);
                }
            }
        }
        if (this.isLeader) {
            details.add("leader", (Object)leader);
        }
        if (follower.size() > 0) {
            details.add("follower", (Object)follower);
        }
        if ((snapshotStats = this.snapShootDetails) != null) {
            details.add(CMD_BACKUP, snapshotStats);
        }
        if (rsp.getValues().get(STATUS) == null) {
            rsp.add(STATUS, OK_STATUS);
        }
        rsp.add(CMD_DETAILS, details);
        return details;
    }

    private void addReplicationProperties(BiConsumer<String, Object> consumer, Properties props) {
        this.addVal(consumer, "indexReplicatedAt", props, Date.class);
        this.addVal(consumer, "indexReplicatedAtList", props, List.class);
        this.addVal(consumer, "replicationFailedAtList", props, List.class);
        this.addVal(consumer, "timesIndexReplicated", props, Integer.class);
        this.addVal(consumer, "confFilesReplicated", props, String.class);
        this.addVal(consumer, "timesConfigReplicated", props, Integer.class);
        this.addVal(consumer, "confFilesReplicatedAt", props, Date.class);
        this.addVal(consumer, "lastCycleBytesDownloaded", props, Long.class);
        this.addVal(consumer, "timesFailed", props, Integer.class);
        this.addVal(consumer, "replicationFailedAt", props, Date.class);
        this.addVal(consumer, "previousCycleTimeInSeconds", props, Long.class);
        this.addVal(consumer, "clearedLocalIndexFirst", props, Boolean.class);
    }

    private void addVal(BiConsumer<String, Object> consumer, String key, Properties props, Class<?> clzz) {
        Object val = this.formatVal(key, props, clzz);
        if (val != null) {
            consumer.accept(key, val);
        }
    }

    private Object formatVal(String key, Properties props, Class<?> clzz) {
        String s = props.getProperty(key);
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        if (clzz == Date.class) {
            try {
                Long l = Long.parseLong(s);
                return new Date(l).toString();
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (clzz == List.class) {
            String[] ss = s.split(",");
            ArrayList<String> l = new ArrayList<String>();
            for (String s1 : ss) {
                l.add(new Date(Long.parseLong(s1)).toString());
            }
            return l;
        }
        if (clzz == Long.class) {
            try {
                Long l = Long.parseLong(s);
                return l;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (clzz == Integer.class) {
            try {
                Integer i = Integer.parseInt(s);
                return i;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (clzz == Boolean.class) {
            return Boolean.parseBoolean(s);
        }
        return s;
    }

    private List<String> getReplicateAfterStrings() {
        ArrayList<String> replicateAfter = new ArrayList<String>();
        if (this.replicateOnCommit) {
            replicateAfter.add("commit");
        }
        if (this.replicateOnOptimize) {
            replicateAfter.add("optimize");
        }
        if (this.replicateOnStart) {
            replicateAfter.add("startup");
        }
        return replicateAfter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    Properties loadReplicationProperties() {
        Properties properties;
        IndexInput input;
        Directory dir;
        block14: {
            dir = null;
            dir = this.core.getDirectoryFactory().get(this.core.getDataDir(), DirectoryFactory.DirContext.META_DATA, this.core.getSolrConfig().indexConfig.lockType);
            try {
                input = dir.openInput("replication.properties", IOContext.DEFAULT);
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                Properties properties2 = new Properties();
                if (dir != null) {
                    this.core.getDirectoryFactory().release(dir);
                }
                return properties2;
            }
            PropertiesInputStream is = new PropertiesInputStream(input);
            Properties props = new Properties();
            props.load(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
            properties = props;
            input.close();
            if (dir == null) break block14;
            this.core.getDirectoryFactory().release(dir);
        }
        return properties;
        {
            catch (Throwable throwable) {
                try {
                    input.close();
                    throw throwable;
                    {
                        catch (Throwable throwable2) {
                            if (dir != null) {
                                this.core.getDirectoryFactory().release(dir);
                            }
                            throw throwable2;
                        }
                    }
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
        }
    }

    private void setupPolling(String intervalStr) {
        this.pollIntervalStr = intervalStr;
        this.pollIntervalNs = ReplicationHandler.readIntervalNs(this.pollIntervalStr);
        if (this.pollIntervalNs == null || this.pollIntervalNs <= 0L) {
            log.info(" No value set for 'pollInterval'. Timer Task not started.");
            return;
        }
        Map context = MDC.getCopyOfContextMap();
        Runnable task = () -> {
            MDC.setContextMap((Map)context);
            if (this.pollDisabled.get()) {
                log.info("Poll disabled");
                return;
            }
            ExecutorUtil.setServerThreadFlag((Boolean)true);
            try {
                log.debug("Polling for index modifications");
                this.markScheduledExecutionStart();
                IndexFetcher.IndexFetchResult fetchResult = this.doFetch(null, false);
                if (this.pollListener != null) {
                    this.pollListener.onComplete(this.core, fetchResult);
                }
            }
            catch (Exception e) {
                log.error("Exception in fetching index", (Throwable)e);
            }
            finally {
                ExecutorUtil.setServerThreadFlag(null);
            }
        };
        this.executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new SolrNamedThreadFactory("indexFetcher"));
        long initialDelayNs = new Random().nextLong() % this.pollIntervalNs + TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
        this.executorService.scheduleWithFixedDelay(task, initialDelayNs, this.pollIntervalNs, TimeUnit.NANOSECONDS);
        log.info("Poll scheduled at an interval of {}ms", (Object)TimeUnit.MILLISECONDS.convert(this.pollIntervalNs, TimeUnit.NANOSECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inform(SolrCore core) {
        String reserve;
        NamedList leader;
        boolean enableLeader;
        this.core = core;
        this.registerCloseHook();
        Object nbtk = this.initArgs.get(NUMBER_BACKUPS_TO_KEEP_INIT_PARAM);
        this.replicationHandlerConfig.numberBackupsToKeep = nbtk != null ? Integer.parseInt(nbtk.toString()) : 0;
        NamedList follower = (NamedList)ReplicationHandler.getObjectWithBackwardCompatibility(this.initArgs, "follower", "slave");
        boolean enableFollower = this.isEnabled(follower);
        if (enableFollower) {
            this.currentIndexFetcher = this.pollingIndexFetcher = new IndexFetcher(follower, this, core);
            this.setupPolling((String)follower.get(POLL_INTERVAL));
            this.isFollower = true;
        }
        if (((enableLeader = this.isEnabled(leader = (NamedList)ReplicationHandler.getObjectWithBackwardCompatibility(this.initArgs, "leader", "master"))) || enableFollower && !this.currentIndexFetcher.fetchFromLeader) && core.getCoreContainer().getZkController() != null) {
            log.warn("SolrCloud is enabled for core {} but so is old-style replication. Make sure you intend this behavior, it usually indicates a mis-configuration. Leader setting is {} and follower setting is {}", new Object[]{core.getName(), enableLeader, enableFollower});
        }
        if (!enableFollower && !enableLeader) {
            enableLeader = true;
            leader = new NamedList();
        }
        if (enableLeader) {
            List backup;
            boolean backupOnCommit;
            this.includeConfFiles = (String)leader.get(CONF_FILES);
            if (this.includeConfFiles != null && this.includeConfFiles.trim().length() > 0) {
                List<String> files = Arrays.asList(this.includeConfFiles.split(","));
                for (String file : files) {
                    if (file.trim().length() == 0) continue;
                    String[] strs = file.trim().split(":");
                    this.confFileNameAlias.add(strs[0], strs.length > 1 ? strs[1] : null);
                }
                log.info("Replication enabled for following config files: {}", (Object)this.includeConfFiles);
            }
            boolean backupOnOptimize = !(backupOnCommit = (backup = leader.getAll("backupAfter")).contains("commit")) && backup.contains("optimize");
            List replicateAfter = leader.getAll(REPLICATE_AFTER);
            this.replicateOnCommit = replicateAfter.contains("commit");
            boolean bl = this.replicateOnOptimize = !this.replicateOnCommit && replicateAfter.contains("optimize");
            if (!this.replicateOnCommit && !this.replicateOnOptimize) {
                this.replicateOnCommit = true;
            }
            if (this.replicateOnOptimize) {
                IndexDeletionPolicy policy;
                IndexDeletionPolicyWrapper wrapper = core.getDeletionPolicy();
                IndexDeletionPolicy indexDeletionPolicy = policy = wrapper == null ? null : wrapper.getWrappedDeletionPolicy();
                if (policy instanceof SolrDeletionPolicy) {
                    SolrDeletionPolicy solrPolicy = (SolrDeletionPolicy)policy;
                    if (solrPolicy.getMaxOptimizedCommitsToKeep() < 1) {
                        solrPolicy.setMaxOptimizedCommitsToKeep(1);
                    }
                } else {
                    log.warn("Replication can't call setMaxOptimizedCommitsToKeep on {}", (Object)policy);
                }
            }
            if (this.replicateOnOptimize || backupOnOptimize) {
                core.getUpdateHandler().registerOptimizeCallback(this.getEventListener(backupOnOptimize, this.replicateOnOptimize));
            }
            if (this.replicateOnCommit || backupOnCommit) {
                this.replicateOnCommit = true;
                core.getUpdateHandler().registerCommitCallback(this.getEventListener(backupOnCommit, this.replicateOnCommit));
            }
            if (replicateAfter.contains("startup")) {
                this.replicateOnStart = true;
                RefCounted<SolrIndexSearcher> s = core.getNewestSearcher(false);
                try {
                    DirectoryReader reader;
                    DirectoryReader directoryReader = reader = s == null ? null : s.get().getIndexReader();
                    if (reader != null && reader.getIndexCommit() != null && reader.getIndexCommit().getGeneration() != 1L) {
                        if (this.replicateOnOptimize) {
                            List commits = DirectoryReader.listCommits((Directory)reader.directory());
                            for (IndexCommit ic : commits) {
                                if (ic.getSegmentCount() != 1 || this.indexCommitPoint != null && this.indexCommitPoint.getGeneration() >= ic.getGeneration()) continue;
                                this.indexCommitPoint = ic;
                            }
                        } else {
                            this.indexCommitPoint = reader.getIndexCommit();
                        }
                    }
                    RefCounted<IndexWriter> iw = core.getUpdateHandler().getSolrCoreState().getIndexWriter(core);
                    iw.decref();
                }
                catch (IOException e) {
                    log.warn("Unable to get IndexCommit on startup", (Throwable)e);
                }
                finally {
                    if (s != null) {
                        s.decref();
                    }
                }
            }
            this.isLeader = true;
        }
        if ((reserve = (String)this.initArgs.get(RESERVE)) != null && !reserve.trim().isEmpty()) {
            this.reserveCommitDuration = ReplicationHandler.readIntervalMs(reserve);
        }
        log.info("Commits will be reserved for {} ms", (Object)this.reserveCommitDuration);
    }

    @Override
    public Collection<Class<? extends JerseyResource>> getJerseyResources() {
        return List.of(CoreReplicationAPI.class, SnapshotBackupAPI.class);
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    private boolean isEnabled(NamedList<?> params) {
        if (params == null) {
            return false;
        }
        Object enable = params.get("enable");
        if (enable == null) {
            return true;
        }
        if (enable instanceof String) {
            return StrUtils.parseBool((String)((String)enable));
        }
        return Boolean.TRUE.equals(enable);
    }

    private void registerCloseHook() {
        this.core.addCloseHook(this.startShutdownHook);
        this.core.addCloseHook(this.finishShutdownHook);
    }

    public void shutdown() {
        this.startShutdownHook.preClose(this.core);
        this.startShutdownHook.postClose(this.core);
        this.finishShutdownHook.preClose(this.core);
        this.finishShutdownHook.postClose(this.core);
        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.executorService);
        this.core.removeCloseHook(this.startShutdownHook);
        this.core.removeCloseHook(this.finishShutdownHook);
    }

    private SolrEventListener getEventListener(final boolean snapshoot, final boolean getCommit) {
        return new SolrEventListener(){

            @Override
            public void postCommit() {
                IndexCommit currentCommitPoint = ReplicationHandler.this.core.getDeletionPolicy().getLatestCommit();
                if (getCommit) {
                    ReplicationHandler.this.indexCommitPoint = currentCommitPoint;
                }
                if (snapshoot) {
                    try {
                        int numberToKeep = ReplicationHandler.this.replicationHandlerConfig.numberBackupsToKeep;
                        if (numberToKeep < 1) {
                            numberToKeep = Integer.MAX_VALUE;
                        }
                        SnapShooter snapShooter = new SnapShooter(ReplicationHandler.this.core, null, null);
                        snapShooter.validateCreateSnapshot();
                        snapShooter.createSnapAsync(numberToKeep, nl -> {
                            ReplicationHandler.this.snapShootDetails = nl;
                        });
                    }
                    catch (Exception e) {
                        log.error("Exception while snapshooting", (Throwable)e);
                    }
                }
            }

            @Override
            public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
            }

            @Override
            public void postSoftCommit() {
            }
        };
    }

    private static Long readIntervalMs(String interval) {
        return TimeUnit.MILLISECONDS.convert(ReplicationHandler.readIntervalNs(interval), TimeUnit.NANOSECONDS);
    }

    private static Long readIntervalNs(String interval) {
        if (interval == null) {
            return null;
        }
        int result = 0;
        Matcher m = INTERVAL_PATTERN.matcher(interval.trim());
        if (m.find()) {
            String hr = m.group(1);
            String min = m.group(2);
            String sec = m.group(3);
            result = 0;
            try {
                if (sec != null && sec.length() > 0) {
                    result += Integer.parseInt(sec);
                }
                if (min != null && min.length() > 0) {
                    result += 60 * Integer.parseInt(min);
                }
                if (hr != null && hr.length() > 0) {
                    result += 3600 * Integer.parseInt(hr);
                }
                return TimeUnit.NANOSECONDS.convert(result, TimeUnit.SECONDS);
            }
            catch (NumberFormatException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, INTERVAL_ERR_MSG);
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, INTERVAL_ERR_MSG);
    }

    @Override
    public ReplicationHandlerConfig provide() {
        return this.replicationHandlerConfig;
    }

    @Override
    public Class<ReplicationHandlerConfig> getConfigClass() {
        return ReplicationHandlerConfig.class;
    }

    private /* synthetic */ void lambda$fetchIndex$0(SolrParams paramsCopy, IndexFetcher.IndexFetchResult[] results) {
        IndexFetcher.IndexFetchResult result;
        results[0] = result = this.doFetch(paramsCopy, false);
    }

    public static class ReplicationHandlerConfig
    implements APIConfigProvider.APIConfig {
        private int numberBackupsToKeep = 0;

        public int getNumberBackupsToKeep() {
            return this.numberBackupsToKeep;
        }
    }

    public static interface PollListener {
        public void onComplete(SolrCore var1, IndexFetcher.IndexFetchResult var2) throws IOException;
    }

    private class LocalFsConfFileStream
    extends LocalFsFileStream {
        public LocalFsConfFileStream(SolrParams solrParams) {
            super(solrParams);
        }

        @Override
        protected Path initFile() {
            return ReplicationHandler.this.core.getResourceLoader().getConfigPath().resolve(this.cfileName);
        }
    }

    private class LocalFsTlogFileStream
    extends LocalFsFileStream {
        public LocalFsTlogFileStream(SolrParams solrParams) {
            super(solrParams);
        }

        @Override
        protected Path initFile() {
            return Path.of(ReplicationHandler.this.core.getUpdateHandler().getUpdateLog().getTlogDir(), this.tlogFileName);
        }
    }

    private class DirectoryFileStream
    implements SolrCore.RawWriter {
        protected SolrParams params;
        protected FastOutputStream fos;
        protected Long indexGen;
        protected IndexDeletionPolicyWrapper delPolicy;
        protected String fileName;
        protected String cfileName;
        protected String tlogFileName;
        protected String sOffset;
        protected String sLen;
        protected final boolean compress;
        protected boolean useChecksum;
        protected long offset = -1L;
        protected int len = -1;
        protected Checksum checksum;
        private RateLimiter rateLimiter;
        byte[] buf;

        public DirectoryFileStream(SolrParams solrParams) {
            this.params = solrParams;
            this.delPolicy = ReplicationHandler.this.core.getDeletionPolicy();
            this.fileName = this.validateFilenameOrError(this.params.get(ReplicationHandler.FILE));
            this.cfileName = this.validateFilenameOrError(this.params.get(ReplicationHandler.CONF_FILE_SHORT));
            this.tlogFileName = this.validateFilenameOrError(this.params.get(ReplicationHandler.TLOG_FILE));
            this.sOffset = this.params.get(ReplicationHandler.OFFSET);
            this.sLen = this.params.get(ReplicationHandler.LEN);
            this.compress = Boolean.parseBoolean(this.params.get(ReplicationHandler.COMPRESSION));
            this.useChecksum = this.params.getBool(ReplicationHandler.CHECKSUM, false);
            this.indexGen = this.params.getLong(ReplicationHandler.GENERATION);
            if (this.useChecksum) {
                this.checksum = new Adler32();
            }
            double maxWriteMBPerSec = this.params.getDouble(ReplicationHandler.MAX_WRITE_PER_SECOND, Double.MAX_VALUE);
            this.rateLimiter = new RateLimiter.SimpleRateLimiter(maxWriteMBPerSec);
        }

        protected String validateFilenameOrError(String fileName) {
            if (fileName != null) {
                Path filePath = Paths.get(fileName, new String[0]);
                filePath.forEach(subpath -> {
                    if ("..".equals(subpath.toString())) {
                        throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "File name cannot contain ..");
                    }
                });
                if (filePath.isAbsolute()) {
                    throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "File name must be relative");
                }
                return fileName;
            }
            return null;
        }

        protected void initWrite() throws IOException {
            if (this.sOffset != null) {
                this.offset = Long.parseLong(this.sOffset);
            }
            if (this.sLen != null) {
                this.len = Integer.parseInt(this.sLen);
            }
            if (this.fileName == null && this.cfileName == null && this.tlogFileName == null) {
                this.writeNothingAndFlush();
            }
            this.buf = new byte[this.len == -1 || this.len > 0x100000 ? 0x100000 : this.len];
            if (this.indexGen != null) {
                this.delPolicy.saveCommitPoint(this.indexGen);
            }
        }

        protected void createOutputStream(OutputStream out) {
            out = new CloseShieldOutputStream(out);
            this.fos = this.compress ? new FastOutputStream((OutputStream)new DeflaterOutputStream(out)) : new FastOutputStream(out);
        }

        protected void extendReserveAndReleaseCommitPoint() {
            if (this.indexGen != null) {
                this.delPolicy.setReserveDuration(this.indexGen, ReplicationHandler.this.reserveCommitDuration);
                this.delPolicy.releaseCommitPoint(this.indexGen);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(OutputStream out) throws IOException {
            this.createOutputStream(out);
            IndexInput in = null;
            try {
                this.initWrite();
                Directory dir = ReplicationHandler.this.core.withSearcher(searcher -> searcher.getIndexReader().directory());
                in = dir.openInput(this.fileName, IOContext.READONCE);
                if (this.offset != -1L) {
                    in.seek(this.offset);
                }
                long filelen = dir.fileLength(this.fileName);
                long maxBytesBeforePause = 0L;
                while (true) {
                    this.offset = this.offset == -1L ? 0L : this.offset;
                    int read = (int)Math.min((long)this.buf.length, filelen - this.offset);
                    in.readBytes(this.buf, 0, read);
                    this.fos.writeInt(read);
                    if (this.useChecksum) {
                        this.checksum.reset();
                        this.checksum.update(this.buf, 0, read);
                        this.fos.writeLong(this.checksum.getValue());
                    }
                    this.fos.write(this.buf, 0, read);
                    this.fos.flush();
                    log.debug("Wrote {} bytes for file {}", (Object)(this.offset + (long)read), (Object)this.fileName);
                    if ((maxBytesBeforePause += (long)read) >= this.rateLimiter.getMinPauseCheckBytes()) {
                        this.rateLimiter.pause(maxBytesBeforePause);
                        maxBytesBeforePause = 0L;
                    }
                    if (read != this.buf.length) {
                        this.writeNothingAndFlush();
                        this.fos.close();
                        break;
                    }
                    this.offset += (long)read;
                    in.seek(this.offset);
                }
            }
            catch (IOException e) {
                log.warn("Exception while writing response for params: {}", (Object)this.params, (Object)e);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                this.extendReserveAndReleaseCommitPoint();
            }
        }

        protected void writeNothingAndFlush() throws IOException {
            this.fos.writeInt(0);
            this.fos.flush();
        }
    }

    static class FileInfo {
        long lastmodified;
        CoreReplicationAPI.FileMetaData fileMetaData;

        public FileInfo(long lasmodified, String name, long size, long checksum) {
            this.lastmodified = lasmodified;
            this.fileMetaData = new CoreReplicationAPI.FileMetaData(size, name, checksum);
        }
    }

    private static final class CommitVersionInfo {
        public final long version;
        public final long generation;

        private CommitVersionInfo(long g, long v) {
            this.generation = g;
            this.version = v;
        }

        public static CommitVersionInfo build(IndexCommit commit) {
            long generation = commit.getGeneration();
            long version = 0L;
            try {
                Map commitData = commit.getUserData();
                String commitTime = (String)commitData.get("commitTimeMSec");
                if (commitTime != null) {
                    try {
                        version = Long.parseLong(commitTime);
                    }
                    catch (NumberFormatException e) {
                        log.warn("Version in commitData was not formatted correctly: {}", (Object)commitTime, (Object)e);
                    }
                }
            }
            catch (IOException e) {
                log.warn("Unable to get version from commitData, commit: {}", (Object)commit, (Object)e);
            }
            return new CommitVersionInfo(generation, version);
        }

        public String toString() {
            return "generation=" + this.generation + ",version=" + this.version;
        }
    }

    private abstract class LocalFsFileStream
    extends DirectoryFileStream {
        private Path file;

        public LocalFsFileStream(SolrParams solrParams) {
            super(solrParams);
            this.file = this.initFile();
        }

        protected abstract Path initFile();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(OutputStream out) throws IOException {
            block16: {
                this.createOutputStream(out);
                try {
                    this.initWrite();
                    if (Files.isReadable(this.file)) {
                        try (SeekableByteChannel channel = Files.newByteChannel(this.file, new OpenOption[0]);){
                            if (this.offset != -1L) {
                                channel.position(this.offset);
                            }
                            ByteBuffer bb = ByteBuffer.wrap(this.buf);
                            while (true) {
                                bb.clear();
                                long bytesRead = channel.read(bb);
                                if (bytesRead <= 0L) {
                                    this.writeNothingAndFlush();
                                    this.fos.close();
                                    break block16;
                                }
                                this.fos.writeInt((int)bytesRead);
                                if (this.useChecksum) {
                                    this.checksum.reset();
                                    this.checksum.update(this.buf, 0, (int)bytesRead);
                                    this.fos.writeLong(this.checksum.getValue());
                                }
                                this.fos.write(this.buf, 0, (int)bytesRead);
                                this.fos.flush();
                            }
                        }
                    }
                    this.writeNothingAndFlush();
                }
                catch (IOException e) {
                    log.warn("Exception while writing response for params: {}", (Object)this.params, (Object)e);
                }
                finally {
                    this.extendReserveAndReleaseCommitPoint();
                }
            }
        }
    }
}

