/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.plugins;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.Replica;
import org.apache.solr.cluster.SolrCollection;
import org.apache.solr.cluster.placement.PlacementContext;
import org.apache.solr.cluster.placement.PlacementPlugin;
import org.apache.solr.cluster.placement.PlacementPluginFactory;
import org.apache.solr.cluster.placement.plugins.OrderedNodePlacementPlugin;

public class RandomPlacementFactory
implements PlacementPluginFactory<PlacementPluginFactory.NoConfig> {
    @Override
    public PlacementPlugin createPluginInstance() {
        return new RandomPlacementPlugin();
    }

    public static class RandomPlacementPlugin
    extends OrderedNodePlacementPlugin {
        private final Random replicaPlacementRandom = new Random();

        private RandomPlacementPlugin() {
            String seed = System.getProperty("tests.seed");
            if (seed != null) {
                this.replicaPlacementRandom.setSeed(seed.hashCode());
            }
        }

        @Override
        protected Map<Node, OrderedNodePlacementPlugin.WeightedNode> getBaseWeightedNodes(PlacementContext placementContext, Set<Node> nodes, Iterable<SolrCollection> relevantCollections, boolean skipNodesWithErrors) {
            HashMap<Node, OrderedNodePlacementPlugin.WeightedNode> nodeMap = new HashMap<Node, OrderedNodePlacementPlugin.WeightedNode>();
            for (Node node : nodes) {
                nodeMap.put(node, new RandomNode(node, this.replicaPlacementRandom));
            }
            return nodeMap;
        }
    }

    private static class RandomNode
    extends OrderedNodePlacementPlugin.WeightedNode {
        private final Random random;
        private int randomTiebreaker;

        public RandomNode(Node node, Random random) {
            super(node);
            this.random = random;
            this.randomTiebreaker = random.nextInt();
        }

        @Override
        public int calcWeight() {
            return 0;
        }

        @Override
        public Comparable getTiebreaker() {
            return Integer.valueOf(this.randomTiebreaker);
        }

        @Override
        public int calcRelevantWeightWithReplica(Replica replica) {
            return this.calcWeight();
        }

        @Override
        protected boolean addProjectedReplicaWeights(Replica replica) {
            this.randomTiebreaker = this.random.nextInt();
            return false;
        }

        @Override
        protected void removeProjectedReplicaWeights(Replica replica) {
            this.randomTiebreaker = this.random.nextInt();
        }
    }
}

