/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.impl.SolrZkClientTimeout;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.Compressor;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.ZLibCompressor;
import org.apache.solr.core.NodeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkCpTool
extends ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ZkCpTool() {
        this(CLIO.getOutStream());
    }

    public ZkCpTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder().longOpt("source").hasArg().argName("SRC").required(true).desc("Source file or directory, may be local or a Znode.").build(), Option.builder().longOpt("destination").hasArg().argName("DST").required(true).desc("Destination of copy, may be local or a Znode.").build(), Option.builder().longOpt("solr-home").argName("DIR").hasArg().required(false).desc("Required to look up configuration for compressing state.json.").build(), SolrCLI.OPTION_RECURSE, SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED, SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_ZKHOST_DEPRECATED);
    }

    @Override
    public String getName() {
        return "cp";
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String zkHost = SolrCLI.getZkHost(cli);
        this.echoIfVerbose("\nConnecting to ZooKeeper at " + zkHost + " ...", cli);
        String src = cli.getOptionValue("source");
        String dst = cli.getOptionValue("destination");
        Boolean recurse = Boolean.parseBoolean(cli.getOptionValue("recurse"));
        this.echo("Copying from '" + src + "' to '" + dst + "'. ZooKeeper at " + zkHost);
        boolean srcIsZk = src.toLowerCase(Locale.ROOT).startsWith("zk:");
        boolean dstIsZk = dst.toLowerCase(Locale.ROOT).startsWith("zk:");
        String srcName = src;
        if (srcIsZk) {
            srcName = src.substring(3);
        } else if (srcName.toLowerCase(Locale.ROOT).startsWith("file:")) {
            srcName = srcName.substring(5);
        }
        Object dstName = dst;
        if (dstIsZk) {
            dstName = dst.substring(3);
            if (!((String)dstName).startsWith("/")) {
                dstName = "/" + (String)dstName;
            }
        } else if (((String)dstName).toLowerCase(Locale.ROOT).startsWith("file:")) {
            dstName = ((String)dstName).substring(5);
        }
        int minStateByteLenForCompression = -1;
        ZLibCompressor compressor = new ZLibCompressor();
        if (dstIsZk) {
            String solrHome = cli.getOptionValue("solr-home");
            if (StrUtils.isNullOrEmpty((String)solrHome)) {
                solrHome = System.getProperty("solr.home");
            }
            if (solrHome != null) {
                this.echoIfVerbose("Using SolrHome: " + solrHome, cli);
                try {
                    Path solrHomePath = Paths.get(solrHome, new String[0]);
                    Properties props = new Properties();
                    props.put("zkHost", zkHost);
                    NodeConfig nodeConfig = NodeConfig.loadNodeConfig(solrHomePath, props);
                    minStateByteLenForCompression = nodeConfig.getCloudConfig().getMinStateByteLenForCompression();
                    String stateCompressorClass = nodeConfig.getCloudConfig().getStateCompressorClass();
                    if (StrUtils.isNotNullOrEmpty((String)stateCompressorClass)) {
                        Class<Compressor> compressionClass = Class.forName(stateCompressorClass).asSubclass(Compressor.class);
                        compressor = compressionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
                catch (SolrException e) {
                    throw new IllegalStateException("Failed to load solr.xml, put/get operations on compressed data will use data as is. If your intention is to read and de-compress data or compress and write data, then solr.xml must be accessible.");
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalStateException("Unable to find or instantiate compression class: " + e.getMessage());
                }
            }
        }
        if (minStateByteLenForCompression > -1) {
            this.echoIfVerbose("Compression of state.json has been enabled", cli);
        }
        try (SolrZkClient zkClient = new SolrZkClient.Builder().withUrl(zkHost).withTimeout(SolrZkClientTimeout.DEFAULT_ZK_CLIENT_TIMEOUT, TimeUnit.MILLISECONDS).withStateFileCompression(minStateByteLenForCompression, (Compressor)compressor).build();){
            zkClient.zkTransfer(srcName, Boolean.valueOf(srcIsZk), (String)dstName, Boolean.valueOf(dstIsZk), recurse);
        }
        catch (Exception e) {
            log.error("Could not complete the zk operation for reason: ", (Throwable)e);
            throw e;
        }
    }
}

