/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.impl.SolrZkClientTimeout;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.cloud.SolrZkClient;

public class UpdateACLTool
extends ToolBase {
    public UpdateACLTool() {
        this(CLIO.getOutStream());
    }

    public UpdateACLTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "updateacls";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder().longOpt("path").argName("PATH").hasArg().required(true).desc("The path to update.").build(), SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_ZKHOST_DEPRECATED);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        String path = cli.getOptionValue("path");
        String zkHost = SolrCLI.getZkHost(cli);
        if (!ZkController.checkChrootPath(zkHost, true)) {
            throw new IllegalStateException("A chroot was specified in zkHost but the znode doesn't exist.");
        }
        try (SolrZkClient zkClient = new SolrZkClient.Builder().withUrl(zkHost).withTimeout(SolrZkClientTimeout.DEFAULT_ZK_CLIENT_TIMEOUT, TimeUnit.MILLISECONDS).build();){
            zkClient.updateACLs(path);
        }
    }
}

