/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import net.lingala.zip4j.core.HeaderWriter;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.CipherOutputStream;
import net.lingala.zip4j.io.DeflaterOutputStream;
import net.lingala.zip4j.io.SplitOutputStream;
import net.lingala.zip4j.io.ZipOutputStream;
import net.lingala.zip4j.model.EndCentralDirRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.util.ArchiveMaintainer;
import net.lingala.zip4j.util.CRCUtil;
import net.lingala.zip4j.util.Zip4jUtil;

public class ZipEngine {
    private ZipModel zipModel;

    public ZipEngine(ZipModel zipModel) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null in ZipEngine constructor");
        }
        this.zipModel = zipModel;
    }

    public void addFiles(ArrayList fileList, ZipParameters parameters, ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        ArrayList<ZipParameters> parametersList = new ArrayList<ZipParameters>();
        int i = 0;
        while (i < fileList.size()) {
            parametersList.add(parameters);
            ++i;
        }
        this.addFiles(fileList, parametersList, progressMonitor, runInThread);
    }

    public void addFiles(final ArrayList fileList, final ArrayList parametersList, final ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        if (fileList == null || parametersList == null || fileList.size() > parametersList.size()) {
            throw new ZipException("one of the input parameters is null when adding files");
        }
        if (fileList.size() <= 0) {
            throw new ZipException("no files to add");
        }
        progressMonitor.setTotalWork(this.calculateTotalWork(fileList, parametersList));
        progressMonitor.setCurrentOperation(0);
        progressMonitor.setState(1);
        progressMonitor.setResult(1);
        if (runInThread) {
            Thread thread = new Thread("Zip4j"){

                @Override
                public void run() {
                    try {
                        ZipEngine.this.initAddFiles(fileList, parametersList, progressMonitor);
                    }
                    catch (ZipException zipException) {
                        // empty catch block
                    }
                }
            };
            thread.start();
        } else {
            this.initAddFiles(fileList, parametersList, progressMonitor);
        }
    }

    private void initAddFiles(ArrayList fileList, ArrayList parametersList, ProgressMonitor progressMonitor) throws ZipException {
        if (fileList == null || parametersList == null || fileList.size() > parametersList.size()) {
            throw new ZipException("one of the input parameters is null when adding files");
        }
        if (fileList.size() <= 0) {
            throw new ZipException("no files to add");
        }
        if (this.zipModel.getEndCentralDirRecord() == null) {
            this.zipModel.setEndCentralDirRecord(this.createEndOfCentralDirectoryRecord());
        }
        CipherOutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            try {
                this.checkParameters(parametersList);
                this.removeFilesIfExists(fileList, parametersList, progressMonitor);
                boolean isZipFileAlreadExists = Zip4jUtil.checkFileExists(this.zipModel.getZipFileObj());
                SplitOutputStream splitOutputStream = new SplitOutputStream(this.zipModel.getZipFileObj(), this.zipModel.getSplitLength());
                outputStream = new ZipOutputStream(splitOutputStream, this.zipModel);
                if (isZipFileAlreadExists) {
                    if (this.zipModel.getEndCentralDirRecord() == null) {
                        throw new ZipException("invalid end of central directory record");
                    }
                    splitOutputStream.seek(this.zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
                }
                byte[] readBuff = new byte[4096];
                int readLen = -1;
                int i = 0;
                while (i < fileList.size()) {
                    ZipParameters parameters = (ZipParameters)parametersList.get(i);
                    ZipParameters fileParameters = (ZipParameters)parameters.clone();
                    progressMonitor.setFileName(((File)fileList.get(i)).getAbsolutePath());
                    if (!((File)fileList.get(i)).isDirectory()) {
                        if (fileParameters.isEncryptFiles() && fileParameters.getEncryptionMethod() == 0) {
                            progressMonitor.setCurrentOperation(3);
                            fileParameters.setSourceFileCRC((int)CRCUtil.computeFileCRC((File)fileList.get(i), progressMonitor));
                            progressMonitor.setCurrentOperation(0);
                        }
                        if (Zip4jUtil.getFileLengh((File)fileList.get(i)) == 0L) {
                            fileParameters.setCompressionMethod(0);
                        }
                    }
                    ((DeflaterOutputStream)outputStream).putNextEntry((File)fileList.get(i), fileParameters);
                    if (((File)fileList.get(i)).isDirectory()) {
                        ((DeflaterOutputStream)outputStream).closeEntry();
                    } else {
                        inputStream = new FileInputStream((File)fileList.get(i));
                        while ((readLen = inputStream.read(readBuff)) != -1) {
                            ((ZipOutputStream)outputStream).write(readBuff, 0, readLen);
                            progressMonitor.updateWorkCompleted(readLen);
                        }
                        ((DeflaterOutputStream)outputStream).closeEntry();
                        inputStream.close();
                    }
                    ++i;
                }
                ((DeflaterOutputStream)outputStream).finish();
                progressMonitor.endProgressMonitorSuccess();
            }
            catch (ZipException e) {
                progressMonitor.endProgressMonitorError(e);
                throw e;
            }
            catch (Exception e) {
                progressMonitor.endProgressMonitorError(e);
                throw new ZipException(e);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addStreamToZip(InputStream inputStream, ZipParameters parameters) throws ZipException {
        if (inputStream == null || parameters == null) {
            throw new ZipException("one of the input parameters is null, cannot add stream to zip");
        }
        CipherOutputStream outputStream = null;
        try {
            try {
                this.checkParameters(parameters);
                boolean isZipFileAlreadExists = Zip4jUtil.checkFileExists(this.zipModel.getZipFileObj());
                SplitOutputStream splitOutputStream = new SplitOutputStream(this.zipModel.getZipFileObj(), this.zipModel.getSplitLength());
                outputStream = new ZipOutputStream(splitOutputStream, this.zipModel);
                if (isZipFileAlreadExists) {
                    if (this.zipModel.getEndCentralDirRecord() == null) {
                        throw new ZipException("invalid end of central directory record");
                    }
                    splitOutputStream.seek(this.zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir());
                }
                byte[] readBuff = new byte[4096];
                int readLen = -1;
                ((DeflaterOutputStream)outputStream).putNextEntry(null, parameters);
                if (!parameters.getFileNameInZip().endsWith("/") && !parameters.getFileNameInZip().endsWith("\\")) {
                    while ((readLen = inputStream.read(readBuff)) != -1) {
                        ((ZipOutputStream)outputStream).write(readBuff, 0, readLen);
                    }
                }
                ((DeflaterOutputStream)outputStream).closeEntry();
                ((DeflaterOutputStream)outputStream).finish();
            }
            catch (ZipException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ZipException(e);
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addFolderToZip(File file, ZipParameters parameters, ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        if (file == null || parameters == null) {
            throw new ZipException("one of the input parameters is null, cannot add folder to zip");
        }
        if (!Zip4jUtil.checkFileExists(file.getAbsolutePath())) {
            throw new ZipException("input folder does not exist");
        }
        if (!file.isDirectory()) {
            throw new ZipException("input file is not a folder, user addFileToZip method to add files");
        }
        if (!Zip4jUtil.checkFileReadAccess(file.getAbsolutePath())) {
            throw new ZipException("cannot read folder: " + file.getAbsolutePath());
        }
        String rootFolderPath = null;
        rootFolderPath = parameters.isIncludeRootFolder() ? (file.getAbsolutePath() != null ? (file.getAbsoluteFile().getParentFile() != null ? file.getAbsoluteFile().getParentFile().getAbsolutePath() : "") : (file.getParentFile() != null ? file.getParentFile().getAbsolutePath() : "")) : file.getAbsolutePath();
        parameters.setDefaultFolderPath(rootFolderPath);
        ArrayList<File> fileList = Zip4jUtil.getFilesInDirectoryRec(file, parameters.isReadHiddenFiles());
        if (parameters.isIncludeRootFolder()) {
            if (fileList == null) {
                fileList = new ArrayList<File>();
            }
            fileList.add(file);
        }
        ArrayList<ZipParameters> parametersList = new ArrayList<ZipParameters>();
        int i = 0;
        while (i < fileList.size()) {
            parametersList.add(parameters);
            ++i;
        }
        this.addFiles(fileList, parametersList, progressMonitor, runInThread);
    }

    private void checkParameters(ArrayList parametersList) throws ZipException {
        int i = 0;
        while (i < parametersList.size()) {
            this.checkParameters((ZipParameters)parametersList.get(i));
            ++i;
        }
    }

    private void checkParameters(ZipParameters parameters) throws ZipException {
        if (parameters == null) {
            throw new ZipException("cannot validate zip parameters");
        }
        if (parameters.getCompressionMethod() != 0 && parameters.getCompressionMethod() != 8) {
            throw new ZipException("unsupported compression type");
        }
        if (parameters.getCompressionMethod() == 8 && parameters.getCompressionLevel() < 0 && parameters.getCompressionLevel() > 9) {
            throw new ZipException("invalid compression level. compression level dor deflate should be in the range of 0-9");
        }
        if (parameters.isEncryptFiles()) {
            if (parameters.getEncryptionMethod() != 0 && parameters.getEncryptionMethod() != 99) {
                throw new ZipException("unsupported encryption method");
            }
            if (parameters.getPassword() == null || parameters.getPassword().length <= 0) {
                throw new ZipException("input password is empty or null");
            }
        } else {
            parameters.setAesKeyStrength(-1);
            parameters.setEncryptionMethod(-1);
        }
    }

    public void removeFiles(final ArrayList fileHeaderList, final ProgressMonitor progressMonitor, boolean runInThread) throws ZipException {
        if (fileHeaderList == null) {
            throw new ZipException("one of the input parameters is null when removing files");
        }
        if (fileHeaderList.size() <= 0) {
            throw new ZipException("no files to remove");
        }
        ArchiveMaintainer archiveMaintainer = new ArchiveMaintainer();
        archiveMaintainer.initProgressMonitorForRemoveOp(this.zipModel, fileHeaderList, progressMonitor);
        if (runInThread) {
            Thread thread = new Thread("Zip4j"){

                @Override
                public void run() {
                    try {
                        ZipEngine.this.removeFilesIfExists(fileHeaderList, null, progressMonitor);
                    }
                    catch (ZipException zipException) {
                        // empty catch block
                    }
                }
            };
            thread.start();
        } else {
            this.removeFilesIfExists(fileHeaderList, null, progressMonitor);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeFilesIfExists(ArrayList fileList, ArrayList parametersList, ProgressMonitor progressMonitor) throws ZipException {
        if (this.zipModel == null) return;
        if (this.zipModel.getCentralDirectory() == null) return;
        if (this.zipModel.getCentralDirectory().getFileHeaders() == null) return;
        if (this.zipModel.getCentralDirectory().getFileHeaders().size() <= 0) {
            return;
        }
        outputRAF = null;
        inputRAF = null;
        try {
            currTime = System.currentTimeMillis();
            tmpZipFileName = String.valueOf(this.zipModel.getZipFileObj().getPath()) + currTime % 1000L;
            tmpFile = Zip4jUtil.getFileObj(this.zipModel.getZipFileObj(), tmpZipFileName);
            while (true) {
                if (!tmpFile.exists()) {
                    outputStream = null;
                    ** try [egrp 1[TRYBLOCK] [0 : 173->197)] { 
lbl16:
                    // 1 sources

                    break;
                }
                currTime = System.currentTimeMillis();
                tmpZipFileName = String.valueOf(this.zipModel.getZipFileObj().getPath()) + currTime % 1000L;
                tmpFile = Zip4jUtil.getFileObj(this.zipModel.getZipFileObj(), tmpZipFileName);
            }
            {
                outputStream = new SplitOutputStream(Zip4jUtil.getFileObj(this.zipModel.getZipFileObj(), tmpZipFileName));
            }
lbl23:
            // 1 sources

            catch (FileNotFoundException e1) {
                throw new ZipException(e1);
            }
            deletedFilesCount = 0;
            offsetLocalHdrs = new ArrayList<Long>(this.zipModel.getCentralDirectory().getFileHeaders().size());
            var14_14 = this.zipModel.getCentralDirectory().getFileHeaders().iterator();
            while (true) {
                if (!var14_14.hasNext()) {
                    offsetEndOfCompressedFile = Long.parseLong("-1");
                    archiveMaintainer = new ArchiveMaintainer();
                    i = 0;
                    break;
                }
                fileHeaderObj = var14_14.next();
                fileHeader = (FileHeader)fileHeaderObj;
                offsetLocalHdrs.add(fileHeader.getOffsetLocalHeader());
            }
            {
                while (true) {
                    if (i >= fileList.size()) break;
                    fileObj = fileList.get(i);
                    parameters = null;
                    if (fileObj instanceof File) {
                        parameters = (ZipParameters)parametersList.get(i);
                        fileName = Zip4jUtil.getRelativeFileName(((File)fileObj).getAbsolutePath(), parameters.getRootFolderInZip(), parameters.getDefaultFolderPath());
                    } else {
                        if (fileObj instanceof FileHeader == false) throw new ZipException("Invalid parameters passed. Cannot remove files.");
                        fileName = ((FileHeader)fileObj).getFileName();
                    }
                    fileHeader = Zip4jUtil.getFileHeader(this.zipModel, fileName);
                    if (fileHeader != null) {
                        if (outputRAF != null) {
                            outputRAF.close();
                            outputRAF = null;
                        }
                        progressMonitor.setCurrentOperation(2);
                        retMap = archiveMaintainer.initRemoveZipFile(this.zipModel, fileHeader, progressMonitor, offsetEndOfCompressedFile + 1L);
                        if (retMap != null && retMap.size() > 0) {
                            ++deletedFilesCount;
                            indexOfFileHeader = Zip4jUtil.getIndexOfFileHeader(this.zipModel, fileHeader);
                            offsetEndOfCompressedFile = Long.parseLong((String)retMap.get("offsetEndOfCompressedFile"));
                            offsetLocalFileHeader = Long.parseLong((String)retMap.get("offsetLocalFileHeader"));
                            offsetLocalHdrs.set(indexOfFileHeader, offsetLocalFileHeader - offsetEndOfCompressedFile - 1L);
                        }
                        if (progressMonitor.isCancelAllTasks()) {
                            progressMonitor.setResult(3);
                            progressMonitor.setState(0);
                            return;
                        }
                        ** try [egrp 5[TRYBLOCK] [8 : 601->1098)] { 
lbl68:
                        // 1 sources

                        progressMonitor.setCurrentOperation(0);
                        outputRAF = this.prepareFileOutputStream();
                        if (retMap != null && retMap.get("offsetCentralDir") != null) {
                            offsetCentralDir = -1L;
                            try {
                                offsetCentralDir = Long.parseLong((String)retMap.get("offsetCentralDir"));
                            }
                            catch (NumberFormatException e) {
                                throw new ZipException("NumberFormatException while parsing offset central directory. Cannot update already existing file header");
                            }
                            catch (Exception e) {
                                throw new ZipException("Error while parsing offset central directory. Cannot update already existing file header");
                            }
                            if (offsetCentralDir >= 0L) {
                                outputRAF.seek(offsetCentralDir);
                            }
                        }
                    }
                    ++i;
                }
                deletedHeaderCount = 0;
                fileHeaderCount = this.zipModel.getCentralDirectory().getFileHeaders().size();
                offsetStart = 0L;
                negativeOffsetLocalHdr = 0L;
                inputRAF = archiveMaintainer.createFileHandler(this.zipModel, "r");
                i = 0;
                while (true) {
                    if (i >= fileHeaderCount) {
                        if (offsetStart != -1L) {
                            archiveMaintainer.copyLeftOverStream(this.zipModel, null, progressMonitor, outputStream, offsetStart);
                        }
                        this.zipModel.getEndCentralDirRecord().setOffsetOfStartOfCentralDir(outputStream.getFilePointer());
                        this.zipModel.getEndCentralDirRecord().setTotNoOfEntriesInCentralDir(this.zipModel.getEndCentralDirRecord().getTotNoOfEntriesInCentralDir() - deletedFilesCount);
                        this.zipModel.getEndCentralDirRecord().setTotNoOfEntriesInCentralDirOnThisDisk(this.zipModel.getEndCentralDirRecord().getTotNoOfEntriesInCentralDirOnThisDisk() - deletedFilesCount);
                        if (inputRAF == null) break;
                        try {
                            inputRAF.close();
                        }
                        catch (IOException i) {
                            // empty catch block
                        }
                        break;
                    }
                    dynamicIndex = i - deletedHeaderCount;
                    newOffsetLocalHdr = (Long)offsetLocalHdrs.get(i);
                    offsetLocalHdr = ((FileHeader)this.zipModel.getCentralDirectory().getFileHeaders().get(dynamicIndex)).getOffsetLocalHeader();
                    if (newOffsetLocalHdr >= 0L) {
                        if (offsetStart == -1L) {
                            offsetStart = offsetLocalHdr;
                        }
                        ((FileHeader)this.zipModel.getCentralDirectory().getFileHeaders().get(dynamicIndex)).setOffsetLocalHeader(offsetLocalHdr + negativeOffsetLocalHdr);
                    } else {
                        if (offsetStart != -1L) {
                            archiveMaintainer.copyFile(inputRAF, outputStream, offsetStart, offsetLocalHdr, progressMonitor);
                            offsetStart = -1L;
                        }
                        this.zipModel.getCentralDirectory().getFileHeaders().remove(dynamicIndex);
                        ++deletedHeaderCount;
                        negativeOffsetLocalHdr += newOffsetLocalHdr.longValue();
                    }
                    ++i;
                }
                if (outputRAF != null) {
                    try {
                        outputRAF.close();
                    }
                    catch (IOException i) {
                        // empty catch block
                    }
                }
                headerWriter = new HeaderWriter();
                headerWriter.finalizeZipFile(this.zipModel, outputStream);
                outputStream.close();
                if (deletedFilesCount != 0) {
                    ArchiveMaintainer.restoreFileName(this.zipModel.getZipFileObj(), tmpZipFileName);
                    return;
                }
                newZipFile = Zip4jUtil.getFileObj(this.zipModel.getZipFileObj(), tmpZipFileName);
                newZipFile.delete();
                return;
            }
        }
lbl136:
        // 2 sources

        catch (IOException e) {
            throw new ZipException(e);
        }
        finally {
            if (outputRAF != null) {
                try {
                    outputRAF.close();
                }
                catch (IOException var27_35) {}
            }
            if (inputRAF != null) {
                try {
                    inputRAF.close();
                }
                catch (IOException var27_36) {}
            }
        }
    }

    private RandomAccessFile prepareFileOutputStream() throws ZipException {
        String outPath = this.zipModel.getZipFileObj().getPath();
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(outPath)) {
            throw new ZipException("invalid output path");
        }
        try {
            File outFile = this.zipModel.getZipFileObj();
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            return Zip4jUtil.getRandomAccess(outFile, "rw");
        }
        catch (FileNotFoundException e) {
            throw new ZipException(e);
        }
    }

    private EndCentralDirRecord createEndOfCentralDirectoryRecord() {
        EndCentralDirRecord endCentralDirRecord = new EndCentralDirRecord();
        endCentralDirRecord.setSignature(101010256L);
        endCentralDirRecord.setNoOfThisDisk(0);
        endCentralDirRecord.setTotNoOfEntriesInCentralDir(0);
        endCentralDirRecord.setTotNoOfEntriesInCentralDirOnThisDisk(0);
        endCentralDirRecord.setOffsetOfStartOfCentralDir(0L);
        return endCentralDirRecord;
    }

    private long calculateTotalWork(ArrayList fileList, ArrayList parametersList) throws ZipException {
        if (fileList == null) {
            throw new ZipException("file list is null, cannot calculate total work");
        }
        long totalWork = 0L;
        int i = 0;
        while (i < fileList.size()) {
            ZipParameters parameters = (ZipParameters)parametersList.get(i);
            if (fileList.get(i) instanceof File && ((File)fileList.get(i)).exists()) {
                String relativeFileName;
                FileHeader fileHeader;
                totalWork = parameters.isEncryptFiles() && parameters.getEncryptionMethod() == 0 ? (totalWork += Zip4jUtil.getFileLengh((File)fileList.get(i)) * 2L) : (totalWork += Zip4jUtil.getFileLengh((File)fileList.get(i)));
                if (this.zipModel.getCentralDirectory() != null && this.zipModel.getCentralDirectory().getFileHeaders() != null && this.zipModel.getCentralDirectory().getFileHeaders().size() > 0 && (fileHeader = Zip4jUtil.getFileHeader(this.zipModel, relativeFileName = Zip4jUtil.getRelativeFileName(((File)fileList.get(i)).getAbsolutePath(), parameters.getRootFolderInZip(), parameters.getDefaultFolderPath()))) != null) {
                    totalWork += Zip4jUtil.getFileLengh(this.zipModel.getZipFileObj()) - fileHeader.getCompressedSize();
                }
            }
            ++i;
        }
        return totalWork;
    }
}

