/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.excel;

import coldfusion.excel.ExcelDataFormatter;
import coldfusion.excel.ExcelInfo;
import coldfusion.excel.VmlDrawing;
import coldfusion.excel.datavalidation.Constants;
import coldfusion.excel.datavalidation.Hyperlink;
import coldfusion.excel.datavalidation.SheetDataValidationRule;
import coldfusion.excel.datavalidation.StreamingReadConfig;
import coldfusion.excel.parallel.SpreadsheetProcessingCallable;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFDateTimeParser;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.FastArray;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.async.Executor;
import coldfusion.runtime.async.Future;
import coldfusion.sql.QueryTable;
import coldfusion.sql.QueryTableMetaData;
import coldfusion.tagext.lang.SpreadSheetTag;
import coldfusion.tagext.validation.CFTypeValidationException;
import coldfusion.tagext.validation.CFTypeValidatorFactory;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.DateUtils;
import coldfusion.util.Key;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFOptimiser;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.ooxml.POIXMLRelation;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.internal.PackagePropertiesPart;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.ImageUtils;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.officeDocument.x2006.extendedProperties.CTProperties;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTHeaderFooter;

public class Excel
implements Serializable {
    private static final double EXAMPLE_DOUBLE_VALUE = 50.05;
    private static final int EXAMPLE_INTEGER_VALUE = 50;
    private static final int BLACK_COLOR_FONT_VALUE = Short.MAX_VALUE;
    private static final String GRAPHIC = "&G";
    private static final String LEFT_ALIGNMENT = "L";
    private static final String RIGHT_ALIGNMENT = "R";
    private static final String CENTER_ALIGNMENT = "C";
    private static final String HEADER_INDICATOR = "H";
    private static final String FOOTER_INDICATOR = "F";
    private static final HashSet<Integer> EMPTY_INTEGER_HASHSET = new HashSet();
    private static final int MAX_WIDTH = 65280;
    public static final String XSSF_FORMAT = "XSSF";
    public static final String HSSF_FORMAT = "HSSF";
    public static final String SXSSF_FORMAT = "SXSSF";
    private Workbook workbook = null;
    private Drawing drawing = null;
    private static FormulaEvaluator evaluator = null;
    private static final short defaultformat = 0;
    private static final int DATETYPE = 1;
    private static final int NULL = 2;
    private static final int NUMERIC = 3;
    private static final int STRING = 4;
    private static final String DATE_FORMAT = "yyyy-MM-dd hh:mm:ss a";
    private static final SimpleDateFormat dateformatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a");
    private static final SimpleDateFormat dateformatter2 = new SimpleDateFormat("dd/MM/yyyy");
    private static Map<Integer, Integer> DATATYPEMAPPER;
    private static Map<String, Integer> DATATYPESTRINGMAPPER;
    private static final String STRINGDATATYPE = "STRING";
    private static final String DATEDATATYPE = "DATE";
    private static final String NUMERICDATATYPE = "NUMERIC";
    private String autofilter;
    private static String value;

    public Excel() {
        this(HSSF_FORMAT);
    }

    public Excel(String xmlformat) {
        this.createNewWorkbook("Sheet1", xmlformat, 0);
    }

    public Excel(String sheetname, String xmlformat) {
        this(sheetname, xmlformat, 0);
    }

    public Excel(String sheetname, String xmlformat, int randomAccessWindowSize) {
        this.createNewWorkbook(sheetname, xmlformat, randomAccessWindowSize);
    }

    public Excel(InputStream inp) {
        this.createNewWorkbook(inp);
    }

    public Excel(InputStream inp, String password) {
        this.createNewWorkbook(inp, password);
    }

    private void createNewWorkbook(String sheetname) {
        this.createNewWorkbook(sheetname, HSSF_FORMAT, 0);
    }

    private void createNewWorkbook(String sheetname, String xmlformat, int randomAccessWindowSize) {
        this.workbook = xmlformat.equalsIgnoreCase(XSSF_FORMAT) ? new XSSFWorkbook() : (xmlformat.equalsIgnoreCase(SXSSF_FORMAT) ? (randomAccessWindowSize > 0 || randomAccessWindowSize == -1 ? new SXSSFWorkbook(randomAccessWindowSize) : new SXSSFWorkbook()) : new HSSFWorkbook());
        Sheet sheet = this.workbook.createSheet();
        this.drawing = sheet.createDrawingPatriarch();
        this.workbook.setSheetName(0, sheetname);
    }

    public static void applyRowbreaks(String rowbreaks, Sheet sheet) {
        int rows = Excel.getRowCount(sheet);
        if (Excel.isNotNull(rowbreaks)) {
            for (String row : rowbreaks.split(",")) {
                try {
                    int rownum = Integer.valueOf(row.trim());
                    if (rownum < 1 || rownum > rows) {
                        throw new SpreadSheetTag.ExcelInvalidBreaksException(row);
                    }
                    sheet.setRowBreak(rownum - 1);
                }
                catch (NumberFormatException e) {
                    throw new SpreadSheetTag.ExcelInvalidBreaksException(row);
                }
            }
        }
    }

    public static void applyColumnbreaks(String breaks, Sheet sheet) {
        int cols = Excel.getColumnCount(sheet);
        if (Excel.isNotNull(breaks)) {
            for (String col : breaks.split(",")) {
                try {
                    int colnum = Integer.valueOf(col.trim());
                    if (colnum < 1 || colnum > cols) {
                        throw new SpreadSheetTag.ExcelInvalidBreaksException(col);
                    }
                    sheet.setColumnBreak(colnum - 1);
                }
                catch (NumberFormatException e) {
                    throw new SpreadSheetTag.ExcelInvalidBreaksException(col);
                }
            }
        }
    }

    public static void applyAutofilter(String autofilter, Sheet sheet) {
        if (Excel.isNotNull(autofilter)) {
            sheet.setAutoFilter(CellRangeAddress.valueOf((String)autofilter.trim()));
        }
    }

    private static boolean isNotNull(String s) {
        return null != s && s.trim().length() != 0;
    }

    private void createNewWorkbook(InputStream inp) {
        try {
            this.workbook = WorkbookFactory.create((InputStream)inp);
        }
        catch (IOException e) {
            throw new SpreadSheetTag.ExcelReadException((Throwable)e);
        }
        catch (Exception e) {
            throw new SpreadSheetTag.ExcelReadException((Throwable)e);
        }
    }

    private void createNewWorkbook(InputStream inp, String password) {
        try {
            this.workbook = WorkbookFactory.create((InputStream)inp, (String)password);
        }
        catch (IOException e) {
            throw new SpreadSheetTag.ExcelReadException((Throwable)e);
        }
        catch (Exception e) {
            throw new SpreadSheetTag.ExcelReadException((Throwable)e);
        }
    }

    public static void createSheet(ExcelInfo excelinfo, String sheetname) {
        Workbook book = excelinfo.getWorkbook();
        book.createSheet(sheetname);
        excelinfo.setSummaryInfo(Excel.info(excelinfo));
    }

    public static void createSheet(ExcelInfo excelinfo) {
        Workbook book = excelinfo.getWorkbook();
        book.createSheet();
        excelinfo.setSummaryInfo(Excel.info(excelinfo));
    }

    public static void removeSheet(ExcelInfo excelinfo, String sheetName) {
        Workbook book = excelinfo.getWorkbook();
        Excel.checkLastSheetInWorkbook(book);
        int sheetnumber = book.getSheetIndex(sheetName);
        if (sheetnumber <= -1) {
            throw new SpreadSheetTag.SpreadSheetInvalidSheetNameException(sheetName);
        }
        book.removeSheetAt(sheetnumber);
        Excel.updateExcelInfoAfterSheetRemoval(excelinfo, sheetName, book);
    }

    public static void removeSheet(ExcelInfo excelinfo, int sheetNumber) {
        Workbook book = excelinfo.getWorkbook();
        Excel.checkLastSheetInWorkbook(book);
        String sheetName = book.getSheetName(--sheetNumber);
        if (sheetNumber <= -1) {
            throw new SpreadSheetTag.SpreadSheetInvalidSheetNumberException(sheetNumber + 1);
        }
        book.removeSheetAt(sheetNumber);
        Excel.updateExcelInfoAfterSheetRemoval(excelinfo, sheetName, book);
    }

    private static void checkLastSheetInWorkbook(Workbook book) {
        if (book.getNumberOfSheets() <= 1) {
            throw new SpreadSheetTag.SpreadSheetLastSheetException();
        }
    }

    private static void updateExcelInfoAfterSheetRemoval(ExcelInfo excelinfo, String sheetName, Workbook book) {
        if (excelinfo.getExcelSheetName().equalsIgnoreCase(sheetName)) {
            int sheetnumber = book.getActiveSheetIndex();
            if (book instanceof XSSFWorkbook && sheetnumber >= book.getNumberOfSheets()) {
                book.setActiveSheet(--sheetnumber);
            }
            String newSheet = book.getSheetName(sheetnumber);
            excelinfo.setExcelSheetName(newSheet);
            excelinfo.setExcelSheetNumber(sheetnumber);
        } else {
            int newSheetNumber = book.getSheetIndex(excelinfo.getExcelSheetName());
            excelinfo.setExcelSheetNumber(newSheetNumber);
        }
        excelinfo.setSummaryInfo(Excel.info(excelinfo));
    }

    public static void setActiveSheet(ExcelInfo excelinfo, String sheetname) {
        int index = 0;
        try {
            Workbook book = excelinfo.getWorkbook();
            index = book.getSheetIndex(sheetname);
            book.setActiveSheet(index);
            excelinfo.setExcelSheetNumber(index);
            excelinfo.setExcelSheetName(sheetname);
            excelinfo.setSheetNoProvided(false);
            Sheet s = book.getSheetAt(index);
            excelinfo.setDrawing(s.createDrawingPatriarch());
        }
        catch (IllegalArgumentException e) {
            throw new SpreadSheetTag.ExcelInvalidSheetNameException(sheetname);
        }
    }

    public static void setActiveSheet(ExcelInfo excelinfo, int sheetnumber) {
        try {
            Workbook book = excelinfo.getWorkbook();
            String sheetname = book.getSheetName(--sheetnumber);
            book.setActiveSheet(sheetnumber);
            excelinfo.setExcelSheetName(sheetname);
            excelinfo.setExcelSheetNumber(sheetnumber);
            excelinfo.setSheetNoProvided(false);
            Sheet s = book.getSheetAt(sheetnumber);
            excelinfo.setDrawing(s.createDrawingPatriarch());
        }
        catch (IllegalArgumentException e) {
            throw new SpreadSheetTag.ExcelInvalidSheetException(sheetnumber);
        }
    }

    public ExcelInfo getExcelInfo() {
        ExcelInfo excelinfo = new ExcelInfo(this.workbook);
        excelinfo.setExcelRowCount(0);
        String sheetname = this.workbook.getSheetName(0);
        int sheetindex = this.workbook.getSheetIndex(sheetname);
        excelinfo.setExcelSheetName(sheetname);
        excelinfo.setExcelSheetNumber(sheetindex);
        Struct i = Excel.info(excelinfo);
        if (i != null) {
            excelinfo.setSummaryInfo(i);
        }
        if (this.drawing != null) {
            excelinfo.setDrawing(this.drawing);
        }
        return excelinfo;
    }

    public static void addInfo(ExcelInfo excel, Struct summary) {
        CaseInsensitiveMap summaryInfo = excel.getSummaryInfo();
        Set s = summary.keySet();
        if (s.isEmpty()) {
            return;
        }
        String[] values = new String[]{"title", "author", "category", "subject", "comments", "keywords", "manager", "company"};
        for (String key : s) {
            for (String value : values) {
                if (!key.equalsIgnoreCase(value)) continue;
                summaryInfo.put((Object)value.toUpperCase(), summary.get((Object)key));
            }
        }
        if (!summaryInfo.isEmpty()) {
            excel.setSummaryInfo(summaryInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXMLSummary(File file, ExcelInfo info, XSSFWorkbook book, boolean isOriginalSheetXSSF) {
        OutputStream os = null;
        try {
            POIXMLProperties prop = book.getProperties();
            PackagePropertiesPart part = prop.getCoreProperties().getUnderlyingProperties();
            CTProperties extProp = prop.getExtendedProperties().getUnderlyingProperties();
            if (null != info) {
                CaseInsensitiveMap summary = info.getSummaryInfo();
                Set set = summary.keySet();
                for (String s : set) {
                    if (s.equalsIgnoreCase("author")) {
                        part.setCreatorProperty((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("comments")) {
                        part.setDescriptionProperty((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("company")) {
                        extProp.setCompany((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("manager")) {
                        extProp.setManager((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("category")) {
                        part.setCategoryProperty((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("keywords")) {
                        part.setKeywordsProperty((String)summary.get((Object)s));
                        continue;
                    }
                    if (s.equalsIgnoreCase("subject")) {
                        part.setSubjectProperty((String)summary.get((Object)s));
                        continue;
                    }
                    if (!s.equalsIgnoreCase("title")) continue;
                    part.setTitleProperty((String)summary.get((Object)s));
                }
            }
            if (isOriginalSheetXSSF) {
                os = VFSFileFactory.getOutputStream((File)file);
                book.write(os);
            }
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.warn((Object)RB.getString(Excel.class, (String)"DOCUMENT_PROPERTIES_UPDATE_WARNING", (Object)file));
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static PropertySet getSummaryInformation(DirectoryEntry dir, String defaultStreamName, Supplier<PropertySet> defaultFactory) throws Exception {
        block7: {
            DocumentSummaryInformation documentSummaryInformation;
            DocumentEntry entry = (DocumentEntry)dir.getEntry(defaultStreamName);
            if (entry == null) break block7;
            DocumentInputStream dis = new DocumentInputStream(entry);
            try {
                PropertySet ps = new PropertySet((InputStream)dis);
                documentSummaryInformation = "\u0005DocumentSummaryInformation".equals(defaultStreamName) ? new DocumentSummaryInformation(ps) : new SummaryInformation(ps);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        dis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
            dis.close();
            return documentSummaryInformation;
        }
        return defaultFactory.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOLE2Summary(File file, ExcelInfo info) {
        InputStream is = null;
        OutputStream os = null;
        try {
            is = VFSFileFactory.getInputStream((File)file);
            POIFSFileSystem poifs = new POIFSFileSystem(is);
            is.close();
            DirectoryNode dir = poifs.getRoot();
            SummaryInformation si = (SummaryInformation)Excel.getSummaryInformation((DirectoryEntry)dir, "\u0005SummaryInformation", PropertySetFactory::newSummaryInformation);
            DocumentSummaryInformation dsi = (DocumentSummaryInformation)Excel.getSummaryInformation((DirectoryEntry)dir, "\u0005DocumentSummaryInformation", PropertySetFactory::newDocumentSummaryInformation);
            if (null != info) {
                CaseInsensitiveMap summary = info.getSummaryInfo();
                Map<String, Consumer<String>> summarySetters = Map.of("author", arg_0 -> ((SummaryInformation)si).setAuthor(arg_0), "title", arg_0 -> ((SummaryInformation)si).setTitle(arg_0), "comments", arg_0 -> ((SummaryInformation)si).setComments(arg_0), "subject", arg_0 -> ((SummaryInformation)si).setSubject(arg_0), "keywords", arg_0 -> ((SummaryInformation)si).setKeywords(arg_0), "category", arg_0 -> ((DocumentSummaryInformation)dsi).setCategory(arg_0), "manager", arg_0 -> ((DocumentSummaryInformation)dsi).setManager(arg_0), "company", arg_0 -> ((DocumentSummaryInformation)dsi).setCompany(arg_0));
                summary.forEach((key, value) -> {
                    Consumer setter = (Consumer)summarySetters.get(((String)key).toLowerCase());
                    if (setter != null) {
                        setter.accept((String)value);
                    }
                });
            }
            si.setEditTime(Calendar.getInstance().getTime().getTime());
            si.write((DirectoryEntry)dir, "\u0005SummaryInformation");
            dsi.write((DirectoryEntry)dir, "\u0005DocumentSummaryInformation");
            os = VFSFileFactory.getOutputStream((File)file);
            poifs.writeFilesystem(os);
        }
        catch (Exception e) {
            CFLogs.APPLICATION_LOG.warn((Object)RB.getString(Excel.class, (String)"DOCUMENT_PROPERTIES_UPDATE_WARNING", (Object)file));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Struct info(ExcelInfo excel) {
        Struct infostruct = new Struct();
        Workbook workbook = excel.getWorkbook();
        SummaryInformation summary = null;
        if (workbook instanceof HSSFWorkbook) {
            String value;
            HSSFWorkbook hssfworkbook = (HSSFWorkbook)workbook;
            try {
                summary = hssfworkbook.getSummaryInformation();
            }
            catch (Exception exception) {
                // empty catch block
            }
            DocumentSummaryInformation summary2 = null;
            try {
                summary2 = hssfworkbook.getDocumentSummaryInformation();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (summary != null) {
                infostruct.put((Object)"SPREADSHEETTYPE", (Object)"Excel");
                value = summary.getAuthor();
                infostruct.put((Object)"AUTHOR", (Object)(value != null ? value : ""));
                Date d = summary.getCreateDateTime();
                if (d != null) {
                    infostruct.put((Object)"CREATIONDATE", (Object)d.toString());
                } else {
                    infostruct.put((Object)"CREATIONDATE", (Object)"");
                }
                long l = summary.getEditTime();
                value = l != 0L ? new Date(l).toString() : "";
                infostruct.put((Object)"LASTEDITED", (Object)(value != null ? value : ""));
                d = summary.getLastSaveDateTime();
                if (d != null) {
                    infostruct.put((Object)"LASTSAVED", (Object)d.toString());
                } else {
                    infostruct.put((Object)"LASTSAVED", (Object)"");
                }
                value = summary.getLastAuthor();
                infostruct.put((Object)"LASTAUTHOR", (Object)(value != null ? value : ""));
                value = summary.getTitle();
                infostruct.put((Object)"TITLE", (Object)(value != null ? value : ""));
                value = summary.getSubject();
                infostruct.put((Object)"SUBJECT", (Object)(value != null ? value : ""));
                value = summary.getKeywords();
                infostruct.put((Object)"KEYWORDS", (Object)(value != null ? value : ""));
                value = summary.getComments();
                infostruct.put((Object)"COMMENTS", (Object)(value != null ? value : ""));
            }
            if (summary2 != null) {
                value = summary2.getCategory();
                infostruct.put((Object)"CATEGORY", (Object)(value != null ? value : ""));
                value = summary2.getCompany();
                infostruct.put((Object)"COMPANY", (Object)(value != null ? value : ""));
                value = summary2.getManager();
                infostruct.put((Object)"MANAGER", (Object)(value != null ? value : ""));
            }
        } else if (workbook instanceof XSSFWorkbook) {
            XSSFWorkbook xssfworkbook = (XSSFWorkbook)workbook;
            try {
                OleDateTime parseDateTime;
                String value = null;
                POIXMLProperties props = xssfworkbook.getProperties();
                PackagePropertiesPart partprops = props.getCoreProperties().getUnderlyingProperties();
                CTProperties extprops = props.getExtendedProperties().getUnderlyingProperties();
                infostruct.put((Object)"TITLE", (Object)partprops.getTitleProperty().orElse(""));
                infostruct.put((Object)"SUBJECT", (Object)partprops.getSubjectProperty().orElse(""));
                infostruct.put((Object)"CATEGORY", (Object)partprops.getCategoryProperty().orElse(""));
                value = partprops.getCreatedPropertyString();
                if (value != null) {
                    parseDateTime = CFDateTimeParser.parseDateTime((String)value);
                    value = dateformatter.format((Date)parseDateTime);
                }
                infostruct.put((Object)"CREATIONDATE", (Object)(value != null ? value : ""));
                infostruct.put((Object)"AUTHOR", (Object)partprops.getCreatorProperty().orElse(""));
                value = partprops.getModifiedPropertyString();
                if (value != null) {
                    parseDateTime = CFDateTimeParser.parseDateTime((String)value);
                    value = dateformatter.format((Date)parseDateTime);
                }
                infostruct.put((Object)"LASTEDITED", (Object)(value != null ? value : ""));
                infostruct.put((Object)"KEYWORDS", (Object)partprops.getKeywordsProperty().orElse(""));
                infostruct.put((Object)"LASTAUTHOR", (Object)partprops.getLastModifiedByProperty().orElse(""));
                infostruct.put((Object)"COMMENTS", (Object)partprops.getDescriptionProperty().orElse(""));
                value = extprops.getCompany();
                infostruct.put((Object)"COMPANY", (Object)(value != null ? value : ""));
                value = extprops.getManager();
                infostruct.put((Object)"MANAGER", (Object)(value != null ? value : ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            infostruct.put((Object)"SPREADSHEETTYPE", (Object)"Excel (2007)");
        } else if (workbook instanceof SXSSFWorkbook) {
            SXSSFWorkbook sxssfWorkbook = (SXSSFWorkbook)workbook;
            infostruct.put((Object)"SPREADSHEETTYPE", (Object)"Streaming");
            infostruct.put((Object)"RANDOMACCESSWINDOWSIZE", (Object)sxssfWorkbook.getRandomAccessWindowSize());
        }
        Excel.fillSheetsInfo(infostruct, workbook);
        return infostruct;
    }

    private static void fillSheetsInfo(Struct infostruct, Workbook workbook) {
        int sheets = workbook.getNumberOfSheets();
        infostruct.put((Object)"SHEETS", (Object)sheets);
        if (sheets > 0) {
            Struct visibility = new Struct();
            Object sheetname = workbook.getSheetName(0);
            visibility.put(sheetname, (Object)workbook.getSheetVisibility(0).toString());
            for (int i = 1; i < sheets; ++i) {
                sheetname = (String)sheetname + "," + workbook.getSheetName(i);
                visibility.put((Object)workbook.getSheetName(i), (Object)workbook.getSheetVisibility(i).toString());
            }
            infostruct.put((Object)"VISIBILITY", (Object)visibility);
            infostruct.put((Object)"SHEETNAMES", sheetname);
        }
    }

    public static byte[] readBinary(ExcelInfo excel) {
        Workbook workbook = excel.getWorkbook();
        Excel.cleanStyles(workbook);
        excel.clearStyleMap();
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("readBinary", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        return out.toByteArray();
    }

    public ExcelInfo getExcelInfo(String name) {
        ExcelInfo excelinfo = new ExcelInfo(this.workbook);
        Sheet sheet = this.workbook.getSheet(name);
        if (null == sheet) {
            throw new SpreadSheetTag.ExcelInvalidSheetNameException(name);
        }
        excelinfo.setExcelRowCount(Excel.getRowCount(sheet));
        excelinfo.setExcelSheetName(name);
        excelinfo.setExcelSheetNumber(this.workbook.getSheetIndex(name));
        Struct i = Excel.info(excelinfo);
        if (i != null) {
            excelinfo.setSummaryInfo(i);
        }
        return excelinfo;
    }

    public ExcelInfo getExcelInfo(int sheetno) {
        int sheets = this.workbook.getNumberOfSheets();
        Sheet sheet = null;
        if (sheetno >= sheets) {
            return this.getExcelInfo("" + (sheetno + 1));
        }
        sheet = this.workbook.getSheetAt(sheetno);
        if (null == sheet) {
            throw new SpreadSheetTag.ExcelInvalidSheetException(sheetno);
        }
        ExcelInfo excelinfo = new ExcelInfo(this.workbook);
        excelinfo.setExcelRowCount(Excel.getRowCount(sheet));
        excelinfo.setExcelSheetName(this.workbook.getSheetName(sheetno));
        excelinfo.setExcelSheetNumber(sheetno);
        Struct i = Excel.info(excelinfo);
        if (i != null) {
            excelinfo.setSummaryInfo(i);
        }
        return excelinfo;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    private static Row getRowAt(Sheet sheet, int rownum) {
        return sheet.getRow(rownum);
    }

    private static Cell getCellAt(Row row, int cellnum) {
        return row.getCell(cellnum);
    }

    private static int getRowCount(Sheet sheet) {
        if (sheet != null) {
            return sheet.getPhysicalNumberOfRows();
        }
        return 0;
    }

    public static int getColumnCount(Sheet sheet) {
        Iterator iter = sheet.iterator();
        short max = 0;
        while (iter.hasNext()) {
            Row hssfrow = (Row)iter.next();
            short cells = hssfrow.getLastCellNum();
            if (max >= cells) continue;
            max = cells;
        }
        return max;
    }

    public static Struct getCommentAt(Row hssfRow, int column) {
        Comment comment;
        Cell hssfCell;
        Struct c = null;
        if (hssfRow != null && (hssfCell = Excel.getCellAt(hssfRow, column)) != null && (comment = hssfCell.getCellComment()) != null) {
            c = new Struct();
            String value = comment.getAuthor();
            if (value != null) {
                c.put((Object)"AUTHOR", (Object)value);
            } else {
                c.put((Object)"AUTHOR", (Object)"");
            }
            c.put((Object)"COLUMN", (Object)(comment.getColumn() + 1));
            c.put((Object)"ROW", (Object)(comment.getRow() + 1));
            RichTextString rt = comment.getString();
            if (rt != null) {
                c.put((Object)"COMMENT", (Object)rt.getString());
            } else {
                c.put((Object)"COMMENT", (Object)"");
            }
        }
        return c;
    }

    public static String getFormulaAt(Row hssfRow, int column) {
        Cell hssfCell = Excel.getCellAt(hssfRow, column);
        String formula = "";
        try {
            if (hssfCell != null) {
                formula = hssfCell.getCellFormula();
            }
        }
        catch (Exception es) {
            return "";
        }
        return formula;
    }

    public static boolean isValidExcelDate(double value) {
        return value > -4.9E-324;
    }

    public static String getValueAt(Row hssfRow, int column) {
        String blankString = "";
        if (hssfRow != null) {
            Cell hssfCell = Excel.getCellAt(hssfRow, column);
            Object content = blankString;
            DataFormatter formatter = new DataFormatter();
            if (hssfCell != null) {
                if (CellType.FORMULA != hssfCell.getCellType()) {
                    try {
                        try {
                            content = formatter.formatCellValue(hssfCell);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (((String)content).equalsIgnoreCase(blankString)) {
                            if (CellType.NUMERIC == hssfCell.getCellType()) {
                                String format = hssfCell.getCellStyle().getDataFormatString();
                                double d = hssfCell.getNumericCellValue();
                                ExcelDataFormatter formatter2 = new ExcelDataFormatter(format);
                                content = formatter2.format(d);
                            } else if (CellType.STRING == hssfCell.getCellType()) {
                                RichTextString text = hssfCell.getRichStringCellValue();
                                content = text.getString();
                            }
                        } else if (CellType.ERROR == hssfCell.getCellType()) {
                            content = Excel.handleFormulaException(hssfCell);
                        }
                    }
                    catch (Exception e) {
                        content = Excel.handleFormulaException(hssfCell);
                    }
                } else if (evaluator != null) {
                    try {
                        content = formatter.formatCellValue(hssfCell, evaluator);
                    }
                    catch (Exception e) {
                        try {
                            content = hssfCell.getNumericCellValue() + blankString;
                        }
                        catch (Exception ee) {
                            try {
                                content = hssfCell.getStringCellValue() + blankString;
                            }
                            catch (Exception eee) {
                                content = hssfCell.getCellFormula();
                            }
                        }
                    }
                } else {
                    content = hssfCell.getCellFormula();
                }
            }
            return content;
        }
        return blankString;
    }

    private static String handleFormulaException(Cell hssfCell) {
        if (CellType.ERROR == hssfCell.getCellType()) {
            byte errorValue = hssfCell.getErrorCellValue();
            if (errorValue == FormulaError.DIV0.getCode()) {
                return "#DIV/0!";
            }
            if (errorValue == FormulaError.NA.getCode()) {
                return "#N/A";
            }
            if (errorValue == FormulaError.NAME.getCode()) {
                return "#NAME?";
            }
            if (errorValue == FormulaError.NULL.getCode()) {
                return "#NULL!";
            }
            if (errorValue == FormulaError.NUM.getCode()) {
                return "#NUM!";
            }
            if (errorValue == FormulaError.REF.getCode()) {
                return "#REF!";
            }
            if (errorValue == FormulaError.VALUE.getCode()) {
                return "#VALUE!";
            }
            return "Unknown error value: " + errorValue + "!";
        }
        return "";
    }

    public void mergeCells(ExcelInfo excelinfo, int rowfrom, int rowto, int colfrom, int colto) {
        if (colto < colfrom) {
            throw new SpreadSheetTag.MergeCellsInvalidValueException(colfrom, colto);
        }
        if (rowto < rowfrom) {
            throw new SpreadSheetTag.MergeCellsInvalidValueException(rowfrom, rowto);
        }
        Workbook book = excelinfo.getWorkbook();
        Sheet s = book.getSheet(excelinfo.getExcelSheetName());
        CellRangeAddress region = new CellRangeAddress(rowfrom - 1, rowto - 1, colfrom - 1, colto - 1);
        s.addMergedRegion(region);
        excelinfo.setExcelRowCount(Excel.getRowCount(s));
        excelinfo.setWorkbook(book);
    }

    public static void setFooter(ExcelInfo excelinfo, String lfooter, String cfooter, String rfooter) {
        Workbook b = excelinfo.getWorkbook();
        Sheet s = b.getSheet(excelinfo.getExcelSheetName());
        Footer f = s.getFooter();
        f.setCenter(cfooter);
        f.setLeft(lfooter);
        f.setRight(rfooter);
    }

    public static void setHeader(ExcelInfo excelinfo, String lheader, String cheader, String rheader) {
        Workbook b = excelinfo.getWorkbook();
        Sheet s = b.getSheet(excelinfo.getExcelSheetName());
        Header h = s.getHeader();
        h.setCenter(cheader);
        h.setLeft(lheader);
        h.setRight(rheader);
    }

    public String[] getValuesAt(Sheet sheet, int row) {
        Row hssfrow = Excel.getRowAt(sheet, row);
        if (hssfrow != null) {
            int lastcell = hssfrow.getLastCellNum();
            if (lastcell < 0) {
                return null;
            }
            String[] values = new String[lastcell];
            int index = 0;
            for (int cellindex = 0; cellindex < lastcell; ++cellindex) {
                values[index] = Excel.getValueAt(hssfrow, cellindex);
                ++index;
            }
            return values;
        }
        return null;
    }

    public String[] getValuesAt(int sheetno, int row) {
        Sheet sheet = this.workbook.getSheetAt(sheetno);
        CreationHelper createHelper = this.workbook.getCreationHelper();
        evaluator = createHelper.createFormulaEvaluator();
        Row hssfrow = Excel.getRowAt(sheet, row);
        if (hssfrow != null) {
            int firstcell = hssfrow.getFirstCellNum();
            short lastcell = hssfrow.getLastCellNum();
            String[] values = new String[lastcell - firstcell];
            int index = 0;
            for (int cellindex = firstcell; cellindex < lastcell; ++cellindex) {
                values[index] = Excel.getValueAt(hssfrow, cellindex);
                ++index;
            }
            return values;
        }
        return null;
    }

    public String[] getValuesAt(Sheet sheet, int row, Integer[] cols) {
        Row hssfrow = Excel.getRowAt(sheet, row);
        if (hssfrow != null) {
            String[] values = new String[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                int colnum = cols[i];
                values[i] = Excel.getValueAt(hssfrow, colnum - 1);
            }
            return values;
        }
        return null;
    }

    public String[] getValuesAt(Sheet sheet, int row, int startcol, int endcol) {
        Row hssfrow = Excel.getRowAt(sheet, row);
        if (hssfrow != null) {
            short lastcell = hssfrow.getLastCellNum();
            String[] values = new String[endcol - startcol];
            if (endcol > lastcell) {
                endcol = lastcell;
            }
            int index = 0;
            for (int cellindex = startcol; cellindex < endcol; ++cellindex) {
                String value = Excel.getValueAt(hssfrow, cellindex);
                if (value == null) continue;
                values[index] = value;
                ++index;
            }
            return values;
        }
        return null;
    }

    public static void addRows(ExcelInfo info, String[] rows, int row, int colnum, boolean insert, String[] datatypes) {
        int start = row;
        int var = 0;
        String lastdatatype = null;
        int sheetContaingRows = Excel.isSheetContaingRows(info);
        if (row > 0) {
            sheetContaingRows = row;
        } else if (sheetContaingRows >= 0) {
            sheetContaingRows += 2;
        }
        for (String rowValue : rows) {
            String datatype = null;
            if (null != datatypes) {
                datatype = datatypes[var++];
            }
            if (null != datatype) {
                lastdatatype = datatype;
            }
            Excel.addRow(info, rowValue, sheetContaingRows, colnum, insert, lastdatatype);
            if (sheetContaingRows == -1) {
                sheetContaingRows += 3;
                continue;
            }
            ++sheetContaingRows;
        }
    }

    public static int isSheetContaingRows(ExcelInfo info) {
        int last;
        String sheetname;
        Workbook book = info.getWorkbook();
        Sheet sheet = book.getSheet(sheetname = info.getExcelSheetName());
        Row r = sheet.getRow(last = Excel.getLastRowNum(sheet));
        if (r == null) {
            last = -1;
        }
        return last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRows(ExcelInfo info, QueryTable q, int row, int colnum, boolean insert, String[] dt, boolean includeColumnHeader) {
        Workbook book = info.getWorkbook();
        CreationHelper createHelper = book.getCreationHelper();
        String sheetname = info.getExcelSheetName();
        Sheet sheet = book.getSheet(sheetname);
        QueryTableMetaData metadata = q.getMeta();
        String[] cols = q.getColumnList();
        int len = cols.length;
        Integer[] datatypes = new Integer[len];
        Integer[] lastdatatype = new Integer[len];
        Integer[] defaultdatatype = new Integer[len];
        if (includeColumnHeader && cols != null && cols.length > 0) {
            Excel.addRow(sheet, cols, row, colnum, createHelper, insert, info, datatypes);
            if (row > 0) {
                ++row;
            }
        }
        for (int j = 0; j < cols.length; ++j) {
            try {
                datatypes[j] = metadata.getColumnType(j + 1);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int dtpos = 0;
        try {
            while (!q.isLast()) {
                boolean ignoreFormat;
                String property;
                coldfusion.sql.imq.Row r = q.getRow(q.getCurrentRow());
                String[] s = new String[len];
                for (int j = 0; j < cols.length; ++j) {
                    Object colValue = r.getColumn(j);
                    if (colValue != null) {
                        if (colValue instanceof char[]) {
                            s[j] = new String((char[])colValue);
                            continue;
                        }
                        s[j] = colValue.toString();
                        continue;
                    }
                    s[j] = "";
                }
                if (null != dt) {
                    if (null != (datatypes = Excel.getParsedDatatypes(dt[dtpos++], cols.length))) {
                        lastdatatype = datatypes;
                    }
                } else {
                    lastdatatype = datatypes;
                }
                if ((property = System.getProperty("coldfusion.spreadsheet.ignoreformat")) != null && (ignoreFormat = Boolean.parseBoolean(property))) {
                    lastdatatype = defaultdatatype;
                }
                Excel.addRow(sheet, s, row, colnum, createHelper, insert, info, lastdatatype);
                if (row > 0) {
                    ++row;
                }
                q.next();
            }
        }
        finally {
            q.close();
        }
        info.setExcelRowCount(Excel.getRowCount(sheet));
    }

    public void addRow(ExcelInfo info, String row, boolean insert) {
        Excel.addRow(info, row, -1, 0, insert, null);
    }

    public static void autoResize(ExcelInfo excelObj, Object autosize) {
        Excel.autoResize(excelObj, false, autosize);
    }

    public static void autoResize(ExcelInfo excelObj, boolean useMergedColumns, Object autosize) {
        Workbook workbook = excelObj.getWorkbook();
        ArrayList ignore_columns = excelObj.getIgnoreColumnsForAutoResize();
        int numberOfSheets = workbook.getNumberOfSheets();
        Sheet sheet = null;
        for (int i = 0; i < numberOfSheets; ++i) {
            sheet = workbook.getSheetAt(i);
            Excel.autoResize(sheet, useMergedColumns, ignore_columns, autosize);
        }
    }

    public static void autoResize(Sheet sheet, boolean useMergedColumns, ArrayList ignore_columns, Object autosize) {
        FastArray cols = null;
        if (CFPage.IsBoolean((Object)autosize)) {
            boolean isautosize = Cast._boolean((Object)autosize);
            if (!isautosize) {
                return;
            }
        } else {
            cols = (FastArray)autosize;
        }
        int columns = Excel.getColumnCount(sheet);
        for (int i = 0; i < columns; ++i) {
            if (cols != null && !cols.contains((Object)("" + (i + 1)))) continue;
            if (ignore_columns != null) {
                if (ignore_columns.contains(i + 1)) continue;
                sheet.autoSizeColumn(i, useMergedColumns);
                continue;
            }
            sheet.autoSizeColumn(i, useMergedColumns);
        }
    }

    public static void addRow(ExcelInfo info, String row, int rownum, int colnum, boolean insert, String datatype) {
        String[] strArray = Excel.getParsedValue(row);
        Integer[] datatypeArray = Excel.getParsedDatatypes(datatype, strArray.length);
        Excel.addRow(info, strArray, rownum, colnum, insert, datatypeArray);
    }

    public static Integer[] getParsedDatatypes(String datatype, int size) {
        String[] dtsplit;
        if (null == datatype || "".equals(datatype.trim())) {
            return null;
        }
        Integer[] intList = new Integer[size];
        int var = 0;
        for (String type : dtsplit = datatype.split(";")) {
            ++var;
            String[] split = type.trim().split(":");
            if (split.length > 2) {
                throw new SpreadSheetTag.ExcelInvalidDatatypevalueException(datatype);
            }
            String dt = split[0].trim();
            if (!Excel.isValidDatatype(dt)) {
                throw new SpreadSheetTag.ExcelInvalidDatatypeException(dt);
            }
            if (split.length == 1) {
                if (var != dtsplit.length) {
                    throw new SpreadSheetTag.ExcelNoColumnDatatypeException(dt);
                }
                for (int i = 0; i < size; ++i) {
                    if (intList[i] != null) continue;
                    intList[i] = DATATYPESTRINGMAPPER.get(dt);
                }
                continue;
            }
            for (String s : split[1].trim().split(",")) {
                int pos = -1;
                if (s.contains("-")) {
                    String[] hyphensplit = s.split("-");
                    try {
                        int startindex = Integer.parseInt(hyphensplit[0].trim());
                        int lastindex = Integer.parseInt(hyphensplit[1].trim());
                        if (lastindex <= startindex || startindex < 1 || lastindex > size) {
                            throw new SpreadSheetTag.ExcelInvalidDatatypeRangeNumberException(s);
                        }
                        for (int k = startindex; k <= lastindex; ++k) {
                            intList[k - 1] = DATATYPESTRINGMAPPER.get(dt);
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new SpreadSheetTag.ExcelInvalidDatatypeRangeNumberException(s);
                    }
                }
                try {
                    pos = Integer.parseInt(s.trim());
                    if (pos > size || pos < 1) {
                        throw new SpreadSheetTag.ExcelInvalidDatatypeColNumberException(s);
                    }
                }
                catch (Exception e) {
                    throw new SpreadSheetTag.ExcelInvalidDatatypeColNumberException(s);
                }
                intList[pos - 1] = DATATYPESTRINGMAPPER.get(dt);
            }
        }
        return intList;
    }

    private static boolean isValidDatatype(String dt) {
        for (String datatype : DATATYPESTRINGMAPPER.keySet()) {
            if (!datatype.equalsIgnoreCase(dt)) continue;
            return true;
        }
        return false;
    }

    public void addRow(ExcelInfo info, String[] row, boolean insert) {
        Excel.addRow(info, row, -1, 0, insert, null);
    }

    public static void addRow(Sheet sheet, String[] row, int rownum, int colnum, CreationHelper createHelper, boolean insert, ExcelInfo info, Integer[] datatypes) {
        int last = Excel.getLastRowNum(sheet);
        Row r = sheet.getRow(last);
        rownum = rownum < 0 ? (last == 0 && r == null ? last : last + 1) : --rownum;
        r = sheet.getRow(rownum);
        if (r != null) {
            if (insert) {
                sheet.shiftRows(rownum, last, 1, true, true);
            } else {
                sheet.removeRow(r);
            }
        }
        r = sheet.createRow(rownum);
        if (colnum > 0) {
            --colnum;
        }
        for (int index = 0; index < row.length; ++index) {
            Cell c = r.createCell(colnum + index);
            String value = row[index];
            if (null == value) {
                Excel.createNonNumericCell(info, c, "", createHelper);
                continue;
            }
            try {
                boolean attemptDouble = true;
                String tmpValue = value.trim();
                Integer type = null;
                if (null != datatypes) {
                    type = datatypes[index];
                }
                if (null == type) {
                    if (tmpValue.length() > 0 && !Character.isDigit(tmpValue.charAt(tmpValue.length() - 1))) {
                        attemptDouble = false;
                    }
                    if (attemptDouble) {
                        double i = Double.parseDouble(value);
                        Excel.createNumericCell(c, i);
                        continue;
                    }
                    Excel.createNonNumericCell(info, c, value, createHelper);
                    continue;
                }
                Excel.createDatatypeAwareCell(type, c, value, createHelper, info);
                continue;
            }
            catch (NumberFormatException e) {
                Excel.createNonNumericCell(info, c, value, createHelper);
            }
        }
    }

    private static void createNonNumericCell(ExcelInfo info, Cell c, String value, CreationHelper createHelper) {
        if (!value.equalsIgnoreCase("")) {
            String lValue = value.toLowerCase();
            if (!lValue.endsWith("p") && !lValue.endsWith("a") && DateUtils.isDate((Object)value.trim())) {
                Excel.createDateCell(info, c, value, createHelper);
            } else {
                Excel.createStringCell(c, value, createHelper);
            }
        } else {
            Excel.createBlankCell(c, createHelper);
        }
    }

    private static void createNumericCell(Cell c, double value) {
        c.setCellType(CellType.NUMERIC);
        c.setCellValue(value);
    }

    private static void createDateCell(ExcelInfo info, Cell c, String value, CreationHelper createHelper) {
        Workbook book = info.getWorkbook();
        c.setCellType(CellType.NUMERIC);
        Date date = DateUtils.parseDateTime((String)value);
        if (DateUtils.getYear((Date)date) == 1899 && DateUtils.getMonth((Date)date) == 12 && DateUtils.getDayOfMonth((Date)date) == 30) {
            date = DateUtils.addDate((String)"d", (int)2, (Date)date);
        }
        if (date.getYear() < 0) {
            Excel.createStringCell(c, value, createHelper);
            return;
        }
        c.setCellValue(date);
        CellStyle cs = null;
        short poiformat = Excel.getDateFormat(value, date, createHelper);
        cs = info.getCellStyleForDateCell(poiformat);
        if (cs == null) {
            cs = book.createCellStyle();
            cs.setDataFormat(poiformat);
            info.setCellStyleForDateCell(poiformat, cs);
        }
        c.setCellStyle(cs);
    }

    private static short getDateFormat(String dateValue, Date dateObj, CreationHelper createHelper) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateObj);
        short day = (short)cal.get(5);
        short month = (short)(cal.get(2) + 1);
        short year = (short)cal.get(1);
        short hour = (short)cal.get(11);
        short hour2 = (short)cal.get(10);
        short minute = (short)cal.get(12);
        short second = (short)cal.get(13);
        StringBuilder buf = new StringBuilder();
        ArrayList<String> formatArray = new ArrayList<String>();
        ArrayList<String> formatTimeArray = new ArrayList<String>();
        Object formatTimeStr = "";
        Object formatStr = "";
        boolean dayAdded = false;
        boolean monthAdded = false;
        boolean yearAdded = false;
        boolean hourAdded = false;
        boolean minuteAdded = false;
        boolean secondAdded = false;
        dateValue = dateValue.trim();
        boolean defaultDate = Excel.isDefaultDate(dateObj);
        for (int i = 0; i < dateValue.length(); ++i) {
            char ch = dateValue.charAt(i);
            if (!Character.isDigit(ch)) {
                try {
                    short value;
                    try {
                        value = Short.parseShort(buf.toString());
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    if (value == day && !dayAdded && !defaultDate) {
                        formatArray.add("dd");
                        dayAdded = true;
                    } else if (value == month && !monthAdded && !defaultDate) {
                        formatArray.add("mm");
                        monthAdded = true;
                    } else if (value == year || ("" + year).endsWith(buf.toString()) && !yearAdded && !defaultDate) {
                        formatArray.add("yyyy");
                        yearAdded = true;
                    } else if (!(value != hour && value != hour2 || hourAdded)) {
                        formatTimeArray.add("h");
                        hourAdded = true;
                    } else if (value == minute && !minuteAdded) {
                        formatTimeArray.add("mm");
                        minuteAdded = true;
                    } else if (value == second && !secondAdded) {
                        formatTimeArray.add("ss");
                        secondAdded = true;
                    }
                }
                catch (Exception e) {
                    return Excel.getDefaultFormat(createHelper);
                }
                buf = new StringBuilder();
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            try {
                short value = Short.parseShort(buf.toString());
                if (value == day && !dayAdded) {
                    formatArray.add("dd");
                } else if (value == month && !monthAdded) {
                    formatArray.add("mm");
                } else if (value == year && !yearAdded) {
                    formatArray.add("yyyy");
                } else if (value == hour && !hourAdded) {
                    formatTimeArray.add("h");
                } else if (value == minute && !minuteAdded) {
                    formatTimeArray.add("mm");
                } else if (value == second && !secondAdded) {
                    formatTimeArray.add("ss");
                }
            }
            catch (Exception e) {
                return Excel.getDefaultFormat(createHelper);
            }
        }
        if (formatArray.size() < 3 && formatTimeArray.size() < 2) {
            return Excel.getDefaultFormat(createHelper);
        }
        if (formatArray.size() >= 3) {
            formatStr = (String)formatArray.get(0) + "/" + (String)formatArray.get(1) + "/" + (String)formatArray.get(2);
        }
        if (formatTimeArray.size() >= 2) {
            if (formatTimeArray.size() == 2 && (hour != 0 || minute != 0)) {
                formatTimeStr = (String)formatTimeArray.get(0) + ":" + (String)formatTimeArray.get(1);
            } else if (formatTimeArray.size() == 3 && (hour != 0 || minute != 0 || second != 0)) {
                formatTimeStr = (String)formatTimeArray.get(0) + ":" + (String)formatTimeArray.get(1) + ":" + (String)formatTimeArray.get(2);
            }
        }
        return createHelper.createDataFormat().getFormat((String)formatStr + " " + (String)formatTimeStr);
    }

    private static boolean isDefaultDate(Date dateObj) {
        int year = dateObj.getYear();
        int month = dateObj.getMonth();
        int day = dateObj.getDate();
        return year == 0 && month == 0 && day == 1;
    }

    private static short getDefaultFormat(CreationHelper createHelper) {
        return createHelper.createDataFormat().getFormat("mm/dd/yyyy");
    }

    private static void createStringCell(Cell c, String value, CreationHelper createHelper) {
        c.setCellType(CellType.STRING);
        RichTextString str = createHelper.createRichTextString(value);
        c.setCellValue(str);
    }

    private static void createBlankCell(Cell c, CreationHelper createHelper) {
        c.setCellType(CellType.BLANK);
        c.setCellValue(createHelper.createRichTextString(""));
    }

    public static void addRow(ExcelInfo info, String[] row, int rownum, int colnum, boolean insert, Integer[] datatypes) {
        try {
            if (info.isUnderProcess()) {
                throw new SpreadSheetTag.ExcelInvalidOperationWhileProcessingException("addRow");
            }
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            CreationHelper createHelper = book.getCreationHelper();
            Excel.addRow(sheet, row, rownum, colnum, createHelper, insert, info, datatypes);
            info.setExcelRowCount(Excel.getRowCount(sheet));
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("addRow", (Throwable)e);
        }
    }

    public static void addColumn(ExcelInfo info, String column, String datatype) {
        Excel.addColumn(info, column, -1, -1, true, datatype);
    }

    public static void addColumn(ExcelInfo info, String column, int rownum, int colnum, boolean insert, String datatype) {
        String[] strArray = Excel.getParsedValue(column);
        Integer[] dtArray = Excel.getParsedDatatypes(datatype, strArray.length);
        Excel.addColumn(info, strArray, rownum, colnum, insert, dtArray);
    }

    private static boolean canParse(String currentString, String next, int currentIndex, int totalLength, int count, boolean parsed) {
        if (currentString.startsWith("'") && currentString.endsWith("'")) {
            return !parsed;
        }
        return !parsed && count > 1 && currentIndex + 1 != totalLength && currentString.startsWith("'") && !next.startsWith("'");
    }

    private static String[] getParsedValue(String value) {
        ArrayList<String> s1 = new ArrayList<String>();
        String[] s = value.split(",");
        int count = value.replaceAll("[^']", "").length();
        if (count <= 1) {
            for (String temp : s) {
                s1.add(temp);
            }
        } else {
            boolean parsed = false;
            StringBuilder temp = null;
            for (int i = 0; i < s.length; ++i) {
                String tempStr = s[i];
                String next = "";
                if (i + 1 < s.length) {
                    next = s[i + 1];
                }
                if (Excel.canParse(tempStr, next, i, s.length, count, parsed)) {
                    if (!tempStr.endsWith("'")) {
                        parsed = true;
                        temp = new StringBuilder();
                        temp.append(tempStr.replaceFirst("'", ""));
                    } else if (!(tempStr = tempStr.replaceFirst("'", "")).equals("")) {
                        tempStr = tempStr.substring(0, tempStr.length() - 1);
                    }
                } else if (parsed) {
                    if (tempStr.endsWith("'")) {
                        if (temp != null) {
                            temp.append("," + tempStr.substring(0, tempStr.length() - 1));
                        }
                        parsed = false;
                    } else if (temp != null) {
                        temp.append("," + tempStr);
                    }
                }
                if (!parsed || i + 1 == s.length) {
                    if (temp != null) {
                        s1.add(temp.toString());
                        temp = null;
                    } else {
                        s1.add(tempStr);
                    }
                }
                count -= tempStr.replaceAll("[^']", "").length();
            }
        }
        String[] strArray = new String[s1.size()];
        s1.toArray(strArray);
        return strArray;
    }

    public static void shiftRows(ExcelInfo info, int from, int to, int unit) {
        try {
            if (unit != 0) {
                Workbook book = info.getWorkbook();
                String sheetname = info.getExcelSheetName();
                Sheet sheet = book.getSheet(sheetname);
                to = to < 0 ? Excel.getLastRowNum(sheet) : --to;
                sheet.shiftRows(from - 1, to, unit);
                info.setExcelRowCount(Excel.getRowCount(sheet));
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.ExcelInvalidArgumentRowException((Throwable)e);
        }
    }

    public static void shiftRows(ExcelInfo info, int from, int unit) {
        try {
            if (unit != 0) {
                Excel.shiftRows(info, from, -1, unit);
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("shiftRows", (Throwable)e);
        }
    }

    public static void shiftColumns(ExcelInfo info, int from, int unit) {
        try {
            if (unit != 0) {
                Excel.shiftColumns(info, from, -1, unit);
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("shiftColumns", (Throwable)e);
        }
    }

    private static void copyCell(Cell fromcell, Cell tocell) {
        Comment comment;
        CellStyle style;
        CellType celltype = fromcell.getCellType();
        if (celltype == CellType.NUMERIC) {
            Date d = fromcell.getDateCellValue();
            if (d != null) {
                tocell.setCellValue(d);
            } else {
                tocell.setCellValue(fromcell.getNumericCellValue());
            }
        } else if (celltype == CellType.BOOLEAN) {
            tocell.setCellValue(fromcell.getBooleanCellValue());
        } else if (celltype == CellType.ERROR) {
            tocell.setCellErrorValue(fromcell.getErrorCellValue());
        } else if (celltype == CellType.FORMULA) {
            tocell.setCellFormula(fromcell.getCellFormula());
        } else if (celltype == CellType.STRING) {
            tocell.setCellValue(fromcell.getRichStringCellValue());
        }
        org.apache.poi.ss.usermodel.Hyperlink hyper = fromcell.getHyperlink();
        if (hyper != null) {
            tocell.setHyperlink(hyper);
        }
        if ((style = fromcell.getCellStyle()) != null) {
            tocell.setCellStyle(style);
        }
        if ((comment = fromcell.getCellComment()) != null) {
            tocell.setCellComment(comment);
        }
    }

    private static void moveCell(Row row, Cell cell, int column) {
        if (column < 0) {
            throw new SpreadSheetTag.ExcelInvalidCellValue();
        }
        Cell c1 = row.getCell(column);
        if (c1 != null) {
            throw new SpreadSheetTag.ExcelInvalidArgumentException(column);
        }
        c1 = row.createCell(column, cell.getCellType());
        Excel.copyCell(cell, c1);
        row.removeCell(cell);
    }

    private static void updateNewMergedRegion(Sheet s, CellRangeAddress[] address, int fromcol, int tocol, int unit) {
        CellRangeAddress r = null;
        ArrayList<Integer> mergedIndices = new ArrayList<Integer>();
        for (int i = 0; i < address.length; ++i) {
            r = address[i];
            if (r.getFirstColumn() < fromcol || r.getLastColumn() > tocol) continue;
            mergedIndices.add(i);
        }
        if (mergedIndices.size() == 0) {
            return;
        }
        Collections.reverse(mergedIndices);
        Iterator iterator = mergedIndices.iterator();
        while (iterator.hasNext()) {
            int mergedIndex = (Integer)iterator.next();
            s.removeMergedRegion(mergedIndex);
            r = address[mergedIndex];
            int orig = r.getFirstColumn();
            r.setFirstColumn(orig + unit);
            orig = r.getLastColumn();
            r.setLastColumn(orig + unit);
            s.addMergedRegion(r);
        }
    }

    private static ArrayList<Integer> getOriginalWidth(Sheet s, int fromcol, int tocol) {
        if (tocol < 0) {
            tocol = Excel.getColumnCount(s);
        }
        ArrayList<Integer> widths = new ArrayList<Integer>();
        for (int i = fromcol; i <= tocol; ++i) {
            widths.add(s.getColumnWidth(i));
        }
        return widths;
    }

    private static void applyWidth(Sheet s, int fromcol, int tocol, int unit, ArrayList<Integer> widths) {
        if (tocol < 0) {
            tocol = Excel.getColumnCount(s);
        }
        int index = 0;
        for (int i = fromcol; i <= tocol; ++i) {
            s.setColumnWidth(i + unit, widths.get(index++).intValue());
        }
    }

    public static void shiftColumns(ExcelInfo info, int from, int to, int unit) {
        if (unit != 0) {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            int startrow = Excel.getFirstRowNum(sheet);
            int lastrow = Excel.getLastRowNum(sheet);
            --from;
            if (to > 0) {
                --to;
            }
            int to_save = to;
            int maxcol = to;
            CellRangeAddress[] mergedRegions = Excel.getMergedRegions(sheet);
            ArrayList<Integer> widths = Excel.getOriginalWidth(sheet, from, to);
            Excel.applyWidth(sheet, from, to, unit, widths);
            for (int j = startrow; j <= lastrow; ++j) {
                Cell c;
                int k;
                Row row = sheet.getRow(j);
                to = to_save;
                if (row == null) continue;
                if (unit > 0) {
                    if (to < 0) {
                        to = row.getLastCellNum();
                    }
                    if (to > maxcol) {
                        maxcol = to;
                    }
                    for (k = to; k >= from; --k) {
                        c = row.getCell(k);
                        if (c == null) continue;
                        Excel.moveCell(row, c, k + unit);
                    }
                    continue;
                }
                if (to < 0) {
                    to = row.getLastCellNum();
                }
                if (to > maxcol) {
                    maxcol = to;
                }
                for (k = from; k <= to; ++k) {
                    c = row.getCell(k);
                    if (c == null) continue;
                    Excel.moveCell(row, c, k + unit);
                }
            }
            if (mergedRegions.length > 0) {
                Excel.updateNewMergedRegion(sheet, mergedRegions, from, maxcol, unit);
            }
            info.setExcelRowCount(Excel.getRowCount(sheet));
        }
    }

    public static void addColumn(ExcelInfo info, String[] column, int rownum, int colnum, boolean insert, Integer[] dt) {
        try {
            if (insert && colnum > 0) {
                Excel.shiftColumns(info, colnum, 1);
            }
            Excel.insertColumn(info, column, rownum, colnum, dt);
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("addColumn", (Throwable)e);
        }
    }

    public static void insertColumn(ExcelInfo info, String[] column, int rownum, int colnum, Integer[] dt) {
        Workbook book = info.getWorkbook();
        CreationHelper createHelper = book.getCreationHelper();
        String sheetname = info.getExcelSheetName();
        Sheet sheet = book.getSheet(sheetname);
        int startrow = rownum < 0 ? Excel.getFirstRowNum(sheet) : rownum - 1;
        if (startrow == -1) {
            startrow = 0;
        }
        int index = 0;
        Row row = sheet.getRow(startrow);
        if (row == null) {
            row = sheet.createRow(startrow);
            row.createCell(0);
            if (colnum < 0) {
                colnum = 0;
            }
        }
        if (colnum < 0) {
            colnum = row.getLastCellNum();
        } else if (colnum != 0) {
            --colnum;
        }
        int last = startrow + column.length;
        for (int j = startrow; j < last; ++j) {
            Cell c2;
            block17: {
                row = sheet.getRow(j);
                if (row == null) {
                    row = sheet.createRow(j);
                }
                Cell c1 = row.getCell(colnum) == null ? row.createCell(colnum) : row.getCell(colnum);
                c2 = row.getCell(colnum + 1);
                String value = column[index];
                Integer type = null;
                if (null != dt) {
                    type = dt[index];
                }
                if (null == type) {
                    try {
                        double i = Double.parseDouble(value);
                        c1.setCellValue(i);
                        c1.setCellType(CellType.NUMERIC);
                    }
                    catch (NumberFormatException e) {
                        if (!value.equalsIgnoreCase("")) {
                            RichTextString str = createHelper.createRichTextString(value);
                            c1.setCellValue(str);
                            int colwidth = sheet.getColumnWidth(colnum);
                            short len = (short)value.length();
                            len = (short)((double)(len * 8) / 0.05);
                            if (colwidth < len) {
                                sheet.setColumnWidth(colnum, len + 1);
                            }
                            c1.setCellType(CellType.STRING);
                            break block17;
                        }
                        c1.setCellValue(createHelper.createRichTextString(""));
                        c1.setCellType(CellType.BLANK);
                    }
                } else {
                    try {
                        Excel.createDatatypeAwareCell(type, c1, value, createHelper, info);
                    }
                    catch (NumberFormatException e) {
                        Excel.createNonNumericCell(info, c1, value, createHelper);
                    }
                }
            }
            ++index;
            if (c2 == null) continue;
        }
        info.setExcelRowCount(Excel.getRowCount(sheet));
    }

    private static void createDatatypeAwareCell(Integer type, Cell c1, String value, CreationHelper createHelper, ExcelInfo info) {
        Integer mappedtype = DATATYPEMAPPER.get(type);
        if (null == mappedtype) {
            Excel.createStringCell(c1, value, createHelper);
        } else if (2 == mappedtype || value != null && value.trim().length() == 0) {
            Excel.createBlankCell(c1, createHelper);
        } else if (3 == mappedtype) {
            Excel.createNumericCell(c1, Double.parseDouble(value));
        } else if (1 == mappedtype) {
            Excel.createDateCell(info, c1, value, createHelper);
        } else {
            Excel.createStringCell(c1, value, createHelper);
        }
    }

    public void deleteRows(ExcelInfo info, String range) {
        block7: {
            try {
                String sheetname;
                if (info.isUnderProcess()) {
                    throw new SpreadSheetTag.ExcelInvalidOperationWhileProcessingException("deleteRows");
                }
                Workbook book = info.getWorkbook();
                Sheet sheet = book.getSheet(sheetname = info.getExcelSheetName());
                if (sheet == null) break block7;
                if (range.contains(",")) {
                    Integer[] rows = Excel.doProcessList(range);
                    for (int i = 0; i < rows.length; ++i) {
                        int rownum = rows[i];
                        Row r = sheet.getRow(rownum - 1);
                        if (r == null) continue;
                        sheet.removeRow(r);
                    }
                } else {
                    int[] rows = Excel.doProcessRange(range);
                    int startrow = rows[0];
                    int endrow = rows[1];
                    for (int i = startrow; i <= endrow; ++i) {
                        Row r = sheet.getRow(i - 1);
                        if (r == null) continue;
                        sheet.removeRow(r);
                    }
                }
                info.setExcelRowCount(Excel.getRowCount(sheet));
            }
            catch (Exception e) {
                throw new SpreadSheetTag.SpreadSheetFunctionException("deleteRows", (Throwable)e);
            }
        }
    }

    public void deleteRow(ExcelInfo info, int rownum) {
        try {
            String sheetname;
            if (info.isUnderProcess()) {
                throw new SpreadSheetTag.ExcelInvalidOperationWhileProcessingException("deleteRow");
            }
            Workbook book = info.getWorkbook();
            Sheet sheet = book.getSheet(sheetname = info.getExcelSheetName());
            Row r = sheet.getRow(rownum - 1);
            if (r != null) {
                sheet.removeRow(r);
                info.setExcelRowCount(Excel.getRowCount(sheet));
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("deleteRow", (Throwable)e);
        }
    }

    public void deleteColumn(ExcelInfo info, int colnum) {
        try {
            int first;
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            int last = Excel.getLastRowNum(sheet);
            for (int i = first = Excel.getFirstRowNum(sheet); i <= last; ++i) {
                Cell c;
                Row r = sheet.getRow(i);
                if (r == null || (c = r.getCell(colnum - 1)) == null) continue;
                r.removeCell(c);
            }
            info.setExcelRowCount(Excel.getRowCount(sheet));
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("deleteColumn", (Throwable)e);
        }
    }

    public void deleteColumns(ExcelInfo info, String range) {
        try {
            int first;
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            int last = Excel.getLastRowNum(sheet);
            for (int j = first = Excel.getFirstRowNum(sheet); j <= last; ++j) {
                Cell c;
                Object object;
                Object[] rows;
                Row r = sheet.getRow(j);
                if (range.contains(",")) {
                    rows = Excel.doProcessList(range);
                    for (object = 0; object < rows.length; ++object) {
                        int colnum = rows[object];
                        if (r == null || (c = r.getCell(colnum - 1)) == null) continue;
                        r.removeCell(c);
                    }
                    continue;
                }
                rows = Excel.doProcessRange(range);
                object = rows[0];
                Integer endcol = rows[1];
                for (Object object2 = object; object2 <= endcol; ++object2) {
                    if (r == null || (c = r.getCell(object2 - 1)) == null) continue;
                    r.removeCell(c);
                }
            }
            info.setExcelRowCount(Excel.getRowCount(sheet));
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("deleteColumns", (Throwable)e);
        }
    }

    private static short getHSSFColor(String value) {
        try {
            HSSFColor.HSSFColorPredefined color = HSSFColor.HSSFColorPredefined.valueOf((String)value.toUpperCase());
            return color.getIndex();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static BorderStyle getBorderStyle(String style) {
        if (style.equalsIgnoreCase("NONE")) {
            return BorderStyle.NONE;
        }
        if (style.equalsIgnoreCase("THIN")) {
            return BorderStyle.THIN;
        }
        if (style.equalsIgnoreCase("MEDIUM")) {
            return BorderStyle.MEDIUM;
        }
        if (style.equalsIgnoreCase("DASHED")) {
            return BorderStyle.DASHED;
        }
        if (style.equalsIgnoreCase("HAIR")) {
            return BorderStyle.HAIR;
        }
        if (style.equalsIgnoreCase("THICK")) {
            return BorderStyle.THICK;
        }
        if (style.equalsIgnoreCase("DOUBLE")) {
            return BorderStyle.DOUBLE;
        }
        if (style.equalsIgnoreCase("DOTTED")) {
            return BorderStyle.DOTTED;
        }
        if (style.equalsIgnoreCase("MEDIUM_DASHED")) {
            return BorderStyle.MEDIUM_DASHED;
        }
        if (style.equalsIgnoreCase("DASH_DOT")) {
            return BorderStyle.DASH_DOT;
        }
        if (style.equalsIgnoreCase("MEDIUM_DASH_DOT")) {
            return BorderStyle.MEDIUM_DASH_DOT;
        }
        if (style.equalsIgnoreCase("DASH_DOT_DOT")) {
            return BorderStyle.DASH_DOT_DOT;
        }
        if (style.equalsIgnoreCase("MEDIUM_DASH_DOT_DOT")) {
            return BorderStyle.MEDIUM_DASH_DOT_DOT;
        }
        if (style.equalsIgnoreCase("SLANTED_DASH_DOT")) {
            return BorderStyle.SLANTED_DASH_DOT;
        }
        return BorderStyle.NONE;
    }

    private static void mergeFonts(Font srcFont, Font destFont) {
        if (!srcFont.equals(destFont)) {
            destFont.setBold(srcFont.getBold());
            destFont.setCharSet(srcFont.getCharSet());
            destFont.setColor(srcFont.getColor());
            destFont.setFontHeight(srcFont.getFontHeight());
            destFont.setFontName(srcFont.getFontName());
            destFont.setItalic(srcFont.getItalic());
            destFont.setStrikeout(srcFont.getStrikeout());
            destFont.setTypeOffset(srcFont.getTypeOffset());
            destFont.setUnderline(srcFont.getUnderline());
        }
    }

    private static Font findFont(Workbook book, Font f, Struct format) {
        Font font;
        boolean boldWeight = f.getBold();
        short color = f.getColor();
        short fontHeight = f.getFontHeight();
        String name = f.getFontName();
        boolean italic = f.getItalic();
        boolean strikeout = f.getStrikeout();
        short typeOffset = f.getTypeOffset();
        byte underline = f.getUnderline();
        Object value = null;
        value = format.get((Object)"font");
        if (value != null) {
            name = (String)value;
        }
        if ((value = format.get((Object)"fontsize")) != null) {
            fontHeight = Cast._short((Object)value, (boolean)false);
            fontHeight = (short)(fontHeight * 20);
        }
        if ((value = format.get((Object)"color")) != null) {
            value = ((String)value).toUpperCase();
            color = Excel.getHSSFColor((String)value);
        }
        if ((value = format.get((Object)"italic")) != null) {
            italic = Cast._boolean((Object)value);
        }
        if ((value = format.get((Object)"strikeout")) != null) {
            strikeout = Cast._boolean((Object)value);
        }
        if ((value = format.get((Object)"bold")) != null && Cast._boolean((Object)value)) {
            boldWeight = true;
        }
        if ((value = format.get((Object)"underline")) != null && Cast._boolean((Object)value)) {
            underline = 1;
        }
        if ((font = book.findFont(boldWeight, color, fontHeight, name, italic, strikeout, typeOffset, underline)) == null) {
            font = Excel.createFont(book);
            Excel.mergeFonts(f, font);
        }
        return font;
    }

    private static Font createFont(Workbook book) {
        short numfonts = (short)(book.getNumberOfFonts() - 1);
        if (numfonts > 3) {
            numfonts = (short)(numfonts + 1);
        }
        Font font = numfonts == Short.MAX_VALUE ? book.getFontAt((int)numfonts) : book.createFont();
        return font;
    }

    private static CellStyle getCellStyle(ExcelInfo info, CellStyle origcellstyle, Struct format) {
        short index;
        CellStyle cellstyle = null;
        Workbook book = info.getWorkbook();
        boolean setFormatCellbyCell = Boolean.getBoolean("coldfusion.format.cellwise");
        if (setFormatCellbyCell || Excel.isCellWiseStyling(format)) {
            Excel.cleanStyles(book);
            cellstyle = book.createCellStyle();
        } else {
            cellstyle = info.getCellStyleForAllCell(format);
            if (cellstyle == null) {
                Excel.cleanStyles(book);
                cellstyle = book.createCellStyle();
                info.setCellStyleForAllCell(format, cellstyle);
            } else {
                return cellstyle;
            }
        }
        cellstyle.cloneStyleFrom(origcellstyle);
        int fontIndex = origcellstyle.getFontIndex();
        Font origfont = book.getFontAt(fontIndex);
        Font font = Excel.findFont(book, origfont, format);
        DataFormat dataformat = book.createDataFormat();
        Object value = format.get((Object)"font");
        if (value != null) {
            font.setFontName((String)value);
        }
        if ((value = format.get((Object)"fontsize")) != null) {
            font.setFontHeightInPoints(Cast._short((Object)value, (boolean)false));
        }
        if ((value = format.get((Object)"color")) != null) {
            index = Excel.getHSSFColor(((String)value).toUpperCase());
            font.setColor(index);
        }
        if ((value = format.get((Object)"italic")) != null) {
            font.setItalic(Cast._boolean((Object)value));
        }
        if ((value = format.get((Object)"strikeout")) != null) {
            font.setStrikeout(Cast._boolean((Object)value));
        }
        if ((value = format.get((Object)"bold")) != null) {
            if (Cast._boolean((Object)value)) {
                font.setBold(true);
            } else {
                font.setBold(false);
            }
        }
        if ((value = format.get((Object)"underline")) != null) {
            if (Cast._boolean((Object)value)) {
                font.setUnderline((byte)1);
            } else {
                font.setUnderline((byte)0);
            }
        }
        cellstyle.setFont(font);
        value = format.get((Object)"bgcolor");
        if (value != null) {
            index = Excel.getHSSFColor(((String)value).toUpperCase());
            cellstyle.setFillBackgroundColor(index);
            cellstyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if ((value = format.get((Object)"fgcolor")) != null) {
            index = Excel.getHSSFColor(((String)value).toUpperCase());
            cellstyle.setFillForegroundColor(index);
            cellstyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if ((value = format.get((Object)"fillpattern")) != null) {
            String val = ((String)value).toUpperCase();
            if (val.equalsIgnoreCase("SQUARES")) {
                cellstyle.setFillPattern(FillPatternType.SQUARES);
            } else if (val.equalsIgnoreCase("NOFILL")) {
                cellstyle.setFillPattern(FillPatternType.NO_FILL);
            } else if (val.equalsIgnoreCase("SOLID_FOREGROUND")) {
                cellstyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            } else if (val.equalsIgnoreCase("FINE_DOTS")) {
                cellstyle.setFillPattern(FillPatternType.FINE_DOTS);
            } else if (val.equalsIgnoreCase("ALT_BARS")) {
                cellstyle.setFillPattern(FillPatternType.ALT_BARS);
            } else if (val.equalsIgnoreCase("SPARSE_DOTS")) {
                cellstyle.setFillPattern(FillPatternType.SPARSE_DOTS);
            } else if (val.equalsIgnoreCase("THICK_HORZ_BANDS")) {
                cellstyle.setFillPattern(FillPatternType.THICK_HORZ_BANDS);
            } else if (val.equalsIgnoreCase("THICK_VERT_BANDS")) {
                cellstyle.setFillPattern(FillPatternType.THICK_VERT_BANDS);
            } else if (val.equalsIgnoreCase("THICK_BACKWARD_DIAG")) {
                cellstyle.setFillPattern(FillPatternType.THICK_BACKWARD_DIAG);
            } else if (val.equalsIgnoreCase("THICK_FORWARD_DIAG")) {
                cellstyle.setFillPattern(FillPatternType.THICK_FORWARD_DIAG);
            } else if (val.equalsIgnoreCase("DIAMONDS")) {
                cellstyle.setFillPattern(FillPatternType.DIAMONDS);
            } else if (val.equalsIgnoreCase("LESS_DOTS")) {
                cellstyle.setFillPattern(FillPatternType.LESS_DOTS);
            } else if (val.equalsIgnoreCase("LEAST_DOTS")) {
                cellstyle.setFillPattern(FillPatternType.LEAST_DOTS);
            } else if (val.equalsIgnoreCase("BIG_DOTS")) {
                cellstyle.setFillPattern(FillPatternType.BIG_SPOTS);
            }
        }
        if ((value = format.get((Object)"leftborder")) != null) {
            BorderStyle borderval = Excel.getBorderStyle(((String)value).toUpperCase());
            cellstyle.setBorderLeft(borderval);
        }
        if ((value = format.get((Object)"rightborder")) != null) {
            BorderStyle borderval = Excel.getBorderStyle((String)value);
            cellstyle.setBorderRight(borderval);
        }
        if ((value = format.get((Object)"topborder")) != null) {
            BorderStyle borderval = Excel.getBorderStyle((String)value);
            cellstyle.setBorderTop(borderval);
        }
        if ((value = format.get((Object)"bottomborder")) != null) {
            BorderStyle borderval = Excel.getBorderStyle((String)value);
            cellstyle.setBorderBottom(borderval);
        }
        if ((value = (String)format.get((Object)"leftbordercolor")) != null) {
            short index2 = Excel.getHSSFColor(((String)value).toUpperCase());
            cellstyle.setLeftBorderColor(index2);
        }
        if ((value = (String)format.get((Object)"rightbordercolor")) != null) {
            short index3 = Excel.getHSSFColor(((String)value).toUpperCase());
            cellstyle.setRightBorderColor(index3);
        }
        if ((value = (String)format.get((Object)"topbordercolor")) != null) {
            short index4 = Excel.getHSSFColor(((String)value).toUpperCase());
            cellstyle.setTopBorderColor(index4);
        }
        if ((value = (String)format.get((Object)"bottombordercolor")) != null) {
            short index5 = Excel.getHSSFColor(((String)value).toUpperCase());
            cellstyle.setBottomBorderColor(index5);
        }
        if ((value = format.get((Object)"rotation")) != null) {
            try {
                cellstyle.setRotation(Cast._short((Object)value, (boolean)false));
            }
            catch (Exception e) {
                throw new SpreadSheetTag.InvalidValueException(Cast._String((Object)value), "rotation");
            }
        }
        if ((value = format.get((Object)"dataformat")) != null) {
            cellstyle.setDataFormat(dataformat.getFormat((String)value));
        }
        if ((value = format.get((Object)"indent")) != null) {
            try {
                cellstyle.setIndention(Cast._short((Object)value, (boolean)false));
            }
            catch (Exception e) {
                throw new SpreadSheetTag.InvalidValueException(Cast._String((Object)value), "indent");
            }
        }
        if ((value = format.get((Object)"hidden")) != null) {
            cellstyle.setHidden(Cast._boolean((Object)value));
        }
        if ((value = format.get((Object)"locked")) != null) {
            cellstyle.setLocked(Cast._boolean((Object)value));
        }
        if ((value = format.get((Object)"alignment")) != null) {
            String val = ((String)value).toUpperCase();
            if (val.equalsIgnoreCase("LEFT")) {
                cellstyle.setAlignment(HorizontalAlignment.LEFT);
            } else if (val.equalsIgnoreCase("RIGHT")) {
                cellstyle.setAlignment(HorizontalAlignment.RIGHT);
            } else if (val.equalsIgnoreCase("CENTER")) {
                cellstyle.setAlignment(HorizontalAlignment.CENTER);
            } else if (val.equalsIgnoreCase("JUSTIFY")) {
                cellstyle.setAlignment(HorizontalAlignment.JUSTIFY);
            } else if (val.equalsIgnoreCase("GENERAL")) {
                cellstyle.setAlignment(HorizontalAlignment.GENERAL);
            } else if (val.equalsIgnoreCase("FILL")) {
                cellstyle.setAlignment(HorizontalAlignment.FILL);
            } else if (val.equalsIgnoreCase("CENTER_SELECTION")) {
                cellstyle.setAlignment(HorizontalAlignment.CENTER_SELECTION);
            }
        }
        if ((value = format.get((Object)"verticalalignment")) != null) {
            String val = ((String)value).toUpperCase();
            if (val.equalsIgnoreCase("VERTICAL_TOP")) {
                cellstyle.setVerticalAlignment(VerticalAlignment.TOP);
            } else if (val.equalsIgnoreCase("VERTICAL_BOTTOM")) {
                cellstyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
            } else if (val.equalsIgnoreCase("VERTICAL_CENTER")) {
                cellstyle.setVerticalAlignment(VerticalAlignment.CENTER);
            } else if (val.equalsIgnoreCase("VERTICAL_JUSTIFY")) {
                cellstyle.setVerticalAlignment(VerticalAlignment.JUSTIFY);
            }
        }
        if ((value = format.get((Object)"textwrap")) != null) {
            cellstyle.setWrapText(Cast._boolean((Object)value));
        }
        return cellstyle;
    }

    private static boolean isCellWiseStyling(Struct format) {
        if (!format.containsKey((Object)"styleCellwise")) {
            return false;
        }
        return Cast._boolean((Object)format.get((Object)"styleCellwise"));
    }

    public static void setColumnWidth(ExcelInfo info, int column, int width) {
        if (width < 0) {
            throw new SpreadSheetTag.SpreadsheetInvalidWidth(width);
        }
        Excel.checkForValidColumnNumber(column);
        Workbook book = info.getWorkbook();
        String sheetname = info.getExcelSheetName();
        Sheet sheet = book.getSheet(sheetname);
        sheet.setColumnWidth(column - 1, width * 256);
    }

    public static void setRowHeight(ExcelInfo info, int row, float heightInPoints) {
        String sheetname;
        if (row > 65535) {
            throw new SpreadSheetTag.SpreadsheetInvalidRowException(row);
        }
        if (heightInPoints < 0.0f) {
            throw new SpreadSheetTag.SpreadsheetInvalidHeight(heightInPoints);
        }
        Workbook book = info.getWorkbook();
        Sheet sheet = book.getSheet(sheetname = info.getExcelSheetName());
        Row hssfrow = sheet.getRow(row - 1);
        if (hssfrow != null) {
            hssfrow.setHeightInPoints(heightInPoints);
        } else {
            hssfrow = sheet.createRow(row - 1);
            hssfrow.setHeightInPoints(heightInPoints);
        }
    }

    public static void formatCellRange(ExcelInfo info, Struct format, int startrow, int startcolumn, int endrow, int endcolumn) {
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            for (int i = startrow - 1; i < endrow; ++i) {
                Row row = sheet.getRow(i);
                if (row == null) {
                    row = sheet.createRow(i);
                }
                Struct rowFormat = (Struct)format.clone();
                rowFormat.put(Key.getInstance((String)("" + i)), (Object)i);
                for (int c = startcolumn - 1; c < endcolumn; ++c) {
                    Cell cell = row.getCell(c);
                    if (cell == null) {
                        cell = row.createCell(c);
                    }
                    CellStyle def = cell.getCellStyle();
                    CellStyle cellstyle = Excel.getCellStyle(info, def, rowFormat);
                    cell.setCellStyle(cellstyle);
                }
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("formatCellRange", (Throwable)e);
        }
    }

    private static void cleanStyles(Workbook book) {
        if (book instanceof HSSFWorkbook && (book.getNumCellStyles() >= Short.MAX_VALUE || book.getNumCellStyles() < 0)) {
            try {
                HSSFOptimiser.optimiseFonts((HSSFWorkbook)((HSSFWorkbook)book));
                HSSFOptimiser.optimiseCellStyles((HSSFWorkbook)((HSSFWorkbook)book));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void formatCell(ExcelInfo info, Struct format, int row, int column) {
        try {
            Cell cell;
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Row hssfrow = sheet.getRow(row - 1);
            if (hssfrow == null) {
                hssfrow = sheet.createRow(row - 1);
            }
            if ((cell = hssfrow.getCell(column - 1)) == null) {
                cell = hssfrow.createCell(column - 1);
            }
            CellStyle def = cell.getCellStyle();
            CellStyle cellstyle = Excel.getCellStyle(info, def, format);
            cell.setCellStyle(cellstyle);
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("formatCell", (Throwable)e);
        }
    }

    public static void formatRows(ExcelInfo info, Struct format, String range) {
        String value = (String)format.get((Object)"size");
        if (value != null) {
            value = value.trim();
        }
        if (range.contains(",")) {
            Integer[] rows = Excel.doProcessList(range);
            for (int i = 0; i < rows.length; ++i) {
                int rownum = rows[i];
                Excel.formatRow(info, format, value, rownum);
            }
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            ArrayList<Integer> resizedColumns = new ArrayList<Integer>();
            for (int i = 0; i < rows.length; ++i) {
                Row row = sheet.getRow(rows[i] - 1);
                if (row == null) continue;
                Iterator cellIterator = row.iterator();
                while (cellIterator.hasNext()) {
                    int colnum = ((Cell)cellIterator.next()).getColumnIndex();
                    if (resizedColumns.contains(colnum)) continue;
                    sheet.autoSizeColumn(colnum, true);
                    resizedColumns.add(colnum);
                }
            }
        } else {
            int[] v = Excel.doProcessRange(range);
            int start = v[0];
            int end = v[1];
            for (int i = start; i <= end; ++i) {
                Excel.formatRow(info, format, value, i);
            }
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            ArrayList<Integer> resizedColumns = new ArrayList<Integer>();
            for (int i = start; i <= end; ++i) {
                Row row = sheet.getRow(i - 1);
                if (row == null) continue;
                Iterator cellIterator = row.iterator();
                while (cellIterator.hasNext()) {
                    int colnum = ((Cell)cellIterator.next()).getColumnIndex();
                    if (resizedColumns.contains(colnum)) continue;
                    sheet.autoSizeColumn(colnum, true);
                    resizedColumns.add(colnum);
                }
            }
        }
    }

    public static void formatColumns(ExcelInfo info, Struct format, String range) {
        Object value = format.get((Object)"size");
        if (range.contains(",")) {
            Integer[] columns = Excel.doProcessList(range);
            for (int i = 0; i < columns.length; ++i) {
                int colnum = columns[i];
                Excel.formatColumn(info, format, value, colnum);
            }
        } else {
            int[] v = Excel.doProcessRange(range);
            int start = v[0];
            int end = v[1];
            for (int i = start; i <= end; ++i) {
                Excel.formatColumn(info, format, value, i);
            }
        }
    }

    public static void formatColumn(ExcelInfo info, Struct format, Object size, int column) {
        Excel.checkForValidColumnNumber(column);
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Object value = format.get((Object)"hidden");
            if (value != null) {
                sheet.setColumnHidden(column - 1, Cast._boolean((Object)value));
            }
            int start = Excel.getFirstRowNum(sheet);
            int last = Excel.getLastRowNum(sheet);
            boolean autosize = false;
            for (int i = start; i <= last; ++i) {
                Cell cell;
                Row row = sheet.getRow(i);
                if (row == null) continue;
                if (size != null) {
                    row.setHeightInPoints(Cast._float((Object)size, (boolean)false) + 1.0f);
                }
                if ((cell = row.getCell(column - 1)) == null) continue;
                if (!autosize) {
                    autosize = true;
                }
                CellStyle def = cell.getCellStyle();
                CellStyle cellstyle = Excel.getCellStyle(info, def, format);
                cell.setCellStyle(cellstyle);
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("formatColumn", (Throwable)e);
        }
    }

    public static void formatColumn(ExcelInfo info, Struct format, int column) {
        Object value = format.get((Object)"size");
        Excel.formatColumn(info, format, value, column);
    }

    public static void formatRow(ExcelInfo info, Struct format, String size, int row) {
        CellStyle cellstyle = null;
        if (row < 1) {
            throw new SpreadSheetTag.ExcelInvalidRowSpecifiedException();
        }
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            if (sheet instanceof SXSSFSheet) {
                ((SXSSFSheet)sheet).trackAllColumnsForAutoSizing();
            }
            Row hssfrow = sheet.getRow(row - 1);
            String value = (String)format.get((Object)"hidden");
            if (value != null) {
                if (value.equalsIgnoreCase("yes")) {
                    value = "true";
                }
                if (value.equalsIgnoreCase("no")) {
                    value = "false";
                }
                hssfrow.setZeroHeight(Cast._boolean((String)value));
            }
            if (hssfrow != null) {
                if (size != null) {
                    hssfrow.setHeightInPoints(new Float(size).floatValue() + 1.0f);
                }
                for (Cell cell : hssfrow) {
                    CellStyle def = cell.getCellStyle();
                    cellstyle = Excel.getCellStyle(info, def, format);
                    cell.setCellStyle(cellstyle);
                }
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("formatRow", (Throwable)e);
        }
    }

    public static void formatRow(ExcelInfo info, Struct format, int row) {
        String value = "";
        value = (String)format.get((Object)"size");
        if (value != null) {
            value = value.trim();
        }
        Excel.formatRow(info, format, value, row);
    }

    public static void setCellValue(ExcelInfo info, String value, int row, int column, String datatype) {
        try {
            Workbook book = info.getWorkbook();
            CreationHelper createHelper = book.getCreationHelper();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Row hssfrow = sheet.getRow(row - 1);
            if (hssfrow == null) {
                hssfrow = sheet.createRow(row - 1);
            }
            Cell c = hssfrow.getCell(column - 1);
            CellStyle style = null;
            if (c != null) {
                style = c.getCellStyle() != null ? c.getCellStyle() : null;
                hssfrow.removeCell(c);
            }
            c = hssfrow.createCell(column - 1);
            if (style != null) {
                c.setCellStyle(style);
            }
            try {
                if (null == datatype) {
                    if (style != null && style.getDataFormatString().equalsIgnoreCase("@")) {
                        Excel.setCellStringValue(sheet, c, column, value, createHelper);
                    } else {
                        double i = Double.parseDouble(value);
                        c.setCellType(CellType.NUMERIC);
                        c.setCellValue(i);
                    }
                } else {
                    Excel.createDatatypeAwareCell(Excel.getParsedDatatypes(datatype, 1)[0], c, value, createHelper, info);
                }
            }
            catch (NumberFormatException e) {
                Excel.setCellStringValue(sheet, c, column, value, createHelper);
            }
            info.setExcelRowCount(Excel.getRowCount(sheet));
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("setCellValue", (Throwable)e);
        }
    }

    private static void setCellStringValue(Sheet sheet, Cell c, int column, String value, CreationHelper createHelper) {
        if (!value.equalsIgnoreCase("")) {
            c.setCellType(CellType.STRING);
            RichTextString str = createHelper.createRichTextString(value);
            c.setCellValue(str);
            int colwidth = sheet.getColumnWidth(column - 1);
            short len = (short)value.length();
            len = (short)((double)(len * 8) / 0.05);
            if (colwidth < len) {
                sheet.setColumnWidth(column - 1, len + 1);
            }
        } else {
            c.setCellType(CellType.BLANK);
            c.setCellValue(createHelper.createRichTextString(""));
        }
    }

    public static String getCellValue(ExcelInfo info, int row, int column) {
        String retval = "";
        Workbook wb = info.getWorkbook();
        CreationHelper createHelper = wb.getCreationHelper();
        evaluator = createHelper.createFormulaEvaluator();
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Row hssfrow = sheet.getRow(row - 1);
            retval = Excel.getValueAt(hssfrow, column - 1);
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("getCellValue", (Throwable)e);
        }
        return retval;
    }

    public static void addFreezePane(ExcelInfo info, int col, int row, int leftcol, int toprow) {
        if (row < 0 || row > 65535) {
            throw new SpreadSheetTag.SpreadsheetInvalidRowException(row);
        }
        if (toprow < 0 || toprow > 65535) {
            throw new SpreadSheetTag.SpreadsheetInvalidRowException(toprow);
        }
        if (leftcol < col) {
            throw new SpreadSheetTag.FreezePaneInvalidColSplitParameter(leftcol, col);
        }
        if (toprow < row) {
            throw new SpreadSheetTag.FreezePaneInvalidRowSplitParameter(toprow, row);
        }
        Workbook wb = info.getWorkbook();
        Sheet sheet = wb.getSheetAt(info.getExcelSheetNumber());
        sheet.createFreezePane(col, row, leftcol, toprow);
    }

    public static void addSplitPane(ExcelInfo info, int col, int row, int leftcol, int toprow, String position) {
        Workbook wb = info.getWorkbook();
        int activepane = position.equalsIgnoreCase("upper_right") ? 1 : (position.equalsIgnoreCase("lower_left") ? 2 : (position.equalsIgnoreCase("lower_right") ? 0 : (position.equalsIgnoreCase("upper_left") ? 3 : 3)));
        if (wb instanceof HSSFWorkbook) {
            HSSFSheet sheet = (HSSFSheet)wb.getSheetAt(info.getExcelSheetNumber());
            sheet.createSplitPane(col, row, leftcol, toprow, activepane);
        } else {
            XSSFSheet sheet = (XSSFSheet)wb.getSheetAt(info.getExcelSheetNumber());
            sheet.createSplitPane(col, row, leftcol, toprow, activepane);
        }
    }

    public static Comment createComment(Workbook wb, Drawing drawing, Struct comment) {
        short numfonts;
        String value = (String)comment.get((Object)"comment");
        if (value == null) {
            return null;
        }
        Object commentString = value;
        CreationHelper factory = wb.getCreationHelper();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setDx1(0);
        anchor.setDx2(0);
        anchor.setDy1(0);
        anchor.setDy2(0);
        anchor.setCol1(4);
        anchor.setRow1(8);
        anchor.setCol2(6);
        anchor.setRow2(11);
        value = (String)comment.get((Object)"anchor");
        if (value != null && value.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(value, "\t\n,");
            int index = 0;
            int count = stringTokenizer.countTokens();
            if (count == 4) {
                String[] c = new String[count];
                while (stringTokenizer.hasMoreElements()) {
                    c[index] = stringTokenizer.nextToken().trim();
                    ++index;
                }
                int top = new Integer(c[0]);
                int left = new Integer(c[1]);
                int bottom = new Integer(c[2]);
                int right = new Integer(c[3]);
                anchor.setCol1(top);
                anchor.setRow1(left);
                anchor.setCol2(bottom);
                anchor.setRow2(right);
            }
        }
        Comment cellComment = drawing.createCellComment(anchor);
        value = (String)comment.get((Object)"author");
        if (value != null) {
            cellComment.setAuthor(value);
            commentString = value + ":\n " + (String)commentString;
        }
        if ((numfonts = (short)(wb.getNumberOfFonts() - 1)) > 3) {
            numfonts = (short)(numfonts + 1);
        }
        Font font = numfonts == Short.MAX_VALUE ? wb.getFontAt((int)numfonts) : wb.createFont();
        value = (String)comment.get((Object)"font");
        if (value != null) {
            font.setFontName(value);
        }
        if ((value = (String)comment.get((Object)"size")) != null) {
            value = value.trim();
            font.setFontHeightInPoints(new Short(value).shortValue());
        }
        if ((value = (String)comment.get((Object)"color")) != null) {
            value = value.toUpperCase();
            short index = Excel.getHSSFColor(value);
            font.setColor(index);
        }
        if (comment.get((Object)"italic") != null) {
            font.setItalic(Cast._boolean((Object)comment.get((Object)"italic")));
        }
        if (comment.get((Object)"strikeout") != null) {
            font.setStrikeout(Cast._boolean((Object)comment.get((Object)"strikeout")));
        }
        if (comment.get((Object)"bold") != null) {
            font.setBold(Cast._boolean((Object)comment.get((Object)"bold")));
        }
        if (comment.get((Object)"underline") != null && Cast._boolean((Object)comment.get((Object)"underline"))) {
            font.setUnderline((byte)1);
        }
        RichTextString richText = factory.createRichTextString((String)commentString);
        richText.applyFont(font);
        cellComment.setString(richText);
        value = (String)comment.get((Object)"visible");
        if (value != null) {
            if (value.equalsIgnoreCase("yes")) {
                value = "true";
            }
            if (value.equalsIgnoreCase("no")) {
                value = "false";
            }
            cellComment.setVisible(Boolean.parseBoolean(value));
        } else {
            cellComment.setVisible(false);
        }
        if (wb instanceof HSSFWorkbook) {
            HSSFComment hssfcomment = (HSSFComment)cellComment;
            value = (String)comment.get((Object)"fillcolor");
            if (value != null) {
                value = value.toUpperCase();
                try {
                    Field f = Color.class.getDeclaredField(value);
                    if (null != f) {
                        Color color = (Color)f.get(null);
                        hssfcomment.setFillColor(color.getRed(), color.getGreen(), color.getBlue());
                    }
                }
                catch (Exception f) {
                    // empty catch block
                }
            }
            if ((value = (String)comment.get((Object)"horizontalalignment")) != null) {
                value = value.trim();
                if ((value = value.toUpperCase()).equalsIgnoreCase("LEFT")) {
                    hssfcomment.setHorizontalAlignment((short)1);
                } else if (value.equalsIgnoreCase("CENTER")) {
                    hssfcomment.setHorizontalAlignment((short)2);
                } else if (value.equalsIgnoreCase("RIGHT")) {
                    hssfcomment.setHorizontalAlignment((short)3);
                } else if (value.equalsIgnoreCase("JUSTIFY")) {
                    hssfcomment.setHorizontalAlignment((short)4);
                } else if (value.equalsIgnoreCase("DISTRIBUTED")) {
                    hssfcomment.setHorizontalAlignment((short)7);
                }
            }
            if ((value = (String)comment.get((Object)"verticalalignment")) != null) {
                value = value.trim();
                if ((value = value.toUpperCase()).equalsIgnoreCase("TOP")) {
                    hssfcomment.setVerticalAlignment((short)1);
                } else if (value.equalsIgnoreCase("CENTER")) {
                    hssfcomment.setVerticalAlignment((short)2);
                } else if (value.equalsIgnoreCase("BOTTOM")) {
                    hssfcomment.setVerticalAlignment((short)3);
                } else if (value.equalsIgnoreCase("JUSTIFY")) {
                    hssfcomment.setVerticalAlignment((short)4);
                } else if (value.equalsIgnoreCase("DISTRIBUTED")) {
                    hssfcomment.setVerticalAlignment((short)7);
                }
            }
            if ((value = (String)comment.get((Object)"linestyle")) != null) {
                value = value.trim();
                if ((value = value.toUpperCase()).equalsIgnoreCase("SOLID")) {
                    hssfcomment.setLineStyle(0);
                } else if (value.equalsIgnoreCase("DASHSYS")) {
                    hssfcomment.setLineStyle(1);
                } else if (value.equalsIgnoreCase("DOTSYS")) {
                    hssfcomment.setLineStyle(2);
                } else if (value.equalsIgnoreCase("DASHDOTSYS")) {
                    hssfcomment.setLineStyle(3);
                } else if (value.equalsIgnoreCase("DASHDOTDOTSYS")) {
                    hssfcomment.setLineStyle(4);
                } else if (value.equalsIgnoreCase("DOTGEL")) {
                    hssfcomment.setLineStyle(5);
                } else if (value.equalsIgnoreCase("DASHGEL")) {
                    hssfcomment.setLineStyle(6);
                } else if (value.equalsIgnoreCase("LONGDASHGEL")) {
                    hssfcomment.setLineStyle(7);
                } else if (value.equalsIgnoreCase("DASHDOTGEL")) {
                    hssfcomment.setLineStyle(8);
                } else if (value.equalsIgnoreCase("LONGDASHDOTGEL")) {
                    hssfcomment.setLineStyle(9);
                } else if (value.equalsIgnoreCase("LONGDASHDOTDOTGEL")) {
                    hssfcomment.setLineStyle(10);
                } else {
                    hssfcomment.setLineStyle(-1);
                }
            }
            if ((value = (String)comment.get((Object)"linewidth")) != null) {
                value = value.trim();
                hssfcomment.setLineWidth(new Integer(value).intValue());
            }
            if ((value = (String)comment.get((Object)"marginbottom")) != null) {
                value = value.trim();
                hssfcomment.setMarginBottom(new Integer(value).intValue());
            }
            if ((value = (String)comment.get((Object)"margintop")) != null) {
                value = value.trim();
                hssfcomment.setMarginTop(new Integer(value).intValue());
            }
            if ((value = (String)comment.get((Object)"marginleft")) != null) {
                value = value.trim();
                hssfcomment.setMarginLeft(new Integer(value).intValue());
            }
            if ((value = (String)comment.get((Object)"marginright")) != null) {
                value = value.trim();
                hssfcomment.setMarginRight(new Integer(value).intValue());
            }
            if ((value = (String)comment.get((Object)"nofill")) != null) {
                if (value.equalsIgnoreCase("yes")) {
                    value = "true";
                }
                if (value.equalsIgnoreCase("no")) {
                    value = "false";
                }
                hssfcomment.setNoFill(Boolean.parseBoolean(value));
            }
            if ((value = (String)comment.get((Object)"linestylecolor")) != null) {
                value = value.toUpperCase();
                try {
                    Field f = Color.class.getDeclaredField(value);
                    if (null != f) {
                        Color color = (Color)f.get(null);
                        hssfcomment.setLineStyleColor(color.getRed(), color.getGreen(), color.getBlue());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return hssfcomment;
        }
        return cellComment;
    }

    public void setCellComment(ExcelInfo info, Struct comment, int row, int column) {
        try {
            Comment cellComment;
            Drawing drawing;
            Cell c;
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Row hssfrow = sheet.getRow(row - 1);
            if (hssfrow == null) {
                hssfrow = sheet.createRow(row - 1);
            }
            if ((c = hssfrow.getCell(column - 1)) == null) {
                c = hssfrow.createCell(column - 1);
            }
            if ((drawing = info.getDrawing()) == null) {
                drawing = sheet.createDrawingPatriarch();
                info.setDrawing(drawing);
            }
            if (comment.get((Object)"anchor") == null) {
                String anchor = column - 1 + "," + (row - 1) + "," + (column + 1) + "," + (row + 2);
                comment.put((Object)"anchor", (Object)anchor);
            }
            if ((cellComment = Excel.createComment(book, drawing, comment)) != null) {
                c.setCellComment(cellComment);
            }
            comment.remove((Object)"anchor");
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("setCellComment", (Throwable)e);
        }
    }

    public static ArrayList<Struct> getCellComment(ExcelInfo info) {
        ArrayList<Struct> comments = new ArrayList<Struct>();
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            int startrow = Excel.getFirstRowNum(sheet);
            int endrow = Excel.getLastRowNum(sheet);
            for (int i = startrow; i < endrow; ++i) {
                Row hssfrow = sheet.getRow(i);
                if (hssfrow == null) continue;
                int firstcell = hssfrow.getFirstCellNum();
                short lastcell = hssfrow.getLastCellNum();
                for (int j = firstcell; j < lastcell; ++j) {
                    Struct c = Excel.getCommentAt(hssfrow, j);
                    if (c == null) continue;
                    comments.add(c);
                }
            }
            return comments;
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("getCellComment", (Throwable)e);
        }
    }

    public static Struct getCellComment(ExcelInfo info, int row, int column) {
        Struct c;
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Row hssfrow = sheet.getRow(row - 1);
            c = Excel.getCommentAt(hssfrow, column - 1);
            if (c == null) {
                c = new Struct();
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("getCellComment", (Throwable)e);
        }
        return c;
    }

    public static String getCellType(ExcelInfo info, int rowNum, int columnNum) {
        try {
            Cell cell = Excel.getCell(info, rowNum, columnNum);
            if (cell == null) {
                return CellType.BLANK.toString();
            }
            if (CellType.FORMULA == cell.getCellType()) {
                if (CellType.ERROR == info.getWorkbook().getCreationHelper().createFormulaEvaluator().evaluate(cell).getCellType()) {
                    return CellType.ERROR.toString();
                }
                return CellType.FORMULA.toString();
            }
            return cell.getCellType().toString();
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("getCellType", (Throwable)e);
        }
    }

    public static Struct getCellFormat(ExcelInfo info, int rowNum, int columnNum) {
        try {
            Excel.checkForValidColumnNumber(columnNum);
            Excel.checkForValidRowNumber(rowNum);
            Cell cell = Excel.getCell(info, rowNum, columnNum);
            if (cell != null) {
                Workbook workbook = info.getWorkbook();
                CellStyle cellStyle = cell.getCellStyle();
                Font font = workbook.getFontAt(cellStyle.getFontIndexAsInt());
                return Excel.fillCellFormatStruct(cellStyle, font, workbook);
            }
            return new Struct();
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("getCellFormat", (Throwable)e);
        }
    }

    private static Struct fillCellFormatStruct(CellStyle cellStyle, Font font, Workbook workbook) {
        Struct struct = new Struct();
        struct.put((Object)"alignment", (Object)cellStyle.getAlignment().toString());
        struct.put((Object)"verticalalignment", (Object)cellStyle.getVerticalAlignment().toString());
        struct.put((Object)"textwrap", (Object)cellStyle.getWrapText());
        struct.put((Object)"indent", (Object)cellStyle.getIndention());
        struct.put((Object)"rotation", (Object)cellStyle.getRotation());
        struct.put((Object)"bottomborder", (Object)cellStyle.getBorderBottom().toString());
        struct.put((Object)"leftborder", (Object)cellStyle.getBorderLeft().toString());
        struct.put((Object)"rightborder", (Object)cellStyle.getBorderRight().toString());
        struct.put((Object)"topborder", (Object)cellStyle.getBorderTop().toString());
        struct.put((Object)"bold", (Object)font.getBold());
        struct.put((Object)"fontsize", (Object)font.getFontHeightInPoints());
        struct.put((Object)"italic", (Object)font.getItalic());
        struct.put((Object)"strikeout", (Object)font.getStrikeout());
        struct.put((Object)"underline", (Object)(font.getUnderline() != 0 ? 1 : 0));
        struct.put((Object)"fillpattern", (Object)cellStyle.getFillPattern().toString());
        struct.put((Object)"dataformat", (Object)cellStyle.getDataFormatString());
        struct.put((Object)"hidden", (Object)cellStyle.getHidden());
        Excel.putColors(cellStyle, workbook, cellStyle instanceof HSSFCellStyle, struct, font);
        return struct;
    }

    private static void putColors(CellStyle cellStyle, Workbook workbook, boolean isBinary, Struct struct, Font font) {
        struct.put((Object)"bottombordercolor", (Object)(isBinary ? Excel.getHSSFColorRGBTriplet(cellStyle, workbook, "bottombordercolor") : (short[])Excel.getXSSFColorRGBTriplet((XSSFCellStyle)cellStyle, "bottombordercolor")));
        struct.put((Object)"topbordercolor", (Object)(isBinary ? Excel.getHSSFColorRGBTriplet(cellStyle, workbook, "topbordercolor") : (short[])Excel.getXSSFColorRGBTriplet((XSSFCellStyle)cellStyle, "topbordercolor")));
        struct.put((Object)"leftbordercolor", (Object)(isBinary ? Excel.getHSSFColorRGBTriplet(cellStyle, workbook, "leftbordercolor") : (short[])Excel.getXSSFColorRGBTriplet((XSSFCellStyle)cellStyle, "leftbordercolor")));
        struct.put((Object)"rightbordercolor", (Object)(isBinary ? Excel.getHSSFColorRGBTriplet(cellStyle, workbook, "rightbordercolor") : (short[])Excel.getXSSFColorRGBTriplet((XSSFCellStyle)cellStyle, "rightbordercolor")));
        struct.put((Object)"fgcolor", (Object)(isBinary ? Excel.getHSSFColorRGBTriplet(cellStyle, workbook, "fgcolor") : (short[])Excel.getXSSFColorRGBTriplet((XSSFCellStyle)cellStyle, "fgcolor")));
        struct.put((Object)"bgcolor", (Object)(isBinary ? Excel.getHSSFColorRGBTriplet(cellStyle, workbook, "bgcolor") : (short[])Excel.getXSSFColorRGBTriplet((XSSFCellStyle)cellStyle, "bgcolor")));
        if (font instanceof HSSFFont) {
            short[] triplet = Constants.DEFAULT_SHORT_TRIPLET;
            HSSFColor hssfColor = ((HSSFFont)font).getHSSFColor((HSSFWorkbook)workbook);
            if (hssfColor != null && hssfColor.getTriplet() != null) {
                triplet = hssfColor.getTriplet();
            }
            struct.put((Object)"color", (Object)triplet);
        } else {
            XSSFColor xssfColor = ((XSSFFont)font).getXSSFColor();
            int[] triplet = Constants.DEFAULT_INT_TRIPLET;
            if (xssfColor != null) {
                triplet = Excel.convertSignedRGBToPositiveTriplet(xssfColor.getRGB());
            }
            struct.put((Object)"color", (Object)triplet);
        }
    }

    private static short[] getHSSFColorRGBTriplet(CellStyle cellStyle, Workbook workbook, String colorString) {
        short[] triplet = Constants.DEFAULT_SHORT_TRIPLET;
        HSSFColor color = null;
        if (workbook instanceof HSSFWorkbook) {
            HSSFPalette pallete = ((HSSFWorkbook)workbook).getCustomPalette();
            switch (colorString) {
                case "bottombordercolor": {
                    color = pallete.getColor(cellStyle.getBottomBorderColor());
                    break;
                }
                case "topbordercolor": {
                    color = pallete.getColor(cellStyle.getTopBorderColor());
                    break;
                }
                case "leftbordercolor": {
                    color = pallete.getColor(cellStyle.getLeftBorderColor());
                    break;
                }
                case "rightbordercolor": {
                    color = pallete.getColor(cellStyle.getRightBorderColor());
                    break;
                }
                case "fgcolor": {
                    color = pallete.getColor(cellStyle.getFillForegroundColor());
                    break;
                }
                case "bgcolor": {
                    color = pallete.getColor(cellStyle.getFillBackgroundColor());
                }
            }
        }
        if (color != null && color.getTriplet() != null) {
            triplet = color.getTriplet();
        }
        return triplet;
    }

    private static int[] getXSSFColorRGBTriplet(XSSFCellStyle cellStyle, String colorString) {
        XSSFColor color = null;
        int[] triplet = Constants.DEFAULT_INT_TRIPLET;
        switch (colorString) {
            case "bottombordercolor": {
                color = cellStyle.getBottomBorderXSSFColor();
                break;
            }
            case "topbordercolor": {
                color = cellStyle.getTopBorderXSSFColor();
                break;
            }
            case "leftbordercolor": {
                color = cellStyle.getLeftBorderXSSFColor();
                break;
            }
            case "rightbordercolor": {
                color = cellStyle.getRightBorderXSSFColor();
                break;
            }
            case "fgcolor": {
                color = cellStyle.getFillForegroundXSSFColor();
                break;
            }
            case "bgcolor": {
                color = cellStyle.getFillBackgroundXSSFColor();
            }
        }
        if (color != null) {
            triplet = Excel.convertSignedRGBToPositiveTriplet(color.getRGB());
        }
        return triplet;
    }

    private static int[] convertSignedRGBToPositiveTriplet(byte[] triplet) {
        if (triplet != null) {
            int[] result = new int[3];
            for (int i = 0; i < 3; ++i) {
                result[i] = triplet[i] & 0xFF;
            }
            return result;
        }
        return Constants.DEFAULT_INT_TRIPLET;
    }

    private static Cell getCell(ExcelInfo info, int rowNum, int columnNum) {
        Workbook book = info.getWorkbook();
        String sheetname = info.getExcelSheetName();
        Sheet sheet = null;
        sheet = sheetname == null ? book.getSheetAt(info.getExcelSheetNumber()) : book.getSheet(sheetname);
        Row row = sheet.getRow(rowNum - 1);
        if (null == row) {
            throw new SpreadSheetTag.InvalidRowSpecifiedException(rowNum);
        }
        if (row.getLastCellNum() < columnNum) {
            throw new SpreadSheetTag.InvalidColumnSpecifiedException(columnNum);
        }
        return row.getCell(columnNum - 1);
    }

    public static void setCellFormula(ExcelInfo info, String formula, int row, int column) {
        try {
            Cell c;
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Row hssfrow = sheet.getRow(row - 1);
            if (hssfrow == null) {
                hssfrow = sheet.createRow(row - 1);
            }
            if ((c = hssfrow.getCell(column - 1)) == null) {
                c = hssfrow.createCell(column - 1);
            }
            c.setCellFormula(formula);
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("setCellFormula", (Throwable)e);
        }
    }

    public static ArrayList<Struct> getCellFormula(ExcelInfo info) {
        ArrayList<Struct> formulas = new ArrayList<Struct>();
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            int startrow = Excel.getFirstRowNum(sheet);
            int endrow = Excel.getLastRowNum(sheet);
            for (int i = startrow; i < endrow; ++i) {
                Row hssfrow = sheet.getRow(i);
                if (hssfrow == null) continue;
                int firstcell = hssfrow.getFirstCellNum();
                short lastcell = hssfrow.getLastCellNum();
                for (int j = firstcell; j < lastcell; ++j) {
                    String s = Excel.getFormulaAt(hssfrow, j);
                    if (s.equalsIgnoreCase("")) continue;
                    Struct c = new Struct();
                    c.put((Object)"FORMULA", (Object)s);
                    c.put((Object)"ROW", (Object)i);
                    c.put((Object)"COLUMN", (Object)j);
                    formulas.add(c);
                }
            }
            return formulas;
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("getCellFormula", (Throwable)e);
        }
    }

    public static String getCellFormula(ExcelInfo info, int row, int column) {
        String formula = "";
        try {
            Workbook book = info.getWorkbook();
            String sheetname = info.getExcelSheetName();
            Sheet sheet = book.getSheet(sheetname);
            Row hssfrow = sheet.getRow(row - 1);
            if (hssfrow != null) {
                formula = Excel.getFormulaAt(hssfrow, column - 1);
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("getCellFormula", (Throwable)e);
        }
        return formula;
    }

    public ArrayList<String[]> readXLS(int sheetno, Integer[] rows, int excludeRow) {
        ArrayList<Object> excel = new ArrayList<String[]>();
        try {
            if (this.workbook.getNumberOfSheets() <= sheetno) {
                throw new SpreadSheetTag.ExcelInvalidSheetException(sheetno + 1);
            }
            Sheet sheet = this.workbook.getSheetAt(sheetno);
            if (sheet != null) {
                excel = new ArrayList();
                for (int i = 0; i < rows.length; ++i) {
                    String[] values;
                    int rownum = rows[i];
                    if (rownum - 1 == excludeRow || (values = this.getValuesAt(sheet, rownum - 1)) == null) continue;
                    excel.add(values);
                }
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.ExcelProcessException("read", (Throwable)e);
        }
        return excel;
    }

    public static void writeCSVToExcel(String filename, String csv, String sheetname, String password, boolean update, Object autosize) {
        String linesep = System.getProperty("line.separator");
        String[] tokens = csv.split(linesep);
        ArrayList<String[]> values = new ArrayList<String[]>();
        for (int ii = 0; ii < tokens.length; ++ii) {
            String s = tokens[ii];
            String[] line = s.split(",");
            ArrayList<String> s1 = new ArrayList<String>();
            for (int i = 0; i < line.length; ++i) {
                StringBuffer tempbuf = new StringBuffer(line[i]);
                String temp = tempbuf.toString();
                if (tempbuf.length() > 0 && tempbuf.charAt(0) == '\"') {
                    if (tempbuf.toString().endsWith("\"")) {
                        tempbuf.setCharAt(0, ' ');
                        tempbuf.setCharAt(tempbuf.length() - 1, ' ');
                        temp = Excel.removeLRSpace(tempbuf);
                        s1.add(temp);
                        continue;
                    }
                    boolean found = false;
                    while (i + 1 < line.length) {
                        int nextState = 0;
                        String next = line[i + 1];
                        if (next.startsWith("\"")) {
                            next = next.replaceFirst("\"", "");
                            ++nextState;
                        }
                        tempbuf.setCharAt(0, ' ');
                        tempbuf.append(",").append(next);
                        ++i;
                        if (!next.endsWith("\"")) continue;
                        found = true;
                        int l = tempbuf.length();
                        if (++nextState != 2) {
                            tempbuf.setCharAt(l - 1, ' ');
                        }
                        temp = Excel.removeLRSpace(tempbuf);
                        break;
                    }
                    temp = Excel.removeLRSpace(tempbuf);
                }
                if (line.length == 1 && temp.startsWith("\"") && temp.endsWith("\"")) {
                    tempbuf.setCharAt(0, ' ');
                    int l = tempbuf.length();
                    tempbuf.setCharAt(l - 1, ' ');
                    temp = Excel.removeLRSpace(tempbuf);
                }
                s1.add(temp);
            }
            String[] row = new String[s1.size()];
            for (int i = 0; i < s1.size(); ++i) {
                row[i] = (String)s1.get(i);
            }
            values.add(row);
        }
        Excel.writeExcel(filename, values, sheetname, password, update, autosize);
    }

    private static String removeLRSpace(StringBuffer tempbuf) {
        String temp = tempbuf.toString();
        temp = temp.replaceAll("\\s+$", "");
        temp = temp.replaceAll("^\\s+", "");
        return temp;
    }

    public static void setImage(ExcelInfo info, String imagePath, boolean isHeaderImage, String alignment, String imageTitle) {
        int lastIndexOfDot = imagePath.toUpperCase().lastIndexOf(".") + 1;
        Excel.setImage(info, Excel.readImage(imagePath), isHeaderImage, alignment, imageTitle, imagePath.substring(lastIndexOfDot));
    }

    public static void setImage(ExcelInfo info, byte[] image, boolean isHeaderImage, String alignment, String imageTitle, String imageType) {
        Sheet sheet = Excel.getPOISheetObject(info);
        if (!Excel.isXMLFormat(info)) {
            throw new SpreadSheetTag.MethodInvalidForFormatException("xlsx");
        }
        Excel.validateIfImageExistsInHeaderFooter(sheet);
        String alignmentCode = Excel.handleAlignment(isHeaderImage, alignment, sheet);
        Workbook workbook = info.getWorkbook();
        int type = Excel.getImageType(imageType);
        if (type == 7) {
            throw new SpreadSheetTag.UnSupportedPictureTypeException(imageType);
        }
        int pictureIndex = workbook.addPicture(image, type);
        String headerFooterIndicator = isHeaderImage ? HEADER_INDICATOR : FOOTER_INDICATOR;
        try {
            Excel.createPicture((XSSFSheet)sheet, pictureIndex, imageTitle, alignmentCode.concat(headerFooterIndicator));
        }
        catch (Exception e) {
            throw new SpreadSheetTag.SpreadSheetFunctionException("addImage", (Throwable)e);
        }
    }

    private static void validateIfImageExistsInHeaderFooter(Sheet sheet) {
        CTHeaderFooter headerFooter = ((XSSFSheet)sheet).getCTWorksheet().getHeaderFooter();
        if (headerFooter != null) {
            if (headerFooter.isSetOddHeader() && headerFooter.getOddHeader().contains(GRAPHIC)) {
                throw new SpreadSheetTag.ExcelSetHeaderFooterImageException();
            }
            if (headerFooter.isSetOddFooter() && headerFooter.getOddFooter().contains(GRAPHIC)) {
                throw new SpreadSheetTag.ExcelSetHeaderFooterImageException();
            }
        }
    }

    static void createPicture(XSSFSheet worksheetSheet, int pictureIndex, String pictureTitle, String alignment) throws Exception {
        OPCPackage workbookPackage = worksheetSheet.getWorkbook().getPackage();
        PackagePartName drawingPartName = PackagingURIHelper.createPartName((String)("/xl/drawings/vmlDrawing" + pictureIndex + ".vml"));
        PackagePart drawingPackagePart = workbookPackage.createPart(drawingPartName, "application/vnd.openxmlformats-officedocument.vmlDrawing");
        VmlDrawing vmlDrawing = Excel.getVmlDrawing(worksheetSheet, pictureIndex, pictureTitle, alignment, drawingPackagePart);
        String relationshipId = worksheetSheet.addRelation(null, (POIXMLRelation)XSSFRelation.VML_DRAWINGS, (POIXMLDocumentPart)vmlDrawing).getRelationship().getId();
        worksheetSheet.getCTWorksheet().addNewLegacyDrawingHF().setId(relationshipId);
    }

    private static VmlDrawing getVmlDrawing(XSSFSheet sheet, int pictureIdx, String pictureTitle, String alignment, PackagePart part) throws IOException {
        VmlDrawing vmldrawing = new VmlDrawing(part);
        XSSFPictureData picData = (XSSFPictureData)sheet.getWorkbook().getAllPictures().get(pictureIdx);
        String rIdPic = vmldrawing.addRelation(null, (POIXMLRelation)XSSFRelation.IMAGES, (POIXMLDocumentPart)picData).getRelationship().getId();
        ByteArrayInputStream is = new ByteArrayInputStream(picData.getData());
        Dimension imageDimension = ImageUtils.getImageDimension((InputStream)is, (int)picData.getPictureType());
        is.close();
        imageDimension.setSize(imageDimension.getWidth(), imageDimension.getHeight());
        vmldrawing.setRIdPic(rIdPic);
        vmldrawing.setPictureTitle(pictureTitle);
        vmldrawing.setImageDimension(imageDimension);
        vmldrawing.setHeaderPos(alignment);
        return vmldrawing;
    }

    private static String handleAlignment(boolean isHeaderImage, String alignment, Sheet sheet) {
        Header header = sheet.getHeader();
        Footer footer = sheet.getFooter();
        String alignmentCode = null;
        switch (alignment.toLowerCase()) {
            case "left": {
                if (isHeaderImage) {
                    header.setLeft(GRAPHIC);
                } else {
                    footer.setLeft(GRAPHIC);
                }
                alignmentCode = LEFT_ALIGNMENT;
                break;
            }
            case "right": {
                if (isHeaderImage) {
                    header.setRight(GRAPHIC);
                } else {
                    footer.setRight(GRAPHIC);
                }
                alignmentCode = RIGHT_ALIGNMENT;
                break;
            }
            case "center": {
                if (isHeaderImage) {
                    header.setCenter(GRAPHIC);
                } else {
                    footer.setCenter(GRAPHIC);
                }
                alignmentCode = CENTER_ALIGNMENT;
                break;
            }
            default: {
                throw new SpreadSheetTag.InvalidParameterValueException("alignment", alignment, "left, right, center");
            }
        }
        return alignmentCode;
    }

    public static void addImage(ExcelInfo info, byte[] image, String type, String anchorVal) {
        block12: {
            try {
                String sheetname = info.getExcelSheetName();
                Workbook book = info.getWorkbook();
                Sheet sheet = book.getSheet(sheetname);
                if (sheet == null) break block12;
                int imgindex = book.addPicture(image, Excel.getImageType(type));
                StringTokenizer stringTokenizer = new StringTokenizer(anchorVal, "\t\n,");
                int index = 0;
                int count = stringTokenizer.countTokens();
                String[] values = new String[count];
                while (stringTokenizer.hasMoreElements()) {
                    values[index] = stringTokenizer.nextToken().trim();
                    ++index;
                }
                CreationHelper helper = book.getCreationHelper();
                Drawing drawing = info.getDrawing();
                if (drawing == null) {
                    try {
                        if (book instanceof HSSFWorkbook) {
                            HSSFSheet s = (HSSFSheet)sheet;
                            drawing = s.getDrawingPatriarch();
                        } else {
                            XSSFSheet s1 = (XSSFSheet)sheet;
                            drawing = (Drawing)s1.getCTWorksheet().getDrawing();
                        }
                    }
                    catch (Exception e) {
                        drawing = sheet.createDrawingPatriarch();
                    }
                    if (drawing == null) {
                        drawing = sheet.createDrawingPatriarch();
                    }
                }
                ClientAnchor anchor = helper.createClientAnchor();
                if (values.length == 8 || values.length == 4) {
                    short endcol;
                    short endrow;
                    short startcol;
                    short startrow;
                    int dy2;
                    int dx2;
                    int dy1;
                    int dx1;
                    if (values.length == 8) {
                        dx1 = new Integer(values[0]);
                        dy1 = new Integer(values[1]);
                        dx2 = new Integer(values[2]);
                        dy2 = new Integer(values[3]);
                        startrow = new Short(values[4]);
                        startcol = new Short(values[5]);
                        endrow = new Short(values[6]);
                        endcol = new Short(values[7]);
                    } else {
                        dx1 = 0;
                        dy1 = 0;
                        dx2 = 0;
                        dy2 = 255;
                        startrow = new Short(values[0]);
                        startcol = new Short(values[1]);
                        endrow = new Short(values[2]);
                        endcol = new Short(values[3]);
                    }
                    startrow = (short)(startrow - 1);
                    startcol = (short)(startcol - 1);
                    endrow = (short)(endrow - 1);
                    endcol = (short)(endcol - 1);
                    anchor.setCol1((int)startcol);
                    anchor.setCol2((int)endcol);
                    anchor.setDx1(dx1);
                    anchor.setDx2(dx2);
                    anchor.setDy1(dy1);
                    anchor.setDy2(dy2);
                    anchor.setRow1((int)startrow);
                    anchor.setRow2((int)endrow);
                    Picture picture = drawing.createPicture(anchor, imgindex);
                }
            }
            catch (Exception e) {
                throw new SpreadSheetTag.SpreadSheetFunctionException("addImage", (Throwable)e);
            }
        }
    }

    private static int getImageType(String type) {
        String upperCaseType;
        return switch (upperCaseType = type.toUpperCase()) {
            case "PNG" -> 6;
            case "JPG", "JPEG" -> 5;
            case "DIB" -> 7;
            default -> throw new SpreadSheetTag.UnSupportedPictureTypeException(upperCaseType);
        };
    }

    public static void addImage(ExcelInfo info, String image, String anchorVal) {
        byte[] picData = Excel.readImage(image);
        String temp = image.toUpperCase();
        int i = temp.lastIndexOf(".");
        Excel.addImage(info, picData, temp.substring(i + 1, temp.length()), anchorVal);
    }

    private static byte[] readImage(String image) {
        byte[] picData;
        block11: {
            FileInputStream picIn = null;
            picData = null;
            try {
                File picFile = VFSFileFactory.getFileObject((String)image);
                if (picFile.exists()) {
                    long length = picFile.length();
                    picData = new byte[(int)length];
                    picIn = new FileInputStream(picFile);
                    picIn.read(picData);
                    break block11;
                }
                throw new FileNotFoundException(image);
            }
            catch (Exception e) {
                throw new SpreadSheetTag.SpreadSheetFunctionException("addImage", (Throwable)e);
            }
            finally {
                if (picIn != null) {
                    try {
                        picIn.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return picData;
    }

    public ArrayList<String[]> readXLS(int sheetno, String rowrange, int excludeRow) {
        if (this.workbook.getNumberOfSheets() <= sheetno) {
            throw new SpreadSheetTag.ExcelInvalidSheetException(sheetno + 1);
        }
        CreationHelper helper = this.workbook.getCreationHelper();
        evaluator = helper.createFormulaEvaluator();
        if (rowrange.contains(",")) {
            Integer[] rows = Excel.doProcessList(rowrange);
            return this.readXLS(sheetno, rows, excludeRow);
        }
        int[] rows = Excel.doProcessRange(rowrange);
        int startrow = rows[0];
        int endrow = rows[1];
        ArrayList<String[]> excel = null;
        --startrow;
        try {
            Sheet sheet = this.workbook.getSheetAt(sheetno);
            if (sheet != null) {
                excel = new ArrayList<String[]>();
                for (int index = startrow; index < endrow; ++index) {
                    String[] values;
                    if (index == excludeRow || (values = this.getValuesAt(sheet, index)) == null || values.length <= 0) continue;
                    excel.add(values);
                }
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.ExcelProcessException("read", (Throwable)e);
        }
        return excel;
    }

    public int getSheetIndex(String name) {
        return this.workbook.getSheetIndex(name);
    }

    public ArrayList<String[]> readXLS(int sheetno, String rowrange, String colrange, int excludeRow) {
        int startrow = 0;
        int endrow = 0;
        boolean processrowlist = false;
        Integer[] rows = new Integer[]{};
        if (this.workbook.getNumberOfSheets() <= sheetno) {
            throw new SpreadSheetTag.ExcelInvalidSheetException(sheetno + 1);
        }
        ArrayList<Object> excel = new ArrayList<String[]>();
        CreationHelper helper = this.workbook.getCreationHelper();
        try {
            Sheet sheet = this.workbook.getSheetAt(sheetno);
            evaluator = helper.createFormulaEvaluator();
            if (sheet != null) {
                if (!rowrange.equalsIgnoreCase("")) {
                    if (rowrange.contains(",")) {
                        rows = Excel.doProcessList(rowrange);
                        processrowlist = true;
                    } else {
                        int[] rowstruct = Excel.doProcessRange(rowrange);
                        startrow = rowstruct[0] - 1;
                        endrow = rowstruct[1];
                    }
                } else {
                    startrow = Excel.getFirstRowNum(sheet);
                    endrow = Excel.getLastRowNum(sheet) + 1;
                }
                if (colrange.contains(",")) {
                    Integer[] cols = Excel.doProcessList(colrange);
                    excel = new ArrayList();
                    if (!processrowlist) {
                        for (int index = startrow; index < endrow; ++index) {
                            String[] values;
                            if (index == excludeRow || (values = this.getValuesAt(sheet, index, cols)) == null) continue;
                            excel.add(values);
                        }
                    } else {
                        for (int index = 0; index < rows.length; ++index) {
                            String[] values;
                            int rownum = rows[index];
                            if (rownum - 1 == excludeRow || (values = this.getValuesAt(sheet, rownum - 1, cols)) == null) continue;
                            excel.add(values);
                        }
                    }
                } else {
                    int[] v = Excel.doProcessRange(colrange);
                    int startcol = v[0] - 1;
                    int endcol = v[1];
                    excel = new ArrayList();
                    if (!processrowlist) {
                        for (int index = startrow; index < endrow; ++index) {
                            String[] values;
                            if (index == excludeRow || (values = this.getValuesAt(sheet, index, startcol, endcol)) == null) continue;
                            excel.add(values);
                        }
                    } else {
                        for (int index = 0; index < rows.length; ++index) {
                            String[] values;
                            int rownum = rows[index];
                            if (rownum - 1 == excludeRow || (values = this.getValuesAt(sheet, rownum - 1, startcol, endcol)) == null) continue;
                            excel.add(values);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ApplicationException) {
                throw (ApplicationException)e;
            }
            throw new SpreadSheetTag.ExcelProcessException("read", (Throwable)e);
        }
        return excel;
    }

    private static int getFirstRowNum(Sheet sheet) {
        int n = sheet.getFirstRowNum();
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    private static int getLastRowNum(Sheet sheet) {
        int n = sheet.getLastRowNum();
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public ArrayList<String[]> readXLS(int sheetno, int excludeRow) {
        if (this.workbook.getNumberOfSheets() <= sheetno) {
            throw new SpreadSheetTag.ExcelInvalidSheetException(sheetno + 1);
        }
        ArrayList<Object> excel = new ArrayList<String[]>();
        try {
            Sheet sheet = this.workbook.getSheetAt(sheetno);
            CreationHelper helper = this.workbook.getCreationHelper();
            evaluator = helper.createFormulaEvaluator();
            if (sheet != null) {
                excel = new ArrayList();
                int startrow = Excel.getFirstRowNum(sheet);
                int endrow = Excel.getLastRowNum(sheet);
                for (int index = startrow; index <= endrow; ++index) {
                    String[] values;
                    if (index == excludeRow || (values = this.getValuesAt(sheet, index)) == null) continue;
                    excel.add(values);
                }
            }
        }
        catch (Exception e) {
            throw new SpreadSheetTag.ExcelProcessException("read", (Throwable)e);
        }
        return excel;
    }

    public static void writeExcel(String xlsfile, ExcelInfo i, String sheetname, String password, boolean update, Object autosize) {
        i.setExcelSheetName(sheetname);
        Excel.writeExcel(xlsfile, i, password, update, autosize);
    }

    public static void cloneCell(Cell src, Cell dest, CreationHelper helper, Map<CellStyle, CellStyle> styleCache) {
        org.apache.poi.ss.usermodel.Hyperlink link;
        Comment comment;
        try {
            comment = src.getCellComment();
        }
        catch (Exception e) {
            comment = null;
        }
        if (comment != null) {
            dest.setCellComment(comment);
        }
        if ((link = src.getHyperlink()) != null) {
            dest.setHyperlink(link);
        }
        switch (src.getCellType().toString()) {
            case "NUMERIC": {
                if (DateUtil.isCellDateFormatted((Cell)src)) {
                    double value = src.getNumericCellValue();
                    if (Excel.isValidExcelDate(value)) {
                        dest.setCellValue(src.getDateCellValue());
                        break;
                    }
                    dest.setCellValue(value);
                    break;
                }
                dest.setCellValue(src.getNumericCellValue());
                break;
            }
            case "STRING": {
                RichTextString text = src.getRichStringCellValue();
                dest.setCellValue(text);
                break;
            }
            case "FORMULA": {
                String formula = null;
                formula = src.getCellFormula();
                if (formula == null) break;
                dest.setCellFormula(formula);
                break;
            }
            default: {
                dest.setCellValue(helper.createRichTextString(""));
            }
        }
        CellStyle srcstyle = src.getCellStyle();
        CellStyle deststyle = styleCache.get(srcstyle);
        if (deststyle == null) {
            deststyle = dest.getSheet().getWorkbook().createCellStyle();
            deststyle.cloneStyleFrom(srcstyle);
            styleCache.put(srcstyle, deststyle);
        }
        dest.setCellStyle(deststyle);
    }

    private static CellRangeAddress[] getMergedRegions(Sheet sheet) {
        int count = sheet.getNumMergedRegions();
        CellRangeAddress[] regions = new CellRangeAddress[count];
        for (int i = 0; i < count; ++i) {
            regions[i] = sheet instanceof HSSFSheet ? ((HSSFSheet)sheet).getMergedRegion(i) : ((XSSFSheet)sheet).getMergedRegion(i);
        }
        return regions;
    }

    private static void cloneSheet(Sheet src, Sheet dest, CreationHelper helper) {
        Header h;
        int first = Excel.getFirstRowNum(src);
        int last = Excel.getLastRowNum(src);
        HashMap<CellStyle, CellStyle> styleCache = new HashMap<CellStyle, CellStyle>();
        for (int j = first; j <= last; ++j) {
            Row row = src.getRow(j);
            if (row == null) continue;
            Row newrow = dest.createRow(j);
            newrow.setHeight(row.getHeight());
            int cellcount = row.getLastCellNum();
            for (int i = 0; i < cellcount; ++i) {
                Cell cell = row.getCell(i);
                if (cell != null && cell.getCellStyle() != null) {
                    dest.setColumnHidden(i, cell.getCellStyle().getHidden());
                }
                if (cell == null) continue;
                Cell newcell = newrow.createCell(cell.getColumnIndex(), cell.getCellType());
                Excel.cloneCell(cell, newcell, helper, styleCache);
            }
        }
        CellRangeAddress[] mergedRegions = Excel.getMergedRegions(src);
        for (int i = 0; i < mergedRegions.length; ++i) {
            dest.addMergedRegion(mergedRegions[i]);
        }
        PaneInformation paneinfo = src.getPaneInformation();
        if (null != paneinfo) {
            if (paneinfo.isFreezePane()) {
                dest.createFreezePane((int)paneinfo.getVerticalSplitPosition(), (int)paneinfo.getHorizontalSplitPosition(), (int)paneinfo.getVerticalSplitLeftColumn(), (int)paneinfo.getHorizontalSplitTopRow());
            } else {
                dest.createSplitPane((int)paneinfo.getVerticalSplitPosition(), (int)paneinfo.getHorizontalSplitPosition(), (int)paneinfo.getVerticalSplitLeftColumn(), (int)paneinfo.getHorizontalSplitTopRow(), (int)paneinfo.getActivePane());
            }
        }
        int columncount = Excel.getColumnCount(src);
        for (int i = 0; i < columncount; ++i) {
            int width = src.getColumnWidth(i);
            if (width > 65280) {
                dest.setColumnWidth(i, 65280);
                continue;
            }
            dest.setColumnWidth(i, width);
        }
        Footer f = src.getFooter();
        if (f != null) {
            Footer destf = dest.getFooter();
            destf.setCenter(f.getCenter());
            destf.setLeft(f.getLeft());
            destf.setRight(f.getRight());
        }
        if ((h = src.getHeader()) != null) {
            Header desth = dest.getHeader();
            desth.setCenter(h.getCenter());
            desth.setLeft(h.getLeft());
            desth.setRight(h.getRight());
        }
    }

    public static void writeExcel(String xlsfile, ExcelInfo i, String password, boolean update, Object autosizeColumn) {
        String action;
        Workbook wb;
        Workbook book;
        block61: {
            book = i.getWorkbook();
            wb = null;
            Excel.cleanStyles(book);
            i.clearStyleMap();
            action = "write";
            if (book != null) {
                try {
                    String sheetname = i.getExcelSheetName();
                    int sheetnumber = i.getExcelSheetNumber();
                    if (i.getWorkbook() instanceof SXSSFWorkbook) {
                        Excel.handleAutosizingForSXSSFSheets(Cast._boolean((Object)autosizeColumn), i.getWorkbook(), sheetname, sheetnumber);
                    }
                    if (VFSFileFactory.getFileObject((String)xlsfile).exists() && update) {
                        action = "update";
                        InputStream inp = null;
                        try {
                            inp = VFSFileFactory.getInputStream((String)xlsfile);
                            wb = WorkbookFactory.create((InputStream)inp, (String)password);
                        }
                        catch (IOException e) {
                            throw new SpreadSheetTag.ExcelProcessException(action, (Throwable)e);
                        }
                        finally {
                            if (inp != null) {
                                try {
                                    inp.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        Sheet newsheet = wb.createSheet(sheetname);
                        CreationHelper helper = wb.getCreationHelper();
                        Sheet book_newSheet = book.getSheet(sheetname);
                        boolean isSheetAlreadyPresent = true;
                        if (book_newSheet == null) {
                            isSheetAlreadyPresent = false;
                            book_newSheet = book.createSheet(sheetname);
                        }
                        CreationHelper book_helper = book.getCreationHelper();
                        Excel.protectSheet(newsheet, password);
                        Sheet sheet = null;
                        sheet = i.isSheetNoProvided() ? book.getSheetAt(0) : book.getSheetAt(i.getExcelSheetNumber());
                        if (sheet != null) {
                            Excel.cloneSheet(sheet, newsheet, helper);
                            if (!isSheetAlreadyPresent) {
                                Excel.cloneSheet(sheet, book_newSheet, book_helper);
                            }
                            int sheetIndex = book.getSheetIndex(sheetname);
                            i.setExcelSheetNumber(sheetIndex);
                            book.setActiveSheet(sheetIndex);
                        }
                        OutputStream out = null;
                        try {
                            if (wb instanceof HSSFWorkbook) {
                                out = VFSFileFactory.getOutputStream((String)xlsfile);
                                wb.write(out);
                            }
                            break block61;
                        }
                        catch (IOException e) {
                            throw new SpreadSheetTag.ExcelProcessException(action, (Throwable)e);
                        }
                        finally {
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    OutputStream out = null;
                    try {
                        if (i.isSheetNoProvided()) {
                            sheetnumber = 0;
                        }
                        if (Excel.getPOISheetObject(i) == null && !book.getSheetName(sheetnumber).equalsIgnoreCase(sheetname)) {
                            book.setSheetName(sheetnumber, sheetname);
                        }
                        Sheet sheet = book.getSheet(sheetname);
                        if (autosizeColumn != null) {
                            Excel.autoResize(i, autosizeColumn);
                        }
                        Excel.protectSheet(sheet, password);
                        if (book instanceof HSSFWorkbook) {
                            out = VFSFileFactory.getOutputStream((String)xlsfile);
                            book.write(out);
                        }
                    }
                    catch (IOException e) {
                        throw new SpreadSheetTag.ExcelProcessException(action, (Throwable)e);
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                catch (Exception e) {
                    throw new SpreadSheetTag.ExcelProcessException(action, (Throwable)e);
                }
            }
        }
        File poifile = VFSFileFactory.getFileObject((String)xlsfile);
        if (book instanceof HSSFWorkbook) {
            Excel.writeOLE2Summary(poifile, i);
        } else if (book instanceof XSSFWorkbook) {
            if (update) {
                Excel.writeXMLSummary(poifile, i, (XSSFWorkbook)wb, true);
            } else {
                Excel.writeXMLSummary(poifile, i, (XSSFWorkbook)book, true);
            }
        } else if (book instanceof SXSSFWorkbook) {
            try (OutputStream out = VFSFileFactory.getOutputStream((String)xlsfile);){
                if (update) {
                    Excel.writeXMLSummary(poifile, i, ((SXSSFWorkbook)wb).getXSSFWorkbook(), false);
                    wb.write(out);
                } else {
                    Excel.writeXMLSummary(poifile, i, ((SXSSFWorkbook)book).getXSSFWorkbook(), false);
                    book.write(out);
                }
            }
            catch (IOException e) {
                throw new SpreadSheetTag.ExcelProcessException(action, (Throwable)e);
            }
        }
    }

    private static void protectSheet(Sheet sheet, String password) {
        if (!Utils.isNullOrEmptyString((String)password)) {
            if (sheet.getProtect()) {
                sheet.protectSheet(null);
            }
            sheet.protectSheet(password);
        }
    }

    private static void handleAutosizingForSXSSFSheets(boolean autosizeColumn, Workbook workbook, String sheetName, int sheetNumber) {
        if (autosizeColumn) {
            Sheet sheet = workbook.getSheet(sheetName);
            if (null == sheet) {
                sheet = workbook.getSheetAt(sheetNumber);
            }
            ((SXSSFSheet)sheet).trackAllColumnsForAutoSizing();
        }
    }

    public static void writeExcel(String xlsfile, ArrayList<String[]> excelvar, String sheetname, String password, boolean update, Object autosizeColumn) {
        InputStream inp = null;
        OutputStream out = null;
        String action = "write";
        Object wb = null;
        if (update) {
            action = "update";
        }
        try {
            if (VFSFileFactory.getFileObject((String)xlsfile).exists() && update) {
                inp = VFSFileFactory.getInputStream((String)xlsfile);
                wb = WorkbookFactory.create((InputStream)inp);
            } else {
                wb = xlsfile.endsWith(".xls") ? new HSSFWorkbook() : new XSSFWorkbook();
            }
            CreationHelper helper = wb.getCreationHelper();
            Sheet s = null;
            if (wb != null) {
                s = wb.createSheet(sheetname);
            }
            Excel.protectSheet(s, password);
            Row r = null;
            Cell c = null;
            ListIterator<String[]> iter = excelvar.listIterator();
            int start = 0;
            while (iter.hasNext()) {
                r = s.createRow(start);
                String[] row = iter.next();
                float columnwidth = 0.0f;
                for (int index = 0; index < row.length; ++index) {
                    c = r.createCell(index);
                    String value = row[index];
                    Double i = Cast._double((String)value, (boolean)false, (boolean)false, (boolean)false);
                    if (i != null) {
                        c.setCellType(CellType.NUMERIC);
                        c.setCellValue(i.doubleValue());
                        continue;
                    }
                    if (value.equals("")) {
                        c.setCellType(CellType.BLANK);
                        c.setCellValue(helper.createRichTextString(""));
                        continue;
                    }
                    c.setCellType(CellType.STRING);
                    RichTextString str = helper.createRichTextString(value);
                    c.setCellValue(str);
                    int colwidth = s.getColumnWidth(index);
                    short len = (short)value.length();
                    len = (short)((double)(len * 8) / 0.05);
                    if (colwidth >= len) continue;
                    s.setColumnWidth(index, len + 1);
                }
                ++start;
            }
            if (autosizeColumn != null) {
                Excel.autoResize(s, false, null, autosizeColumn);
            }
            out = VFSFileFactory.getOutputStream((String)xlsfile);
            wb.write(out);
        }
        catch (Exception e) {
            throw new SpreadSheetTag.ExcelProcessException(action, (Throwable)e);
        }
        finally {
            if (inp != null) {
                try {
                    inp.close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        File poifile = VFSFileFactory.getFileObject((String)xlsfile);
        if (wb instanceof HSSFWorkbook) {
            Excel.writeOLE2Summary(poifile, null);
        } else if (wb instanceof XSSFWorkbook) {
            Excel.writeXMLSummary(poifile, null, (XSSFWorkbook)wb, true);
        }
    }

    public static int doReadStreamingSheet(ArrayList<String[]> rows, Sheet sheet, StreamingReadConfig readConfig) {
        Set<Integer> rowsToProcessSet = Excel.processRowsOrColumns(readConfig.getRows());
        Set<Integer> columnsToProcessSet = Excel.processRowsOrColumns(readConfig.getColumns());
        int index = 0;
        int headerRow = readConfig.getHeaderRow() - 1;
        int maxColCount = 0;
        for (Row row : sheet) {
            maxColCount = Math.max(row.getLastCellNum(), maxColCount);
            if (null != rowsToProcessSet) {
                if (rowsToProcessSet.contains(index) || headerRow == index) {
                    Excel.addCellsToRow(rows, row, columnsToProcessSet);
                }
            } else {
                Excel.addCellsToRow(rows, row, columnsToProcessSet);
            }
            ++index;
        }
        return maxColCount;
    }

    private static Set<Integer> processRowsOrColumns(String rowsOrColumns) {
        LinkedHashSet<Integer> valuesToProcessSet = null;
        Integer[] valuesToProcessArray = null;
        int start = -1;
        int end = -1;
        if (null != rowsOrColumns && !rowsOrColumns.equalsIgnoreCase("")) {
            if (rowsOrColumns.contains(",")) {
                valuesToProcessArray = Excel.doProcessList(rowsOrColumns);
                int index = 0;
                while (index < valuesToProcessArray.length) {
                    Integer[] integerArray = valuesToProcessArray;
                    int n = index++;
                    Integer.valueOf(integerArray[n] - 1);
                }
            } else {
                int[] range = Excel.doProcessRange(rowsOrColumns);
                start = range[0] - 1;
                end = range[1];
            }
        }
        if (null != valuesToProcessArray) {
            valuesToProcessSet = new LinkedHashSet(Arrays.asList(valuesToProcessArray));
        } else if (start != -1) {
            valuesToProcessSet = new LinkedHashSet();
            for (int i = start; i < end; ++i) {
                valuesToProcessSet.add(i);
            }
        }
        if (start == -1 && end == 0) {
            return EMPTY_INTEGER_HASHSET;
        }
        return valuesToProcessSet;
    }

    private static void addCellsToRow(ArrayList<String[]> rows, Row row, Set<Integer> columnsToProcessSet) {
        int lastCellNum = row.getLastCellNum();
        String[] rowCells = new String[null == columnsToProcessSet ? (int)(lastCellNum < 0 ? null : Short.valueOf((short)lastCellNum)).shortValue() : columnsToProcessSet.size()];
        int index = 0;
        if (null != columnsToProcessSet) {
            for (Integer column : columnsToProcessSet) {
                rowCells[index++] = Excel.getValueAt(row, column);
            }
        } else {
            for (int cellindex = 0; cellindex < lastCellNum; ++cellindex) {
                rowCells[index++] = Excel.getValueAt(row, cellindex);
            }
        }
        rows.add(rowCells);
    }

    public static int[] doProcessRange(String range) {
        int[] values = new int[2];
        try {
            if (range.contains("-")) {
                int dot = range.indexOf("-");
                values[0] = new Integer(range.substring(0, dot));
                if (range.length() >= 3) {
                    values[1] = new Integer(range.substring(dot + 1, range.length()));
                }
            } else {
                values[0] = new Integer(range);
                values[1] = values[0];
            }
        }
        catch (NumberFormatException e) {
            throw new SpreadSheetTag.InvalidRangeException(range);
        }
        return values;
    }

    public static Integer[] doProcessList(String list) {
        ArrayList<Integer> rangeval = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(list, "\t\n,");
            rangeval = new ArrayList<Integer>();
            while (stringTokenizer.hasMoreElements()) {
                String token = stringTokenizer.nextToken().trim();
                if (token.contains("-")) {
                    int[] v = Excel.doProcessRange(token);
                    int startrow = v[0];
                    int endrow = v[1];
                    for (int j = startrow; j <= endrow; ++j) {
                        rangeval.add(j);
                    }
                    continue;
                }
                rangeval.add(new Integer(token));
            }
        }
        catch (NumberFormatException e) {
            throw new SpreadSheetTag.InvalidRangeException(list);
        }
        Integer[] retval = new Integer[rangeval.size()];
        for (int i = 0; i < rangeval.size(); ++i) {
            retval[i] = (Integer)rangeval.get(i);
        }
        return retval;
    }

    public void setAutofilter(String autofilter) {
        this.autofilter = autofilter;
    }

    public String getAutofilter() {
        return this.autofilter;
    }

    public static void doProcessStreamingSheet(Sheet sheet, UDFMethod rowProcessor, ExcelInfo excelInfo) {
        for (Row r : sheet) {
            int rowNum = r.getRowNum() + 1;
            short lastCellNum = r.getLastCellNum();
            String[] rowCells = new String[lastCellNum];
            for (short cellindex = 0; cellindex < lastCellNum; cellindex = (short)(cellindex + 1)) {
                rowCells[cellindex] = Excel.getValueAt(r, cellindex);
            }
            Excel.addRow(excelInfo, rowCells, rowNum, 0, true, null);
            Object[] args = new Object[]{excelInfo, rowNum};
            try {
                excelInfo.setUnderProcess(true);
                excelInfo = (ExcelInfo)CFPage._invokeUDF((Object)rowProcessor, (String)rowProcessor.getName(), (CFPage)((CFPage)FusionContext.getCurrent().pageContext.getPage()), (Object[])args);
                if (excelInfo == null || !(excelInfo instanceof ExcelInfo)) {
                    throw new RuntimeException("The function returned an unexpected value " + excelInfo);
                }
                excelInfo.setUnderProcess(false);
            }
            catch (Throwable e) {
                throw new SpreadSheetTag.ExcelProcessingException(e);
            }
        }
    }

    public static Future doAsyncProcessStreamingSheet(Sheet sheet, UDFMethod rowProcessor, ExcelInfo excelInfo) {
        FusionContext fusionContext = FusionContext.getCurrent();
        SpreadsheetProcessingCallable callable = new SpreadsheetProcessingCallable(sheet, excelInfo, rowProcessor, fusionContext, fusionContext.pageContext, RequestMonitorData.getCurrent());
        java.util.concurrent.Future sheetProcessingResultFuture = Executor.getInstance().submit(callable);
        return new Future(sheetProcessingResultFuture);
    }

    public static void setCellRangeValue(ExcelInfo spreadsheet, String value, int startRow, int startColumn, int endRow, int endColumn, String datatype) {
        for (int row = startRow; row <= endRow; ++row) {
            for (int column = startColumn; column <= endColumn; ++column) {
                Excel.setCellValue(spreadsheet, value, row, column, datatype);
            }
        }
    }

    public static void setActiveCell(ExcelInfo spreadsheet, int row, int column) {
        Excel.checkForValidRowNumber(row);
        Excel.checkForValidColumnNumber(column);
        spreadsheet.getWorkbook().getSheet(spreadsheet.getExcelSheetName()).setActiveCell(new CellAddress(row - 1, column - 1));
    }

    public static Struct getActiveCell(ExcelInfo spreadsheet) {
        CellAddress address = spreadsheet.getWorkbook().getSheet(spreadsheet.getExcelSheetName()).getActiveCell();
        Struct result = new Struct();
        result.put((Object)"row", (Object)(address.getRow() + 1));
        result.put((Object)"column", (Object)(address.getColumn() + 1));
        return result;
    }

    public static void clearCell(ExcelInfo spreadsheet, int rowNum, int columnNum) {
        Sheet sheet = Excel.getPOISheetObject(spreadsheet);
        Cell cell = Excel.getCell(spreadsheet, rowNum, columnNum);
        if (cell == null) {
            throw new SpreadSheetTag.ExcelClearCellException();
        }
        Row row = sheet.getRow(rowNum - 1);
        row.removeCell(cell);
    }

    public static void clearCellRange(ExcelInfo spreadsheet, int startRow, int startColumn, int endRow, int endColumn) {
        for (int row = startRow; row <= endRow; ++row) {
            for (int column = startColumn; column <= endColumn; ++column) {
                Excel.clearCell(spreadsheet, row, column);
            }
        }
    }

    public static void setCellHyperlink(ExcelInfo spreadsheet, Hyperlink hyperlink) {
        String type = hyperlink.getType();
        String address = hyperlink.getAddress();
        org.apache.poi.ss.usermodel.Hyperlink cellHyperlink = spreadsheet.getWorkbook().getCreationHelper().createHyperlink(HyperlinkType.valueOf((String)type));
        Excel.validateAddress(type, address);
        cellHyperlink.setAddress(address);
        Cell cell = Excel.getOrCreateCell(spreadsheet, address, hyperlink.getRow(), hyperlink.getColumn());
        if (cell.getHyperlink() != null) {
            cell.removeHyperlink();
        }
        cell.setHyperlink(cellHyperlink);
        cell.setCellStyle(spreadsheet.getHyperlinkStyle());
    }

    private static Cell getOrCreateCell(ExcelInfo spreadsheet, String address, int row, int column) {
        Cell cell = null;
        try {
            cell = Excel.getCell(spreadsheet, row, column);
            if (cell == null) {
                Excel.setCellValue(spreadsheet, address, row, column, null);
            }
        }
        catch (SpreadSheetTag.InvalidColumnSpecifiedException | SpreadSheetTag.InvalidRowSpecifiedException e) {
            Excel.setCellValue(spreadsheet, address, row, column, null);
        }
        return Excel.getCell(spreadsheet, row, column);
    }

    private static void validateAddress(String type, String address) {
        try {
            switch (type) {
                case "EMAIL": {
                    CFTypeValidatorFactory.EMAIL_VALIDATOR.validate((Object)address);
                    break;
                }
                case "URL": {
                    CFTypeValidatorFactory.URL_VALIDATOR.validate((Object)address);
                }
            }
        }
        catch (CFTypeValidationException ex) {
            throw new SpreadSheetTag.ExcelInvalidAddressException(address, type);
        }
    }

    public static Struct getCellHyperlink(ExcelInfo spreadsheet, int row, int column) {
        Cell cell = Excel.getCell(spreadsheet, row, column);
        if (cell != null) {
            org.apache.poi.ss.usermodel.Hyperlink hyperlink = cell.getHyperlink();
            return Excel.fillHyperlinkStruct(hyperlink);
        }
        return new Struct();
    }

    public static List getHyperlinks(ExcelInfo spreadsheet) {
        Array array = new Array();
        Sheet sheet = Excel.getPOISheetObject(spreadsheet);
        sheet.getHyperlinkList().forEach(hyperlink -> array.add((Object)Excel.fillHyperlinkStruct(hyperlink)));
        return array;
    }

    private static Struct fillHyperlinkStruct(org.apache.poi.ss.usermodel.Hyperlink hyperlink) {
        Struct result = new Struct();
        if (null != hyperlink) {
            result.put((Object)"address", (Object)hyperlink.getAddress());
            result.put((Object)"row", (Object)(hyperlink.getFirstRow() + 1));
            result.put((Object)"column", (Object)(hyperlink.getFirstColumn() + 1));
            result.put((Object)"address", (Object)hyperlink.getAddress());
            result.put((Object)"type", (Object)hyperlink.getType().toString());
        }
        return result;
    }

    public static void setRepeatingRows(ExcelInfo spreadsheet, String rows) {
        Sheet sheet = Excel.getPOISheetObject(spreadsheet);
        Optional<String> optionalRows = Optional.ofNullable(rows);
        CellRangeAddress cellRangeAddress = optionalRows.map(r -> Excel.getCellRangeAddress(r, sheet, false)).orElse(null);
        sheet.setRepeatingRows(cellRangeAddress);
    }

    public static void setRepeatingColumns(ExcelInfo spreadsheet, String columns) {
        Sheet sheet = Excel.getPOISheetObject(spreadsheet);
        Optional<String> optionalColumns = Optional.ofNullable(columns);
        CellRangeAddress cellRangeAddress = optionalColumns.map(c -> Excel.getCellRangeAddress(c, sheet, true)).orElse(null);
        sheet.setRepeatingColumns(cellRangeAddress);
    }

    private static CellRangeAddress getCellRangeAddress(String range, Sheet sheet, boolean isColumnRange) {
        int[] splitRange = Excel.doProcessRange(range);
        String start = isColumnRange ? CellReference.convertNumToColString((int)(splitRange[0] - 1)) : String.valueOf(splitRange[0]);
        String end = isColumnRange ? CellReference.convertNumToColString((int)(splitRange[1] - 1)) : String.valueOf(splitRange[1]);
        String convertedRange = start + ":" + end;
        return CellRangeAddress.valueOf((String)convertedRange);
    }

    public static void addPrintGridlines(ExcelInfo spreadsheet, String sheetName) {
        Excel.getPOISheetObject(spreadsheet, sheetName).setPrintGridlines(true);
    }

    public static void removePrintGridlines(ExcelInfo spreadsheet, String sheetName) {
        Excel.getPOISheetObject(spreadsheet, sheetName).setPrintGridlines(false);
    }

    public static boolean isRowHidden(ExcelInfo spreadsheet, int rowNum) {
        Excel.checkForValidRowNumber(rowNum);
        Row row = Excel.getPOISheetObject(spreadsheet).getRow(rowNum - 1);
        if (null == row) {
            throw new SpreadSheetTag.InvalidRowSpecifiedException(rowNum);
        }
        return row.getZeroHeight();
    }

    public static boolean isColumnHidden(ExcelInfo spreadsheet, int columnNum) {
        Excel.checkForValidColumnNumber(columnNum);
        return Excel.getPOISheetObject(spreadsheet).isColumnHidden(columnNum - 1);
    }

    public static void setRowHidden(ExcelInfo spreadsheet, int rowNum, boolean hide) {
        Excel.checkForValidRowNumber(rowNum);
        Row row = Excel.getPOISheetObject(spreadsheet).getRow(rowNum - 1);
        if (null == row) {
            throw new SpreadSheetTag.InvalidRowSpecifiedException(rowNum);
        }
        row.setZeroHeight(hide);
    }

    public static void setColumnHidden(ExcelInfo spreadsheet, int columnNum, boolean hide) {
        Excel.checkForValidColumnNumber(columnNum);
        Excel.getPOISheetObject(spreadsheet).setColumnHidden(columnNum - 1, hide);
    }

    public static int getColumnWidth(ExcelInfo spreadsheet, int columnNum, boolean returnWidthInPixels) {
        Excel.checkForValidColumnNumber(columnNum);
        if (returnWidthInPixels) {
            return Cast._int((double)Excel.getPOISheetObject(spreadsheet).getColumnWidthInPixels(columnNum - 1));
        }
        return Excel.getPOISheetObject(spreadsheet).getColumnWidth(columnNum - 1) / 256;
    }

    public static int getLastRowNumber(ExcelInfo spreadsheet) {
        return Excel.getPOISheetObject(spreadsheet).getLastRowNum() + 1;
    }

    public static void setFitToPage(ExcelInfo spreadsheet, boolean fitToPage, int pagesWidth, int pagesHeight) {
        if (pagesWidth < 0) {
            throw new SpreadSheetTag.SpreadsheetInvalidWidth(pagesWidth);
        }
        if (pagesHeight < 0) {
            throw new SpreadSheetTag.SpreadsheetInvalidHeight((float)pagesHeight);
        }
        Sheet sheet = Excel.getPOISheetObject(spreadsheet);
        sheet.setFitToPage(fitToPage);
        sheet.getPrintSetup().setFitWidth(Cast._short((long)pagesWidth));
        sheet.getPrintSetup().setFitHeight(Cast._short((long)pagesHeight));
    }

    public static boolean isXMLFormat(ExcelInfo spreadsheet) {
        return Excel.getPOISheetObject(spreadsheet) instanceof XSSFSheet;
    }

    public static boolean isStreamingXMLFormat(ExcelInfo spreadsheet) {
        return Excel.getPOISheetObject(spreadsheet) instanceof SXSSFSheet;
    }

    public static boolean isBinaryFormat(ExcelInfo spreadsheet) {
        return Excel.getPOISheetObject(spreadsheet) instanceof HSSFSheet;
    }

    public static void addDataValidationRule(ExcelInfo spreadsheet, SheetDataValidationRule validationRule) {
        Sheet sheet = Excel.getPOISheetObject(spreadsheet);
        DataValidationHelper dataValidationHelper = Excel.createDataValidationHelper(spreadsheet, sheet);
        DataValidationConstraint constraint = null;
        int validationType = validationRule.getValidationType();
        switch (validationType) {
            case 1: 
            case 2: 
            case 6: {
                Excel.checkNumericValue("value", validationRule.getValue(), validationType, Excel.getExampleValueForValidationType(validationType));
                Excel.checkNumericValue("minValue", validationRule.getMinValue(), validationType, Excel.getExampleValueForValidationType(validationType));
                Excel.checkNumericValue("maxValue", validationRule.getMaxValue(), validationType, Excel.getExampleValueForValidationType(validationType));
            }
            case 4: {
                switch (validationRule.getOperatorType()) {
                    case 0: 
                    case 1: {
                        String minValue = validationRule.getMinValue();
                        String maxValue = validationRule.getMaxValue();
                        if (validationType == 4) {
                            if (Excel.getExcelDate(minValue, "minValue").compareTo(Excel.getExcelDate(maxValue, "maxValue")) > 0) {
                                throw new SpreadSheetTag.InvalidParameterCombinationException("maxValue", validationRule.getMaxValue(), "minValue", validationRule.getMinValue());
                            }
                            constraint = dataValidationHelper.createDateConstraint(validationRule.getOperatorType(), Excel.getExcelDate(minValue, "minValue"), Excel.getExcelDate(maxValue, "maxValue"), "yyyy-mm-dd");
                            break;
                        }
                        if (validationType != 6 && Cast._double((String)minValue) > Cast._double((String)maxValue)) {
                            throw new SpreadSheetTag.InvalidParameterCombinationException("maxValue", validationRule.getMaxValue(), "minValue", validationRule.getMinValue());
                        }
                        constraint = dataValidationHelper.createNumericConstraint(validationType, validationRule.getOperatorType(), minValue, maxValue);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        constraint = validationType == 4 ? dataValidationHelper.createDateConstraint(validationRule.getOperatorType(), Excel.getExcelDate(validationRule.getValue(), "value"), null, "yyyy-mm-dd") : dataValidationHelper.createNumericConstraint(validationType, validationRule.getOperatorType(), validationRule.getValue(), null);
                    }
                }
                break;
            }
            case 3: {
                constraint = dataValidationHelper.createExplicitListConstraint(validationRule.getAllowedValues());
            }
        }
        CellRangeAddressList regions = new CellRangeAddressList();
        validationRule.getRegions().forEach(region -> regions.addCellRangeAddress(region));
        DataValidation dataValidation = dataValidationHelper.createValidation(constraint, regions);
        dataValidation.setShowErrorBox(true);
        dataValidation.createErrorBox(validationRule.getErrorBoxTitle(), validationRule.getErrorBoxText());
        if (null != validationRule.getPromptBoxText()) {
            dataValidation.setShowPromptBox(true);
            dataValidation.createPromptBox(validationRule.getPromptBoxTitle(), validationRule.getPromptBoxText());
        }
        sheet.addValidationData(dataValidation);
    }

    private static Number getExampleValueForValidationType(int validationType) {
        return 1 == validationType || 6 == validationType ? 50.0 : 50.05;
    }

    private static void checkNumericValue(String key, String value, int validationType, Number example) {
        if (null != value && !CFPage.IsNumeric((Object)value)) {
            String type = "DOUBLE";
            switch (validationType) {
                case 1: {
                    type = "INTEGER";
                    break;
                }
                case 2: {
                    type = "DOUBLE";
                    break;
                }
                case 6: {
                    type = "TEXT_LENGTH";
                }
            }
            throw new SpreadSheetTag.InvalidValueForValidationTypeException(key, value, type, example.toString());
        }
    }

    private static String getExcelDate(String value, String key) {
        Date date = Cast._Date((String)value);
        date.setHours(0);
        date.setMinutes(0);
        date.setSeconds(0);
        if (DateUtil.getExcelDate((Date)date) == -1.0) {
            throw new SpreadSheetTag.InvalidValueForValidationTypeException(key, value, DATEDATATYPE, "2024-01-01");
        }
        return "" + DateUtil.getExcelDate((Date)date);
    }

    private static DataValidationHelper createDataValidationHelper(ExcelInfo spreadsheet, Sheet sheet) {
        DataValidationHelper dataValidationHelper = null;
        if (Excel.isBinaryFormat(spreadsheet)) {
            dataValidationHelper = sheet.getDataValidationHelper();
        } else if (Excel.isXMLFormat(spreadsheet)) {
            dataValidationHelper = sheet.getDataValidationHelper();
        } else {
            throw new SpreadSheetTag.MethodNotImplementedForStreamingSheetException("addDataValidationRule");
        }
        return dataValidationHelper;
    }

    public static void setForceFormulaRecalculation(ExcelInfo spreadsheet, boolean forceRecalculation) {
        Excel.getPOISheetObject(spreadsheet).setForceFormulaRecalculation(forceRecalculation);
    }

    public static boolean getForceFormulaRecalculation(ExcelInfo spreadsheet) {
        return Excel.getPOISheetObject(spreadsheet).getForceFormulaRecalculation();
    }

    public static void setPrintOrientation(ExcelInfo spreadsheet, String orientation, String sheetName) {
        PrintSetup printSetup = Excel.getPOISheetObject(spreadsheet, sheetName).getPrintSetup();
        switch (orientation.toLowerCase()) {
            case "portrait": {
                printSetup.setLandscape(false);
                break;
            }
            case "landscape": {
                printSetup.setLandscape(true);
                break;
            }
            default: {
                throw new SpreadSheetTag.InvalidParameterValueException("printOrientation", orientation, "portrait, landscape");
            }
        }
    }

    public static String getPrintOrientation(ExcelInfo spreadsheet, String sheetName) {
        return Excel.getPOISheetObject(spreadsheet, sheetName).getPrintSetup().getLandscape() ? "landscape" : "portrait";
    }

    public static void renameSheet(ExcelInfo excelInfo, String oldName, String newName) {
        Workbook book = excelInfo.getWorkbook();
        int sheetIndex = book.getSheetIndex(oldName);
        if (sheetIndex == -1) {
            throw new SpreadSheetTag.SpreadSheetInvalidSheetNameException(oldName);
        }
        book.setSheetName(sheetIndex, newName);
        excelInfo.setExcelSheetName(newName);
        excelInfo.setSummaryInfo(Excel.info(excelInfo));
    }

    public static void setRowBreak(ExcelInfo spreadsheet, int row) {
        Excel.checkForValidRowNumber(row);
        Excel.getPOISheetObject(spreadsheet).setRowBreak(row - 1);
    }

    public static void removeRowBreak(ExcelInfo spreadsheet, int row) {
        Excel.checkForValidRowNumber(row);
        Excel.getPOISheetObject(spreadsheet).removeRowBreak(row - 1);
    }

    public static void setColumnBreak(ExcelInfo spreadsheet, int column) {
        Excel.checkForValidColumnNumber(column);
        Excel.getPOISheetObject(spreadsheet).setColumnBreak(column - 1);
    }

    public static void removeColumnBreak(ExcelInfo spreadsheet, int column) {
        Excel.checkForValidColumnNumber(column);
        Excel.getPOISheetObject(spreadsheet).removeColumnBreak(column - 1);
    }

    public static void groupRows(ExcelInfo spreadsheet, int startRow, int endRow) {
        Excel.checkValidRange(startRow, endRow, true);
        Excel.getPOISheetObject(spreadsheet).groupRow(startRow - 1, endRow - 1);
    }

    public static void ungroupRows(ExcelInfo spreadsheet, int startRow, int endRow) {
        Excel.checkValidRange(startRow, endRow, true);
        Excel.getPOISheetObject(spreadsheet).ungroupRow(startRow - 1, endRow - 1);
    }

    public static void groupColumns(ExcelInfo spreadsheet, int startColumn, int endColumn) {
        Excel.checkValidRange(startColumn, endColumn, false);
        Excel.getPOISheetObject(spreadsheet).groupColumn(startColumn - 1, endColumn - 1);
    }

    public static void ungroupColumns(ExcelInfo spreadsheet, int startColumn, int endColumn) {
        Excel.checkValidRange(startColumn, endColumn, false);
        Excel.getPOISheetObject(spreadsheet).ungroupColumn(startColumn - 1, endColumn - 1);
    }

    private static Sheet getPOISheetObject(ExcelInfo spreadsheet, String sheetName) {
        if (sheetName == null) {
            return Excel.getPOISheetObject(spreadsheet);
        }
        Sheet sheet = spreadsheet.getWorkbook().getSheet(sheetName);
        if (null == sheet) {
            throw new SpreadSheetTag.ExcelInvalidSheetNameException(sheetName);
        }
        return sheet;
    }

    private static Sheet getPOISheetObject(ExcelInfo spreadsheet) {
        String sheetName = spreadsheet.getExcelSheetName();
        if (null != sheetName) {
            return spreadsheet.getWorkbook().getSheet(spreadsheet.getExcelSheetName());
        }
        return spreadsheet.getWorkbook().getSheetAt(spreadsheet.getExcelSheetNumber());
    }

    private static void checkValidRange(int start, int end, boolean isRowRange) {
        if (isRowRange) {
            Excel.checkForValidRowNumber(start);
            Excel.checkForValidRowNumber(end);
        } else {
            Excel.checkForValidColumnNumber(start);
            Excel.checkForValidColumnNumber(end);
        }
        if (start > end) {
            throw new SpreadSheetTag.InvalidRangeException(start + "-" + end);
        }
    }

    private static void checkForValidColumnNumber(int columnNum) {
        if (columnNum < 1 || columnNum > 16384) {
            throw new SpreadSheetTag.InvalidColumnSpecifiedException(columnNum);
        }
    }

    private static void checkForValidRowNumber(int row) {
        if (row < 1 || row > 0x100000) {
            throw new SpreadSheetTag.InvalidRowSpecifiedException(row);
        }
    }

    static {
        dateformatter.setTimeZone(TimeZone.getDefault());
        dateformatter2.setTimeZone(TimeZone.getDefault());
        DATATYPEMAPPER = new HashMap<Integer, Integer>();
        DATATYPEMAPPER.put(2, 3);
        DATATYPEMAPPER.put(4, 3);
        DATATYPEMAPPER.put(-5, 3);
        DATATYPEMAPPER.put(3, 3);
        DATATYPEMAPPER.put(8, 3);
        DATATYPEMAPPER.put(6, 3);
        DATATYPEMAPPER.put(-6, 3);
        DATATYPEMAPPER.put(5, 3);
        DATATYPEMAPPER.put(7, 3);
        DATATYPEMAPPER.put(0, 2);
        DATATYPEMAPPER.put(16, 4);
        DATATYPEMAPPER.put(91, 1);
        DATATYPEMAPPER.put(92, 1);
        DATATYPEMAPPER.put(93, 1);
        DATATYPESTRINGMAPPER = new CaseInsensitiveMap();
        DATATYPESTRINGMAPPER.put(NUMERICDATATYPE, 2);
        DATATYPESTRINGMAPPER.put(STRINGDATATYPE, -1);
        DATATYPESTRINGMAPPER.put(DATEDATATYPE, 91);
    }
}

