/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.cms.CMSAttributeTableGenerator;

public class DefaultSignedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public DefaultSignedAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public DefaultSignedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    protected Hashtable createStandardAttributeTable(Map map) {
        Object object;
        Hashtable hashtable = (Hashtable)this.table.clone();
        if (!hashtable.containsKey(CMSAttributes.contentType)) {
            object = new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((DEREncodable)((DERObjectIdentifier)map.get("contentType"))));
            hashtable.put(object.getAttrType(), object);
        }
        if (!hashtable.containsKey(CMSAttributes.signingTime)) {
            object = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((DEREncodable)new Time(new Date())));
            hashtable.put(object.getAttrType(), object);
        }
        if (!hashtable.containsKey(CMSAttributes.messageDigest)) {
            object = (byte[])map.get("digest");
            Attribute attribute = object != null ? new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((DEREncodable)new DEROctetString((byte[])object))) : new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((DEREncodable)new DERNull()));
            hashtable.put(attribute.getAttrType(), attribute);
        }
        return hashtable;
    }

    public AttributeTable getAttributes(Map map) {
        return new AttributeTable(this.createStandardAttributeTable(map));
    }
}

