/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.pdf;

import coldfusion.image.Image;
import coldfusion.pdf.PDFFormException;
import coldfusion.pdf.PDFXMLDataObject;
import coldfusion.pdf.core.PDFException;
import coldfusion.tagext.ChildTag;
import coldfusion.tagext.pdf.PDFFormTag;
import coldfusion.util.RB;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;

public class PDFFormParamTag
extends ChildTag {
    private PDFFormTag pdfFormTag = null;
    private String name;
    private Object value;
    private int index = 1;
    private boolean imageField = false;

    public PDFFormParamTag() {
        super(PDFFormTag.class);
    }

    public void setName(String name) {
        if (name == null || "".equals(name.trim())) {
            throw new PDFException.EmptyAttributeException3("name");
        }
        this.name = name;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setImageField(boolean imageField) {
        this.imageField = imageField;
    }

    public int doEndTag() throws JspException {
        this.onTagEnd();
        return 6;
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        if ("READ".equalsIgnoreCase(this.pdfFormTag.getAction())) {
            throw new PDFFormException(RB.getString(PDFFormException.class, (String)"cfpdfform.invalidPDFFormParamTagUse"));
        }
        PDFXMLDataObject pdfXMLDataObject = this.pdfFormTag.getPdfDataObject();
        if (this.imageField) {
            this.value = this.convertImage(this.value);
        }
        if (pdfXMLDataObject == null) {
            throw new PDFFormException();
        }
        pdfXMLDataObject.addChildNode(this.name, this.value, this.index);
        return 0;
    }

    private Object convertImage(Object image) {
        String format;
        Image result;
        block12: {
            result = null;
            format = "png";
            if (image instanceof Image) {
                result = new Image((Image)image);
                String imgSource = ((Image)image).getSource();
                int x = imgSource.lastIndexOf(".");
                if (x != -1) {
                    format = imgSource.substring(x + 1);
                }
            } else {
                try {
                    if (image.getClass().isArray() || image instanceof byte[]) {
                        result = new Image((byte[])image);
                        break block12;
                    }
                    if (!(image instanceof String)) break block12;
                    try {
                        Image tempImg = new Image();
                        tempImg.readBase64((String)image);
                        result = tempImg;
                        String imgSource = tempImg.getSource();
                        int x = imgSource.lastIndexOf(".");
                        if (x != -1) {
                            format = imgSource.substring(x + 1);
                        }
                    }
                    catch (Exception e) {
                        result = new Image((String)image, this.pageContext);
                        int x = ((String)image).lastIndexOf(".");
                        if (x != -1) {
                            format = ((String)image).substring(x + 1);
                        }
                    }
                }
                catch (Exception ex) {
                    result = null;
                }
            }
        }
        if (result == null) {
            return image;
        }
        if (!((format = format.toLowerCase()).startsWith("jp") || format.startsWith("tif") || format.equals("bmp"))) {
            format = "png";
        }
        return result.getBase64String(format);
    }

    public void release() {
        this.name = null;
        this.value = null;
        this.index = 1;
        this.imageField = false;
        super.release();
    }

    protected void setAncestor(Tag ancestor) {
        this.pdfFormTag = (PDFFormTag)ancestor;
    }
}

