/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.DeleteType;
import coldfusion.exchange.EffectiveRights;
import coldfusion.exchange.ExchangeFolder;
import coldfusion.exchange.FolderFilterInfo;
import coldfusion.tagext.net.exchange.ExchangeExceptions;
import coldfusion.tagext.net.exchange.ExchangeFilterable;
import coldfusion.tagext.net.exchange.ExchangeTag;
import coldfusion.tagext.net.exchange.FolderConstants;
import coldfusion.tagext.net.exchange.FolderTagHelper;
import coldfusion.tagext.validation.RequiredAttributesException;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;
import java.util.HashMap;
import java.util.Map;

public class ExchangeFolderTag
extends ExchangeTag
implements ExchangeFilterable,
FolderConstants {
    private static final String action_getInfo = "getInfo";
    private static final String action_getExtendedInfo = "getExtendedInfo";
    private static final String action_findSubFolders = "findSubfolders";
    private static final String action_empty = "empty";
    private static final String action_copy = "copy";
    private static final String action_move = "move";
    FolderFilterInfo filterInfo = new FolderFilterInfo();
    private Map folder = null;
    private DeleteType deleteType = DeleteType.MoveToDeletedItems;
    private String pathDelimitter = "/";
    private String folderPath;
    private String parentFolderId;
    private boolean deleteSubFolders;
    private String sourceFolderId;
    private String destinationFolderId;
    private static HashMap validFilterAttributes = new HashMap();
    private static HashMap validFolderAttributes = new HashMap();

    PageContext getPageContext() {
        return this.pageContext;
    }

    FolderFilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    @Override
    public void addFilter(String attribName, HashMap values) {
        if (!this.isValidAttributeKey(attribName, validFilterAttributes)) {
            ExchangeExceptions.throwInvalidFilterAttributeKeyException(attribName, "cfexchangefolder");
        }
        if (attribName.equalsIgnoreCase("ChildFolderCount")) {
            int[] result = this.getFromAndToValuesForTheAttribute("ChildFolderCount", values);
            boolean valueSet = false;
            if (result[0] != -1) {
                this.filterInfo.setFromChildFolderCount(result[0]);
                valueSet = true;
            }
            if (result[1] != -1) {
                this.filterInfo.setToChildFolderCount(result[1]);
                valueSet = true;
            }
            if (!valueSet) {
                ExchangeExceptions.throwInvalidAttributeValueException("ChildFolderCount");
            }
            return;
        }
        if (attribName.equalsIgnoreCase("TotalCount")) {
            int[] result = this.getFromAndToValuesForTheAttribute("TotalCount", values);
            boolean valueSet = false;
            if (result[0] != -1) {
                this.filterInfo.setFromTotalCount(result[0]);
                valueSet = true;
            } else if (result[1] != -1) {
                this.filterInfo.setToTotalCount(result[1]);
                valueSet = true;
            }
            if (!valueSet) {
                ExchangeExceptions.throwInvalidAttributeValueException("TotalCount");
            }
            return;
        }
        if (attribName.equalsIgnoreCase("UnreadCount")) {
            int[] result = this.getFromAndToValuesForTheAttribute("UnreadCount", values);
            boolean valueSet = false;
            if (result[0] != -1) {
                this.filterInfo.setFromUnreadCount(result[0]);
                valueSet = true;
            } else if (result[1] != -1) {
                this.filterInfo.setToUnreadCount(result[1]);
                valueSet = true;
            }
            if (!valueSet) {
                ExchangeExceptions.throwInvalidAttributeValueException("UnreadCount");
            }
            return;
        }
        Object value = values.get("value");
        if (value == null || value.toString().length() == 0) {
            ExchangeExceptions.throwEmptyAttributeValueException(attribName);
        }
        if (!(value instanceof String)) {
            ExchangeExceptions.throwInvalidStringValueException(attribName);
        }
        if (attribName.equalsIgnoreCase("MaxRows")) {
            int tmpInt = ExchangeTag.castInt(value, "MaxRows");
            if (tmpInt <= 0 && tmpInt != -1) {
                ExchangeExceptions.throwNonPositiveValueException("MaxRows");
            }
            this.filterInfo.setMaxRows(tmpInt);
        } else if (attribName.equalsIgnoreCase("DisplayName")) {
            this.filterInfo.setDisplayName(value.toString());
        } else if (attribName.equalsIgnoreCase("FolderClass")) {
            this.filterInfo.setFolderClass(value.toString());
        } else if (attribName.equalsIgnoreCase("EffectiveRights")) {
            EffectiveRights effectiveRights = ExchangeFolder.stringToEffectiveRights(value.toString());
            if (null == effectiveRights) {
                ExchangeExceptions.throwInvalidAttributeValueException(attribName);
            }
            this.filterInfo.setEffectiveRights(effectiveRights);
        }
    }

    private int[] getFromAndToValuesForTheAttribute(String attributeName, HashMap values) {
        int[] result = new int[2];
        int from = -1;
        int to = -1;
        if (values.containsKey("from") && (from = ExchangeTag.castInt(values.get("from"), "from")) < 0) {
            ExchangeExceptions.throwNonPositiveValueException(attributeName);
        }
        if (values.containsKey("to") && (to = ExchangeTag.castInt(values.get("to"), "to")) < 0) {
            ExchangeExceptions.throwNonPositiveValueException(attributeName);
        }
        result[0] = from;
        result[1] = to;
        return result;
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        this.onTagStart();
        if ((this.action.equalsIgnoreCase("create") || this.action.equalsIgnoreCase("modify")) && this.getFolder() == null) {
            throw new RequiredAttributesException(this.getTagPublicName(), "Folder");
        }
        return 6;
    }

    @Override
    public int doEndTag() throws JspException {
        super.doEndTag();
        if (this.action.equalsIgnoreCase(action_getInfo)) {
            if (this.getName() == null) {
                throw new RequiredAttributesException(this.getTagPublicName(), "name");
            }
            FolderTagHelper.getFolderInfo(this);
        } else if (this.action.equalsIgnoreCase(action_getExtendedInfo)) {
            if (this.getName() == null) {
                throw new RequiredAttributesException(this.getTagPublicName(), "name");
            }
            FolderTagHelper.getFolderExtendedInfo(this);
        } else if (this.action.equalsIgnoreCase(action_findSubFolders)) {
            if (this.getName() == null) {
                throw new RequiredAttributesException(this.getTagPublicName(), "name");
            }
            FolderTagHelper.findSubFolders(this);
        } else if (this.action.equalsIgnoreCase("create")) {
            FolderTagHelper.saveFolder(this, this.getFolder(), true);
        } else if (this.action.equalsIgnoreCase("modify")) {
            FolderTagHelper.saveFolder(this, this.getFolder(), false);
        } else if (this.action.equalsIgnoreCase("delete")) {
            if (this.getUid() == null || this.getUid().trim().length() == 0) {
                ExchangeExceptions.throwInvalidAttributeValueException("uid");
            }
            FolderTagHelper.deleteFolder(this);
        } else if (this.action.equalsIgnoreCase(action_empty)) {
            if (this.getUid() == null || this.getUid().trim().length() == 0) {
                ExchangeExceptions.throwInvalidAttributeValueException("uid");
            }
            FolderTagHelper.emptyFolder(this);
        } else if (this.action.equalsIgnoreCase(action_copy)) {
            if (this.getSourceFolderId() == null || this.getSourceFolderId().trim().length() == 0) {
                ExchangeExceptions.throwInvalidAttributeValueException("sourcefolderid");
            }
            if (this.getDestinationFolderId() == null || this.getDestinationFolderId().trim().length() == 0) {
                ExchangeExceptions.throwInvalidAttributeValueException("destinationfolderid");
            }
            FolderTagHelper.copyFolder(this);
        } else if (this.action.equalsIgnoreCase(action_move)) {
            if (this.getSourceFolderId() == null || this.getSourceFolderId().trim().length() == 0) {
                ExchangeExceptions.throwInvalidAttributeValueException("sourcefolderid");
            }
            if (this.getDestinationFolderId() == null || this.getDestinationFolderId().trim().length() == 0) {
                ExchangeExceptions.throwInvalidAttributeValueException("destinationfolderid");
            }
            FolderTagHelper.moveFolder(this);
        }
        this.release();
        this.onTagEnd();
        return 6;
    }

    public Map getFolder() {
        return this.folder;
    }

    public void setFolder(Map folder) {
        this.validateStruct(folder, validFolderAttributes, "cfexchangefolder", "folder");
        this.folder = folder;
    }

    @Override
    public void release() {
        super.release();
        this.filterInfo = new FolderFilterInfo();
        this.folder = null;
    }

    public void setDeleteType(String deleteType) {
        if (deleteType == null || deleteType.trim().length() == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("deletetype");
        }
        this.deleteType = this.stringToDeleteType(deleteType);
    }

    private DeleteType stringToDeleteType(String deleteType) {
        if (deleteType.equalsIgnoreCase(DeleteType.HardDelete.toString())) {
            return DeleteType.HardDelete;
        }
        if (deleteType.equalsIgnoreCase(DeleteType.SoftDelete.toString())) {
            return DeleteType.SoftDelete;
        }
        if (deleteType.equalsIgnoreCase(DeleteType.MoveToDeletedItems.toString())) {
            return DeleteType.MoveToDeletedItems;
        }
        ExchangeExceptions.throwInvalidAttributeValueException("deletetype");
        return null;
    }

    public DeleteType getDeleteType() {
        return this.deleteType;
    }

    public String getPathDelimitter() {
        return this.pathDelimitter;
    }

    public void setPathDelimitter(String pathDelimitter) {
        if (pathDelimitter == null || pathDelimitter.trim().length() == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("pathDelimitter");
        }
        this.pathDelimitter = pathDelimitter;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public void setFolderPath(String folderPath) {
        if (folderPath == null || folderPath.trim().length() == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("folderPath");
        }
        this.folderPath = folderPath;
    }

    public void setParentFolderId(String parentFolderId) {
        if (parentFolderId == null || parentFolderId.trim().length() == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("parentFolderId");
        }
        this.parentFolderId = parentFolderId;
    }

    public String getParentFolderId() {
        return this.parentFolderId;
    }

    public void setDeleteSubFolders(String deleteSubFolders) {
        if (deleteSubFolders == null || deleteSubFolders.trim().length() == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("deletesubfolders");
        }
        this.deleteSubFolders = ExchangeTag.castBoolean(deleteSubFolders, "deletesubfolders");
    }

    public boolean getDeleteSubFolders() {
        return this.deleteSubFolders;
    }

    public void setSourceFolderId(String sourceFolderId) {
        if (sourceFolderId == null || sourceFolderId.trim().length() == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("sourceFolderId");
        }
        this.sourceFolderId = sourceFolderId;
    }

    public String getSourceFolderId() {
        return this.sourceFolderId;
    }

    public void setDestinationFolderId(String destinationFolderId) {
        if (destinationFolderId == null || destinationFolderId.trim().length() == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("destinationFolderId");
        }
        this.destinationFolderId = destinationFolderId;
    }

    public String getDestinationFolderId() {
        return this.destinationFolderId;
    }

    static {
        validFolderAttributes.put("DisplayName".toUpperCase(), "DisplayName".toUpperCase());
        validFolderAttributes.put("FolderClass".toUpperCase(), "FolderClass".toUpperCase());
        validFolderAttributes.put("PathSeparator".toUpperCase(), "PathSeparator".toUpperCase());
        validFolderAttributes.put("DeleteType".toUpperCase(), "DeleteType".toUpperCase());
        validFolderAttributes.put("DeleteSubFolders".toUpperCase(), "DeleteSubFolders".toUpperCase());
        validFolderAttributes.put("Folder".toUpperCase(), "Folder".toUpperCase());
        validFilterAttributes.put("DisplayName".toUpperCase(), "DisplayName".toUpperCase());
        validFilterAttributes.put("FolderClass".toUpperCase(), "FolderClass".toUpperCase());
        validFilterAttributes.put("ChildFolderCount".toUpperCase(), "ChildFolderCount".toUpperCase());
        validFilterAttributes.put("TotalCount".toUpperCase(), "TotalCount".toUpperCase());
        validFilterAttributes.put("UnreadCount".toUpperCase(), "UnreadCount".toUpperCase());
        validFilterAttributes.put("MaxRows".toUpperCase(), "MaxRows".toUpperCase());
        validFilterAttributes.put("value".toUpperCase(), "value".toUpperCase());
        validFilterAttributes.put("from".toUpperCase(), "from".toUpperCase());
        validFilterAttributes.put("to".toUpperCase(), "to".toUpperCase());
    }
}

