/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.ExchangeConnection;
import coldfusion.exchange.webdav.WebDAVExceptions;
import coldfusion.tagext.net.exchange.ExchangeExceptions;
import coldfusion.tagext.net.exchange.ExchangeTag;
import coldfusion.tagext.net.exchange.FolderQuery;
import jakarta.servlet.jsp.JspException;
import java.util.ArrayList;

public class ExchangeConnectionTag
extends ExchangeTag {
    private String folder = null;
    private boolean recurse = false;

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folderName) {
        this.folder = folderName;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        this.onTagStart();
        return 6;
    }

    @Override
    public int doEndTag() throws JspException {
        super.doEndTag();
        String act = this.getAction();
        if (act.equalsIgnoreCase("open")) {
            this.createConnection();
        } else if (act.equalsIgnoreCase("close")) {
            this.closeConnection();
        } else if (act.equalsIgnoreCase("GetSubFolders")) {
            this.getSubFolders();
        } else {
            ExchangeExceptions.throwInvalidConnectionActionException("action");
        }
        this.release();
        this.onTagEnd();
        return 6;
    }

    @Override
    public void release() {
        super.release();
        this.folder = null;
        this.recurse = false;
    }

    void getSubFolders() {
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = this.getConnection(false);
        if (con == null) {
            con = this.createConnection();
            getTempConnection = true;
        }
        ArrayList folders = null;
        try {
            folders = con.getSubFolders(this.folder, this.recurse);
        }
        catch (WebDAVExceptions we) {
            int code = we.getWebDAVCode();
            if (code == 404) {
                ExchangeExceptions.throwMailFolderNotFoundException(this.folder);
            }
            this.processException(we);
        }
        catch (Throwable t) {
            this.processException(t);
        }
        FolderQuery queryResult = new FolderQuery();
        queryResult.populate(folders);
        this.pageContext.setAttribute(this.getName(), (Object)queryResult);
        if (getTempConnection) {
            con.closeConnection();
        }
    }
}

