/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webservice;

import java.util.ArrayList;
import java.util.Iterator;

public class XMLElement {
    private String elementStart = null;
    private String elementEnd = null;
    private String value = null;
    private String xmlStr = null;
    protected static final String newLine = "\n";
    private ArrayList childElements = new ArrayList();

    public XMLElement() {
    }

    public XMLElement(String xmlContent, XMLElement parent) {
        this.xmlStr = xmlContent;
        if (parent != null) {
            parent.addChildElement(this);
        }
    }

    public XMLElement(String startElement, String endElement, String value) {
        this.elementStart = startElement;
        this.elementEnd = endElement;
        this.value = value;
    }

    public XMLElement(String startElement, String endElement, String value, XMLElement parent) {
        this.elementStart = startElement;
        this.elementEnd = endElement;
        this.value = value;
        if (parent != null) {
            parent.addChildElement(this);
        }
    }

    public void setParent(XMLElement parentElm) {
        if (parentElm != null) {
            parentElm.addChildElement(this);
        }
    }

    public ArrayList getChildElements() {
        return this.childElements;
    }

    public void setChildElements(ArrayList childElements) {
        this.childElements = childElements;
    }

    public String getElementEnd() {
        return this.elementEnd;
    }

    public void setElementEnd(String elementEnd) {
        this.elementEnd = elementEnd;
    }

    public String getElementStart() {
        return this.elementStart;
    }

    public void setElementStart(String elementStart) {
        this.elementStart = elementStart;
    }

    public String toString() {
        if (this.xmlStr != null) {
            return this.xmlStr;
        }
        StringBuffer buf = new StringBuffer(this.elementStart);
        if (this.value != null) {
            buf.append(this.value);
        } else {
            buf.append(newLine);
        }
        Iterator it = this.childElements.iterator();
        while (it.hasNext()) {
            buf.append(((XMLElement)it.next()).toString());
            buf.append(newLine);
        }
        if (this.elementEnd != null) {
            buf.append(this.elementEnd);
            if (this.value == null) {
                buf.append(newLine);
            }
        }
        return buf.toString();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void addChildElement(XMLElement element) {
        this.childElements.add(element);
    }

    public XMLElement getChildElement(int index) {
        if (this.childElements == null || this.childElements.size() <= index) {
            return null;
        }
        return (XMLElement)this.childElements.get(index);
    }

    public int getChildrenCount() {
        return this.childElements.size();
    }

    public String getXML() {
        return this.xmlStr;
    }

    public void setXML(String xmlStr) {
        this.xmlStr = xmlStr;
    }
}

