/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.microsoft.graph;

import coldfusion.exchange.ContactAddress;
import coldfusion.exchange.ContactFilterInfo;
import coldfusion.exchange.ContactOtherDetails;
import coldfusion.exchange.ExchangeAttachment;
import coldfusion.exchange.ExchangeContact;
import coldfusion.exchange.microsoft.graph.AbstractServiceManager;
import coldfusion.exchange.microsoft.graph.GraphException;
import coldfusion.exchange.microsoft.graph.QueryType;
import coldfusion.log.CFLogs;
import coldfusion.util.RB;
import com.microsoft.graph.core.content.BatchRequestContent;
import com.microsoft.graph.core.requests.IBaseClient;
import com.microsoft.graph.models.Contact;
import com.microsoft.graph.models.ContactCollectionResponse;
import com.microsoft.graph.models.EmailAddress;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.ProfilePhoto;
import com.microsoft.graph.models.SingleValueLegacyExtendedProperty;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ContactManager
extends AbstractServiceManager {
    private static volatile ContactManager instance = null;
    private final String MAILING_ADDRESS_TYPE_EXTENDED_PROPERTY_ID = "String {8731c65e-199f-4e24-8789-fd757486ca3e} Name MailingAddressType";
    private final String BUSINESS_FAX_EXTENDED_PROPERTY_ID = "String {b4c70a6f-26b7-4a25-9be3-a89f66e352be} Name BusinessFax";
    private final String PAGER_EXTENDED_PROPERTY_ID = "String {30d61118-fd96-44c1-aba4-37d019c59c87} Name Pager";
    private final String OTHER_TELEPHONE_EXTENDED_PROPERTY_ID = "String {d0c64f3b-5215-4327-9e18-ac13dcfb3b49} Name OtherTelephone";
    private final String QUERY_EXPANDER = "($filter=id eq 'String {8731c65e-199f-4e24-8789-fd757486ca3e} Name MailingAddressType' or id eq 'String {b4c70a6f-26b7-4a25-9be3-a89f66e352be} Name BusinessFax' or id eq 'String {30d61118-fd96-44c1-aba4-37d019c59c87} Name Pager' or id eq 'String {d0c64f3b-5215-4327-9e18-ac13dcfb3b49} Name OtherTelephone')";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ContactManager getInstance(GraphServiceClient graphServiceClient) {
        if (instance == null) {
            Class<ContactManager> clazz = ContactManager.class;
            // MONITORENTER : coldfusion.exchange.microsoft.graph.ContactManager.class
            if (instance == null) {
                instance = new ContactManager(graphServiceClient);
            }
            // MONITOREXIT : clazz
        }
        ContactManager.instance.graphServiceClient = graphServiceClient;
        return instance;
    }

    private ContactManager(GraphServiceClient graphServiceClient) {
        super(graphServiceClient);
    }

    public void create(ExchangeContact exchangeContact, String[] attachedFileNames, Object[] attachedFileContents) throws IOException {
        Contact contact = this.createContact(exchangeContact);
        Contact postedContact = this.graphServiceClient.me().contacts().post(contact);
        if (attachedFileNames != null && attachedFileContents != null) {
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getPhotoData(attachedFileNames, attachedFileContents));){
                this.graphServiceClient.me().contacts().byContactId(postedContact.getId()).photo().content().put((InputStream)byteArrayInputStream);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                CFLogs.APPLICATION_LOG.error((Object)RB.getString((Object)this, (String)"ContactManager.noPhotoProvided"), (Throwable)ex);
            }
        }
        exchangeContact.setId(postedContact.getId());
    }

    public ArrayList<ExchangeContact> get(ContactFilterInfo filter) throws ReflectiveOperationException {
        ArrayList<ExchangeContact> exchangeContacts = new ArrayList<ExchangeContact>();
        String id = filter.getId();
        if (!this.isNullOrEmpty(id)) {
            this.splitCommaSeperatedString(id).forEach(uid -> {
                Contact contact = this.graphServiceClient.me().contacts().byContactId(uid).get(requestConfig -> {
                    requestConfig.queryParameters.expand = new String[]{"singleValueExtendedProperties($filter=id eq 'String {8731c65e-199f-4e24-8789-fd757486ca3e} Name MailingAddressType' or id eq 'String {b4c70a6f-26b7-4a25-9be3-a89f66e352be} Name BusinessFax' or id eq 'String {30d61118-fd96-44c1-aba4-37d019c59c87} Name Pager' or id eq 'String {d0c64f3b-5215-4327-9e18-ac13dcfb3b49} Name OtherTelephone')"};
                });
                exchangeContacts.add(this.createContact(contact));
            });
        } else {
            String filterParameter = this.getFilter(filter);
            int maxRows = filter.getMaxRows();
            ArrayList contactList = new ArrayList();
            if (maxRows == -1) {
                contacts = this.graphServiceClient.me().contacts().get(requestConfiguration -> {
                    requestConfiguration.queryParameters.filter = filterParameter;
                    requestConfiguration.queryParameters.expand = new String[]{"singleValueExtendedProperties($filter=id eq 'String {8731c65e-199f-4e24-8789-fd757486ca3e} Name MailingAddressType' or id eq 'String {b4c70a6f-26b7-4a25-9be3-a89f66e352be} Name BusinessFax' or id eq 'String {30d61118-fd96-44c1-aba4-37d019c59c87} Name Pager' or id eq 'String {d0c64f3b-5215-4327-9e18-ac13dcfb3b49} Name OtherTelephone')"};
                });
                ContactManager.iterateCollection(contactList, this.graphServiceClient, requestInfo -> {
                    requestInfo.addQueryParameter("%24filter", (Object)filterParameter);
                    requestInfo.addQueryParameter("%24expand", (Object)new String[]{"singleValueExtendedProperties($filter=id eq 'String {8731c65e-199f-4e24-8789-fd757486ca3e} Name MailingAddressType' or id eq 'String {b4c70a6f-26b7-4a25-9be3-a89f66e352be} Name BusinessFax' or id eq 'String {30d61118-fd96-44c1-aba4-37d019c59c87} Name Pager' or id eq 'String {d0c64f3b-5215-4327-9e18-ac13dcfb3b49} Name OtherTelephone')"});
                    return requestInfo;
                }, contacts, ContactCollectionResponse::createFromDiscriminatorValue);
            } else {
                contacts = this.graphServiceClient.me().contacts().get(requestConfiguration -> {
                    requestConfiguration.queryParameters.filter = filterParameter;
                    requestConfiguration.queryParameters.expand = new String[]{"singleValueExtendedProperties($filter=id eq 'String {8731c65e-199f-4e24-8789-fd757486ca3e} Name MailingAddressType' or id eq 'String {b4c70a6f-26b7-4a25-9be3-a89f66e352be} Name BusinessFax' or id eq 'String {30d61118-fd96-44c1-aba4-37d019c59c87} Name Pager' or id eq 'String {d0c64f3b-5215-4327-9e18-ac13dcfb3b49} Name OtherTelephone')"};
                    requestConfiguration.queryParameters.top = maxRows;
                });
                contactList.addAll(contacts.getValue());
            }
            for (Contact contact : contactList) {
                exchangeContacts.add(this.createContact(contact));
            }
        }
        return exchangeContacts;
    }

    public void modify(String uid, ExchangeContact exchangeContact, String[] attachedFileNames, Object[] attachedFileContents) throws IOException {
        Contact contact = this.createContact(exchangeContact);
        this.graphServiceClient.me().contacts().byContactId(uid).patch(contact);
        if (attachedFileNames != null && attachedFileContents != null) {
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getPhotoData(attachedFileNames, attachedFileContents));){
                this.graphServiceClient.me().contacts().byContactId(uid).photo().content().put((InputStream)byteArrayInputStream);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                CFLogs.APPLICATION_LOG.error((Object)RB.getString((Object)this, (String)"ContactManager.noPhotoProvided"), (Throwable)ex);
            }
        }
    }

    public void delete(String[] uids) throws IOException {
        BatchRequestContent batchRequestContent = new BatchRequestContent((IBaseClient)this.graphServiceClient);
        for (String uid : uids) {
            batchRequestContent.addBatchRequestStep(this.graphServiceClient.me().contacts().byContactId(uid).toDeleteRequestInformation());
        }
        this.graphServiceClient.getBatchRequestBuilder().post(batchRequestContent, null);
    }

    public ArrayList<ExchangeAttachment> getAttachments(String uid) throws IOException {
        ArrayList<ExchangeAttachment> attachmentList = new ArrayList<ExchangeAttachment>();
        ExchangeAttachment exchangeAttachment = new ExchangeAttachment();
        byte[] content = this.graphServiceClient.me().contacts().byContactId(uid).photo().content().get().readAllBytes();
        ProfilePhoto profilePhoto = this.graphServiceClient.me().contacts().byContactId(uid).photo().get();
        exchangeAttachment.setCID(profilePhoto.getId());
        this.setIfPresent(profilePhoto.getAdditionalData(), map -> (String)map.get("@odata.mediaContentType"), exchangeAttachment::setMimeType);
        this.setIfPresent(exchangeAttachment.getMimeType(), this::getFileType, fileType -> {
            exchangeAttachment.setFileExt((String)fileType);
            exchangeAttachment.setFileName("contact_profile_picture." + fileType);
        });
        if (content != null) {
            exchangeAttachment.setFileContent(new ByteArrayInputStream(content));
            exchangeAttachment.setFileSize(content.length);
        }
        attachmentList.add(exchangeAttachment);
        return attachmentList;
    }

    public void deleteAttachments(String uid) {
        this.graphServiceClient.me().contacts().byContactId(uid).photo().content().delete();
    }

    private byte[] getPhotoData(String[] attachedFileNames, Object[] attachedFileContents) {
        if (attachedFileNames.length != attachedFileContents.length) {
            throw new GraphException(RB.getString((Object)this, (String)"GraphConnection.attachmentCountMismatch", (Object[])new Object[]{attachedFileNames.length, attachedFileContents.length}));
        }
        if (attachedFileNames.length > 1) {
            throw new GraphException(RB.getString((Object)this, (String)"ContactManager.multipleProfilePhotos"));
        }
        if (!(attachedFileContents[0] instanceof byte[])) {
            throw new GraphException(RB.getString((Object)this, (String)"GraphConnection.attachmentInvalidType", (Object[])new Object[]{attachedFileNames[0], attachedFileContents[0]}));
        }
        return (byte[])attachedFileContents[0];
    }

    private String getEmailAtIndex(List<EmailAddress> emailAddresses, int index) {
        return emailAddresses != null && emailAddresses.size() > index ? emailAddresses.get(index).getAddress() : null;
    }

    private String getPhoneAtIndex(List<String> phoneList) {
        return phoneList != null && phoneList.size() > 0 ? phoneList.get(0) : null;
    }

    private ExchangeContact createContact(Contact contact) {
        String categories;
        ExchangeContact exchangeContact = new ExchangeContact();
        exchangeContact.setLastName(contact.getSurname());
        exchangeContact.setDislpayName(contact.getDisplayName());
        exchangeContact.setDislpayName(contact.getFileAs());
        exchangeContact.setLocation(contact.getOfficeLocation());
        exchangeContact.setFirstName(contact.getGivenName());
        exchangeContact.setMiddleName(contact.getMiddleName());
        exchangeContact.setJobTitle(contact.getJobTitle());
        exchangeContact.setId(contact.getId());
        exchangeContact.setCompany(contact.getCompanyName());
        exchangeContact.setBusinessHomePage(contact.getBusinessHomePage());
        OffsetDateTime timestamp = contact.getLastModifiedDateTime();
        if (timestamp != null) {
            exchangeContact.setLastModified(Date.from(timestamp.atZoneSameInstant(ZoneId.systemDefault()).toInstant()));
        }
        this.setIfPresent(contact.getEmailAddresses(), emailList -> this.getEmailAtIndex((List<EmailAddress>)emailList, 0), exchangeContact::setEMail1);
        this.setIfPresent(contact.getEmailAddresses(), emailList -> this.getEmailAtIndex((List<EmailAddress>)emailList, 1), exchangeContact::setEMail2);
        this.setIfPresent(contact.getEmailAddresses(), emailList -> this.getEmailAtIndex((List<EmailAddress>)emailList, 2), exchangeContact::setEMail3);
        this.setIfPresent(contact.getBusinessPhones(), this::getPhoneAtIndex, exchangeContact::setBusinessPhone);
        this.setIfPresent(contact.getHomePhones(), this::getPhoneAtIndex, exchangeContact::setHomePhone);
        List categoriesList = contact.getCategories();
        StringBuilder categoriesBuilder = new StringBuilder();
        if (categoriesList != null) {
            for (String category : categoriesList) {
                if (category == null) continue;
                categoriesBuilder.append(category).append(",");
            }
        }
        if ((categories = categoriesBuilder.toString()).length() > 0) {
            exchangeContact.setCategories(categories.substring(0, categories.length() - 1));
        }
        if (contact.getBusinessAddress() != null) {
            exchangeContact.setBusinessAddress(this.getPhysicalAddress(contact.getBusinessAddress()));
        }
        if (contact.getHomeAddress() != null) {
            exchangeContact.setHomeAddress(this.getPhysicalAddress(contact.getHomeAddress()));
        }
        if (contact.getOtherAddress() != null) {
            exchangeContact.setOtherAddress(this.getPhysicalAddress(contact.getOtherAddress()));
        }
        this.setIfPresent(contact.getPhoto(), Entity::getId, value -> exchangeContact.setHasAttachment(true));
        exchangeContact.setDescription(contact.getPersonalNotes());
        exchangeContact.setMessage(contact.getPersonalNotes());
        this.setIfPresent(contact.getSingleValueExtendedProperties(), properties -> {
            for (SingleValueLegacyExtendedProperty property : properties) {
                switch (property.getId()) {
                    case "String {8731c65e-199f-4e24-8789-fd757486ca3e} Name MailingAddressType": {
                        exchangeContact.setMailingAdressType(Integer.parseInt(property.getValue()));
                        break;
                    }
                    case "String {b4c70a6f-26b7-4a25-9be3-a89f66e352be} Name BusinessFax": {
                        exchangeContact.setBusinessFax(property.getValue());
                        break;
                    }
                    case "String {30d61118-fd96-44c1-aba4-37d019c59c87} Name Pager": {
                        exchangeContact.setPager(property.getValue());
                        break;
                    }
                    case "String {d0c64f3b-5215-4327-9e18-ac13dcfb3b49} Name OtherTelephone": {
                        exchangeContact.setOtherPhone(property.getValue());
                        break;
                    }
                }
            }
        });
        ContactOtherDetails contactOtherDetails = new ContactOtherDetails();
        contactOtherDetails.setAssistant(contact.getAssistantName());
        contactOtherDetails.setManager(contact.getManager());
        contactOtherDetails.setDepartment(contact.getDepartment());
        contactOtherDetails.setProfession(contact.getProfession());
        contactOtherDetails.setNickname(contact.getNickName());
        contactOtherDetails.setOffice(contact.getOfficeLocation());
        contactOtherDetails.setPartner(contact.getSpouseName());
        exchangeContact.setDetails(contactOtherDetails);
        return exchangeContact;
    }

    public Contact createContact(ExchangeContact exchangeContact) {
        Contact contact = new Contact();
        this.setIfPresent(exchangeContact.getFirstName(), arg_0 -> ((Contact)contact).setGivenName(arg_0));
        this.setIfPresent(exchangeContact.getMiddleName(), arg_0 -> ((Contact)contact).setMiddleName(arg_0));
        this.setIfPresent(exchangeContact.getLastName(), arg_0 -> ((Contact)contact).setSurname(arg_0));
        this.setIfPresent(exchangeContact.getDislpayName(), arg_0 -> ((Contact)contact).setDisplayName(arg_0));
        this.setIfPresent(exchangeContact.getDislpayName(), arg_0 -> ((Contact)contact).setFileAs(arg_0));
        this.setIfPresent(exchangeContact.getJobTitle(), arg_0 -> ((Contact)contact).setJobTitle(arg_0));
        this.setIfPresent(exchangeContact.getCompany(), arg_0 -> ((Contact)contact).setCompanyName(arg_0));
        this.setIfPresent(exchangeContact.getBusinessHomePage(), arg_0 -> ((Contact)contact).setBusinessHomePage(arg_0));
        ArrayList<EmailAddress> emailAddresses = new ArrayList<EmailAddress>();
        this.addEmailAddress(emailAddresses, exchangeContact.getDislpayName(), exchangeContact.getEMail1());
        this.addEmailAddress(emailAddresses, exchangeContact.getDislpayName(), exchangeContact.getEMail2());
        this.addEmailAddress(emailAddresses, exchangeContact.getDislpayName(), exchangeContact.getEMail3());
        if (emailAddresses.size() > 0) {
            contact.setEmailAddresses(emailAddresses);
        }
        this.setIfPresent(exchangeContact.getBusinessAddress(), businessAddress -> contact.setBusinessAddress(this.getPhysicalAddress((ContactAddress)businessAddress)));
        this.setIfPresent(exchangeContact.getHomeAddress(), homeAddress -> contact.setHomeAddress(this.getPhysicalAddress((ContactAddress)homeAddress)));
        this.setIfPresent(exchangeContact.getOtherAddress(), otherAddress -> contact.setOtherAddress(this.getPhysicalAddress((ContactAddress)otherAddress)));
        this.setIfPresent(exchangeContact.getMobilePhone(), arg_0 -> ((Contact)contact).setMobilePhone(arg_0));
        this.setIfPresent(exchangeContact.getBusinessPhone(), businessPhone -> contact.setBusinessPhones(new ArrayList<String>(Set.of(businessPhone))));
        this.setIfPresent(exchangeContact.getHomePhone(), homePhone -> contact.setHomePhones(new ArrayList<String>(Set.of(homePhone))));
        this.setIfPresent(exchangeContact.getMessage(), arg_0 -> ((Contact)contact).setPersonalNotes(arg_0));
        this.setIfPresent(exchangeContact.getDescription(), arg_0 -> ((Contact)contact).setPersonalNotes(arg_0));
        if (Objects.nonNull(exchangeContact.getDetails())) {
            ContactOtherDetails contactOtherDetails = exchangeContact.getDetails();
            this.setIfPresent(contactOtherDetails.getManager(), arg_0 -> ((Contact)contact).setManager(arg_0));
            this.setIfPresent(contactOtherDetails.getAssistant(), arg_0 -> ((Contact)contact).setAssistantName(arg_0));
            this.setIfPresent(contactOtherDetails.getDepartment(), arg_0 -> ((Contact)contact).setDepartment(arg_0));
            this.setIfPresent(contactOtherDetails.getNickname(), arg_0 -> ((Contact)contact).setNickName(arg_0));
            this.setIfPresent(contactOtherDetails.getOffice(), arg_0 -> ((Contact)contact).setOfficeLocation(arg_0));
            this.setIfPresent(contactOtherDetails.getPartner(), arg_0 -> ((Contact)contact).setSpouseName(arg_0));
            this.setIfPresent(contactOtherDetails.getProfession(), arg_0 -> ((Contact)contact).setProfession(arg_0));
        }
        this.setIfPresent(exchangeContact.getCategories(), categories -> contact.setCategories(this.splitCommaSeperatedString(exchangeContact.getCategories())));
        LinkedList extendedPropertiesList = new LinkedList();
        this.setIfPresent(exchangeContact.getMailingAdressType(), mailingAddressType -> this.createSingleValueExtendedProperty("String {8731c65e-199f-4e24-8789-fd757486ca3e} Name MailingAddressType", mailingAddressType.toString()), extendedPropertiesList::add);
        this.setIfPresent(exchangeContact.getBusinessFax(), businessFax -> this.createSingleValueExtendedProperty("String {b4c70a6f-26b7-4a25-9be3-a89f66e352be} Name BusinessFax", (String)businessFax), extendedPropertiesList::add);
        this.setIfPresent(exchangeContact.getPager(), pager -> this.createSingleValueExtendedProperty("String {30d61118-fd96-44c1-aba4-37d019c59c87} Name Pager", (String)pager), extendedPropertiesList::add);
        this.setIfPresent(exchangeContact.getOtherPhone(), otherPhone -> this.createSingleValueExtendedProperty("String {d0c64f3b-5215-4327-9e18-ac13dcfb3b49} Name OtherTelephone", (String)otherPhone), extendedPropertiesList::add);
        if (extendedPropertiesList.size() > 0) {
            contact.setSingleValueExtendedProperties(extendedPropertiesList);
        }
        return contact;
    }

    private String getFilter(ContactFilterInfo filter) {
        StringBuilder filterBuilder = new StringBuilder();
        this.setIfPresent(filter.getFirstName(), value -> QueryType.CONTAINS.getQuery("givenName", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getMiddleName(), value -> QueryType.CONTAINS.getQuery("middleName", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getLastName(), value -> QueryType.CONTAINS.getQuery("surname", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getDislpayName(), value -> QueryType.CONTAINS.getQuery("fileAs", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getJobTitle(), value -> QueryType.CONTAINS.getQuery("jobTitle", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getCompany(), value -> QueryType.CONTAINS.getQuery("companyName", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getBusinessHomePage(), value -> QueryType.CONTAINS.getQuery("businessHomePage", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getDescription(), value -> QueryType.CONTAINS.getQuery("personalNotes", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getBusinessFax(), businessFax -> QueryType.ANY.getQuery("singleValueExtendedProperties", QueryType.COLON.getQuery("i", QueryType.AND.getQuery(QueryType.EQ.getQuery(new String[]{"i", "id"}, "String {b4c70a6f-26b7-4a25-9be3-a89f66e352be} Name BusinessFax", true), QueryType.CONTAINS.getQuery(new String[]{"i", "value"}, (String)businessFax, true)))), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getMailingAdressType(), mailingAddressType -> QueryType.ANY.getQuery("singleValueExtendedProperties", QueryType.COLON.getQuery("i", QueryType.AND.getQuery(QueryType.EQ.getQuery(new String[]{"i", "id"}, "String {8731c65e-199f-4e24-8789-fd757486ca3e} Name MailingAddressType", true), QueryType.CONTAINS.getQuery(new String[]{"i", "value"}, mailingAddressType.toString(), true)))), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getEMail1(), email1 -> QueryType.ANY.getQuery("emailAddresses", QueryType.COLON.getQuery("i", QueryType.EQ.getQuery(new String[]{"i", "address"}, (String)email1, true))), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getEMail2(), email2 -> QueryType.ANY.getQuery("emailAddresses", QueryType.COLON.getQuery("i", QueryType.EQ.getQuery(new String[]{"i", "address"}, (String)email2, true))), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getEMail3(), email3 -> QueryType.ANY.getQuery("emailAddresses", QueryType.COLON.getQuery("i", QueryType.EQ.getQuery(new String[]{"i", "address"}, (String)email3, true))), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getBusinessAddress(), businessAddress -> this.getPhysicalAddressFilter((ContactAddress)businessAddress, "businessAddress"), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getHomeAddress(), homeAddress -> this.getPhysicalAddressFilter((ContactAddress)homeAddress, "homeAddress"), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getOtherAddress(), otherAddress -> this.getPhysicalAddressFilter((ContactAddress)otherAddress, "otherAddress"), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getHomePhone(), homePhone -> QueryType.ANY.getQuery("homePhones", QueryType.COLON.getQuery("i", QueryType.CONTAINS.getQuery("i", (String)homePhone, true))), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getBusinessPhone(), businessPhone -> QueryType.ANY.getQuery("businessPhones", QueryType.COLON.getQuery("i", QueryType.CONTAINS.getQuery("i", (String)businessPhone, true))), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getMobilePhone(), value -> QueryType.CONTAINS.getQuery("mobilePhone", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getOtherPhone(), otherPhone -> QueryType.ANY.getQuery("singleValueExtendedProperties", QueryType.COLON.getQuery("i", QueryType.AND.getQuery(QueryType.EQ.getQuery(new String[]{"i", "id"}, "String {d0c64f3b-5215-4327-9e18-ac13dcfb3b49} Name OtherTelephone", true), QueryType.CONTAINS.getQuery(new String[]{"i", "value"}, (String)otherPhone, true)))), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getPager(), pager -> QueryType.ANY.getQuery("singleValueExtendedProperties", QueryType.COLON.getQuery("i", QueryType.AND.getQuery(QueryType.EQ.getQuery(new String[]{"i", "id"}, "String {30d61118-fd96-44c1-aba4-37d019c59c87} Name Pager", true), QueryType.CONTAINS.getQuery(new String[]{"i", "value"}, (String)pager, true)))), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        ContactOtherDetails details = filter.getDetails();
        if (details != null) {
            this.setIfPresent(details.getAssistant(), value -> QueryType.CONTAINS.getQuery("assistantName", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
            this.setIfPresent(details.getManager(), value -> QueryType.CONTAINS.getQuery("manager", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
            this.setIfPresent(details.getDepartment(), value -> QueryType.CONTAINS.getQuery("department", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
            this.setIfPresent(details.getOffice(), value -> QueryType.CONTAINS.getQuery("officeLocation", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
            this.setIfPresent(details.getPartner(), value -> QueryType.CONTAINS.getQuery("spouseName", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
            this.setIfPresent(details.getProfession(), value -> QueryType.CONTAINS.getQuery("profession", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
            this.setIfPresent(details.getNickname(), value -> QueryType.CONTAINS.getQuery("nickName", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        }
        this.setIfPresent(filter.getFromLastModifiedDate(), lastModifiedDate -> QueryType.GE.getQuery("lastModifiedDateTime", this.getDateStringISOWithOffset((Date)lastModifiedDate)), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getToLastModifiedDate(), lastModifiedDate -> QueryType.LE.getQuery("lastModifiedDateTime", this.getDateStringISOWithOffset((Date)lastModifiedDate)), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getCategories(), value -> {
            List<String> categoriesList = this.splitCommaSeperatedString((String)value);
            StringBuilder queryBuilder = new StringBuilder();
            categoriesList.forEach(category -> queryBuilder.append(this.getAnyFilter((String)category, QueryType.EQ, new String[]{"i"}, "categories")).append(QueryType.AND.getSpaced()));
            return queryBuilder.toString();
        }, filterBuilder::append);
        return filterBuilder.length() > 0 ? this.trimAnd(filterBuilder.toString()) : filterBuilder.toString();
    }

    private String getPhysicalAddressFilter(ContactAddress contactAddress, String type) {
        StringBuilder addressBuilder = new StringBuilder();
        this.setIfPresent(contactAddress.getStreet(), value -> QueryType.CONTAINS.getQuery(new String[]{type, "street"}, (String)value, true), value -> addressBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(contactAddress.getCity(), value -> QueryType.CONTAINS.getQuery(new String[]{type, "city"}, (String)value, true), value -> addressBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(contactAddress.getState(), value -> QueryType.CONTAINS.getQuery(new String[]{type, "state"}, (String)value, true), value -> addressBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(contactAddress.getCountry(), value -> QueryType.CONTAINS.getQuery(new String[]{type, "countryOrRegion"}, (String)value, true), value -> addressBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(contactAddress.getPostalCode(), value -> QueryType.CONTAINS.getQuery(new String[]{type, "postalCode"}, (String)value, true), value -> addressBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        return addressBuilder.length() > 0 ? this.trimAnd(addressBuilder.toString()) : null;
    }

    private void addEmailAddress(List<EmailAddress> emailAddressList, String displayName, String address) {
        if (Objects.isNull(address)) {
            return;
        }
        EmailAddress emailAddress = new EmailAddress();
        emailAddress.setName(displayName);
        emailAddress.setAddress(address);
        emailAddressList.add(emailAddress);
    }

    private String getFileType(String mimeType) {
        String extension = "jpeg";
        int slashIndex = mimeType.indexOf(47);
        if (slashIndex != -1) {
            extension = mimeType.substring(slashIndex + 1);
        }
        return extension;
    }
}

