/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.microsoft.graph;

import coldfusion.exchange.AppointmentFilterInfo;
import coldfusion.exchange.ExchangeAppointment;
import coldfusion.exchange.ExchangeAttachment;
import coldfusion.exchange.ExchangeMailMeeting;
import coldfusion.exchange.RecurrenceInfo;
import coldfusion.exchange.microsoft.graph.AbstractServiceManager;
import coldfusion.exchange.microsoft.graph.GraphException;
import coldfusion.exchange.microsoft.graph.QueryType;
import coldfusion.exchange.webdav.Utils;
import coldfusion.exchange.webservice.AvailabilityData;
import coldfusion.exchange.webservice.CFTimeZone;
import coldfusion.exchange.webservice.CFUserAvailability;
import coldfusion.exchange.webservice.CalendarEvent;
import coldfusion.exchange.webservice.CalendarEventDetails;
import coldfusion.exchange.webservice.Conflict;
import coldfusion.exchange.webservice.EmailAddress;
import coldfusion.exchange.webservice.Suggestion;
import coldfusion.exchange.webservice.TimeSuggestion;
import coldfusion.runtime.Cast;
import coldfusion.util.RB;
import com.microsoft.graph.core.content.BatchRequestContent;
import com.microsoft.graph.core.content.BatchResponseContent;
import com.microsoft.graph.core.requests.IBaseClient;
import com.microsoft.graph.models.ActivityDomain;
import com.microsoft.graph.models.Attachment;
import com.microsoft.graph.models.AttachmentCollectionResponse;
import com.microsoft.graph.models.Attendee;
import com.microsoft.graph.models.AttendeeAvailability;
import com.microsoft.graph.models.AttendeeBase;
import com.microsoft.graph.models.AttendeeType;
import com.microsoft.graph.models.BodyType;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.DayOfWeek;
import com.microsoft.graph.models.Event;
import com.microsoft.graph.models.EventCollectionResponse;
import com.microsoft.graph.models.EventType;
import com.microsoft.graph.models.FileAttachment;
import com.microsoft.graph.models.FreeBusyStatus;
import com.microsoft.graph.models.Importance;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.Location;
import com.microsoft.graph.models.MeetingTimeSuggestion;
import com.microsoft.graph.models.MeetingTimeSuggestionsResult;
import com.microsoft.graph.models.PatternedRecurrence;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.models.RecurrencePattern;
import com.microsoft.graph.models.RecurrencePatternType;
import com.microsoft.graph.models.RecurrenceRange;
import com.microsoft.graph.models.RecurrenceRangeType;
import com.microsoft.graph.models.ScheduleInformation;
import com.microsoft.graph.models.Sensitivity;
import com.microsoft.graph.models.TimeConstraint;
import com.microsoft.graph.models.TimeSlot;
import com.microsoft.graph.models.WeekIndex;
import com.microsoft.graph.models.WorkingHours;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import com.microsoft.graph.users.item.calendar.getschedule.GetSchedulePostRequestBody;
import com.microsoft.graph.users.item.calendar.getschedule.GetSchedulePostResponse;
import com.microsoft.graph.users.item.events.item.EventItemRequestBuilder;
import com.microsoft.graph.users.item.events.item.accept.AcceptPostRequestBody;
import com.microsoft.graph.users.item.events.item.decline.DeclinePostRequestBody;
import com.microsoft.graph.users.item.events.item.tentativelyaccept.TentativelyAcceptPostRequestBody;
import com.microsoft.graph.users.item.findmeetingtimes.FindMeetingTimesPostRequestBody;
import com.microsoft.kiota.PeriodAndDuration;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class CalendarManager
extends AbstractServiceManager {
    private static volatile CalendarManager instance;
    private static final String SUGGESTION_TYPE = "work";
    private static final String SUGGESTION_DURATION = "PT1H";
    private static final Integer SCHEDULE_INTERVAL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static CalendarManager getInstance(GraphServiceClient graphServiceClient) {
        if (instance == null) {
            Class<CalendarManager> clazz = CalendarManager.class;
            // MONITORENTER : coldfusion.exchange.microsoft.graph.CalendarManager.class
            if (instance == null) {
                instance = new CalendarManager(graphServiceClient);
            }
            // MONITOREXIT : clazz
        }
        CalendarManager.instance.graphServiceClient = graphServiceClient;
        return instance;
    }

    private CalendarManager(GraphServiceClient graphServiceClient) {
        super(graphServiceClient);
    }

    public void create(ExchangeAppointment appointment, String[] attachedFileNames, Object[] attachedFileContents) throws IOException {
        Event postedEvent;
        Event calendarEvent = this.createCalendarEvent(appointment);
        Event event = postedEvent = Objects.nonNull(appointment.getCalendarFolderId()) ? this.graphServiceClient.me().calendars().byCalendarId(appointment.getCalendarFolderId()).events().post(calendarEvent) : this.graphServiceClient.me().calendar().events().post(calendarEvent);
        if (attachedFileNames != null && attachedFileContents != null) {
            List<Attachment> attachments = this.getGraphAttachments(attachedFileNames, attachedFileContents);
            for (Attachment attachment : attachments) {
                this.graphServiceClient.me().events().byEventId(postedEvent.getId()).attachments().post(attachment);
            }
        }
        appointment.setId(postedEvent.getId());
    }

    public void delete(String[] uids, boolean notify, String message) throws IOException {
        BatchRequestContent batchRequestContent = new BatchRequestContent((IBaseClient)this.graphServiceClient);
        for (String uid : uids) {
            batchRequestContent.addBatchRequestStep(this.graphServiceClient.me().events().byEventId(uid).toDeleteRequestInformation());
        }
        this.graphServiceClient.getBatchRequestBuilder().post(batchRequestContent, null);
    }

    public ArrayList<ExchangeAppointment> get(AppointmentFilterInfo filter) throws ReflectiveOperationException {
        ArrayList<ExchangeAppointment> appointments = new ArrayList<ExchangeAppointment>();
        String id = filter.getUids();
        if (!this.isNullOrEmpty(id)) {
            this.splitCommaSeperatedString(id).forEach(uid -> {
                Event event = this.graphServiceClient.me().calendar().events().byEventId(uid).get();
                appointments.add(this.createCFEvent(event));
            });
        } else {
            String filterParameter = this.getFilter(filter);
            int maxRows = filter.getMaxRows();
            ArrayList eventList = new ArrayList();
            if (maxRows == -1) {
                events = this.getCollectionByCalendarId(filter.getCalendarFolderId(), filterParameter, null, false);
                CalendarManager.iterateCollection(eventList, this.graphServiceClient, requestInfo -> {
                    requestInfo.addQueryParameter("%24filter", (Object)filterParameter);
                    return requestInfo;
                }, events, EventCollectionResponse::createFromDiscriminatorValue);
            } else {
                events = this.getCollectionByCalendarId(filter.getCalendarFolderId(), filterParameter, null, true, maxRows);
                eventList.addAll(events.getValue());
            }
            for (Event event : eventList) {
                appointments.add(this.createCFEvent(event));
            }
        }
        return appointments;
    }

    public ArrayList<ExchangeAppointment> getOccurrences(AppointmentFilterInfo filter) throws ReflectiveOperationException {
        ArrayList<ExchangeAppointment> appointments = new ArrayList<ExchangeAppointment>();
        String filterParameter = QueryType.AND.getQuery(QueryType.GE.getQuery(new String[]{"start", "dateTime"}, this.getDateStringISO(filter.getFromStartTime()), true), QueryType.LE.getQuery(new String[]{"end", "dateTime"}, this.getDateStringISO(filter.getToEndTime()), true));
        EventCollectionResponse events = this.getCollectionByCalendarId(filter.getCalendarFolderId(), filterParameter, new String[]{"instances"}, false);
        ArrayList eventList = new ArrayList();
        CalendarManager.iterateCollection(eventList, this.graphServiceClient, requestInfo -> {
            requestInfo.addQueryParameter("%24filter", (Object)filterParameter);
            requestInfo.addQueryParameter("%24expand", (Object)new String[]{"instances"});
            return requestInfo;
        }, events, EventCollectionResponse::createFromDiscriminatorValue);
        for (Event event : eventList) {
            appointments.add(this.createCFEvent(event));
        }
        return appointments;
    }

    public ArrayList<ExchangeAttachment> getAttachments(String uid, boolean getContent) throws IOException {
        AttachmentCollectionResponse attachmentCollectionResponse = this.graphServiceClient.me().events().byEventId(uid).attachments().get();
        BatchRequestContent batchRequestContent = new BatchRequestContent((IBaseClient)this.graphServiceClient);
        HashSet<String> requestIdSet = new HashSet<String>();
        for (Attachment attachment : attachmentCollectionResponse.getValue()) {
            requestIdSet.add(batchRequestContent.addBatchRequestStep(this.graphServiceClient.me().events().byEventId(uid).attachments().byAttachmentId(attachment.getId()).toGetRequestInformation()));
        }
        BatchResponseContent batchResponseContent = this.executeBatchOperation(batchRequestContent);
        ArrayList<ExchangeAttachment> attachments = new ArrayList<ExchangeAttachment>();
        for (String requestId : requestIdSet) {
            Attachment attachment = (Attachment)batchResponseContent.getResponseById(requestId, Attachment::createFromDiscriminatorValue);
            attachments.add(this.getExchangeAttachment(attachment.getId(), attachment.getSize(), attachment.getName(), attachment.getContentType(), ((FileAttachment)attachment).getContentBytes()));
        }
        return attachments;
    }

    public void deleteAttachments(String uid, String[] fileNames) throws IOException {
        AttachmentCollectionResponse attachmentCollectionResponse = this.graphServiceClient.me().events().byEventId(uid).attachments().get(requestConfig -> this.getFilterToDeleteAttachments(fileNames).ifPresent(filter -> {
            requestConfig.queryParameters.filter = filter;
        }));
        for (Attachment attachment : attachmentCollectionResponse.getValue()) {
            this.graphServiceClient.me().events().byEventId(uid).attachments().byAttachmentId(attachment.getId()).delete();
        }
    }

    public void modify(String uid, ExchangeAppointment apt, String[] attachedFileNames, Object[] attachedFileContents) throws IOException {
        Event event = this.createCalendarEvent(apt);
        this.graphServiceClient.me().events().byEventId(uid).patch(event);
        if (attachedFileNames != null && attachedFileContents != null) {
            List<Attachment> attachments = this.getGraphAttachments(attachedFileNames, attachedFileContents);
            for (Attachment attachment : attachments) {
                this.graphServiceClient.me().events().byEventId(uid).attachments().post(attachment);
            }
        }
    }

    public void respond(String uid, int responseCode, boolean sendResponse, String responseMessage) throws Throwable {
        EventItemRequestBuilder eventItemRequestBuilder = this.graphServiceClient.me().events().byEventId(uid);
        switch (responseCode) {
            case 2: {
                TentativelyAcceptPostRequestBody body = new TentativelyAcceptPostRequestBody();
                body.setSendResponse(Boolean.valueOf(sendResponse));
                body.setComment(responseMessage);
                eventItemRequestBuilder.tentativelyAccept().post(body);
                break;
            }
            case 4: {
                DeclinePostRequestBody declinePostRequestBody = new DeclinePostRequestBody();
                declinePostRequestBody.setSendResponse(Boolean.valueOf(sendResponse));
                declinePostRequestBody.setComment(responseMessage);
                eventItemRequestBuilder.decline().post(declinePostRequestBody);
                break;
            }
            default: {
                AcceptPostRequestBody acceptPostRequestBody = new AcceptPostRequestBody();
                acceptPostRequestBody.setSendResponse(Boolean.valueOf(sendResponse));
                acceptPostRequestBody.setComment(responseMessage);
                eventItemRequestBuilder.accept().post(acceptPostRequestBody);
            }
        }
    }

    public ArrayList getRoomList() {
        return (ArrayList)this.graphServiceClient.places().graphRoomList().get().getValue();
    }

    public ArrayList getRooms(EmailAddress emailAddress) {
        String roomListAddress = emailAddress.getAddress();
        ArrayList rooms = Objects.nonNull(roomListAddress) ? new ArrayList(this.graphServiceClient.places().byPlaceId(roomListAddress).graphRoomList().get(requestConfiguration -> {
            requestConfiguration.queryParameters.expand = new String[]{"rooms"};
        }).getRooms()) : new ArrayList(this.graphServiceClient.places().graphRoom().get().getValue());
        return rooms;
    }

    public CFUserAvailability getUserAvailability(List<String> attendees, Date startDate, Date endDate, AvailabilityData type) throws ReflectiveOperationException {
        if (Objects.isNull((Object)type)) {
            type = AvailabilityData.FreeBusy;
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case AvailabilityData.FreeBusy -> this.createCFUserAvailability(this.getFreeBusySchedule(attendees, startDate, endDate), null);
            case AvailabilityData.Suggestions -> this.createCFUserAvailability(null, this.findMeetingTimes(attendees, startDate, endDate));
            case AvailabilityData.FreeBusyAndSuggestions -> this.createCFUserAvailability(this.getFreeBusySchedule(attendees, startDate, endDate), this.findMeetingTimes(attendees, startDate, endDate));
        };
    }

    private CFUserAvailability createCFUserAvailability(List<ScheduleInformation> schedulePostResponse, MeetingTimeSuggestionsResult meetingTimeSuggestionsResult) {
        CFUserAvailability cfUserAvailabilityObject = new CFUserAvailability();
        this.setIfPresent(schedulePostResponse, this::getAttendeeAvailibility, attendeeAvailibityList -> attendeeAvailibityList.forEach(cfUserAvailabilityObject::addAttendeeAvailability));
        this.setIfPresent(meetingTimeSuggestionsResult, meetingSuggestions -> this.getSuggestions(meetingSuggestions.getMeetingTimeSuggestions()), suggestionsList -> suggestionsList.forEach(cfUserAvailabilityObject::addSuggestion));
        return cfUserAvailabilityObject;
    }

    private List<ScheduleInformation> getFreeBusySchedule(List<String> attendees, Date startDate, Date endDate) throws ReflectiveOperationException {
        GetSchedulePostRequestBody getSchedulePostRequestBody = new GetSchedulePostRequestBody();
        LinkedList<String> schedules = new LinkedList<String>(attendees);
        getSchedulePostRequestBody.setSchedules(schedules);
        ZonedDateTime zonedStartTime = ZonedDateTime.ofInstant(startDate.toInstant(), ZoneId.systemDefault());
        getSchedulePostRequestBody.setStartTime(this.getDateTime(zonedStartTime));
        ZonedDateTime zonedEndTime = ZonedDateTime.ofInstant(endDate.toInstant(), ZoneId.systemDefault());
        getSchedulePostRequestBody.setEndTime(this.getDateTime(zonedEndTime));
        getSchedulePostRequestBody.setAvailabilityViewInterval(SCHEDULE_INTERVAL);
        ArrayList<ScheduleInformation> scheduleInformationList = new ArrayList<ScheduleInformation>();
        GetSchedulePostResponse getSchedulePostResponse = this.graphServiceClient.me().calendar().getSchedule().post(getSchedulePostRequestBody);
        CalendarManager.iterateCollection(scheduleInformationList, this.graphServiceClient, requestInfo -> requestInfo, getSchedulePostResponse, GetSchedulePostResponse::createFromDiscriminatorValue);
        return scheduleInformationList;
    }

    private MeetingTimeSuggestionsResult findMeetingTimes(List<String> attendees, Date startDate, Date endDate) {
        FindMeetingTimesPostRequestBody findMeetingTimesPostRequestBody = new FindMeetingTimesPostRequestBody();
        findMeetingTimesPostRequestBody.setMeetingDuration(PeriodAndDuration.parse((String)SUGGESTION_DURATION));
        TimeConstraint timeConstraint = new TimeConstraint();
        timeConstraint.setActivityDomain(ActivityDomain.forValue((String)SUGGESTION_TYPE));
        TimeSlot timeSlot = new TimeSlot();
        ZonedDateTime zonedStartTime = ZonedDateTime.ofInstant(startDate.toInstant(), ZoneId.systemDefault());
        ZonedDateTime zonedEndTime = ZonedDateTime.ofInstant(endDate.toInstant(), ZoneId.systemDefault());
        timeSlot.setStart(this.getDateTime(zonedStartTime));
        timeSlot.setEnd(this.getDateTime(zonedEndTime));
        timeConstraint.setTimeSlots(new LinkedList<TimeSlot>(List.of(timeSlot)));
        findMeetingTimesPostRequestBody.setTimeConstraint(timeConstraint);
        List<AttendeeBase> attendeeBaseList = attendees.stream().map(attendee -> {
            AttendeeBase attendeeBase = new AttendeeBase();
            attendeeBase.setType(AttendeeType.Required);
            attendeeBase.setEmailAddress(this.getEmailAddress((String)attendee));
            return attendeeBase;
        }).toList();
        findMeetingTimesPostRequestBody.setAttendees(attendeeBaseList);
        return this.graphServiceClient.me().findMeetingTimes().post(findMeetingTimesPostRequestBody);
    }

    private Collection<coldfusion.exchange.webservice.AttendeeAvailability> getAttendeeAvailibility(List<ScheduleInformation> scheduleInformations) {
        return scheduleInformations.stream().map(scheduleInfo -> {
            List scheduleItemsList;
            coldfusion.exchange.webservice.AttendeeAvailability attendeeAvailabilityObject = new coldfusion.exchange.webservice.AttendeeAvailability();
            WorkingHours serverWorkingHours = scheduleInfo.getWorkingHours();
            if (Objects.nonNull(serverWorkingHours)) {
                coldfusion.exchange.webservice.WorkingHours workingHours = new coldfusion.exchange.webservice.WorkingHours();
                this.setIfPresent(serverWorkingHours.getStartTime(), startTime -> workingHours.setStartTime(startTime.toSecondOfDay()));
                this.setIfPresent(serverWorkingHours.getEndTime(), endTime -> workingHours.setEndTime(endTime.toSecondOfDay()));
                this.setIfPresent(serverWorkingHours.getTimeZone(), timeZoneBase -> {
                    CFTimeZone cfTimeZone = new CFTimeZone();
                    cfTimeZone.setName(timeZoneBase.getName());
                    return cfTimeZone;
                }, workingHours::setTimeZone);
                this.setIfPresent(serverWorkingHours.getDaysOfWeek(), daysOfWeek -> daysOfWeek.forEach(dayOfWeek -> workingHours.addDayOfTheWeek(dayOfWeek.name())));
                attendeeAvailabilityObject.setWorkingHours(workingHours);
            }
            if (Objects.nonNull(scheduleItemsList = scheduleInfo.getScheduleItems())) {
                scheduleItemsList.forEach(scheduleItem -> {
                    CalendarEvent calendarEvent = new CalendarEvent();
                    this.setIfPresent(scheduleItem.getStart(), this::getDateTime, calendarEvent::setStartTime);
                    this.setIfPresent(scheduleItem.getEnd(), this::getDateTime, calendarEvent::setEndTime);
                    this.setIfPresent(scheduleItem.getStatus(), Enum::name, status -> {
                        calendarEvent.setFreeBusyStatus((String)status);
                        attendeeAvailabilityObject.addFreeBusyStatus((String)status);
                    });
                    CalendarEventDetails calendarEventDetails = new CalendarEventDetails();
                    this.setIfPresent(scheduleItem.getIsPrivate(), calendarEventDetails::setPrivate);
                    this.setIfPresent(scheduleItem.getLocation(), calendarEventDetails::setLocation);
                    this.setIfPresent(scheduleItem.getSubject(), calendarEventDetails::setSubject);
                    calendarEvent.setDetails(calendarEventDetails);
                    attendeeAvailabilityObject.addCalendarEvent(calendarEvent);
                });
            }
            attendeeAvailabilityObject.setViewType("DetailedMerged");
            return attendeeAvailabilityObject;
        }).collect(Collectors.toList());
    }

    private LocalDate getLocalDate(DateTimeTimeZone dateTimeTimeZone) {
        ZoneId systemZoneId = ZoneId.systemDefault();
        ZoneId providedZoneId = ZoneId.of(dateTimeTimeZone.getTimeZone());
        LocalDateTime localDateTime = LocalDateTime.parse(dateTimeTimeZone.getDateTime(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        ZonedDateTime providedDateTime = ZonedDateTime.of(localDateTime, providedZoneId);
        ZonedDateTime currentDateTime = providedDateTime.withZoneSameInstant(systemZoneId);
        return currentDateTime.toLocalDate();
    }

    private Conflict parseAttendeeAvailibility(AttendeeAvailability attendeeAvailability, Double confidence) {
        Conflict conflict = new Conflict();
        conflict.setFreeBusyStatus(attendeeAvailability.getAvailability().name());
        if (confidence.intValue() != 100) {
            conflict.setConflictType("individualAttendeeConflict");
        }
        return conflict;
    }

    private Collection<Suggestion> getSuggestions(List<MeetingTimeSuggestion> meetingTimeSuggestions) {
        HashMap suggestionsMapper = new HashMap();
        meetingTimeSuggestions.forEach(meetingTimeSuggestion -> {
            TimeSuggestion timeSuggestionObject = new TimeSuggestion();
            Double confidence = meetingTimeSuggestion.getConfidence();
            this.setIfPresent(confidence, quality -> timeSuggestionObject.setQuality(quality.toString()));
            this.setIfPresent(meetingTimeSuggestion.getAttendeeAvailability(), attendeeAvailabilities -> attendeeAvailabilities.forEach(attendeeAvailibility -> timeSuggestionObject.addConflict(this.parseAttendeeAvailibility((AttendeeAvailability)attendeeAvailibility, confidence))));
            timeSuggestionObject.setWorkTime(true);
            this.setIfPresent(meetingTimeSuggestion.getMeetingTimeSlot(), TimeSlot::getStart, startDateTime -> {
                Date cfMeetingDate = this.getDateTime((DateTimeTimeZone)startDateTime);
                LocalDate meetingDate = this.getLocalDate((DateTimeTimeZone)startDateTime);
                timeSuggestionObject.setMeetingTime(cfMeetingDate);
                if (suggestionsMapper.containsKey(meetingDate)) {
                    Suggestion currentSuggestion = (Suggestion)suggestionsMapper.get(meetingDate);
                    Optional.ofNullable(timeSuggestionObject.getQuality()).filter(quality -> currentSuggestion.getQuality() != null).map(quality -> {
                        double currentQuality = Cast._double((String)currentSuggestion.getQuality());
                        double incomingQuality = Cast._double((String)quality);
                        int size = currentSuggestion.getTimeSuggestions().size();
                        return (currentQuality * (double)size + incomingQuality) / (double)(size + 1);
                    }).ifPresent(newQuality -> currentSuggestion.setQuality(newQuality.toString()));
                    ((Suggestion)suggestionsMapper.get(meetingDate)).addTimeSuggestion(timeSuggestionObject);
                } else {
                    Suggestion newSuggestion = new Suggestion();
                    newSuggestion.setDate(Date.from(meetingDate.atStartOfDay(ZoneId.systemDefault()).toInstant()));
                    newSuggestion.addTimeSuggestion(timeSuggestionObject);
                    newSuggestion.setQuality(timeSuggestionObject.getQuality());
                    suggestionsMapper.put(meetingDate, newSuggestion);
                }
            });
        });
        return suggestionsMapper.values();
    }

    private EventCollectionResponse getCollectionByCalendarId(String calendarId, String filter, String[] expand, boolean isTop) {
        return this.getCollectionByCalendarId(calendarId, filter, expand, isTop, 0);
    }

    private EventCollectionResponse getCollectionByCalendarId(String calendarId, String filter, String[] expand, boolean isTop, int top) {
        if (calendarId != null) {
            return this.graphServiceClient.me().calendars().byCalendarId(calendarId).events().get(requestConfiguration -> {
                if (filter.length() > 0) {
                    requestConfiguration.queryParameters.filter = filter;
                }
                if (expand != null) {
                    requestConfiguration.queryParameters.expand = new String[]{"instances"};
                }
                if (isTop) {
                    requestConfiguration.queryParameters.top = top;
                }
            });
        }
        return this.graphServiceClient.me().calendar().events().get(requestConfiguration -> {
            if (filter.length() > 0) {
                requestConfiguration.queryParameters.filter = filter;
            }
            if (expand != null) {
                requestConfiguration.queryParameters.expand = new String[]{"instances"};
            }
            if (isTop) {
                requestConfiguration.queryParameters.top = top;
            }
        });
    }

    protected ExchangeAppointment createCFEvent(Event event) {
        String categories;
        Integer reminder;
        Boolean isOrganizer;
        OffsetDateTime timestamp;
        Boolean isAllDayEvent;
        PatternedRecurrence recurrence;
        Boolean hasAttachments;
        Sensitivity sensitivity;
        Importance importance;
        DateTimeTimeZone dateTimeTimeZone;
        Location location;
        String temp;
        ItemBody itemBody;
        ExchangeMailMeeting appointment = new ExchangeMailMeeting();
        Recipient recipient = event.getOrganizer();
        if (recipient != null && recipient.getEmailAddress() != null) {
            appointment.setFromId(recipient.getEmailAddress().getAddress());
            appointment.setOrganizer(recipient.getEmailAddress().getName());
        }
        if ((itemBody = event.getBody()) != null) {
            switch (itemBody.getContentType()) {
                case Html: {
                    appointment.setHtmlMessage(itemBody.getContent());
                    break;
                }
                case Text: {
                    appointment.setMessage(itemBody.getContent());
                    break;
                }
                default: {
                    appointment.setMessage(itemBody.getContent());
                }
            }
        }
        List attendees = event.getAttendees();
        StringBuilder requiredattendees = new StringBuilder();
        StringBuilder optionalAttendees = new StringBuilder();
        StringBuilder resources = new StringBuilder();
        if (attendees != null) {
            for (Attendee attendee : attendees) {
                if (attendee.getEmailAddress() == null) continue;
                switch (attendee.getType()) {
                    case Required: {
                        requiredattendees.append(attendee.getEmailAddress().getAddress()).append(",");
                        break;
                    }
                    case Optional: {
                        optionalAttendees.append(attendee.getEmailAddress().getAddress()).append(",");
                        break;
                    }
                    case Resource: {
                        resources.append(attendee.getEmailAddress().getAddress()).append(",");
                    }
                }
            }
        }
        if (requiredattendees.length() > 0) {
            appointment.setRequiredAttendees(requiredattendees.substring(0, requiredattendees.length() - 1));
        }
        if (optionalAttendees.length() > 0) {
            appointment.setOptionalAttendees(optionalAttendees.substring(0, optionalAttendees.length() - 1));
        }
        if (resources.length() > 0) {
            appointment.setResources(resources.substring(0, resources.length() - 1));
        }
        if ((temp = event.getSubject()) != null) {
            appointment.setSubject(temp);
        }
        if ((location = event.getLocation()) != null) {
            appointment.setLocation(location.getDisplayName());
        }
        if ((temp = event.getId()) != null) {
            appointment.setId(temp);
        }
        if ((dateTimeTimeZone = event.getStart()) != null) {
            appointment.setStartTime(this.getDateTime(dateTimeTimeZone));
        }
        if ((dateTimeTimeZone = event.getEnd()) != null) {
            appointment.setEndTime(this.getDateTime(dateTimeTimeZone));
        }
        if ((importance = event.getImportance()) != null) {
            appointment.setImportance(importance.getValue());
        }
        if ((sensitivity = event.getSensitivity()) != null) {
            appointment.setSensitivity(sensitivity.equals((Object)Sensitivity.Confidential) ? "company-Confidential" : sensitivity.getValue());
        }
        if ((hasAttachments = event.getHasAttachments()) != null) {
            appointment.setHasAttachment(hasAttachments);
        }
        if ((recurrence = event.getRecurrence()) != null) {
            appointment.setRecurring(true);
            appointment.setRecurringSeries(true);
        } else {
            appointment.setRecurring(false);
            appointment.setRecurringSeries(false);
        }
        EventType eventType = event.getType();
        if (eventType != null) {
            appointment.setAppointmentType(eventType.getValue());
        }
        if ((isAllDayEvent = event.getIsAllDay()) != null) {
            appointment.setAllDay(isAllDayEvent);
        }
        if ((timestamp = event.getLastModifiedDateTime()) != null) {
            appointment.setLastModified(Date.from(timestamp.atZoneSameInstant(ZoneId.systemDefault()).toInstant()));
        }
        if ((isOrganizer = event.getIsOrganizer()) != null) {
            appointment.setIsOrganizer(isOrganizer);
        }
        if ((reminder = event.getReminderMinutesBeforeStart()) != null) {
            appointment.setReminderPeriod(reminder);
        }
        List categoriesList = event.getCategories();
        StringBuilder categoriesBuilder = new StringBuilder();
        if (categoriesList != null) {
            for (String category : categoriesList) {
                if (category == null) continue;
                categoriesBuilder.append(category).append(",");
            }
        }
        if ((categories = categoriesBuilder.toString()).length() > 0) {
            appointment.setCategories(categories.substring(0, categories.length() - 1));
        }
        return appointment;
    }

    private String getFilter(AppointmentFilterInfo filter) {
        StringBuilder filterBuilder = new StringBuilder();
        this.setIfPresent(filter.getFromStartTime(), startTime -> QueryType.GE.getQuery(new String[]{"start", "dateTime"}, this.getDateStringISO((Date)startTime), true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getToStartTime(), startTime -> QueryType.LE.getQuery(new String[]{"start", "dateTime"}, this.getDateStringISO((Date)startTime), true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getFromEndTime(), endTime -> QueryType.GE.getQuery(new String[]{"end", "dateTime"}, this.getDateStringISO((Date)endTime), true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getToEndTime(), endTime -> QueryType.LE.getQuery(new String[]{"end", "dateTime"}, this.getDateStringISO((Date)endTime), true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getHasAttachment(), value -> QueryType.EQ.getQuery("hasAttachments", value.toString()), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getIsAllDay(), value -> QueryType.EQ.getQuery("isAllDay", value.toString()), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getLocation(), value -> QueryType.EQ.getQuery(new String[]{"location", "displayName"}, (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getMessage(), value -> QueryType.CONTAINS.getQuery(new String[]{"body", "content"}, (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getSubject(), value -> QueryType.CONTAINS.getQuery("subject", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getRequiredAttendees(), value -> {
            List<String> requiredAttendeesList = this.splitCommaSeperatedString((String)value);
            StringBuilder queryBuilder = new StringBuilder();
            requiredAttendeesList.forEach(attendee -> queryBuilder.append(this.getAnyFilter((String)attendee, QueryType.EQ, new String[]{"i", "emailAddress", "address"}, "attendees")).append(QueryType.AND.getSpaced()));
            queryBuilder.append(this.getAnyFilter(AttendeeType.Optional.value, QueryType.EQ, new String[]{"i", "type"}, "attendees"));
            return queryBuilder.toString();
        }, value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getOptionalAttendees(), value -> {
            List<String> optionalAttendeesList = this.splitCommaSeperatedString((String)value);
            StringBuilder queryBuilder = new StringBuilder();
            optionalAttendeesList.forEach(attendee -> queryBuilder.append(this.getAnyFilter((String)attendee, QueryType.EQ, new String[]{"i", "emailAddress", "address"}, "attendees")).append(QueryType.AND.getSpaced()));
            queryBuilder.append(this.getAnyFilter(AttendeeType.Optional.value, QueryType.EQ, new String[]{"i", "type"}, "attendees"));
            return queryBuilder.toString();
        }, value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getResources(), value -> this.getAnyFilter((String)value, QueryType.EQ, new String[]{"i", "emailAddress", "address"}, "attendees") + QueryType.AND.getSpaced() + this.getAnyFilter(AttendeeType.Resource.value, QueryType.EQ, new String[]{"i", "type"}, "attendees"), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getImportance(), importance -> QueryType.EQ.getQuery("importance", Importance.forValue((String)importance.toLowerCase()) != null ? filter.getImportance() : Importance.Normal.value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getOrganizer(), value -> QueryType.EQ.getQuery(new String[]{"organizer", "emailAddress", "name"}, (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getFromId(), value -> QueryType.EQ.getQuery(new String[]{"organizer", "emailAddress", "address"}, (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getSensitivity(), sensitivity -> {
            if (sensitivity.equalsIgnoreCase("company-Confidential")) {
                sensitivity = "confidential";
            }
            return QueryType.EQ.getQuery("sensitivity", Sensitivity.forValue((String)sensitivity.toLowerCase()) != null ? sensitivity.toLowerCase() : Sensitivity.Normal.getValue(), true);
        }, value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getRecurringSeries(), recurringSeries -> recurringSeries == 1 ? QueryType.NEQ.getQuery("type", "singleInstance", true) : QueryType.EQ.getQuery("type", "singleInstance", true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getCategories(), value -> {
            List<String> categoriesList = this.splitCommaSeperatedString((String)value);
            StringBuilder queryBuilder = new StringBuilder();
            categoriesList.forEach(category -> queryBuilder.append(this.getAnyFilter((String)category, QueryType.EQ, new String[]{"i"}, "categories")).append(QueryType.AND.getSpaced()));
            return queryBuilder.toString();
        }, filterBuilder::append);
        return filterBuilder.length() > 0 ? this.trimAnd(filterBuilder.toString()) : filterBuilder.toString();
    }

    private Event createCalendarEvent(ExchangeAppointment appointment) {
        Integer intTemp;
        Event event = new Event();
        this.addTimeZoneDependentAttributes(appointment, event);
        RecurrenceInfo recurrenceInfo = appointment.getRecurrenceInfo();
        if (recurrenceInfo != null) {
            PatternedRecurrence patternedRecurrence = this.getRecurrence(recurrenceInfo, event.getStart());
            event.setRecurrence(patternedRecurrence);
        }
        this.setIfPresent(appointment.getLocation(), location -> event.setLocation(this.getGraphLocation((String)location)));
        String temp = appointment.getBusyStatus();
        if (temp != null) {
            if (temp.equalsIgnoreCase("NoData")) {
                temp = "unknown";
            }
            event.setShowAs(FreeBusyStatus.forValue((String)temp.toLowerCase()));
        }
        ArrayList attendees = new ArrayList();
        this.setIfPresent(appointment.getRequiredAttendees(), requiredAttendees -> this.updateAttendees(attendees, (String)requiredAttendees, AttendeeType.Required));
        this.setIfPresent(appointment.getOptionalAttendees(), optionalAttendees -> this.updateAttendees(attendees, (String)optionalAttendees, AttendeeType.Optional));
        this.setIfPresent(appointment.getResources(), resources -> this.updateAttendees(attendees, (String)resources, AttendeeType.Resource));
        this.setIfPresent(attendees.size() > 0 ? attendees : null, arg_0 -> ((Event)event).setAttendees(arg_0));
        temp = appointment.getSensitivity();
        if (temp != null) {
            if (temp.equalsIgnoreCase("company-Confidential")) {
                temp = "confidential";
            }
            event.setSensitivity(Sensitivity.forValue((String)temp.toLowerCase()));
        }
        if ((temp = appointment.getImportance()) != null) {
            event.setImportance(Importance.forValue((String)temp.toLowerCase()));
        }
        if ((intTemp = appointment.getReminderPeriod()) != null) {
            event.setIsReminderOn(Boolean.valueOf(true));
            event.setReminderMinutesBeforeStart(intTemp);
        }
        this.setIfPresent(appointment.getSubject(), arg_0 -> ((Event)event).setSubject(arg_0));
        this.setIfPresent(appointment.getMessage(), message -> this.createItemBody(BodyType.Text, (String)message), arg_0 -> ((Event)event).setBody(arg_0));
        this.setIfPresent(appointment.getHtmlMessage(), message -> this.createItemBody(BodyType.Html, (String)message), arg_0 -> ((Event)event).setBody(arg_0));
        temp = appointment.getCategories();
        if (temp != null) {
            event.setCategories(this.splitCommaSeperatedString(temp));
        }
        return event;
    }

    private List<DayOfWeek> getGraphDaysOfWeek(String recurrenceWeekDays) {
        ArrayList<DayOfWeek> daysOfWeek = new ArrayList<DayOfWeek>();
        if (recurrenceWeekDays != null) {
            String[] splits;
            for (String split : splits = Utils.splitString(recurrenceWeekDays)) {
                if ("MO".equals(split)) {
                    daysOfWeek.add(DayOfWeek.Monday);
                    continue;
                }
                if ("TU".equals(split)) {
                    daysOfWeek.add(DayOfWeek.Tuesday);
                    continue;
                }
                if ("WE".equals(split)) {
                    daysOfWeek.add(DayOfWeek.Wednesday);
                    continue;
                }
                if ("TH".equals(split)) {
                    daysOfWeek.add(DayOfWeek.Thursday);
                    continue;
                }
                if ("FR".equals(split)) {
                    daysOfWeek.add(DayOfWeek.Friday);
                    continue;
                }
                if ("SA".equals(split)) {
                    daysOfWeek.add(DayOfWeek.Saturday);
                    continue;
                }
                if (!"SU".equals(split)) continue;
                daysOfWeek.add(DayOfWeek.Sunday);
            }
        }
        return daysOfWeek;
    }

    private PatternedRecurrence getRecurrence(RecurrenceInfo recurrenceInfo, DateTimeTimeZone startDateTime) {
        LocalDateTime localStartDateTime = LocalDateTime.parse(startDateTime.getDateTime(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        ZonedDateTime zonedStartDateTime = ZonedDateTime.of(localStartDateTime, ZoneId.of(startDateTime.getTimeZone()));
        int recurrencePatternType = recurrenceInfo.getRecurrencePatternType();
        PatternedRecurrence patternedRecurrence = new PatternedRecurrence();
        RecurrencePattern recurrencePattern = new RecurrencePattern();
        switch (recurrencePatternType) {
            case 1: {
                recurrencePattern.setType(RecurrencePatternType.Daily);
                recurrencePattern.setInterval(Integer.valueOf(recurrenceInfo.getEveryNumDays()));
                if (!recurrenceInfo.isEveryWeekday()) break;
                recurrencePattern.setInterval(Integer.valueOf(1));
                ArrayList<DayOfWeek> dayOfWeekList = new ArrayList<DayOfWeek>(Set.of(DayOfWeek.Monday, DayOfWeek.Tuesday, DayOfWeek.Wednesday, DayOfWeek.Thursday, DayOfWeek.Friday));
                recurrencePattern.setDaysOfWeek(dayOfWeekList);
                break;
            }
            case 2: {
                String recurrenceWeekDays = recurrenceInfo.getRecurrenceWeekDays();
                List<DayOfWeek> daysOfWeek = this.getGraphDaysOfWeek(recurrenceWeekDays);
                recurrencePattern.setType(RecurrencePatternType.Weekly);
                recurrencePattern.setInterval(Integer.valueOf(recurrenceInfo.getEveryNumWeeks()));
                if (daysOfWeek.size() <= 0) {
                    daysOfWeek.add(DayOfWeek.forValue((String)zonedStartDateTime.getDayOfWeek().name().toLowerCase()));
                }
                recurrencePattern.setDaysOfWeek(daysOfWeek);
                break;
            }
            case 3: {
                String recurrenceWeek = recurrenceInfo.getRecurrenceWeek();
                recurrencePattern.setInterval(Integer.valueOf(recurrenceInfo.getEveryNumMonths()));
                if (recurrenceWeek == null) {
                    recurrencePattern.setType(RecurrencePatternType.AbsoluteMonthly);
                    recurrencePattern.setDayOfMonth(Integer.valueOf(zonedStartDateTime.getDayOfMonth()));
                    break;
                }
                recurrencePattern.setType(RecurrencePatternType.RelativeMonthly);
                List<DayOfWeek> daysOfWeek = this.getGraphDaysOfWeek(recurrenceInfo.getRecurrenceWeekDays());
                if (daysOfWeek.size() <= 0) {
                    daysOfWeek.add(DayOfWeek.forValue((String)zonedStartDateTime.getDayOfWeek().name().toLowerCase()));
                }
                recurrencePattern.setDaysOfWeek(daysOfWeek);
                recurrencePattern.setIndex(WeekIndex.valueOf((String)recurrenceWeek.toLowerCase()));
                break;
            }
            case 4: {
                String recurrenceWeek = recurrenceInfo.getRecurrenceWeek();
                recurrencePattern.setInterval(Integer.valueOf(1));
                if (recurrenceWeek == null) {
                    recurrencePattern.setType(RecurrencePatternType.AbsoluteYearly);
                    recurrencePattern.setDayOfMonth(Integer.valueOf(zonedStartDateTime.getDayOfMonth()));
                    recurrencePattern.setMonth(Integer.valueOf(zonedStartDateTime.getMonthValue()));
                    break;
                }
                recurrencePattern.setType(RecurrencePatternType.RelativeYearly);
                List<DayOfWeek> daysOfWeek = this.getGraphDaysOfWeek(recurrenceInfo.getRecurrenceWeekDays());
                if (daysOfWeek.size() <= 0) {
                    daysOfWeek.add(DayOfWeek.forValue((String)zonedStartDateTime.getDayOfWeek().name().toLowerCase()));
                }
                recurrencePattern.setDaysOfWeek(daysOfWeek);
                recurrencePattern.setIndex(WeekIndex.valueOf((String)recurrenceWeek.toLowerCase()));
                recurrencePattern.setMonth(Integer.valueOf(recurrenceInfo.getRecurranceMonth()));
                break;
            }
        }
        RecurrenceRange recurrenceRange = new RecurrenceRange();
        int recurrenceRangeType = recurrenceInfo.getRecurrenceRangeType();
        switch (recurrenceRangeType) {
            case 1: {
                recurrenceRange.setType(RecurrenceRangeType.NoEnd);
                recurrenceRange.setStartDate(localStartDateTime.toLocalDate());
                break;
            }
            case 3: {
                recurrenceRange.setType(RecurrenceRangeType.EndDate);
                Date recurEndDate = recurrenceInfo.getEndRecurrenceByDate();
                recurrenceRange.setEndDate(LocalDate.ofInstant(recurEndDate.toInstant(), ZoneId.systemDefault()));
                break;
            }
            case 2: {
                recurrenceRange.setType(RecurrenceRangeType.Numbered);
                recurrenceRange.setStartDate(localStartDateTime.toLocalDate());
                recurrenceRange.setNumberOfOccurrences(Integer.valueOf(recurrenceInfo.getEndRecurrenceAfterCount()));
                break;
            }
        }
        patternedRecurrence.setRange(recurrenceRange);
        patternedRecurrence.setPattern(recurrencePattern);
        return patternedRecurrence;
    }

    private void updateAttendees(List<Attendee> attendees, String requiredAttendees, AttendeeType attendeeType) {
        String[] splits;
        for (String split : splits = Utils.splitString(requiredAttendees)) {
            if (null == split || split.trim().length() == 0) continue;
            Attendee attendee = new Attendee();
            com.microsoft.graph.models.EmailAddress emailAddress = new com.microsoft.graph.models.EmailAddress();
            emailAddress.setAddress(split);
            attendee.setEmailAddress(emailAddress);
            attendee.setType(attendeeType);
            attendees.add(attendee);
        }
    }

    private void addTimeZoneDependentAttributes(ExchangeAppointment appointment, Event event) {
        ZoneId zoneId;
        ZoneId zoneId2 = zoneId = appointment.getTimeZone() != null ? ZoneId.of(appointment.getTimeZone()) : ZoneId.systemDefault();
        if (appointment.getStartTime() == null) {
            throw new GraphException(RB.getString(CalendarManager.class, (String)"CalendarManager.invalidStartTime"));
        }
        ZonedDateTime zonedStartTime = ZonedDateTime.ofInstant(appointment.getStartTime().toInstant(), zoneId);
        ZonedDateTime zonedEndTime = null;
        if (appointment.getEndTime() == null) {
            Long duration = appointment.getDuration();
            if (duration != null) {
                zonedEndTime = zonedStartTime.plusMinutes(duration);
            }
        } else {
            zonedEndTime = ZonedDateTime.ofInstant(appointment.getEndTime().toInstant(), zoneId);
        }
        Boolean isAllDay = appointment.isAllDay();
        if (isAllDay != null && isAllDay.booleanValue()) {
            zonedStartTime = zonedStartTime.withZoneSameInstant(ZoneId.of("UTC")).withHour(0).withMinute(0).withSecond(0).withNano(0);
            if (zonedEndTime == null) {
                zonedEndTime = ZonedDateTime.ofInstant(appointment.getStartTime().toInstant(), zoneId);
            }
            zonedEndTime = zonedEndTime.withZoneSameInstant(ZoneId.of("UTC")).withHour(0).withMinute(0).withSecond(0).withNano(0).plusDays(1L);
            event.setIsAllDay(Boolean.valueOf(true));
        }
        if (zonedEndTime == null) {
            throw new GraphException(RB.getString(CalendarManager.class, (String)"CalendarManager.invalidEndTime"));
        }
        if (zonedStartTime.compareTo(zonedEndTime) > 0) {
            throw new GraphException(RB.getString(CalendarManager.class, (String)"CalendarManager.invalidStartDate"));
        }
        event.setStart(this.getDateTime(zonedStartTime));
        event.setEnd(this.getDateTime(zonedEndTime));
    }

    static {
        SCHEDULE_INTERVAL = 60;
    }
}

