/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.microsoft.graph;

import coldfusion.exchange.ContactAddress;
import coldfusion.exchange.ExchangeAttachment;
import coldfusion.exchange.microsoft.graph.GraphException;
import coldfusion.exchange.microsoft.graph.QueryType;
import coldfusion.exchange.webdav.Utils;
import coldfusion.util.MimeTypeUtils;
import coldfusion.util.RB;
import com.microsoft.graph.core.content.BatchRequestContent;
import com.microsoft.graph.core.content.BatchResponseContent;
import com.microsoft.graph.core.requests.IBaseClient;
import com.microsoft.graph.core.tasks.PageIterator;
import com.microsoft.graph.models.Attachment;
import com.microsoft.graph.models.BodyType;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.EmailAddress;
import com.microsoft.graph.models.FileAttachment;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.Location;
import com.microsoft.graph.models.LocationType;
import com.microsoft.graph.models.PhysicalAddress;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.models.SingleValueLegacyExtendedProperty;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public abstract class AbstractServiceManager {
    protected GraphServiceClient graphServiceClient;
    protected final ZoneId UTCZoneId = ZoneId.of("UTC");

    protected AbstractServiceManager(GraphServiceClient client) {
        this.graphServiceClient = client;
    }

    protected DateTimeTimeZone getDateTime(ZonedDateTime zonedDateTime) {
        zonedDateTime = zonedDateTime.withZoneSameInstant(this.UTCZoneId);
        String dateTimeString = zonedDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        DateTimeTimeZone dateTimeTimeZone = new DateTimeTimeZone();
        dateTimeTimeZone.setDateTime(dateTimeString);
        dateTimeTimeZone.setTimeZone(this.UTCZoneId.getId());
        return dateTimeTimeZone;
    }

    protected Date getDateTime(DateTimeTimeZone dateTimeTimeZone) {
        ZoneId systemZoneId = ZoneId.systemDefault();
        ZoneId providedZoneId = ZoneId.of(dateTimeTimeZone.getTimeZone());
        LocalDateTime localDateTime = LocalDateTime.parse(dateTimeTimeZone.getDateTime(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        ZonedDateTime providedDateTime = ZonedDateTime.of(localDateTime, providedZoneId);
        ZonedDateTime currentDateTime = providedDateTime.withZoneSameInstant(systemZoneId);
        return Date.from(currentDateTime.toInstant());
    }

    protected Location getGraphLocation(String location) {
        Location graphLocation = new Location();
        graphLocation.setLocationType(LocationType.Default);
        graphLocation.setDisplayName(location);
        graphLocation.setLocationUri(location);
        return graphLocation;
    }

    protected String getCFLocation(Location location) {
        return location.getLocationUri();
    }

    protected PhysicalAddress getPhysicalAddress(ContactAddress address) {
        PhysicalAddress physicalAddress = new PhysicalAddress();
        physicalAddress.setCity(address.getCity());
        physicalAddress.setCountryOrRegion(address.getCountry());
        physicalAddress.setPostalCode(address.getPostalCode());
        physicalAddress.setState(address.getState());
        physicalAddress.setStreet(address.getStreet());
        return physicalAddress;
    }

    protected ContactAddress getPhysicalAddress(PhysicalAddress address) {
        ContactAddress physicalAddress = new ContactAddress();
        physicalAddress.setCity(address.getCity());
        physicalAddress.setCountry(address.getCountryOrRegion());
        physicalAddress.setPostalCode(address.getPostalCode());
        physicalAddress.setState(address.getState());
        physicalAddress.setStreet(address.getStreet());
        return physicalAddress;
    }

    protected List<String> splitCommaSeperatedString(String value) {
        String[] splits;
        ArrayList<String> list = new ArrayList<String>();
        for (String split : splits = Utils.splitString(value)) {
            if (split.trim().length() == 0) continue;
            list.add(split);
        }
        return list;
    }

    protected List<Attachment> getGraphAttachments(String[] attachedFileNames, Object[] attachedFileContents) {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (attachedFileNames.length != attachedFileContents.length) {
            throw new GraphException(RB.getString((Object)this, (String)"GraphConnection.attachmentCountMismatch", (Object[])new Object[]{attachedFileNames.length, attachedFileContents.length}));
        }
        for (int i = 0; i < attachedFileNames.length; ++i) {
            if (!(attachedFileContents[i] instanceof byte[])) {
                throw new GraphException(RB.getString((Object)this, (String)"GraphConnection.attachmentInvalidType", (Object[])new Object[]{attachedFileNames[i], attachedFileContents[i]}));
            }
            FileAttachment fileAttachment = new FileAttachment();
            fileAttachment.setContentBytes((byte[])attachedFileContents[i]);
            fileAttachment.setName(attachedFileNames[i]);
            String mimeType = MimeTypeUtils.guessMimeType((String)attachedFileNames[i]);
            if (null != mimeType) {
                fileAttachment.setContentType(mimeType);
            }
            attachments.add((Attachment)fileAttachment);
        }
        return attachments;
    }

    protected Recipient getRecipient(String value) {
        Recipient recipient = new Recipient();
        recipient.setEmailAddress(this.getEmailAddress(value));
        return recipient;
    }

    protected EmailAddress getEmailAddress(String value) {
        EmailAddress emailAddress = new EmailAddress();
        emailAddress.setAddress(value);
        return emailAddress;
    }

    protected String trimAnd(String string) {
        return string.substring(0, string.length() - 5);
    }

    protected String getAnyFilter(String values, QueryType insideQueryType, String[] insideKeyPath, String collection) {
        List<String> list = this.splitCommaSeperatedString(values);
        StringBuilder valueBuilder = new StringBuilder();
        list.forEach(value -> valueBuilder.append(insideQueryType.getQuery(insideKeyPath, (String)value, true)).append(QueryType.AND.getSpaced()));
        return valueBuilder.length() > 0 ? QueryType.ANY.getQuery(collection, QueryType.COLON.getQuery("i", this.trimAnd(valueBuilder.toString()))) : null;
    }

    protected static <TEntity extends Parsable, TCollectionPage extends Parsable & AdditionalDataHolder> void iterateCollection(@Nonnull List<TEntity> theList, @Nonnull GraphServiceClient gc, UnaryOperator<RequestInformation> requestConfigurator, TCollectionPage pageResponse, @Nonnull ParsableFactory<TCollectionPage> collectionPageFactory) throws ReflectiveOperationException {
        if (pageResponse == null) {
            return;
        }
        PageIterator pageIterator = new PageIterator.Builder().client((IBaseClient)gc).collectionPage(pageResponse).collectionPageFactory(collectionPageFactory).requestConfigurator(requestConfigurator).processPageItemCallback(item -> {
            theList.add(item);
            return true;
        }).build();
        pageIterator.iterate();
    }

    protected String getDateStringISO(Date date) {
        return this.getDateTime(ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault())).getDateTime();
    }

    protected String getDateStringISOWithOffset(Date date) {
        return ZonedDateTime.ofInstant(date.toInstant(), this.UTCZoneId).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    protected <T, R> void setIfPresent(T value, Function<T, R> mapper, Consumer<R> setter) {
        Optional.ofNullable(value).map(mapper).ifPresent(setter);
    }

    protected <T> void setIfPresent(T value, Consumer<T> setter) {
        Optional.ofNullable(value).ifPresent(setter);
    }

    protected ItemBody createItemBody(BodyType type, String content) {
        ItemBody itemBody = new ItemBody();
        itemBody.setContentType(type);
        itemBody.setContent(content);
        return itemBody;
    }

    protected SingleValueLegacyExtendedProperty createSingleValueExtendedProperty(String propertyId, String propertyValue) {
        SingleValueLegacyExtendedProperty sensitivityExtendedProperty = new SingleValueLegacyExtendedProperty();
        sensitivityExtendedProperty.setId(propertyId);
        sensitivityExtendedProperty.setValue(propertyValue);
        return sensitivityExtendedProperty;
    }

    protected boolean isNullOrEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    protected Optional<String> getFilterToDeleteAttachments(String[] fileNames) {
        StringBuilder filter = new StringBuilder();
        if (Objects.nonNull(fileNames) && fileNames.length > 0) {
            for (String fileName : fileNames) {
                filter.append(QueryType.EQ.getQuery("name", fileName, true));
            }
            return Optional.of(this.trimAnd(filter.toString()));
        }
        return Optional.empty();
    }

    protected ExchangeAttachment getExchangeAttachment(String id, Integer size, String name, String contentType, byte[] content) throws IOException {
        ExchangeAttachment exchangeAttachment = new ExchangeAttachment();
        if (Objects.nonNull(content)) {
            exchangeAttachment.setFileContent(new ByteArrayInputStream(content));
        }
        this.setIfPresent(id, exchangeAttachment::setCID);
        this.setIfPresent(size, exchangeAttachment::setFileSize);
        this.setIfPresent(name, exchangeAttachment::setFileName);
        this.setIfPresent(contentType, exchangeAttachment::setMimeType);
        return exchangeAttachment;
    }

    protected BatchResponseContent executeBatchOperation(BatchRequestContent batchRequestContent) throws IOException {
        return this.graphServiceClient.getBatchRequestBuilder().post(batchRequestContent, null);
    }
}

