/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange;

import coldfusion.exchange.ExchangeConnection;
import coldfusion.exchange.ExchangeLoginInfo;
import coldfusion.exchange.microsoft.graph.GraphConnection;
import coldfusion.exchange.webdav.WebDAVConnection;
import coldfusion.exchange.webservice.EWSConnection;
import coldfusion.exchange.webservice.EWSException;
import coldfusion.log.CFLogs;
import coldfusion.util.RB;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;

public class ExchangeConnectionFactory {
    public static ExchangeConnection createExchangeConnection(ExchangeLoginInfo loginInfo) throws Throwable {
        switch (loginInfo.getExchangeVersion()) {
            case "2010": {
                return ExchangeConnectionFactory.createEWSConnection(loginInfo, ExchangeVersion.Exchange2010);
            }
            case "2010_SP1": {
                return ExchangeConnectionFactory.createEWSConnection(loginInfo, ExchangeVersion.Exchange2010_SP1);
            }
            case "2010_SP2": {
                return ExchangeConnectionFactory.createEWSConnection(loginInfo, ExchangeVersion.Exchange2010_SP2);
            }
            case "2013": 
            case "2016": 
            case "2019": {
                return ExchangeConnectionFactory.createEWSConnection(loginInfo);
            }
            case "2007": 
            case "2003": {
                return ExchangeConnectionFactory.createWebDAVConnection(loginInfo);
            }
            case "online": {
                return ExchangeConnectionFactory.createGraphConnection(loginInfo);
            }
        }
        return null;
    }

    private static WebDAVConnection createWebDAVConnection(ExchangeLoginInfo loginInfo) throws Throwable {
        CFLogs.APPLICATION_LOG.debug((Object)RB.getString(ExchangeConnectionFactory.class, (String)"ExchangeConnectionFactory.creatingWebDAVConnection"));
        return new WebDAVConnection(loginInfo);
    }

    private static ExchangeConnection createEWSConnection(ExchangeLoginInfo loginInfo) throws EWSException {
        return ExchangeConnectionFactory.createEWSConnection(loginInfo, null);
    }

    private static ExchangeConnection createEWSConnection(ExchangeLoginInfo loginInfo, ExchangeVersion exchangeVersion) throws EWSException {
        CFLogs.APPLICATION_LOG.debug((Object)RB.getString(ExchangeConnectionFactory.class, (String)"ExchangeConnectionFactory.creatingEWSConnection"));
        return new EWSConnection(loginInfo, exchangeVersion);
    }

    private static ExchangeConnection createGraphConnection(ExchangeLoginInfo loginInfo) {
        CFLogs.APPLICATION_LOG.debug((Object)RB.getString(ExchangeConnectionFactory.class, (String)"ExchangeConnectionFactory.creatingGraphConnection"));
        return new GraphConnection(loginInfo);
    }
}

