/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.search;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.search.FolderTraversal;
import microsoft.exchange.webservices.data.core.enumeration.search.OffsetBasePoint;
import microsoft.exchange.webservices.data.core.enumeration.service.ServiceObjectType;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.search.PagedView;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FolderView
extends PagedView {
    private static final Log LOG = LogFactory.getLog(FolderView.class);
    private FolderTraversal traversal = FolderTraversal.Shallow;

    @Override
    protected String getViewXmlElementName() {
        return "IndexedPageFolderView";
    }

    @Override
    protected ServiceObjectType getServiceObjectType() {
        return ServiceObjectType.Folder;
    }

    @Override
    public void writeAttributesToXml(EwsServiceXmlWriter writer) {
        try {
            writer.writeAttributeValue("Traversal", (Object)this.getTraversal());
        }
        catch (ServiceXmlSerializationException e) {
            LOG.error((Object)e);
        }
    }

    public FolderView(int pageSize) {
        super(pageSize);
    }

    public FolderView(int pageSize, int offset) {
        super(pageSize, offset);
    }

    public FolderView(int pageSize, int offset, OffsetBasePoint offsetBasePoint) {
        super(pageSize, offset, offsetBasePoint);
    }

    public FolderTraversal getTraversal() {
        return this.traversal;
    }

    public void setTraversal(FolderTraversal traversal) {
        this.traversal = traversal;
    }
}

