/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.ICustomXmlUpdateSerializer;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.DictionaryEntryProperty;
import microsoft.exchange.webservices.data.property.complex.IComplexPropertyChangedDelegate;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinition;

@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class DictionaryProperty<TKey, TEntry extends DictionaryEntryProperty<TKey>>
extends ComplexProperty
implements ICustomXmlUpdateSerializer,
IComplexPropertyChangedDelegate<TEntry> {
    private Map<TKey, TEntry> entries = new HashMap<TKey, TEntry>();
    private Map<TKey, TEntry> removedEntries = new HashMap<TKey, TEntry>();
    private List<TKey> addedEntries = new ArrayList<TKey>();
    private List<TKey> modifiedEntries = new ArrayList<TKey>();

    private void entryChanged(TEntry complexProperty) {
        Object key = ((DictionaryEntryProperty)complexProperty).getKey();
        if (!this.addedEntries.contains(key) && !this.modifiedEntries.contains(key)) {
            this.modifiedEntries.add(key);
            this.changed();
        }
    }

    private void writeUriToXml(EwsServiceXmlWriter writer, TKey key) throws Exception {
        writer.writeStartElement(XmlNamespace.Types, "IndexedFieldURI");
        writer.writeAttributeValue("FieldURI", this.getFieldURI());
        writer.writeAttributeValue("FieldIndex", this.getFieldIndex(key));
        writer.writeEndElement();
    }

    protected String getFieldIndex(TKey key) {
        return key.toString();
    }

    protected String getFieldURI() {
        return null;
    }

    protected TEntry createEntry(EwsServiceXmlReader reader) {
        if (reader.getLocalName().equalsIgnoreCase("Entry")) {
            return this.createEntryInstance();
        }
        return null;
    }

    protected abstract TEntry createEntryInstance();

    protected String getEntryXmlElementName(TEntry entry) {
        return "Entry";
    }

    @Override
    public void clearChangeLog() {
        this.addedEntries.clear();
        this.removedEntries.clear();
        this.modifiedEntries.clear();
        for (DictionaryEntryProperty entry : this.entries.values()) {
            entry.clearChangeLog();
        }
    }

    protected void internalAdd(TEntry entry) {
        ((ComplexProperty)entry).addOnChangeEvent(this);
        this.entries.put(((DictionaryEntryProperty)entry).getKey(), entry);
        this.addedEntries.add(((DictionaryEntryProperty)entry).getKey());
        this.removedEntries.remove(((DictionaryEntryProperty)entry).getKey());
        this.changed();
    }

    @Override
    public void complexPropertyChanged(TEntry complexProperty) {
        this.entryChanged(complexProperty);
    }

    protected void internalAddOrReplace(TEntry entry) {
        if (this.entries.containsKey(((DictionaryEntryProperty)entry).getKey())) {
            DictionaryEntryProperty oldEntry = (DictionaryEntryProperty)this.entries.get(((DictionaryEntryProperty)entry).getKey());
            oldEntry.removeChangeEvent(this);
            ((ComplexProperty)entry).addOnChangeEvent(this);
            if (!this.addedEntries.contains(((DictionaryEntryProperty)entry).getKey()) && !this.modifiedEntries.contains(((DictionaryEntryProperty)entry).getKey())) {
                this.modifiedEntries.add(((DictionaryEntryProperty)entry).getKey());
            }
            this.changed();
        } else {
            this.internalAdd(entry);
        }
    }

    protected void internalRemove(TKey key) {
        if (this.entries.containsKey(key)) {
            DictionaryEntryProperty entry = (DictionaryEntryProperty)this.entries.get(key);
            entry.removeChangeEvent(this);
            this.entries.remove(key);
            this.removedEntries.put(key, entry);
            this.changed();
        }
        this.addedEntries.remove(key);
    }

    @Override
    public void loadFromXml(EwsServiceXmlReader reader, String localElementName) throws Exception {
        reader.ensureCurrentNodeIsStartElement(XmlNamespace.Types, localElementName);
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                if (!reader.isStartElement()) continue;
                TEntry entry = this.createEntry(reader);
                if (entry != null) {
                    ((ComplexProperty)entry).loadFromXml(reader, reader.getLocalName());
                    this.internalAdd(entry);
                    continue;
                }
                reader.skipCurrentElement();
            } while (!reader.isEndElement(XmlNamespace.Types, localElementName));
        } else {
            reader.read();
        }
    }

    @Override
    public void writeToXml(EwsServiceXmlWriter writer, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        if (this.entries.size() > 0) {
            super.writeToXml(writer, xmlNamespace, xmlElementName);
        }
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        for (Map.Entry<TKey, TEntry> keyValuePair : this.entries.entrySet()) {
            ((DictionaryEntryProperty)keyValuePair.getValue()).writeToXml(writer, this.getEntryXmlElementName((DictionaryEntryProperty)keyValuePair.getValue()));
        }
    }

    protected Map<TKey, TEntry> getEntries() {
        return this.entries;
    }

    public boolean contains(TKey key) {
        return this.entries.containsKey(key);
    }

    @Override
    public boolean writeSetUpdateToXml(EwsServiceXmlWriter writer, ServiceObject ewsObject, PropertyDefinition propertyDefinition) throws Exception {
        ArrayList<TEntry> tempEntries = new ArrayList<TEntry>();
        for (TKey key : this.addedEntries) {
            tempEntries.add(this.entries.get(key));
        }
        for (TKey key : this.modifiedEntries) {
            tempEntries.add(this.entries.get(key));
        }
        for (DictionaryEntryProperty entry : tempEntries) {
            if (entry.writeSetUpdateToXml(writer, ewsObject, propertyDefinition.getXmlElement())) continue;
            writer.writeStartElement(XmlNamespace.Types, ewsObject.getSetFieldXmlElementName());
            this.writeUriToXml(writer, entry.getKey());
            writer.writeStartElement(XmlNamespace.Types, ewsObject.getXmlElementName());
            writer.writeStartElement(XmlNamespace.Types, propertyDefinition.getXmlElement());
            entry.writeToXml(writer, this.getEntryXmlElementName(entry));
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
        for (DictionaryEntryProperty entry : this.removedEntries.values()) {
            if (entry.writeDeleteUpdateToXml(writer, ewsObject)) continue;
            writer.writeStartElement(XmlNamespace.Types, ewsObject.getDeleteFieldXmlElementName());
            this.writeUriToXml(writer, entry.getKey());
            writer.writeEndElement();
        }
        return true;
    }

    @Override
    public boolean writeDeleteUpdateToXml(EwsServiceXmlWriter writer, ServiceObject ewsObject) {
        return false;
    }
}

