/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.property.complex.FolderId;

public final class SendItemRequest
extends MultiResponseServiceRequest<ServiceResponse> {
    private Iterable<Item> items;
    private FolderId savedCopyDestinationFolderId;

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.items, "Items");
        if (this.savedCopyDestinationFolderId != null) {
            this.savedCopyDestinationFolderId.validate(this.getService().getRequestedServerVersion());
        }
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ServiceResponse();
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return EwsUtilities.getEnumeratedObjectCount(this.items.iterator());
    }

    @Override
    public String getXmlElementName() {
        return "SendItem";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "SendItemResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "SendItemResponseMessage";
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        writer.writeAttributeValue("SaveItemToFolder", this.savedCopyDestinationFolderId != null);
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Messages, "ItemIds");
        for (Item item : this.getItems()) {
            item.getId().writeToXml(writer, "ItemId");
        }
        writer.writeEndElement();
        if (this.savedCopyDestinationFolderId != null) {
            writer.writeStartElement(XmlNamespace.Messages, "SavedItemFolderId");
            this.savedCopyDestinationFolderId.writeToXml(writer);
            writer.writeEndElement();
        }
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public SendItemRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    public Iterable<Item> getItems() {
        return this.items;
    }

    public void setItems(Iterable<Item> items) {
        this.items = items;
    }

    public FolderId getSavedCopyDestinationFolderId() {
        return this.savedCopyDestinationFolderId;
    }

    public void setSavedCopyDestinationFolderId(FolderId savedCopyDestinationFolderId) {
        this.savedCopyDestinationFolderId = savedCopyDestinationFolderId;
    }
}

