/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.BodyType;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.GetAttachmentResponse;
import microsoft.exchange.webservices.data.property.complex.Attachment;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;

public final class GetAttachmentRequest
extends MultiResponseServiceRequest<GetAttachmentResponse> {
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private List<PropertyDefinitionBase> additionalProperties = new ArrayList<PropertyDefinitionBase>();
    private BodyType bodyType;

    public GetAttachmentRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.getAttachments().iterator(), "Attachments");
        for (int i = 0; i < this.getAdditionalProperties().size(); ++i) {
            EwsUtilities.validateParam(this.getAdditionalProperties().get(i), String.format("AdditionalProperties[%d]", i));
        }
    }

    @Override
    protected GetAttachmentResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new GetAttachmentResponse(this.getAttachments().get(responseIndex));
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.getAttachments().size();
    }

    @Override
    public String getXmlElementName() {
        return "GetAttachment";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetAttachmentResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "GetAttachmentResponseMessage";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        if (this.getBodyType() != null || this.getAdditionalProperties().size() > 0) {
            writer.writeStartElement(XmlNamespace.Messages, "AttachmentShape");
            if (this.getBodyType() != null) {
                writer.writeElementValue(XmlNamespace.Types, "BodyType", (Object)this.getBodyType());
            }
            if (this.getAdditionalProperties().size() > 0) {
                PropertySet.writeAdditionalPropertiesToXml(writer, this.getAdditionalProperties().iterator());
            }
            writer.writeEndElement();
        }
        writer.writeStartElement(XmlNamespace.Messages, "AttachmentIds");
        for (Attachment attachment : this.getAttachments()) {
            writer.writeStartElement(XmlNamespace.Types, "AttachmentId");
            writer.writeAttributeValue("Id", attachment.getId());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public List<PropertyDefinitionBase> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public BodyType getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(BodyType bodyType) {
        this.bodyType = bodyType;
    }
}

