/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.request.SimpleServiceRequestBase;
import microsoft.exchange.webservices.data.core.response.DelegateManagementResponse;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.property.complex.Mailbox;

abstract class DelegateManagementRequestBase<TResponse extends DelegateManagementResponse>
extends SimpleServiceRequestBase<TResponse> {
    private Mailbox mailbox;

    protected DelegateManagementRequestBase(ExchangeService service) throws Exception {
        super(service);
    }

    @Override
    protected void validate() throws ServiceLocalException, Exception {
        super.validate();
        EwsUtilities.validateParam(this.getMailbox(), "Mailbox");
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getMailbox().writeToXml(writer, XmlNamespace.Messages, "Mailbox");
    }

    protected abstract TResponse createResponse();

    @Override
    protected TResponse parseResponse(EwsServiceXmlReader reader) throws Exception {
        TResponse response = this.createResponse();
        ((ServiceResponse)response).loadFromXml(reader, this.getResponseXmlElementName());
        return response;
    }

    public TResponse execute() throws Exception {
        DelegateManagementResponse serviceResponse = (DelegateManagementResponse)this.internalExecute();
        serviceResponse.throwIfNecessary();
        return (TResponse)serviceResponse;
    }

    public Mailbox getMailbox() {
        return this.mailbox;
    }

    public void setMailbox(Mailbox mailbox) {
        this.mailbox = mailbox;
    }
}

