/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.azure.blob;

import coldfusion.azure.blob.InvalidURLException;
import coldfusion.cloud.azure.AzureCredential;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.util.RB;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageCredentialsAnonymous;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.core.Utility;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Objects;

public abstract class BlobUtil {
    private static final String ENDPOINT_SUFFIX_NAME = "EndpointSuffix";
    private static final String ACCOUNT_NAME_NAME = "AccountName";
    private static final String DEFAULT_ENDPOINTS_PROTOCOL_NAME = "DefaultEndpointsProtocol";

    static CloudBlobClient authenticate(AzureCredential credentials) {
        try {
            CloudStorageAccount storageAccount;
            String connectionString = credentials.getConnectionString();
            try {
                storageAccount = CloudStorageAccount.parse((String)connectionString);
            }
            catch (Exception e) {
                if (!connectionString.contains("AccountKey=") && !connectionString.contains("SharedAccessSignature=")) {
                    HashMap setting = Utility.parseAccountString((String)connectionString);
                    String endpointSuffix = setting.getOrDefault(ENDPOINT_SUFFIX_NAME, "core.windows.net");
                    String accountName = (String)setting.get(ACCOUNT_NAME_NAME);
                    String protocol = setting.getOrDefault(DEFAULT_ENDPOINTS_PROTOCOL_NAME, "http");
                    if (Objects.isNull(accountName) || accountName.isEmpty()) {
                        throw new ValidationException(RB.getString(BlobUtil.class, (String)"invalidAccountNameInConnectionString"));
                    }
                    storageAccount = new CloudStorageAccount(StorageCredentialsAnonymous.ANONYMOUS, protocol.equalsIgnoreCase("https"), endpointSuffix, accountName);
                }
                throw e;
            }
            return storageAccount.createCloudBlobClient();
        }
        catch (URISyntaxException | InvalidKeyException ex) {
            throw new InvalidURLException();
        }
    }
}

