/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore.impl;

import coldfusion.cloud.gcp.firestore.FirestoreQuery;
import coldfusion.cloud.gcp.firestore.impl.FirestoreDocumentChange;
import coldfusion.cloud.gcp.firestore.impl.FirestoreDocumentSnapshot;
import coldfusion.cloud.gcp.firestore.impl.FirestoreQueryImpl;
import coldfusion.cloud.gcp.firestore.util.FirestoreUtils;
import coldfusion.runtime.Array;
import coldfusion.runtime.OleDateTime;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentChange;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.QuerySnapshot;

public class FirestoreQuerySnapshot {
    private final QuerySnapshot querySnapshot;

    public FirestoreQuerySnapshot(QuerySnapshot querySnapshot) {
        this.querySnapshot = querySnapshot;
    }

    QuerySnapshot getQuerySnapshot() {
        return this.querySnapshot;
    }

    public int size() {
        return this.getQuerySnapshot().size();
    }

    public OleDateTime getReadTime() {
        Timestamp ts = this.getQuerySnapshot().getReadTime();
        return FirestoreUtils.getPrecisedDate(ts);
    }

    public FirestoreQuery getQuery() {
        return new FirestoreQueryImpl(this.getQuerySnapshot().getQuery());
    }

    public Array getDocuments() {
        Array documents = new Array();
        this.getQuerySnapshot().getDocuments().forEach(documentSnapshot -> documents.addElement((Object)new FirestoreDocumentSnapshot((DocumentSnapshot)documentSnapshot)));
        return documents;
    }

    public Array getDocumentChanges() {
        Array documentChanges = new Array();
        this.getQuerySnapshot().getDocumentChanges().forEach(documentChange -> documentChanges.addElement((Object)new FirestoreDocumentChange((DocumentChange)documentChange)));
        return documentChanges;
    }
}

