/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore.impl;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.gcp.firestore.FirestoreQuery;
import coldfusion.cloud.gcp.firestore.codecs.FirestoreSerializer;
import coldfusion.cloud.gcp.firestore.impl.FirestoreDocumentSnapshot;
import coldfusion.cloud.gcp.firestore.impl.FirestoreQuerySnapshot;
import coldfusion.cloud.gcp.firestore.impl.ReferenceGetter;
import coldfusion.cloud.gcp.firestore.pmt.util.GCPFirestoreApis;
import coldfusion.cloud.gcp.firestore.pmt.util.PMTUtilForGCPFirestore;
import coldfusion.cloud.gcp.firestore.util.CallBackExecutor;
import coldfusion.cloud.gcp.firestore.util.FirestoreUtils;
import coldfusion.filter.FusionContext;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.util.RequestMonitorData;
import coldfusion.runtime.Array;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.async.Future;
import coldfusion.util.RB;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.ListenerRegistration;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QuerySnapshot;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class FirestoreQueryImpl
implements FirestoreQuery {
    private final Query query;
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)CloudServiceName.FIRESTORE.name());

    public FirestoreQueryImpl(Query query) {
        this.query = query;
    }

    Query getQuery() {
        return this.query;
    }

    @Override
    public FirestoreQuery select(String ... paths) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.select, this.tagAttributeList);
        String status = "Success";
        try {
            if (Objects.isNull(paths)) {
                throw new ValidationException(RB.getString(FirestoreQueryImpl.class, (String)"FILTER_VALUE_NULL", (Object)"select"));
            }
            ArrayList<FieldPath> fieldPaths = new ArrayList<FieldPath>();
            for (String fieldPath : paths) {
                fieldPaths.add(FirestoreUtils.stringToFieldPath(fieldPath));
            }
            FieldPath[] arrayOfFieldPaths = fieldPaths.toArray(new FieldPath[fieldPaths.size()]);
            FirestoreQueryImpl firestoreQueryImpl = new FirestoreQueryImpl(this.query.select(arrayOfFieldPaths));
            return firestoreQueryImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.select, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery whereArrayContains(String path, Object value) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.whereArrayContains, this.tagAttributeList);
        String status = "Success";
        try {
            FieldPath fieldPath = FirestoreUtils.stringToFieldPath(path);
            FirestoreQueryImpl firestoreQueryImpl = new FirestoreQueryImpl(this.query.whereArrayContains(fieldPath, FirestoreSerializer.serializeCFTypes(value)));
            return firestoreQueryImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.whereArrayContains, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery whereArrayContainsAny(String path, Array values) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.whereArrayContainsAny, this.tagAttributeList);
        String status = "Success";
        try {
            if (Objects.isNull(values)) {
                throw new ValidationException(RB.getString(FirestoreQueryImpl.class, (String)"FILTER_VALUE_NULL", (Object)"whereArrayContainsAny"));
            }
            FieldPath fieldPath = FirestoreUtils.stringToFieldPath(path);
            FirestoreQueryImpl firestoreQueryImpl = new FirestoreQueryImpl(this.query.whereArrayContainsAny(fieldPath, FirestoreSerializer.serializeList((List<Object>)values)));
            return firestoreQueryImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.whereArrayContainsAny, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery whereEqualTo(String path, Object value) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.whereEqualTo, this.tagAttributeList);
        String status = "Success";
        try {
            FieldPath fieldPath = FirestoreUtils.stringToFieldPath(path);
            FirestoreQueryImpl firestoreQueryImpl = new FirestoreQueryImpl(this.query.whereEqualTo(fieldPath, FirestoreSerializer.serializeCFTypes(value)));
            return firestoreQueryImpl;
        }
        catch (RuntimeException e) {
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.whereEqualTo, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery whereGreaterThan(String path, Object value) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.whereGreaterThan, this.tagAttributeList);
        String status = "Success";
        try {
            FieldPath fieldPath = FirestoreUtils.stringToFieldPath(path);
            FirestoreQueryImpl firestoreQueryImpl = new FirestoreQueryImpl(this.query.whereGreaterThan(fieldPath, FirestoreSerializer.serializeCFTypes(value)));
            return firestoreQueryImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.whereGreaterThan, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery whereGreaterThanOrEqualTo(String path, Object value) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.whereGreaterThanOrEqualTo, this.tagAttributeList);
        String status = "Success";
        try {
            FieldPath fieldPath = FirestoreUtils.stringToFieldPath(path);
            FirestoreQueryImpl firestoreQueryImpl = new FirestoreQueryImpl(this.query.whereGreaterThanOrEqualTo(fieldPath, FirestoreSerializer.serializeCFTypes(value)));
            return firestoreQueryImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.whereGreaterThanOrEqualTo, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery whereLessThan(String path, Object value) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.whereLessThan, this.tagAttributeList);
        String status = "Success";
        try {
            FieldPath fieldPath = FirestoreUtils.stringToFieldPath(path);
            FirestoreQueryImpl firestoreQueryImpl = new FirestoreQueryImpl(this.query.whereLessThan(fieldPath, FirestoreSerializer.serializeCFTypes(value)));
            return firestoreQueryImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.whereLessThan, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery whereLessThanOrEqualTo(String path, Object value) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.whereLessThanOrEqualTo, this.tagAttributeList);
        String status = "Success";
        try {
            FieldPath fieldPath = FirestoreUtils.stringToFieldPath(path);
            FirestoreQueryImpl firestoreQueryImpl = new FirestoreQueryImpl(this.query.whereLessThanOrEqualTo(fieldPath, FirestoreSerializer.serializeCFTypes(value)));
            return firestoreQueryImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.whereLessThanOrEqualTo, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery whereIn(String path, Array values) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.whereIn, this.tagAttributeList);
        String status = "Success";
        try {
            if (Objects.isNull(values)) {
                throw new ValidationException(RB.getString(FirestoreQueryImpl.class, (String)"FILTER_VALUE_NULL", (Object)"whereIn"));
            }
            FieldPath fieldPath = FirestoreUtils.stringToFieldPath(path);
            FirestoreQueryImpl firestoreQueryImpl = new FirestoreQueryImpl(this.query.whereIn(fieldPath, FirestoreSerializer.serializeList((List<Object>)values)));
            return firestoreQueryImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.whereIn, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery whereNotEqualTo(String path, Object value) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.whereNotEqualTo, this.tagAttributeList);
        String status = "Success";
        try {
            FieldPath fieldPath = FirestoreUtils.stringToFieldPath(path);
            FirestoreQueryImpl firestoreQueryImpl = new FirestoreQueryImpl(this.query.whereNotEqualTo(fieldPath, FirestoreSerializer.serializeCFTypes(value)));
            return firestoreQueryImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.whereNotEqualTo, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery whereNotIn(String path, Array values) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.whereNotIn, this.tagAttributeList);
        String status = "Success";
        try {
            if (Objects.isNull(values)) {
                status = "Failure";
                throw new ValidationException(RB.getString(FirestoreQueryImpl.class, (String)"FILTER_VALUE_NULL", (Object)"whereNotIn"));
            }
            FieldPath fieldPath = FirestoreUtils.stringToFieldPath(path);
            FirestoreQueryImpl firestoreQueryImpl = new FirestoreQueryImpl(this.query.whereNotIn(fieldPath, FirestoreSerializer.serializeList((List<Object>)values)));
            return firestoreQueryImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.whereNotIn, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery orderBy(String path) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.orderBy, this.tagAttributeList);
        String status = "Success";
        try {
            FirestoreQuery firestoreQuery = this.orderBy(path, Query.Direction.ASCENDING.name());
            return firestoreQuery;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.orderBy, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery orderBy(String path, String direction) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.orderBy, this.tagAttributeList);
        String status = "Success";
        try {
            Query.Direction directionType = Query.Direction.valueOf((String)direction.toUpperCase());
            FieldPath fieldPath = FirestoreUtils.stringToFieldPath(path);
            FirestoreQueryImpl firestoreQueryImpl = new FirestoreQueryImpl(this.query.orderBy(fieldPath, directionType));
            return firestoreQueryImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.orderBy, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public Future runQuery() {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.runQuery, this.tagAttributeList);
        String status = "Success";
        try {
            Future future = new Future((java.util.concurrent.Future)this.query.get(), FirestoreUtils.getQuerySnapshotStruct());
            return future;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.runQuery, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("get", status));
        }
    }

    @Override
    public FirestoreQuery startAt(Object value) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.startAt, this.tagAttributeList);
        String status = "Success";
        try {
            FirestoreQuery firestoreQuery = this.cursorSeggregation(value, "startAt", list -> new FirestoreQueryImpl(this.query.startAt(list)), snapshot -> new FirestoreQueryImpl(this.query.startAt(snapshot)));
            return firestoreQuery;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.startAt, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery startAfter(Object value) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.startAfter, this.tagAttributeList);
        String status = "Success";
        try {
            FirestoreQuery firestoreQuery = this.cursorSeggregation(value, "startAfter", list -> new FirestoreQueryImpl(this.query.startAfter(list)), snapshot -> new FirestoreQueryImpl(this.query.startAfter(snapshot)));
            return firestoreQuery;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.startAfter, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery endAt(Object value) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.endAt, this.tagAttributeList);
        String status = "Success";
        try {
            FirestoreQuery firestoreQuery = this.cursorSeggregation(value, "endAt", list -> new FirestoreQueryImpl(this.query.endAt(list)), snapshot -> new FirestoreQueryImpl(this.query.endAt(snapshot)));
            return firestoreQuery;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.endAt, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery endBefore(Object value) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.endBefore, this.tagAttributeList);
        String status = "Success";
        try {
            FirestoreQuery firestoreQuery = this.cursorSeggregation(value, "endBefore", list -> new FirestoreQueryImpl(this.query.endBefore(list)), snapshot -> new FirestoreQueryImpl(this.query.endBefore(snapshot)));
            return firestoreQuery;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.endBefore, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    private FirestoreQuery cursorSeggregation(Object value, String cursorType, Function<Object[], FirestoreQuery> listFunction, Function<DocumentSnapshot, FirestoreQuery> snapshotFunction) {
        if (value instanceof Array) {
            return listFunction.apply(FirestoreSerializer.serializeList((List<Object>)((Array)value)).toArray());
        }
        if (value instanceof FirestoreDocumentSnapshot) {
            return snapshotFunction.apply(ReferenceGetter.getDocumentSnapshot((FirestoreDocumentSnapshot)value));
        }
        throw new ValidationException(RB.getString(FirestoreQueryImpl.class, (String)"INVALID_CURSOR_VALUE", (Object)cursorType));
    }

    @Override
    public FirestoreQuery limit(int limit) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.limit, this.tagAttributeList);
        String status = "Success";
        try {
            FirestoreQueryImpl firestoreQueryImpl = new FirestoreQueryImpl(this.query.limit(limit));
            return firestoreQueryImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.limit, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery limitToLast(int limit) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.limitToLast, this.tagAttributeList);
        String status = "Success";
        try {
            FirestoreQueryImpl firestoreQueryImpl = new FirestoreQueryImpl(this.query.limitToLast(limit));
            return firestoreQueryImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.limitToLast, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public FirestoreQuery offset(int offset) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.offset, this.tagAttributeList);
        String status = "Success";
        try {
            FirestoreQueryImpl firestoreQueryImpl = new FirestoreQueryImpl(this.query.offset(offset));
            return firestoreQueryImpl;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.offset, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap(status));
        }
    }

    @Override
    public ListenerRegistration addSnapshotListener(UDFMethod onSuccess, UDFMethod onFailure) {
        TagAttributeList tempAttributeList = PMTUtilForGCPFirestore.startGCPStorageMonitoring(GCPFirestoreApis.addSnapshotListener, this.tagAttributeList);
        String status = "Success";
        try {
            if (Objects.isNull(onSuccess)) {
                throw new ValidationException(RB.getString(FirestoreQueryImpl.class, (String)"SUCCESS_METHOD_NULL"));
            }
            if (Objects.isNull(onFailure)) {
                throw new ValidationException(RB.getString(FirestoreQueryImpl.class, (String)"FAILURE_METHOD_NULL"));
            }
            CallBackExecutor successHandler = new CallBackExecutor(onSuccess, FusionContext.getCurrent(), FusionContext.getCurrent().pageContext, RequestMonitorData.getCurrent());
            CallBackExecutor failureHandler = new CallBackExecutor(onFailure, FusionContext.getCurrent(), FusionContext.getCurrent().pageContext, RequestMonitorData.getCurrent());
            ListenerRegistration listenerRegistration = this.query.addSnapshotListener((querySnapshot, firestoreException) -> {
                Object[] args = new Object[1];
                if (querySnapshot != null) {
                    args[0] = new FirestoreQuerySnapshot((QuerySnapshot)querySnapshot);
                    successHandler.execute(args);
                } else if (firestoreException != null) {
                    args[0] = FirestoreUtils.HandleFirestoreException(firestoreException.getMessage(), (Throwable)firestoreException);
                    failureHandler.execute(args);
                }
            });
            return listenerRegistration;
        }
        catch (RuntimeException e) {
            status = "Failure";
            throw FirestoreUtils.HandleFirestoreException(e.getMessage(), e);
        }
        finally {
            PMTUtilForGCPFirestore.endGCPStorageMonitoring(GCPFirestoreApis.addSnapshotListener, tempAttributeList, PMTUtilForGCPFirestore.getMonitoringResponseMap("get", status));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FirestoreQueryImpl) {
            return this.query.equals((Object)((FirestoreQueryImpl)obj).query);
        }
        return false;
    }
}

