/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore.config;

import coldfusion.cloud.Executor;
import coldfusion.cloud.gcp.config.ChannelProviderBuilder;
import coldfusion.cloud.gcp.config.ChannelProviderType;
import coldfusion.cloud.gcp.config.GrpcChannelProvider;
import coldfusion.cloud.gcp.config.RetrySettingsBuilder;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.ServiceOptions;
import java.util.Objects;
import org.threeten.bp.Duration;

public class ConfigUtil {
    static RetrySettings buildRetrySettings(RetrySettingsBuilder retrySettingsRequest) {
        java.time.Duration duration;
        RetrySettings.Builder retrySettingsBuilder = ServiceOptions.getDefaultRetrySettings().toBuilder();
        if (retrySettingsRequest.getTotalTimeout() != null) {
            duration = retrySettingsRequest.getTotalTimeout();
            retrySettingsBuilder.setTotalTimeout(Duration.ofSeconds((long)duration.getSeconds(), (long)duration.getNano()));
        }
        if (retrySettingsRequest.getInitialRetryDelay() != null) {
            duration = retrySettingsRequest.getInitialRetryDelay();
            retrySettingsBuilder.setInitialRetryDelay(Duration.ofSeconds((long)duration.getSeconds(), (long)duration.getNano()));
        }
        if (retrySettingsRequest.getRetryDelayMultiplier() != null) {
            retrySettingsBuilder.setRetryDelayMultiplier(retrySettingsRequest.getRetryDelayMultiplier().doubleValue());
        }
        if (retrySettingsRequest.getMaxRetryDelay() != null) {
            duration = retrySettingsRequest.getMaxRetryDelay();
            retrySettingsBuilder.setMaxRetryDelay(Duration.ofSeconds((long)duration.getSeconds(), (long)duration.getNano()));
        }
        if (retrySettingsRequest.getMaxAttempts() != null) {
            retrySettingsBuilder.setMaxAttempts(retrySettingsRequest.getMaxAttempts().intValue());
        }
        if (retrySettingsRequest.getInitialRpcTimeout() != null) {
            duration = retrySettingsRequest.getInitialRpcTimeout();
            retrySettingsBuilder.setInitialRpcTimeout(Duration.ofSeconds((long)duration.getSeconds(), (long)duration.getNano()));
        }
        if (retrySettingsRequest.getRpcTimeoutMultiplier() != null) {
            retrySettingsBuilder.setRpcTimeoutMultiplier(retrySettingsRequest.getRpcTimeoutMultiplier().doubleValue());
        }
        if (retrySettingsRequest.getMaxRpcTimeout() != null) {
            duration = retrySettingsRequest.getMaxRpcTimeout();
            retrySettingsBuilder.setMaxRpcTimeout(Duration.ofSeconds((long)duration.getSeconds(), (long)duration.getNano()));
        }
        return retrySettingsBuilder.build();
    }

    static TransportChannelProvider buildChannelProvider(ChannelProviderBuilder channelProviderBuilder) {
        switch ((ChannelProviderType)channelProviderBuilder.getType()) {
            case GRPC: {
                return ConfigUtil.buildGrpcProvider((GrpcChannelProvider)channelProviderBuilder);
            }
        }
        return ConfigUtil.buildGrpcProvider((GrpcChannelProvider)channelProviderBuilder);
    }

    private static TransportChannelProvider buildGrpcProvider(GrpcChannelProvider channelProviderBuilder) {
        java.time.Duration keepAliveTime;
        InstantiatingGrpcChannelProvider.Builder builder = InstantiatingGrpcChannelProvider.newBuilder();
        builder.setMaxInboundMessageSize(channelProviderBuilder.getMaxInboundMessageSize());
        builder.setKeepAliveWithoutCalls(channelProviderBuilder.isKeepAliveWithoutCalls());
        java.time.Duration keepAliveTimeout = channelProviderBuilder.getKeepAliveTimeout();
        if (Objects.nonNull(keepAliveTimeout)) {
            builder.setKeepAliveTimeout(Duration.ofSeconds((long)keepAliveTimeout.getSeconds(), (long)keepAliveTimeout.getNano()));
        }
        if (Objects.nonNull(keepAliveTime = channelProviderBuilder.getKeepAliveTime())) {
            builder.setKeepAliveTime(Duration.ofSeconds((long)keepAliveTime.getSeconds(), (long)keepAliveTime.getNano()));
        }
        builder.setExecutor((java.util.concurrent.Executor)Executor.getInstance());
        return builder.build();
    }
}

