/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import coldfusion.log.CFLogs;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRSubreportRunResult;
import net.sf.jasperreports.engine.fill.JRSubreportRunnable;
import net.sf.jasperreports.engine.fill.JRSubreportRunner;

public class JRThreadSubreportRunner
extends JRSubreportRunnable
implements JRSubreportRunner {
    private final JRFillSubreport fillSubreport;
    private final JRBaseFiller subreportFiller;
    private Thread fillThread;
    private long waitTimeOut = 0L;
    private static boolean waitLogged = false;
    private final String timeoutKey = "coldfusion.jasper.waittimeout";

    public JRThreadSubreportRunner(JRFillSubreport fillSubreport, JRBaseFiller subreportFiller) {
        super(fillSubreport, subreportFiller);
        this.fillSubreport = fillSubreport;
        try {
            String timeoutProp = System.getProperty("coldfusion.jasper.waittimeout");
            if (timeoutProp != null && timeoutProp.length() > 0) {
                this.waitTimeOut = Long.parseLong(timeoutProp);
            }
            if (!waitLogged) {
                CFLogs.REPORT_LOG.debug((Object)("The Thread timeout defined for " + this.waitTimeOut + " . All the thread should timeout from wait state after waiting for this much time."));
                waitLogged = true;
            }
        }
        catch (NumberFormatException e) {
            CFLogs.REPORT_LOG.error((Object)"There was an error applying wait timeout. There will be no timeout on wait for sub rerpot threads.", (Throwable)e);
        }
        this.subreportFiller = subreportFiller;
    }

    @Override
    public boolean isFilling() {
        return this.fillThread != null;
    }

    @Override
    public JRSubreportRunResult start() {
        this.fillThread = new Thread((Runnable)this, this.subreportFiller.getJasperReport().getName() + " subreport filler");
        CFLogs.REPORT_LOG.debug((Object)("Sub Report Filler Thread  " + this.fillThread.getId() + " initialized. "));
        this.fillThread.start();
        return this.waitResult();
    }

    @Override
    public JRSubreportRunResult resume() {
        CFLogs.REPORT_LOG.debug((Object)("Sub Report Filler Thread  " + this.fillThread.getId() + " is Resuming to continue on next page. "));
        this.subreportFiller.notifyAll();
        return this.waitResult();
    }

    protected JRSubreportRunResult waitResult() {
        try {
            this.subreportFiller.wait();
        }
        catch (InterruptedException e) {
            CFLogs.REPORT_LOG.debug((Object)("Error encountered while waiting on the report filling thread " + this.fillThread.getId() + " ."));
            throw new JRRuntimeException("Error encountered while waiting on the report filling thread.", e);
        }
        return this.runResult();
    }

    @Override
    public void reset() {
        this.fillThread = null;
    }

    @Override
    public void cancel() throws JRException {
        this.subreportFiller.notifyAll();
        if (this.isRunning()) {
            try {
                this.subreportFiller.wait();
            }
            catch (InterruptedException e) {
                CFLogs.REPORT_LOG.debug((Object)("Error encountered while waiting on the report filling thread " + this.fillThread.getId() + " . "));
                throw new JRException("Error encountered while waiting on the subreport filling thread.", e);
            }
        }
    }

    @Override
    public void suspend() throws JRException {
        CFLogs.REPORT_LOG.debug((Object)("Sub Report Filler Thread  " + this.fillThread.getId() + " has finshed and notifying to master to continue. "));
        this.subreportFiller.notifyAll();
        try {
            CFLogs.REPORT_LOG.debug((Object)("Sub Report Filler Thread  " + this.fillThread.getId() + " is wating for notification to continue on next page. "));
            this.subreportFiller.wait(this.waitTimeOut);
        }
        catch (InterruptedException e) {
            CFLogs.REPORT_LOG.debug((Object)("Error encountered while waiting on the report filling thread " + this.fillThread.getId() + ". "));
            throw new JRException("Error encountered while waiting on the subreport filling thread.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CFLogs.REPORT_LOG.debug((Object)("Sub Report Filler Thread  " + this.fillThread.getId() + " is going to start."));
        super.run();
        JRBaseFiller jRBaseFiller = this.subreportFiller;
        synchronized (jRBaseFiller) {
            CFLogs.REPORT_LOG.debug((Object)("Sub Report Filler Thread  " + this.fillThread.getId() + " is notifying to master to continue. "));
            this.subreportFiller.notifyAll();
        }
    }
}

