/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.HashSet;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.DistinctCountHolder;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;

class JRDistinctCountExtendedIncrementer
extends JRAbstractExtendedIncrementer {
    private DistinctCountHolder lastHolder = new DistinctCountHolder();

    @Override
    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        DistinctCountHolder holder = (DistinctCountHolder)variable.getIncrementedValue();
        if (holder == null) {
            holder = this.lastHolder;
        } else {
            this.lastHolder = holder;
        }
        holder.addLastValue();
        return new DistinctCountHolder(holder, expressionValue);
    }

    @Override
    public Object combine(JRCalculable calculable1, JRCalculable calculable2, AbstractValueProvider valueProvider) {
        DistinctCountHolder holder2;
        HashSet<Object> distinctValues = new HashSet<Object>();
        DistinctCountHolder holder1 = (DistinctCountHolder)calculable1.getValue();
        if (holder1 != null) {
            distinctValues.addAll(holder1.getDistinctValues());
            if (holder1.getLastValue() != null) {
                distinctValues.add(holder1.getLastValue());
            }
        }
        if ((holder2 = (DistinctCountHolder)calculable2.getValue()) != null) {
            distinctValues.addAll(holder2.getDistinctValues());
            if (holder2.getLastValue() != null) {
                distinctValues.add(holder2.getLastValue());
            }
        }
        return new DistinctCountHolder(distinctValues);
    }

    @Override
    public Object initialValue(JRCalculable variable) {
        return null;
    }
}

