/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRAbstractMultiClassCompiler;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRJavacCompiler;
import net.sf.jasperreports.engine.design.JRJdk12Compiler;
import net.sf.jasperreports.engine.design.JRJdk13Compiler;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRProperties;

public final class JRDefaultCompiler
implements JRCompiler {
    private static final JRDefaultCompiler instance = new JRDefaultCompiler();

    private JRDefaultCompiler() {
    }

    public static JRDefaultCompiler getInstance() {
        return instance;
    }

    @Override
    public JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        JRCompiler jrCompiler = null;
        String compiler = JRProperties.getProperty("net.sf.jasperreports.compiler.class");
        if (compiler == null || compiler.trim().length() == 0) {
            jrCompiler = JRDefaultCompiler.getJavaCompiler();
        } else {
            try {
                Class clazz = JRClassLoader.loadClassForName(compiler);
                jrCompiler = (JRCompiler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new JRException("Could not instantiate report compiler : " + compiler, e);
            }
        }
        return jrCompiler.compileReport(jasperDesign);
    }

    private static JRCompiler getJavaCompiler() {
        JRAbstractMultiClassCompiler compiler = null;
        if (compiler == null) {
            try {
                JRClassLoader.loadClassForName("com.sun.tools.javac.Main");
                compiler = new JRJdk13Compiler();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (compiler == null) {
            try {
                JRClassLoader.loadClassForName("sun.tools.javac.Main");
                compiler = new JRJdk12Compiler();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (compiler == null) {
            compiler = new JRJavacCompiler();
        }
        return compiler;
    }

    private static JRCompiler getCompiler(JasperReport jasperReport) throws JRException {
        JRCompiler compiler = null;
        String compilerClassName = jasperReport.getCompilerClass();
        Class<?> compilerClass = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                compilerClass = classLoader.loadClass(compilerClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (compilerClass == null) {
            classLoader = JRDefaultCompiler.class.getClassLoader();
            try {
                compilerClass = classLoader == null ? Class.forName(compilerClassName) : classLoader.loadClass(compilerClassName);
            }
            catch (ClassNotFoundException e) {
                throw new JRException("Report compiler class not found : " + compilerClassName);
            }
        }
        try {
            compiler = (JRCompiler)compilerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new JRException("Could not instantiate report compiler : " + compilerClassName, e);
        }
        return compiler;
    }

    @Override
    public JREvaluator loadEvaluator(JasperReport jasperReport, JRDataset dataset) throws JRException {
        JRCompiler compiler = JRDefaultCompiler.getCompiler(jasperReport);
        return compiler.loadEvaluator(jasperReport, dataset);
    }

    @Override
    public JREvaluator loadEvaluator(JasperReport jasperReport, JRCrosstab crosstab) throws JRException {
        JRCompiler compiler = JRDefaultCompiler.getCompiler(jasperReport);
        return compiler.loadEvaluator(jasperReport, crosstab);
    }

    @Override
    public JREvaluator loadEvaluator(JasperReport jasperReport) throws JRException {
        return this.loadEvaluator(jasperReport, jasperReport.getMainDataset());
    }
}

