/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut.trace;

import com.adobe.xfa.ut.trace.TraceHandler;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public final class TraceTimer {
    private final TraceHandler.TimingType meType;
    private long mnStart;
    private static final boolean gUseCpuTime;
    private static final ThreadMXBean gBean;

    public TraceTimer(TraceHandler.TimingType eType) {
        this.meType = eType;
        if (TraceHandler.timingTraceEnabled()) {
            this.doStartTimer();
        }
    }

    public void startTiming() {
        if (TraceHandler.timingTraceEnabled()) {
            this.doStartTimer();
        }
    }

    public void stopTiming() {
        if (TraceHandler.timingTraceEnabled()) {
            this.doStopTimer();
        }
    }

    private void doStartTimer() {
        assert (this.mnStart == 0L);
        this.mnStart = TraceTimer.getNanos();
    }

    private void doStopTimer() {
        if (this.mnStart != 0L) {
            TraceHandler.addTimerNanos(this.meType, TraceTimer.getNanos() - this.mnStart);
            this.mnStart = 0L;
        }
    }

    private static long getNanos() {
        return gUseCpuTime ? gBean.getCurrentThreadCpuTime() : System.nanoTime();
    }

    static {
        boolean useCpuTime;
        boolean bl = useCpuTime = System.getProperty("test.use.cputime") != null;
        if (useCpuTime) {
            gBean = ManagementFactory.getThreadMXBean();
            if (!gBean.isCurrentThreadCpuTimeSupported()) {
                useCpuTime = false;
            }
        } else {
            gBean = null;
        }
        gUseCpuTime = useCpuTime;
    }
}

