/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import java.io.Serializable;
import java.util.Comparator;

public final class StringUtils {
    public static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = String.CASE_INSENSITIVE_ORDER;
    public static final Comparator<String> UCS_CODEPOINT_COMPARATOR = new CodePointComparator();
    public static final String WHITE_SPACE = " \t\n\r\u00a0\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u200b\u3000\ufeff";
    private static final char[] hexdigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean equalsWithNull(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static int findNoCase(CharSequence source, CharSequence target, int fromIndex) {
        if (fromIndex >= source.length()) {
            return target.length() == 0 ? source.length() : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (target.length() == 0) {
            return fromIndex;
        }
        char first = StringUtils.asciiToLower(target.charAt(0));
        int max = source.length() - target.length();
        for (int i = fromIndex; i <= max; ++i) {
            char c2;
            char c1;
            char c;
            while (i <= max && (c = source.charAt(i)) != first && StringUtils.asciiToLower(c) != first) {
                ++i;
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + target.length() - 1;
            int k = 1;
            while (j < end && ((c1 = source.charAt(j)) == (c2 = target.charAt(k)) || StringUtils.asciiToLower(c1) == StringUtils.asciiToLower(c2))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    private static char asciiToLower(char c) {
        if ('@' < c && c < '[') {
            c = (char)(c + 32);
        }
        return c;
    }

    public static Comparator<String> getCaseInsensitiveComparator() {
        return CASE_INSENSITIVE_COMPARATOR;
    }

    public static boolean isEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static Integer number(String s) {
        return StringUtils.number(s, 10);
    }

    public static Integer number(String s, int radix) {
        try {
            return Integer.parseInt(s, radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long longNumber(String s) {
        return StringUtils.longNumber(s, 10);
    }

    public static Long longNumber(String s, int radix) {
        try {
            return Long.parseLong(s, radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String parseToken(StringBuilder source) {
        int i;
        for (i = 0; i < source.length() && WHITE_SPACE.indexOf(source.charAt(i)) >= 0; ++i) {
        }
        if (i == source.length()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean quoted = false;
        boolean backslashPending = false;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (!quoted && WHITE_SPACE.indexOf(c) >= 0) break;
            boolean process = false;
            if (c != '\\' && c != '\"') {
                process = true;
            } else if (quoted && c == '\\') {
                backslashPending = true;
            } else if (c == '\"') {
                if (backslashPending) {
                    backslashPending = false;
                    process = true;
                } else {
                    quoted = !quoted;
                }
            } else {
                process = true;
            }
            if (process) {
                if (backslashPending) {
                    result.append('\\');
                    backslashPending = false;
                }
                result.append(c);
            }
            ++i;
        }
        source.delete(0, i);
        return result.toString();
    }

    public static void replace(StringBuilder buf, char find, char rep) {
        StringUtils.replace(buf, find, rep, 0, buf.length());
    }

    public static void replace(StringBuilder buf, char find, char rep, int start, int limit) {
        for (int i = start; i < limit; ++i) {
            if (buf.charAt(i) != find) continue;
            buf.setCharAt(i, rep);
        }
    }

    public static int safeNumber(String s) {
        return StringUtils.safeNumber(s, 10);
    }

    public static int safeNumber(String s, int radix) {
        Integer num = StringUtils.number(s, radix);
        return num == null ? 0 : num;
    }

    public static long safeLongNumber(String s) {
        return StringUtils.safeLongNumber(s, 10);
    }

    public static long safeLongNumber(String s, int radix) {
        Long num = StringUtils.longNumber(s, radix);
        return num == null ? 0L : num;
    }

    public static int skipOver(CharSequence src, String sSkip, int nOffset) {
        int nCharsSkipped = nOffset;
        while (nCharsSkipped < src.length()) {
            int i = nCharsSkipped;
            if (sSkip.indexOf(src.charAt(i++)) == -1) break;
            nCharsSkipped = i;
        }
        return nCharsSkipped - nOffset;
    }

    public static int skipUntil(CharSequence src, String sSkip, int nOffset) {
        int nCharsSkipped = nOffset;
        while (nCharsSkipped < src.length()) {
            int i = nCharsSkipped;
            if (sSkip.indexOf(src.charAt(i++)) != -1) break;
            nCharsSkipped = i;
        }
        return nCharsSkipped - nOffset;
    }

    public static void trim(StringBuilder buf) {
        int trunc;
        for (trunc = buf.length(); trunc > 0 && Character.isWhitespace(buf.charAt(trunc - 1)); --trunc) {
        }
        buf.delete(trunc, buf.length());
    }

    public static void trimStart(StringBuilder buf) {
        int start;
        for (start = 0; start < buf.length() && Character.isWhitespace(buf.charAt(start)); ++start) {
        }
        buf.delete(0, start);
    }

    public static String trim(String s) {
        int length;
        int endIndex;
        for (endIndex = length = s.length(); endIndex > 0 && Character.isWhitespace(s.charAt(endIndex - 1)); --endIndex) {
        }
        return endIndex < length ? s.substring(0, endIndex) : s;
    }

    public static String trimStart(String s) {
        int startIndex;
        int length = s.length();
        for (startIndex = 0; startIndex < length && Character.isWhitespace(s.charAt(startIndex)); ++startIndex) {
        }
        return startIndex > 0 ? s.substring(startIndex, length) : s;
    }

    public static String toXML(String src, boolean isAttribute) {
        int length = src.length();
        int needsEncoding = 0;
        for (int i = 0; i < length; ++i) {
            char c = src.charAt(i);
            if (c == '&') {
                if (StringUtils.isValidEntityReference(src, i)) {
                    i = src.indexOf(59, i);
                    continue;
                }
                ++needsEncoding;
                continue;
            }
            if (isAttribute) {
                if (c != '<' && c != '\"' && c != '\t' && c != '\n' && c != '\r') continue;
                ++needsEncoding;
                continue;
            }
            if (c != '<' && c != '>' && c != '\r') continue;
            ++needsEncoding;
        }
        if (needsEncoding == 0) {
            return src;
        }
        StringBuilder result = new StringBuilder(length + needsEncoding * 5);
        block10: for (int i = 0; i < length; ++i) {
            char c = src.charAt(i);
            switch (c) {
                case '&': {
                    result.append("&amp;");
                    continue block10;
                }
                case '<': {
                    result.append("&lt;");
                    continue block10;
                }
                case '>': {
                    if (isAttribute) {
                        result.append(c);
                        continue block10;
                    }
                    result.append("&gt;");
                    continue block10;
                }
                case '\"': {
                    if (isAttribute) {
                        result.append("&quot;");
                        continue block10;
                    }
                    result.append(c);
                    continue block10;
                }
                case '\r': {
                    result.append("&#xD;");
                    continue block10;
                }
                case '\n': {
                    if (isAttribute) {
                        result.append("&#xA;");
                        continue block10;
                    }
                    result.append(c);
                    continue block10;
                }
                case '\t': {
                    if (isAttribute) {
                        result.append("&#x9;");
                        continue block10;
                    }
                    result.append(c);
                    continue block10;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String toXML(String sSrc, ToXMLType eTargetType, String sOthers, char cRangeMin, char cRangeMax, String sExclude) {
        int range = 0;
        if (cRangeMin != '\u0000' && cRangeMax != '\u0000') {
            range = 3;
        } else if (cRangeMin != '\u0000' && cRangeMax == '\u0000') {
            range = 2;
        } else if (cRangeMin == '\u0000' && cRangeMax != '\u0000') {
            range = 1;
        }
        boolean bHasInvalidChar = false;
        int nNeedsEncoding = 0;
        int nLen = sSrc.length();
        int i = 0;
        block0: while (i < nLen) {
            char chr;
            if ((chr = sSrc.charAt(i++)) == '&' || chr == '<' || chr == '\r') {
                ++nNeedsEncoding;
                continue;
            }
            if (chr == '>' && eTargetType == ToXMLType.XMLTEXT) {
                ++nNeedsEncoding;
                continue;
            }
            if ((chr == '\t' || chr == '\n') && eTargetType != ToXMLType.XMLTEXT) {
                ++nNeedsEncoding;
                continue;
            }
            if (chr == '\"' && eTargetType == ToXMLType.XMLATTRIBUTE_WITH_DQUOTE) {
                ++nNeedsEncoding;
                continue;
            }
            if (chr == '\'' && eTargetType == ToXMLType.XMLATTRIBUTE_WITH_QUOTE) {
                ++nNeedsEncoding;
                continue;
            }
            if (range == 1 && chr <= cRangeMax) {
                ++nNeedsEncoding;
                continue;
            }
            if (range == 2 && cRangeMin <= chr) {
                ++nNeedsEncoding;
                continue;
            }
            if (range == 3 && cRangeMin <= chr && chr <= cRangeMax) {
                ++nNeedsEncoding;
                continue;
            }
            if (chr < ' ' && chr != '\t' && chr != '\n' && chr != '\r' || '\ud7ff' < chr && chr < '\ue000' || '\ufffd' < chr && chr < '\u10000' || chr > '\u10ffff') {
                bHasInvalidChar = true;
                continue;
            }
            int j = 0;
            while (j < sOthers.length()) {
                if (chr != sOthers.charAt(j++)) continue;
                ++nNeedsEncoding;
                continue block0;
            }
        }
        if (nNeedsEncoding > 0 || bHasInvalidChar) {
            StringBuilder retStr = new StringBuilder(nLen + nNeedsEncoding * 12);
            int i2 = 0;
            while (i2 < nLen) {
                char chr = sSrc.charAt(i2++);
                boolean bExcluded = false;
                int j = 0;
                while (j < sExclude.length()) {
                    if (chr != sExclude.charAt(j++)) continue;
                    retStr.append(chr);
                    bExcluded = true;
                    break;
                }
                if (bExcluded || bHasInvalidChar && (chr < ' ' && chr != '\t' && chr != '\n' && chr != '\r' || '\ud7ff' < chr && chr < '\ue000' || '\ufffd' < chr && chr < '\u10000' || chr > '\u10ffff')) continue;
                if (chr == '<') {
                    retStr.append("&lt;");
                    continue;
                }
                if (chr == '&') {
                    retStr.append("&amp;");
                    continue;
                }
                if (chr == '\r') {
                    retStr.append("&#xD;");
                    continue;
                }
                if (chr == '>' && eTargetType == ToXMLType.XMLTEXT) {
                    retStr.append("&gt;");
                    continue;
                }
                if (chr == '\"' && eTargetType == ToXMLType.XMLATTRIBUTE_WITH_DQUOTE) {
                    retStr.append("&quot;");
                    continue;
                }
                if (chr == '\'' && eTargetType == ToXMLType.XMLATTRIBUTE_WITH_QUOTE) {
                    retStr.append("&apos;");
                    continue;
                }
                if (chr == '\n' && eTargetType != ToXMLType.XMLTEXT) {
                    retStr.append("&#xA;");
                    continue;
                }
                if (chr == '\t' && eTargetType != ToXMLType.XMLTEXT) {
                    retStr.append("&#x9;");
                    continue;
                }
                if (range == 1 && chr <= cRangeMax) {
                    StringUtils.appendHex(retStr, chr);
                    continue;
                }
                if (range == 2 && cRangeMin <= chr) {
                    StringUtils.appendHex(retStr, chr);
                    continue;
                }
                if (range == 3 && cRangeMin <= chr && chr <= cRangeMax) {
                    StringUtils.appendHex(retStr, chr);
                    continue;
                }
                boolean bFound = false;
                int j2 = 0;
                while (j2 < sOthers.length()) {
                    if (chr != sOthers.charAt(j2++)) continue;
                    StringUtils.appendHex(retStr, chr);
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                retStr.append(chr);
            }
            return retStr.toString();
        }
        return sSrc;
    }

    private static void appendHex(StringBuilder srcStr, char srcChr) {
        srcStr.append("&#x");
        char nUCS4 = srcChr;
        if ((nUCS4 & 0xF0000) != 0) {
            srcStr.append(hexdigit[nUCS4 >> 16 & 0xF]);
            srcStr.append(hexdigit[nUCS4 >> 12 & 0xF]);
            srcStr.append(hexdigit[nUCS4 >> 8 & 0xF]);
            srcStr.append(hexdigit[nUCS4 >> 4 & 0xF]);
            srcStr.append(hexdigit[nUCS4 & 0xF]);
        } else if ((nUCS4 & 0xF000) != 0) {
            srcStr.append(hexdigit[nUCS4 >> 12 & 0xF]);
            srcStr.append(hexdigit[nUCS4 >> 8 & 0xF]);
            srcStr.append(hexdigit[nUCS4 >> 4 & 0xF]);
            srcStr.append(hexdigit[nUCS4 & 0xF]);
        } else if ((nUCS4 & 0xF00) != 0) {
            srcStr.append(hexdigit[nUCS4 >> 8 & 0xF]);
            srcStr.append(hexdigit[nUCS4 >> 4 & 0xF]);
            srcStr.append(hexdigit[nUCS4 & 0xF]);
        } else if ((nUCS4 & 0xF0) != 0) {
            srcStr.append(hexdigit[nUCS4 >> 4 & 0xF]);
            srcStr.append(hexdigit[nUCS4 & 0xF]);
        } else {
            srcStr.append(hexdigit[nUCS4 & 0xF]);
        }
        srcStr.append(';');
    }

    public static String toXHTML(String sSrc, boolean bIncludePI) {
        boolean bHasInvalidChar = false;
        int nNeedsEncoding = 0;
        int nLen = sSrc.length();
        int i = 0;
        while (i < nLen) {
            char chr;
            if ((chr = sSrc.charAt(i++)) == '&' || chr == '<' || chr == '\n' || chr == '\r' || chr == '>') {
                ++nNeedsEncoding;
                continue;
            }
            if (!(chr < ' ' && chr != '\t' && chr != '\n' && chr != '\r' || '\ud7ff' < chr && chr < '\ue000' || '\ufffd' < chr && chr < '\u10000') && chr <= '\u10ffff') continue;
            bHasInvalidChar = true;
        }
        int nNewSize = nLen + nNeedsEncoding * 7 + 57;
        if (bIncludePI) {
            nNewSize += 21;
        }
        StringBuilder sRet = new StringBuilder(nNewSize);
        if (bIncludePI) {
            sRet.append("<?xml version=\"1.0\"?>");
        }
        sRet.append("<body xmlns=\"http://www.w3.org/1999/xhtml\"><p>");
        int nSpaceRun = 0;
        int i2 = 0;
        while (i2 < nLen) {
            char chr = sSrc.charAt(i2++);
            if (nSpaceRun > 0 && chr != ' ') {
                sRet.append(' ');
                if (nSpaceRun > 1) {
                    sRet.append("</span>");
                }
                nSpaceRun = 0;
            }
            if (bHasInvalidChar && (chr < ' ' && chr != '\t' && chr != '\n' && chr != '\r' || '\ud7ff' < chr && chr < '\ue000' || '\ufffd' < chr && chr < '\u10000' || chr > '\u10ffff')) continue;
            if (chr == '<') {
                sRet.append("&lt;");
            } else if (chr == '&') {
                sRet.append("&amp;");
            } else if (chr == '\r') {
                sRet.append("&#xD;");
            } else if (chr == '\n') {
                sRet.append("</p><p>");
            } else if (chr == '\t') {
                sRet.append("<span style=\"xfa-tab-count:1\">&#160;</span>");
            } else if (chr == ' ') {
                if (++nSpaceRun == 2) {
                    sRet.append("<span style=\"xfa-spacerun:yes\">");
                }
                if (nSpaceRun >= 2) {
                    sRet.append("&#160;");
                }
            } else if (chr == '>') {
                sRet.append("&gt;");
            } else {
                sRet.append(chr);
            }
            if (nSpaceRun <= 0 || i2 != nLen) continue;
            sRet.append(' ');
            if (nSpaceRun <= 1) continue;
            sRet.append("</span>");
        }
        sRet.append("</p></body>");
        return sRet.toString();
    }

    private static boolean isValidEntityReference(String src, int index) {
        assert (src.charAt(index) == '&');
        int semicolon = src.indexOf(59, index);
        if (semicolon - index >= 3) {
            String entList = "&lt;&gt;&amp;&apos;&quot;";
            String ent = src.substring(index, semicolon);
            if (entList.contains(ent)) {
                return true;
            }
            if (ent.startsWith("&#x")) {
                for (int j = 3; j < ent.length(); ++j) {
                    char h = ent.charAt(j);
                    if ('0' <= h && h <= '9' || 'a' <= h && h <= 'f' || 'A' <= h && h <= 'F') continue;
                    return false;
                }
                return true;
            }
            if (ent.startsWith("&#")) {
                for (int j = 2; j < ent.length(); ++j) {
                    char n = ent.charAt(j);
                    if ('0' <= n && n <= '9') continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private StringUtils() {
    }

    public static enum ToXMLType {
        XMLTEXT,
        XMLATTRIBUTE_WITH_DQUOTE,
        XMLATTRIBUTE_WITH_QUOTE;

    }

    private static class CodePointComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = -8178230179838097500L;

        private CodePointComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int codePoint2;
            int codePoint1;
            int length1 = s1.length();
            int length2 = s2.length();
            int i = 0;
            int j = 0;
            do {
                char low;
                if (i == length1) {
                    return j == length2 ? 0 : -1;
                }
                if (j == length2) {
                    return 1;
                }
                int high = s1.charAt(i);
                ++i;
                if (Character.isHighSurrogate((char)high)) {
                    if (i == length1) {
                        codePoint1 = high;
                    } else {
                        low = s1.charAt(i);
                        if (Character.isLowSurrogate(low)) {
                            codePoint1 = Character.toCodePoint((char)high, low);
                            ++i;
                        } else {
                            codePoint1 = high;
                        }
                    }
                } else {
                    codePoint1 = high;
                }
                high = s2.charAt(j);
                ++j;
                if (Character.isHighSurrogate((char)high)) {
                    if (j == length1) {
                        codePoint2 = high;
                        continue;
                    }
                    low = s2.charAt(j);
                    if (Character.isLowSurrogate(low)) {
                        codePoint2 = Character.toCodePoint((char)high, low);
                        ++j;
                        continue;
                    }
                    codePoint2 = high;
                    continue;
                }
                codePoint2 = high;
            } while (codePoint1 == codePoint2);
            return codePoint1 - codePoint2;
        }
    }
}

