/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.ResourceLoader;
import com.adobe.xfa.ut.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class MsgFormat {
    private int mnResId;
    private int mnSourceIndex;
    private final List<String> moParms = new ArrayList<String>();
    private StringBuilder msResult = new StringBuilder();
    private String msSource;

    protected MsgFormat() {
    }

    public MsgFormat(MsgFormat oSource) {
        this.assign(oSource);
    }

    public MsgFormat(int nResId) {
        this.initialize(nResId);
    }

    public MsgFormat(int nResId, String sOut) {
        this.initialize(nResId);
        this.format(sOut);
    }

    public MsgFormat(String sSource) {
        this.initialize(sSource);
    }

    public MsgFormat(String sSource, String sOut) {
        this.initialize(sSource);
        this.format(sOut);
    }

    private void append(char cappend) {
        this.msResult.append(cappend);
    }

    private void append(String sAppend) {
        this.msResult.append(sAppend);
        this.moParms.add(sAppend);
    }

    public MsgFormat assign(MsgFormat oSource) {
        if (this == oSource) {
            return this;
        }
        this.mnResId = oSource.mnResId;
        this.msSource = oSource.msSource;
        this.msResult = oSource.msResult;
        this.moParms.addAll(oSource.moParms);
        this.mnSourceIndex = oSource.mnSourceIndex;
        return this;
    }

    private void findNextformat() {
        if (StringUtils.isEmpty(this.msResult)) {
            this.msResult.ensureCapacity(this.msSource.length());
        }
        while (this.mnSourceIndex < this.msSource.length()) {
            if (this.msSource.charAt(this.mnSourceIndex) == '%') {
                ++this.mnSourceIndex;
                if (this.mnSourceIndex < this.msSource.length() && this.msSource.charAt(this.mnSourceIndex) != '%') break;
            }
            this.append(this.msSource.charAt(this.mnSourceIndex));
            ++this.mnSourceIndex;
        }
    }

    public MsgFormat format(String sOut) {
        String sformat = this.loadformat();
        this.formatString(sformat, sOut);
        this.findNextformat();
        return this;
    }

    private void formatString(String sformat, String sOut) {
        this.append(sOut);
    }

    public String getParm(int nIndex) {
        return nIndex > this.moParms.size() ? "" : this.moParms.get(nIndex);
    }

    public int getParmCount() {
        return this.moParms.size();
    }

    private void initialize(int nResId) {
        this.mnResId = nResId;
        this.msSource = ResourceLoader.loadResource(nResId);
        this.mnSourceIndex = 0;
        this.findNextformat();
    }

    private void initialize(String sSource) {
        this.mnResId = 0;
        this.msSource = sSource;
        this.mnSourceIndex = 0;
        this.findNextformat();
    }

    private String loadformat() {
        int nStart = this.mnSourceIndex;
        boolean bDotFound = false;
        boolean bSkipL = false;
        String sformat = "%";
        while (this.mnSourceIndex < this.msSource.length()) {
            char cNext = this.msSource.charAt(this.mnSourceIndex);
            if (cNext == '.') {
                if (bDotFound) {
                    break;
                }
            } else {
                if (cNext == 'l') {
                    bSkipL = true;
                    break;
                }
                if (cNext < '0' || cNext > '9') break;
            }
            ++this.mnSourceIndex;
        }
        sformat = sformat + this.msSource.substring(nStart, this.mnSourceIndex);
        if (bSkipL) {
            ++this.mnSourceIndex;
        }
        if (this.mnSourceIndex < this.msSource.length()) {
            ++this.mnSourceIndex;
        }
        return sformat;
    }

    public int resId() {
        return this.mnResId;
    }

    public String sourceString() {
        return this.msSource;
    }

    public String toString() {
        return this.msResult.toString();
    }
}

