/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.DateTimeUtil;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.LcLocale;
import com.adobe.xfa.ut.StringUtils;

public class LcText {
    public static final String TEXT_PICTURE_SYMBOLS = "9AO0Xt";
    private final LcLocale mLocale;
    private boolean mbValid;
    private StringBuilder msText;
    private int mnSignf;

    public LcText(String text, String locale) {
        String sLocale = StringUtils.isEmpty(locale) ? LcLocale.getLocale() : locale;
        LcLocale lcLocale = new LcLocale(sLocale);
        this.mLocale = lcLocale.isValid() ? lcLocale : new LcLocale("en_US");
        this.setTextSymbols(this.mLocale.getIsoName());
        this.msText = new StringBuilder(text != null ? text : "");
        this.mbValid = true;
    }

    public LcText(String text, String pat, String locale) {
        this(text, locale);
        this.mbValid = this.parse(this.msText.toString(), pat);
    }

    public String format(String pat) {
        if (!this.mbValid) {
            return "";
        }
        StringBuilder sRes = new StringBuilder();
        try {
            char prevChr = '\u0000';
            int chrCnt = 0;
            boolean inQuoted = false;
            boolean inQuoteQuoted = false;
            int picLen = pat.length();
            int txtLen = this.msText.length();
            int txtIdx = 0;
            int i = 0;
            while (i < picLen) {
                StringBuilder s;
                int idx = 0;
                char chr = pat.charAt(i++);
                if (inQuoteQuoted) {
                    if (chr == '\'') {
                        sRes.append(chr);
                        chrCnt = 0;
                    } else {
                        inQuoted = false;
                        chrCnt = 1;
                        prevChr = chr;
                    }
                    inQuoteQuoted = false;
                    continue;
                }
                if (inQuoted) {
                    if (chr == '\'') {
                        inQuoteQuoted = true;
                    } else {
                        sRes.append(chr);
                    }
                    ++chrCnt;
                    continue;
                }
                if (chr == '\'') {
                    if (chrCnt > 0) {
                        s = new StringBuilder();
                        idx = this.subFormat(prevChr, chrCnt, txtIdx, s);
                        if (s.length() == 0) {
                            return "";
                        }
                        sRes.append((CharSequence)s);
                        txtIdx = idx;
                        chrCnt = 0;
                        prevChr = '\u0000';
                    }
                    inQuoted = true;
                    continue;
                }
                if (DateTimeUtil.matchChr(TEXT_PICTURE_SYMBOLS, chr) || 'a' <= chr && chr <= 'z' || 'A' <= chr && chr <= 'Z') {
                    if (chr != prevChr) {
                        if (chrCnt > 0) {
                            s = new StringBuilder();
                            idx = this.subFormat(prevChr, chrCnt, txtIdx, s);
                            if (s.length() == 0) {
                                return "";
                            }
                            sRes.append((CharSequence)s);
                            txtIdx = idx;
                            chrCnt = 0;
                        }
                        prevChr = chr;
                    }
                    ++chrCnt;
                    continue;
                }
                if (chrCnt > 0) {
                    s = new StringBuilder();
                    idx = this.subFormat(prevChr, chrCnt, txtIdx, s);
                    if (s.length() == 0) {
                        return "";
                    }
                    sRes.append((CharSequence)s);
                    txtIdx = idx;
                    chrCnt = 0;
                }
                prevChr = '\u0000';
                if (chr == '?' || chr == '*' || chr == '+') {
                    sRes.append(' ');
                    continue;
                }
                sRes.append(chr);
            }
            if (inQuoteQuoted) {
                inQuoted = false;
            }
            if (inQuoted) {
                return "";
            }
            if (prevChr > '\u0000' && chrCnt > 0) {
                int numSrcCharsLeft = txtLen - txtIdx;
                if (numSrcCharsLeft < chrCnt) {
                    return "";
                }
                StringBuilder s = new StringBuilder();
                int idx = this.subFormat(prevChr, chrCnt, txtIdx, s);
                if (s.length() == 0) {
                    return "";
                }
                sRes.append((CharSequence)s);
                txtIdx = idx;
            }
            if (txtIdx != 0 && txtIdx != txtLen) {
                return "";
            }
        }
        catch (ExFull e) {
            sRes.setLength(0);
        }
        return sRes.toString();
    }

    public static int getSymbolCount(String pic) {
        String sLoc = "en_US";
        LcText oText = new LcText("", sLoc);
        oText.xlate(pic);
        return oText.mnSignf;
    }

    public String getText() {
        return this.msText.toString();
    }

    public boolean isValid() {
        return this.mbValid;
    }

    public boolean parse(String str, String pat) {
        int resPos;
        this.mbValid = false;
        int strPos = 0;
        char prevChr = '\u0000';
        int chrCnt = 0;
        boolean inQuoted = false;
        boolean inQuoteQuoted = false;
        int strLen = str.length();
        int picLen = pat.length();
        StringBuilder sRes = new StringBuilder();
        int i = 0;
        while (i < picLen) {
            char chr = pat.charAt(i++);
            if (strPos >= strLen) {
                if (inQuoted && chr == '\'') {
                    inQuoteQuoted = true;
                    break;
                }
                return false;
            }
            if (inQuoteQuoted) {
                if (chr == '\'') {
                    if (!DateTimeUtil.matchChr(str, strPos, chr, false)) {
                        return false;
                    }
                    ++strPos;
                    chrCnt = 0;
                } else {
                    inQuoted = false;
                    chrCnt = 1;
                    prevChr = chr;
                }
                inQuoteQuoted = false;
                continue;
            }
            if (inQuoted) {
                if (chr == '\'') {
                    inQuoteQuoted = true;
                } else {
                    if (!DateTimeUtil.matchChr(str, strPos, chr, false)) {
                        return false;
                    }
                    ++strPos;
                }
                ++chrCnt;
                continue;
            }
            if (chr == '\'') {
                if (chrCnt > 0) {
                    resPos = this.subParse(str, strPos, prevChr, chrCnt);
                    if (resPos < 0) {
                        return false;
                    }
                    if (DateTimeUtil.matchChr(TEXT_PICTURE_SYMBOLS, prevChr)) {
                        sRes.append(this.getStr(str, strPos, resPos));
                    }
                    strPos = resPos;
                    chrCnt = 0;
                    prevChr = '\u0000';
                }
                inQuoted = true;
                continue;
            }
            if (DateTimeUtil.matchChr(TEXT_PICTURE_SYMBOLS, chr) || 'a' <= chr && chr <= 'z' || 'A' <= chr && chr <= 'Z') {
                if (chr != prevChr) {
                    if (chrCnt > 0) {
                        resPos = this.subParse(str, strPos, prevChr, chrCnt);
                        if (resPos < 0) {
                            return false;
                        }
                        if (DateTimeUtil.matchChr(TEXT_PICTURE_SYMBOLS, prevChr)) {
                            sRes.append(this.getStr(str, strPos, resPos));
                        }
                        strPos = resPos;
                        chrCnt = 0;
                    }
                    prevChr = chr;
                }
                ++chrCnt;
                continue;
            }
            if (chrCnt > 0) {
                resPos = this.subParse(str, strPos, prevChr, chrCnt);
                if (resPos < 0) {
                    return false;
                }
                if (DateTimeUtil.matchChr(TEXT_PICTURE_SYMBOLS, prevChr)) {
                    sRes.append(this.getStr(str, strPos, resPos));
                }
                strPos = resPos;
                chrCnt = 0;
                prevChr = '\u0000';
            }
            if (chr == '?') {
                if (strPos >= strLen || !Character.isDefined(str.charAt(strPos))) continue;
                ++strPos;
                continue;
            }
            if (chr == '+') {
                if (strPos >= strLen || !Character.isWhitespace(str.charAt(strPos))) {
                    return false;
                }
                ++strPos;
                while (strPos < strLen && Character.isWhitespace(str.charAt(strPos))) {
                    ++strPos;
                }
                continue;
            }
            if (chr == '*') {
                while (strPos < strLen && Character.isWhitespace(str.charAt(strPos))) {
                    ++strPos;
                }
                continue;
            }
            if (strPos < strLen && str.charAt(strPos) == chr) {
                ++strPos;
                continue;
            }
            return false;
        }
        if (inQuoteQuoted) {
            inQuoted = false;
        }
        if (inQuoted) {
            return false;
        }
        if (prevChr > '\u0000' && chrCnt > 0) {
            int numSrcCharsLeft = strLen - strPos;
            if (numSrcCharsLeft < chrCnt) {
                return false;
            }
            resPos = this.subParse(str, strPos, prevChr, chrCnt);
            if (resPos < 0) {
                return false;
            }
            if (DateTimeUtil.matchChr(TEXT_PICTURE_SYMBOLS, prevChr)) {
                sRes.append(this.getStr(str, strPos, resPos));
            }
            strPos = resPos;
        }
        if (strPos != strLen) {
            return false;
        }
        this.msText = sRes;
        return true;
    }

    private String getStr(String src, int begPos, int endPos) {
        assert (begPos < endPos && endPos <= src.length());
        StringBuilder s = new StringBuilder();
        while (begPos < endPos) {
            s.append(src.charAt(begPos++));
        }
        return s.toString();
    }

    private int matchAlphabetic(String src, int begPos, int endPos) {
        char cUni;
        assert (0 <= begPos && begPos < endPos && endPos <= src.length());
        boolean bAlphasSeen = false;
        int nAlphasSeen = 0;
        endPos = Math.min(endPos, src.length());
        while (begPos < endPos && Character.isLetter(cUni = src.charAt(begPos++))) {
            bAlphasSeen = true;
            ++nAlphasSeen;
        }
        return bAlphasSeen ? nAlphasSeen : -1;
    }

    private int matchAlphanumeric(String src, int begPos, int endPos) {
        char cUni;
        assert (0 <= begPos && begPos < endPos && endPos <= src.length());
        boolean bAlphanumsSeen = false;
        int nAlphanumsSeen = 0;
        endPos = Math.min(endPos, src.length());
        while (begPos < endPos && Character.isLetterOrDigit(cUni = src.charAt(begPos++))) {
            bAlphanumsSeen = true;
            ++nAlphanumsSeen;
        }
        return bAlphanumsSeen ? nAlphanumsSeen : -1;
    }

    private int matchCharacter(String src, int begPos, int endPos) {
        char cUni;
        assert (0 <= begPos && begPos < endPos && endPos <= src.length());
        boolean bCharsSeen = false;
        int nCharsSeen = 0;
        endPos = Math.min(endPos, src.length());
        while (begPos < endPos && Character.isDefined(cUni = src.charAt(begPos++))) {
            bCharsSeen = true;
            ++nCharsSeen;
        }
        return bCharsSeen ? nCharsSeen : -1;
    }

    private int matchNumeric(String src, int begPos, int endPos) {
        char cUni;
        assert (0 <= begPos && begPos < endPos && endPos <= src.length());
        boolean bDigitsSeen = false;
        int nDigitsSeen = 0;
        endPos = Math.min(endPos, src.length());
        while (begPos < endPos && Character.isDigit(cUni = src.charAt(begPos++))) {
            bDigitsSeen = true;
            ++nDigitsSeen;
        }
        return bDigitsSeen ? nDigitsSeen : -1;
    }

    private void setTextSymbols(String locale) {
    }

    private int subFormat(char chr, int chrCnt, int txtIdx, StringBuilder sRes) {
        assert (sRes != null);
        int retIdx = 0;
        int txtLen = this.msText.length();
        while (chrCnt-- > 0 && txtIdx < txtLen) {
            switch (chr) {
                case '9': {
                    char cUni = this.msText.charAt(txtIdx++);
                    if (!Character.isDigit(cUni)) {
                        throw new ExFull();
                    }
                    sRes.append(cUni);
                    break;
                }
                case 'A': {
                    char cUni = this.msText.charAt(txtIdx++);
                    if (!Character.isLetter(cUni)) {
                        throw new ExFull();
                    }
                    sRes.append(cUni);
                    break;
                }
                case '0': 
                case 'O': {
                    char cUni = this.msText.charAt(txtIdx++);
                    if (!Character.isLetterOrDigit(cUni)) {
                        throw new ExFull();
                    }
                    sRes.append(cUni);
                    break;
                }
                case 'X': {
                    char cUni = this.msText.charAt(txtIdx++);
                    sRes.append(cUni);
                    break;
                }
                case 't': {
                    sRes.append('\t');
                    break;
                }
                default: {
                    sRes.append(chr);
                }
            }
            retIdx = txtIdx;
        }
        return retIdx;
    }

    private int subParse(String src, int srcPos, char chr, int chrCnt) {
        switch (chr) {
            case '9': {
                int len = this.matchNumeric(src, srcPos, srcPos + chrCnt);
                if (len != chrCnt) {
                    return -1;
                }
                srcPos = DateTimeUtil.incPos(src, srcPos, len);
                break;
            }
            case 'A': {
                int len = this.matchAlphabetic(src, srcPos, srcPos + chrCnt);
                if (len != chrCnt) {
                    return -1;
                }
                srcPos = DateTimeUtil.incPos(src, srcPos, len);
                break;
            }
            case '0': 
            case 'O': {
                int len = this.matchAlphanumeric(src, srcPos, srcPos + chrCnt);
                if (len != chrCnt) {
                    return -1;
                }
                srcPos = DateTimeUtil.incPos(src, srcPos, len);
                break;
            }
            case 'X': {
                int len = this.matchCharacter(src, srcPos, srcPos + chrCnt);
                if (len != chrCnt) {
                    return -1;
                }
                srcPos = DateTimeUtil.incPos(src, srcPos, len);
                break;
            }
            case 't': {
                while (chrCnt-- > 0) {
                    if (src.charAt(srcPos) != '\t') {
                        return -1;
                    }
                    ++srcPos;
                }
                break;
            }
            default: {
                if (src.charAt(srcPos) != chr) {
                    return -1;
                }
                ++srcPos;
            }
        }
        return srcPos;
    }

    private String subXlate(char chr, int chrCnt) {
        StringBuilder sRes = new StringBuilder();
        for (int i = 0; i < chrCnt; ++i) {
            sRes.append(chr);
        }
        if ('\uff01' <= chr && chr <= '\uff5e') {
            chr = (char)(chr - 65504);
            chr = (char)(chr & 0xFF);
        }
        if (chr == '9' || chr == 'A' || chr == 'O' || chr == '0' || chr == 'X') {
            this.mnSignf += chrCnt;
        }
        return sRes.toString();
    }

    private String xlate(String pic) {
        this.mnSignf = 0;
        String sRes = null;
        char prevChr = '\u0000';
        int chrCnt = 0;
        boolean inQuoted = false;
        boolean inQuoteQuoted = false;
        int picLen = pic.length();
        int i = 0;
        while (i < picLen) {
            char chr = pic.charAt(i++);
            if (inQuoteQuoted) {
                if (chr == '\'') {
                    sRes = sRes + chr;
                    chrCnt = 0;
                } else {
                    inQuoted = false;
                    chrCnt = 1;
                    prevChr = chr;
                }
                inQuoteQuoted = false;
                continue;
            }
            if (inQuoted) {
                if (chr == '\'') {
                    inQuoteQuoted = true;
                }
                sRes = sRes + chr;
                chrCnt = 0;
                prevChr = chr;
                continue;
            }
            if (chr == '\'') {
                if (chrCnt > 0) {
                    sRes = sRes + this.subXlate(prevChr, chrCnt);
                    chrCnt = 0;
                    prevChr = '\u0000';
                }
                sRes = sRes + chr;
                inQuoted = true;
                continue;
            }
            if (DateTimeUtil.matchChr(TEXT_PICTURE_SYMBOLS, chr) || 'a' <= chr && chr <= 'z' || 'A' <= chr && chr <= 'Z') {
                if (prevChr != chr) {
                    if (chrCnt > 0) {
                        sRes = sRes + this.subXlate(prevChr, chrCnt);
                        prevChr = chr;
                        chrCnt = 1;
                        continue;
                    }
                    prevChr = chr;
                    ++chrCnt;
                    continue;
                }
                ++chrCnt;
                continue;
            }
            if (chrCnt > 0) {
                sRes = sRes + this.subXlate(prevChr, chrCnt);
                chrCnt = 0;
            }
            prevChr = '\u0000';
            sRes = sRes + chr;
        }
        if (inQuoteQuoted) {
            inQuoted = false;
        }
        if (inQuoted) {
            throw new ExFull();
        }
        if (prevChr > '\u0000' && chrCnt > 0) {
            sRes = sRes + this.subXlate(prevChr, chrCnt);
        }
        return sRes;
    }
}

