/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.StringUtils;

public final class DateTimeUtil {
    static final char[] Kanji_Num = new char[]{'\u3007', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d', '\u5341', '\u767e', '\u5343'};
    static final char[] Hanja_Num = new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d', '\u5341', '\u767e', '\u5343'};
    static final char[] Hangul_Num = new char[]{'\uc601', '\uc77c', '\uc774', '\uc0bc', '\uc0ac', '\uc624', '\uc721', '\uce60', '\ud314', '\uad6c', '\uc2ed', '\ubc31', '\ucc9c'};

    private DateTimeUtil() {
    }

    static int getNum(String src, int begPos, int endPos, boolean fw, char zero) {
        assert (begPos < endPos);
        int n = 0;
        while (begPos < endPos && begPos < src.length()) {
            char chr = src.charAt(begPos++);
            n *= 10;
            if (fw) {
                n += chr - 65296;
                continue;
            }
            n += chr - zero;
        }
        return n;
    }

    static int getNum(String src, int begPos, int endPos, char[] num, boolean tr) {
        assert (begPos < endPos);
        int n = 0;
        if (tr) {
            int mils = 0;
            int cens = 0;
            int tens = 0;
            int ones = 0;
            block0: while (begPos < endPos && begPos < src.length()) {
                char chr = src.charAt(begPos++);
                for (int p = 0; p < num.length; ++p) {
                    if (chr != num[p]) continue;
                    if (p == 12) {
                        mils = ones > 0 ? ones : 1;
                        ones = 0;
                        continue block0;
                    }
                    if (p == 11) {
                        cens = ones > 0 ? ones : 1;
                        ones = 0;
                        continue block0;
                    }
                    if (p == 10) {
                        tens = ones > 0 ? ones : 1;
                        ones = 0;
                        continue block0;
                    }
                    if (p > 9) continue block0;
                    ones = p;
                    continue block0;
                }
            }
            n = mils * 1000 + cens * 100 + tens * 10 + ones;
        } else {
            while (begPos < endPos && begPos < src.length()) {
                int p;
                char chr = src.charAt(begPos++);
                for (p = 0; p < num.length; ++p) {
                    if (chr != num[p] || p > 9) continue;
                    n *= 10;
                    n += p;
                    break;
                }
                if (p != num.length) continue;
                break;
            }
        }
        return n;
    }

    static String fmtNum(int w, int n, boolean fw, char zero) {
        assert (n >= 0 && w > 0);
        StringBuilder s = new StringBuilder();
        for (int i = w - 1; i >= 0; --i) {
            char d = (char)(zero + n % 10);
            if (fw) {
                d = (char)(d + 65248);
            }
            s.insert(0, d);
            n /= 10;
        }
        return s.toString();
    }

    static String fmtNum(int d, int n, char[] num, int tr) {
        StringBuilder s = new StringBuilder();
        if (num == null) {
            return "";
        }
        assert (n >= 0 && 1 <= d && d <= 4);
        int mils = n / 1000;
        int cens = (n - mils * 1000) / 100;
        int tens = (n - mils * 1000 - cens * 100) / 10;
        int ones = n - mils * 1000 - cens * 100 - tens * 10;
        if (tr != 0) {
            boolean prevIsZero = false;
            if (mils > 0) {
                if (tr > 0 || mils > 1) {
                    s.append(num[mils]);
                }
                s.append(num[12]);
            }
            if (cens > 0) {
                if (tr > 0 || cens > 1) {
                    s.append(num[cens]);
                }
                s.append(num[11]);
            } else if (tr > 0 && !prevIsZero && tens > 0 && ones > 0 && !StringUtils.isEmpty(s)) {
                s.append(num[0]);
                prevIsZero = true;
            }
            if (tens > 0) {
                if (tens > 1) {
                    s.append(num[tens]);
                }
                s.append(num[10]);
            } else if (tr > 0 && !prevIsZero && ones > 0 && !StringUtils.isEmpty(s)) {
                s.append(num[0]);
                prevIsZero = true;
            }
            if (StringUtils.isEmpty(s) || ones > 0) {
                s.append(num[ones]);
            }
        } else {
            if (mils > 0) {
                s.append(num[mils]);
            }
            if (s.length() > 0 || cens > 0) {
                s.append(num[cens]);
            }
            if (s.length() > 0 || tens > 0) {
                s.append(num[tens]);
            }
            s.append(num[ones]);
        }
        return s.toString();
    }

    static String fmtPlainNum(int w, int n, boolean fw, char zero) {
        assert (n >= 0 && w > 0);
        StringBuilder s = new StringBuilder();
        for (int i = w - 1; i >= 0; --i) {
            char d = (char)(zero + n % 10);
            if (fw) {
                d = (char)(d + 65248);
            }
            s.insert(0, d);
            if ((n /= 10) == 0) break;
        }
        return s.toString();
    }

    static String fmtStr(String src, boolean fw) {
        StringBuilder s = new StringBuilder();
        int n = src.length();
        for (int i = 0; i < n; ++i) {
            s.append(DateTimeUtil.matchChr(src.charAt(i), fw));
        }
        return s.toString();
    }

    static int matchName(String src, int srcPos, String[] names, boolean is) {
        int matchIdx = -1;
        int matchLen = -1;
        String pSrc = src.substring(srcPos);
        for (int i = 0; i < names.length; ++i) {
            int len;
            if (names[i] == null || (len = names[i].length()) <= matchLen) continue;
            if (len == 0 || pSrc.startsWith(names[i])) {
                matchIdx = i;
                matchLen = len;
                continue;
            }
            if (!is || !pSrc.toLowerCase().startsWith(names[i].toLowerCase())) continue;
            matchIdx = i;
            matchLen = len;
        }
        return matchIdx;
    }

    static int matchNum(String src, int begPos, int endPos, char[] num, boolean tr) {
        if (num == null) {
            return -1;
        }
        assert (begPos < endPos);
        int srcLen = src.length();
        int nDigitsSeen = 0;
        if (tr) {
            int mils = 0;
            int cens = 0;
            int tens = 0;
            int ones = 1;
            while (begPos < srcLen) {
                int p;
                char chr;
                if ((chr = src.charAt(begPos++)) == '\u5143') {
                    return nDigitsSeen > 0 ? nDigitsSeen : 1;
                }
                for (p = 0; p < num.length; ++p) {
                    if (chr != num[p]) continue;
                    if (p == 12) {
                        if (mils > 0 || cens > 0 || tens > 0) {
                            return nDigitsSeen > 0 ? nDigitsSeen : -1;
                        }
                        mils = ones;
                        ones = 1;
                    } else if (p == 11) {
                        if (cens > 0 || tens > 0) {
                            return nDigitsSeen > 0 ? nDigitsSeen : -1;
                        }
                        cens = ones;
                        ones = 1;
                    } else if (p == 10) {
                        if (tens > 0) {
                            return nDigitsSeen > 0 ? nDigitsSeen : -1;
                        }
                        tens = ones;
                        ones = 1;
                    } else if (p <= 9) {
                        if (ones != 1) {
                            return nDigitsSeen > 0 ? nDigitsSeen : -1;
                        }
                        ones = p;
                    }
                    ++nDigitsSeen;
                    break;
                }
                if (p != num.length) continue;
                break;
            }
        } else {
            int end = begPos;
            for (int beg = begPos; beg < endPos; ++beg) {
                if (end >= src.length()) continue;
                ++end;
            }
            endPos = end;
            while (begPos < endPos) {
                int p;
                char chr;
                if ((chr = src.charAt(begPos++)) == '\u5143') {
                    return nDigitsSeen > 0 ? nDigitsSeen : 1;
                }
                for (p = 0; p <= 9; ++p) {
                    if (chr != num[p]) continue;
                    ++nDigitsSeen;
                    break;
                }
                if (p != 10) continue;
                break;
            }
        }
        return nDigitsSeen > 0 ? nDigitsSeen : -1;
    }

    static int matchNum(String src, int begPos, int endPos, boolean fw, char zero) {
        assert (begPos < endPos);
        int nDigitsSeen = 0;
        int end = begPos;
        for (int beg = begPos; beg < endPos; ++beg) {
            if (end >= src.length()) continue;
            ++end;
        }
        endPos = end;
        while (begPos < endPos && begPos < src.length()) {
            char chr = src.charAt(begPos++);
            if (!fw && (zero > chr || chr > zero + 9) || fw && ('\uff10' > chr || chr > '\uff19')) break;
            ++nDigitsSeen;
        }
        return nDigitsSeen > 0 ? nDigitsSeen : -1;
    }

    static int matchStr(String src, int srcPos, String str, boolean fw) {
        int i = 0;
        int n = str.length();
        while (i < n) {
            int chr;
            int n2 = chr = srcPos < src.length() ? src.charAt(srcPos++) : 0;
            if (fw) {
                if (65281 <= chr && chr <= 65374) {
                    chr = (char)(chr - 65504);
                    chr = (char)(chr & 0xFF);
                } else if (chr == 12288) {
                    chr = 32;
                }
            }
            if (str.charAt(i++) == chr) continue;
            return -1;
        }
        return srcPos;
    }

    static int incPos(String src, int srcPos, int inc) {
        assert (inc > 0);
        for (int i = 0; i < inc; ++i) {
            src.charAt(srcPos++);
        }
        return srcPos;
    }

    static boolean matchChr(String src, char chr) {
        if ('\uff01' <= chr && chr <= '\uff5e') {
            chr = (char)(chr - 65504);
            chr = (char)(chr & 0xFF);
        } else if (chr == '\u3000') {
            chr = (char)32;
        }
        int n = src.length();
        for (int i = 0; i < n; ++i) {
            if (src.charAt(i) != chr) continue;
            return true;
        }
        return false;
    }

    static char matchChr(char chr, boolean fw) {
        if (fw) {
            if ('!' <= chr && chr <= '~') {
                chr = (char)(chr + 65248);
            } else if (chr == ' ') {
                chr = (char)12288;
            }
        }
        return chr;
    }

    static boolean matchChr(String src, int srcPos, char chr, boolean fw) {
        if (srcPos >= src.length()) {
            return false;
        }
        return DateTimeUtil.matchChr(src.charAt(srcPos), fw) == chr;
    }
}

